/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import java.util.Vector;
import mlsub.typing.lowlevel.BitMatrix;
import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.Domain;
import mlsub.typing.lowlevel.DomainVector;
import mlsub.typing.lowlevel.Interface;
import mlsub.typing.lowlevel.LowlevelImplementsClash;
import mlsub.typing.lowlevel.LowlevelIncompatibleClash;
import mlsub.typing.lowlevel.LowlevelRigidClash;
import mlsub.typing.lowlevel.LowlevelSolutionHandler;
import mlsub.typing.lowlevel.LowlevelUnsatisfiable;
import mlsub.typing.lowlevel.S;
import mlsub.typing.lowlevel.Satisfier;
import mlsub.typing.lowlevel.Separator;
import mlsub.typing.lowlevel.Unsatisfiable;

public final class K0 {
    public static boolean debugK0 = S.debugK0;
    private static int IDs = 0;
    private int ID = IDs++;
    private Callbacks callbacks;
    private BitMatrix R;
    private BitMatrix Rt;
    private int m;
    private int m0;
    private BitMatrix C;
    private BitMatrix Ct;
    private int n;
    private BitVector minimal;
    private BitVector garbage;
    private Vector interfaces;
    private boolean hasBeenInitialized = false;
    private DomainVector domains = null;
    private BitVector _collapsed = new BitVector(256);
    private BitVector _toCollapse = new BitVector(256);
    private int backtrackMode;
    public static final int BACKTRACK_UNLIMITED = 1;
    public static final int BACKTRACK_ONCE = 2;
    private Backup backup = null;
    public static final int ALL = 0;
    public static final int SIMPLIFIED = 1;
    private int weakMarkedSize = -1;
    private int weakMarkedM = -1;
    BitVector negTagged;
    BitVector posTagged;
    private static final int OVERLOADING_CONSTRUCTOR = 0;
    private static final int OVERLOADING_INTERFACE = 1;

    public K0(int backtrackMode, Callbacks callbacks) {
        this.backtrackMode = backtrackMode;
        this.callbacks = callbacks;
        this.R = null;
        this.Rt = null;
        this.m = 0;
        this.C = new BitMatrix();
        this.Ct = new BitMatrix();
        this.n = 0;
        this.minimal = new BitVector();
        this.garbage = new BitVector();
        this.posTagged = new BitVector();
        this.negTagged = new BitVector();
        this.interfaces = new Vector();
        if (debugK0) {
            System.err.println("created K0 #" + this.ID);
        }
    }

    public K0(Callbacks callbacks) {
        this(2, callbacks);
    }

    int initialContextSize() {
        return this.m0;
    }

    public int firstNonRigid() {
        return this.m;
    }

    public boolean isRigid(int x) {
        return x < this.m;
    }

    public boolean hasNoSoft() {
        return this.n == this.m;
    }

    public int size() {
        return this.n;
    }

    public boolean isMinimal(int x) {
        return this.minimal.get(x);
    }

    public void minimal(int x) {
        this.minimal.set(x);
    }

    public boolean isValidIndex(int x) {
        return x >= 0 && x < this.n && !this.garbage.get(x);
    }

    public String getName() {
        return this.callbacks.getName();
    }

    private String indexToString(int index) {
        return this.callbacks.indexToString(index);
    }

    String interfaceToString(int iid) {
        return this.callbacks.interfaceToString(iid);
    }

    public String domainsToString() {
        StringBuffer sb = new StringBuffer();
        int i = this.m;
        while (i < this.n) {
            if (this.isValidIndex(i)) {
                sb.append("D(").append(this.indexToString(i)).append(") = ");
                Domain d = this.hasBeenInitialized ? this.domains.getDomain(i) : null;
                sb.append(d);
                sb.append("; ");
            }
            ++i;
        }
        return sb.toString();
    }

    private BitVector weakComponent(int x0) {
        int x;
        S.assume(this.isValidIndex(x0));
        BitVector component = new BitVector();
        BitVector toInclude = new BitVector();
        toInclude.set(x0);
        while ((x = toInclude.getLowestSetBitNotIn(component)) != Integer.MIN_VALUE) {
            BitVector lx;
            if (this.garbage.get(x)) continue;
            component.set(x);
            BitVector ux = this.C.getRow(x);
            if (ux != null) {
                toInclude.or(ux);
            }
            if ((lx = this.Ct.getRow(x)) == null) continue;
            toInclude.or(lx);
        }
        return component;
    }

    private String ineqToString(int x, int y) {
        return this.indexToString(x) + " <: " + this.indexToString(y);
    }

    private String componentToString(BitVector component) {
        StringBuffer sb = new StringBuffer();
        Separator sep = new Separator(", ");
        int nvars = 0;
        int x = 0;
        while (x < this.n) {
            if (component.get(x)) {
                sb.append(sep).append(this.indexToString(x));
                if (this.isRigid(x)) {
                    sb.append("*");
                }
                ++nvars;
            }
            ++x;
        }
        if (nvars == 0) {
            return "";
        }
        sb.append(" | ");
        sep.reset();
        int x2 = 0;
        while (x2 < this.n) {
            if (component.get(x2)) {
                int y = x2 < this.m0 ? this.m0 : x2 + 1;
                while (y < this.n) {
                    if (component.get(y)) {
                        if (this.C.get(y, x2)) {
                            sb.append(sep).append(this.ineqToString(y, x2));
                        }
                        if (this.C.get(x2, y)) {
                            sb.append(sep).append(this.ineqToString(x2, y));
                        }
                    }
                    ++y;
                }
            }
            ++x2;
        }
        int x3 = this.m0;
        while (x3 < this.n) {
            if (component.get(x3)) {
                int iid = 0;
                while (iid < this.nInterfaces()) {
                    if (this.getInterface((int)iid).implementors.get(x3)) {
                        sb.append(sep).append(this.indexToString(x3)).append(": ").append(this.interfaceToString(iid));
                    }
                    ++iid;
                }
            }
            ++x3;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Separator nl = new Separator("\n");
        BitVector rest = new BitVector(this.n);
        rest.fill(this.n);
        String restComp = this.componentToString(rest);
        if (!restComp.equals("")) {
            sb.append(nl).append(restComp);
        }
        if (sb.length() != 0) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public String dumpInterfaces() {
        final StringBuffer sb = new StringBuffer();
        final Separator sep = new Separator(", ");
        int iid = 0;
        while (iid < this.nInterfaces()) {
            sb.append(sep).append(this.interfaceToString(iid));
            ++iid;
        }
        sb.append(" | ");
        sep.reset();
        int iid1 = 0;
        while (iid1 < this.nInterfaces()) {
            int iid2 = 0;
            while (iid2 < this.nInterfaces()) {
                if (this.getInterface((int)iid2).subInterfaces.get(iid1)) {
                    sb.append(sep).append(this.interfaceToString(iid1)).append(" < ").append(this.interfaceToString(iid2));
                }
                ++iid2;
            }
            ++iid1;
        }
        sb.append("\n");
        sep.reset();
        try {
            this.implementsIter(new ImplementsIterator(){

                public void iter(int x, int iid) {
                    sb.append(sep).append(K0.this.indexToString(x)).append(" : ").append(K0.this.interfaceToString(iid));
                }
            });
        }
        catch (Unsatisfiable e) {
            // empty catch block
        }
        try {
            this.abstractsIter(new AbstractsIterator(){

                public void iter(int x, int iid) {
                    sb.append(sep).append(K0.this.indexToString(x)).append(" :: ").append(K0.this.interfaceToString(iid));
                }
            });
        }
        catch (Unsatisfiable e) {
            // empty catch block
        }
        return sb.toString();
    }

    public String dumpRigid() {
        StringBuffer sb = new StringBuffer();
        Separator sep = new Separator(", ");
        int x = 0;
        while (x < this.m) {
            if (this.isValidIndex(x)) {
                sb.append(sep).append(this.indexToString(x));
            }
            ++x;
        }
        sb.append(" | ");
        sep.reset();
        int x2 = 0;
        while (x2 < this.m) {
            int y = 0;
            while (y < this.m) {
                if (this.isValidIndex(x2) && this.isValidIndex(y) && this.R.get(x2, y)) {
                    sb.append(sep).append(this.indexToString(x2)).append(" < ").append(this.indexToString(y));
                }
                ++y;
            }
            ++x2;
        }
        int iid = 0;
        while (iid < this.nInterfaces()) {
            int x3 = 0;
            while (x3 < this.m) {
                if (this.isValidIndex(x3) && this.getInterface((int)iid).rigidImplementors.get(x3)) {
                    sb.append(sep).append(this.indexToString(x3)).append(": ").append(this.interfaceToString(iid));
                }
                ++x3;
            }
            ++iid;
        }
        return sb.toString();
    }

    private void setSize(int n) {
        S.assume(n >= this.m);
        this.n = n;
        this.C.setSize(n);
        this.Ct.setSize(n);
        if (this.domains != null) {
            this.domains.setSize(n - this.m);
        }
        this.garbage.truncate(n);
        this.posTagged.truncate(n);
        this.negTagged.truncate(n);
        this.minimal.truncate(n);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            this.getInterface(iid).setIndexSize(n);
            ++iid;
        }
    }

    private int collect(int i, int j) {
        while (i < j) {
            if (!this.garbage.get(i)) {
                ++i;
                continue;
            }
            do {
                if (i < j) continue;
                return i;
            } while (this.garbage.get(--j));
            this.indexMove(j, i);
            ++i;
        }
        return i;
    }

    private void collect() {
        this.setSize(this.collect(this.m, this.n));
    }

    private void indexMove(int src, int dest) {
        this.domainMove(src, dest);
        this.posTagged.bitCopy(src, dest);
        this.negTagged.bitCopy(src, dest);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            this.getInterface(iid).indexMove(src, dest);
            ++iid;
        }
        this.garbage.set(src);
        this.garbage.clear(dest);
        this.C.indexMove(src, dest);
        this.Ct.indexMove(src, dest);
        this.callbacks.indexMoved(src, dest);
    }

    private void indexMerge(int src, int dest) throws Unsatisfiable {
        this.domainMerge(src, dest);
        this.C.indexMerge(src, dest);
        this.Ct.indexMerge(src, dest);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            this.getInterface(iid).indexMerge(src, dest);
            ++iid;
        }
        this.garbage.set(src);
        this.posTagged.bitMerge(src, dest);
        this.negTagged.bitMerge(src, dest);
        this.callbacks.indexMerged(src, dest);
    }

    public int extend() {
        this.C.extend();
        this.Ct.extend();
        this.garbage.clear(this.n);
        if (this.hasBeenInitialized) {
            this.domains.extend();
        }
        return this.n++;
    }

    public int nInterfaces() {
        return this.interfaces.size();
    }

    Interface getInterface(int iid) {
        return (Interface)this.interfaces.elementAt(iid);
    }

    public boolean hasBeenInitialized() {
        return this.hasBeenInitialized;
    }

    public int newInterface() {
        S.assume(!this.hasBeenInitialized);
        int iid = this.nInterfaces();
        Interface iface = new Interface(this, iid);
        this.interfaces.addElement(iface);
        if (debugK0) {
            System.err.println("newInterface in #" + this.ID + " -> " + iid);
        }
        return iid;
    }

    public void subInterface(int iid1, int iid2) {
        S.assume(!this.hasBeenInitialized);
        this.getInterface((int)iid2).subInterfaces.set(iid1);
    }

    public void initialImplements(int x, int iid) {
        S.assume(!this.hasBeenInitialized);
        this.getInterface((int)iid).implementors.set(x);
    }

    public void initialAbstracts(int x, int iid) {
        S.assume(!this.hasBeenInitialized);
        this.getInterface((int)iid).abstractors.set(x);
    }

    public void initialLeq(int x, int y) {
        S.assume(!this.hasBeenInitialized);
        this.C.set(x, y);
        this.Ct.set(y, x);
    }

    public void createInitialContext() throws LowlevelUnsatisfiable {
        S.assume(!this.hasBeenInitialized);
        this.R = (BitMatrix)this.C.clone();
        this.R.closure();
        this.Rt = (BitMatrix)this.Ct.clone();
        this.Rt.closure();
        this.m0 = this.m = this.n;
        this.closeInterfaceRelation();
        BitVector[] rigidImplementors = this.closeImplements(this.R, this.Rt);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            this.getInterface((int)iid).rigidImplementors = rigidImplementors[iid];
            ++iid;
        }
        this.computeInitialArrows();
        if (debugK0) {
            System.err.println("Initial Context (saturated) " + this.getName() + ":\n" + this + "\n" + this.dumpInterfaces() + "\n");
        }
        this.domains = new DomainVector(this.m, this.m);
        this.hasBeenInitialized = true;
    }

    public void releaseInitialContext() {
        this.hasBeenInitialized = false;
        if (this.m != this.m0) {
            System.err.println("releaseInitialContext should be called when in first rigid context");
        }
        this.m = 0;
        this.m0 = 0;
    }

    public void indexImplements(int x, int iid) throws Unsatisfiable {
        S.assume(this.hasBeenInitialized);
        if (LowlevelUnsatisfiable.refinedReports) {
            try {
                this.indexImplements0(x, iid);
            }
            catch (LowlevelUnsatisfiable e) {
                throw this.refine(e);
            }
        } else {
            this.indexImplements0(x, iid);
        }
    }

    private void indexImplements0(int x, int iid) throws LowlevelUnsatisfiable {
        if (debugK0) {
            System.err.println("#" + this.ID + " -> " + this.indexToString(x) + ": " + this.interfaceToString(iid));
        }
        Interface iface = this.getInterface(iid);
        if (iface.implementors.get(x)) {
            return;
        }
        if (this.isRigid(x)) {
            if (!iface.rigidImplementors.get(x)) {
                throw new LowlevelImplementsClash(x, iid);
            }
            return;
        }
        iface.implementors.set(x);
        this.reduceDomain(x, true, iface.rigidImplementors);
    }

    public void eq(int x1, int x2) throws Unsatisfiable {
        this.leq(x1, x2);
        this.leq(x2, x1);
    }

    public void leq(int x1, int x2) throws Unsatisfiable {
        S.assume(this.hasBeenInitialized);
        if (LowlevelUnsatisfiable.refinedReports) {
            try {
                this.leq0(x1, x2);
            }
            catch (LowlevelUnsatisfiable e) {
                throw this.refine(e);
            }
        } else {
            this.leq0(x1, x2);
        }
    }

    public void enterConstraint(int x1, int v0, int x2) throws Unsatisfiable {
        if (v0 > 0) {
            this.leq(x1, x2);
        }
        if (v0 < 0) {
            this.leq(x2, x1);
        }
        if (v0 == 0) {
            this.eq(x1, x2);
        }
    }

    private void leq0(int x1, int x2) throws LowlevelUnsatisfiable {
        if (debugK0) {
            System.err.println("#" + this.ID + " -> " + this.indexToString(x1) + " <: " + this.indexToString(x2));
        }
        if (x1 == x2) {
            return;
        }
        if (this.C.get(x1, x2)) {
            return;
        }
        if (this.isRigid(x1) && this.isRigid(x2)) {
            if (!this.R.get(x1, x2)) {
                throw new LowlevelRigidClash(this.indexToString(x1), this.indexToString(x2));
            }
            return;
        }
        this.C.set(x1, x2);
        this.Ct.set(x2, x1);
        if (this.isRigid(x1)) {
            this.reduceDomain(x2, false, this.R.getRow(x1));
        }
        if (this.isRigid(x2)) {
            this.reduceDomain(x1, false, this.Rt.getRow(x2));
            if (this.minimal.get(x2)) {
                this.leq0(x2, x1);
            }
        }
    }

    private LowlevelUnsatisfiable refine(LowlevelUnsatisfiable e) {
        if (debugK0) {
            System.err.println("Trying to refine " + e);
            System.err.println("The constraint is " + this.toString());
            System.err.println("The rigid constraint is " + this.dumpRigid());
            e.printStackTrace();
        }
        if (e instanceof LowlevelRigidClash || e instanceof LowlevelImplementsClash) {
            return e;
        }
        this.C.closure();
        this.Ct.closure();
        BitVector[] saturatedImplementors = this.closeImplements(this.C, this.Ct);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            this.getInterface((int)iid).implementors = saturatedImplementors[iid];
            ++iid;
        }
        int[] rigidClash = this.C.includedIn(this.m, this.R);
        if (rigidClash != null) {
            return new LowlevelRigidClash(this.indexToString(rigidClash[0]), this.indexToString(rigidClash[1]));
        }
        LowlevelIncompatibleClash clash = null;
        clash = this.refineIncompatible(this.C, this.R, 2);
        if (clash != null) {
            return clash;
        }
        clash = this.refineIncompatible(this.Ct, this.Rt, 1);
        if (clash != null) {
            return clash;
        }
        int iid2 = 0;
        while (iid2 < this.nInterfaces()) {
            Interface iface = this.getInterface(iid2);
            int x = iface.implementors.getLowestSetBitNotIn(iface.rigidImplementors);
            if (this.isValidIndex(x) && this.isRigid(x)) {
                return new LowlevelImplementsClash(x, iid2);
            }
            ++iid2;
        }
        return e;
    }

    private LowlevelIncompatibleClash refineIncompatible(BitMatrix C, BitMatrix R, int what) {
        int a = 0;
        while (a < this.m) {
            int b = a + 1;
            while (b < this.m) {
                int z;
                BitVector Cb;
                BitVector Ca;
                if (R.getRow(a).getLowestSetBitAnd(R.getRow(b)) == Integer.MIN_VALUE && (Ca = C.getRow(a)) != null && (Cb = C.getRow(b)) != null && (z = Ca.getLowestSetBitAnd(Cb)) != Integer.MIN_VALUE) {
                    return new LowlevelIncompatibleClash(what, a, b, z);
                }
                ++b;
            }
            ++a;
        }
        return null;
    }

    private void domainMerge(int src, int dest) throws Unsatisfiable {
        this.domains.merge(src, dest);
    }

    private void domainMove(int src, int dest) {
        this.domains.move(src, dest);
    }

    public void reduceDomain(int x, boolean unit, BitVector set) throws LowlevelUnsatisfiable {
        S.assume(x >= -1);
        if (x == -1) {
            if (!unit) {
                throw new LowlevelUnsatisfiable();
            }
        } else if (x < this.m) {
            if (!set.get(x)) {
                throw new LowlevelUnsatisfiable();
            }
        } else {
            if (debugK0) {
                System.err.println("Reducing domain of " + this.indexToString(x));
                System.err.println("from " + this.domains.getDomain(x));
                System.err.println("with " + set);
            }
            this.domains.reduce(x, unit, set);
        }
    }

    private void collapseMinimal() throws Unsatisfiable {
        int y = 0;
        while (y < this.m0) {
            if (this.minimal.get(y)) {
                int x;
                BitVector uy = this.R.getRow(y);
                this._collapsed.clearAll();
                this._toCollapse.clearAll();
                this._toCollapse.set(y);
                while ((x = this._toCollapse.getLowestSetBitNotIn(this._collapsed)) != Integer.MIN_VALUE) {
                    this._collapsed.set(x);
                    BitVector lx = this.Ct.getRow(x);
                    if (lx != null) {
                        this._toCollapse.or(lx);
                    }
                    if (x == y || this.C.get(y, x)) continue;
                    if (x < this.m0) {
                        throw new LowlevelRigidClash(this.indexToString(x), this.indexToString(y));
                    }
                    this.C.set(y, x);
                    this.Ct.set(x, y);
                    this.reduceDomain(x, false, uy);
                }
            }
            ++y;
        }
    }

    private void computeInitialArrows() throws LowlevelUnsatisfiable {
        int iid = 0;
        while (iid < this.nInterfaces()) {
            Interface i = this.getInterface(iid);
            BitVector abstractors = i.abstractors;
            BitVector subInterfaces = i.subInterfaces;
            int abs = abstractors.getLowestSetBit();
            while (abs != Integer.MIN_VALUE) {
                int jid = subInterfaces.getLowestSetBit();
                while (jid != Integer.MIN_VALUE) {
                    BitVector labs = this.Rt.getRow(abs);
                    int node = labs.getLowestSetBit();
                    while (node != Integer.MIN_VALUE) {
                        this.setApproxToMinAbove(node, this.getInterface(jid), this.R);
                        node = labs.getNextBit(node);
                    }
                    jid = subInterfaces.getNextBit(jid);
                }
                abs = abstractors.getNextBit(abs);
            }
            ++iid;
        }
        this.computeApproxMinimals(0, this.R);
    }

    private void computeApproxMinimals(int min, BitMatrix leq) throws LowlevelUnsatisfiable {
        int node = this.minimal.getLowestSetBit(min);
        while (node != Integer.MIN_VALUE) {
            int iid = 0;
            while (iid < this.nInterfaces()) {
                this.setApproxToMinAbove(node, this.getInterface(iid), leq);
                ++iid;
            }
            node = this.minimal.getNextBit(node);
        }
    }

    private void setApproxToMinAbove(int abs, Interface j, BitMatrix leq) throws LowlevelUnsatisfiable {
        BitVector implementors = j.rigidImplementors;
        boolean toCheck = false;
        int approx = Integer.MIN_VALUE;
        int x = implementors.getLowestSetBit();
        while (x != Integer.MIN_VALUE && x < this.m0) {
            if (leq.get(abs, x)) {
                if (approx == Integer.MIN_VALUE || leq.get(x, approx)) {
                    approx = x;
                } else {
                    toCheck = true;
                }
            }
            x = implementors.getNextBit(x);
        }
        if (toCheck) {
            int x2 = implementors.getLowestSetBit();
            while (x2 != Integer.MIN_VALUE) {
                if (leq.get(abs, x2) && !leq.get(approx, x2)) {
                    approx = Integer.MIN_VALUE;
                    break;
                }
                x2 = implementors.getNextBit(x2);
            }
        }
        if (debugK0) {
            System.err.println("Initial approximation for " + j + ": " + this.indexToString(abs) + " -> " + this.indexToString(approx));
        }
        j.setApprox(abs, approx);
    }

    private void computeArrows(BitMatrix leq) throws LowlevelUnsatisfiable {
        this.computeApproxMinimals(this.m, leq);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            Interface i = this.getInterface(iid);
            i.setIndexSize(this.n);
            BitVector abstractors = i.abstractors;
            int x = abstractors.getLowestSetBit();
            while (x != Integer.MIN_VALUE) {
                int approx = i.getApprox(x);
                if (approx != Integer.MIN_VALUE) {
                    int node = this.m;
                    while (node < this.n) {
                        if (leq.get(node, x)) {
                            i.setApprox(node, approx);
                            if (debugK0) {
                                System.err.println("Approximation for " + iid + ": " + this.indexToString(node) + " -> " + this.indexToString(approx));
                            }
                        }
                        ++node;
                    }
                }
                x = abstractors.getNextBit(x);
            }
            ++iid;
        }
    }

    private void saturateAbs(BitMatrix leq) throws Unsatisfiable {
        boolean changed;
        do {
            changed = false;
            int nInt = this.nInterfaces();
            int iid = 0;
            while (iid < nInt) {
                Interface i = this.getInterface(iid);
                BitVector hasApprox = i.getHasApprox();
                int node = hasApprox.getLowestSetBit();
                while (node != Integer.MIN_VALUE) {
                    int n1 = i.getApprox(node);
                    int p = i.implementors.getLowestSetBit();
                    while (p != Integer.MIN_VALUE) {
                        if (leq.get(node, p) && !leq.get(n1, p)) {
                            if (this.isRigid(p)) {
                                throw new LowlevelUnsatisfiable("saturateAbs: there should be " + this.indexToString(n1) + " <: " + this.indexToString(p) + " (node=" + this.indexToString(node) + ")\n" + "interface " + this.interfaceToString(iid) + "\n" + this);
                            }
                            if (debugK0) {
                                System.err.println("Abs rule applied : " + this.indexToString(n1) + " < " + this.indexToString(p) + " using " + this.indexToString(node) + " for interface " + this.interfaceToString(iid));
                            }
                            this.C.set(n1, p);
                            this.Ct.set(p, n1);
                            leq.set(n1, p);
                            changed = true;
                        }
                        p = i.implementors.getNextBit(p);
                    }
                    node = hasApprox.getNextBit(node);
                }
                ++iid;
            }
            if (!changed) continue;
            leq.closure();
        } while (changed);
    }

    private void condense() throws Unsatisfiable {
        BitMatrix T = (BitMatrix)this.C.clone();
        T.closure();
        this.condense(T);
    }

    private void condense(BitMatrix T) throws Unsatisfiable {
        if (this.m > 0 && T.includedIn(this.m, this.R) != null) {
            throw new LowlevelUnsatisfiable();
        }
        BitMatrix Tt = (BitMatrix)this.Ct.clone();
        Tt.closure();
        if (debugK0) {
            System.err.println(this.toString());
            System.err.println(this.domainsToString());
        }
        int i = 0;
        while (i < this.n) {
            int root;
            if (!this.garbage.get(i) && (root = T.getRow(i).getLowestSetBitAnd(Tt.getRow(i))) != i) {
                if (this.isRigid(root) && !this.isRigid(i)) {
                    int j = this.m;
                    while (j < this.n) {
                        if (i != j && this.isValidIndex(j)) {
                            if (this.C.get(i, j)) {
                                this.reduceDomain(j, false, this.R.getRow(root));
                            }
                            if (this.Ct.get(i, j)) {
                                this.reduceDomain(j, false, this.Rt.getRow(root));
                            }
                        }
                        ++j;
                    }
                }
                this.indexMerge(i, root);
            }
            ++i;
        }
        this.collect();
    }

    private void prepareConstraint() throws Unsatisfiable {
        this.collapseMinimal();
        BitMatrix leq = (BitMatrix)this.C.clone();
        leq.closure();
        this.computeArrows(leq);
        this.saturateAbs(leq);
    }

    public void enumerate(LowlevelSolutionHandler handler) throws Unsatisfiable {
        S.assume(this.hasBeenInitialized);
        this.prepareConstraint();
        this.domains.trimToSize();
        if (this.m == 0 || this.m == this.n) {
            handler.handle(this.domains);
        } else {
            int[] strategy = Satisfier.compileStrategy(this.C, this.Ct, this.m, this.n);
            Satisfier.enumerateSolutions(strategy, this.domains, this.C, this.Ct, this.R, this.Rt, this.m, this.n, handler);
        }
    }

    public void enumerate(BitVector observers, LowlevelSolutionHandler handler) {
        S.assume(this.hasBeenInitialized);
        try {
            this.prepareConstraint();
        }
        catch (Unsatisfiable e) {
            return;
        }
        this.domains.trimToSize();
        if (this.m == 0 || this.m == this.n) {
            handler.handle(this.domains);
        } else {
            int[] strategy = Satisfier.compileStrategy(this.C, this.Ct, this.m, this.n);
            Satisfier.enumerateSolutions(strategy, this.domains, this.C, this.Ct, this.R, this.Rt, this.m, this.n, observers, handler);
        }
    }

    public void satisfy() throws Unsatisfiable {
        S.assume(this.hasBeenInitialized);
        if (this.m == 0 || this.m == this.n) {
            return;
        }
        try {
            this.prepareConstraint();
            this.rawSatisfy();
        }
        catch (LowlevelUnsatisfiable e) {
            if (LowlevelUnsatisfiable.refinedReports) {
                throw this.refine(e);
            }
            throw e;
        }
    }

    private void rawSatisfy() throws Unsatisfiable {
        this.domains.trimToSize();
        if (0 < this.m && this.m < this.n) {
            int[] strategy = Satisfier.compileStrategy(this.C, this.Ct, this.m, this.n);
            Satisfier.satisfy(strategy, this.domains, this.C, this.Ct, this.R, this.Rt, this.m, this.n);
        }
    }

    private void closeInterfaceRelation() {
        int k = 0;
        while (k < this.nInterfaces()) {
            Interface K = this.getInterface(k);
            int i = 0;
            while (i < this.nInterfaces()) {
                Interface I = this.getInterface(i);
                if (I.subInterfaces.get(k)) {
                    I.subInterfaces.or(K.subInterfaces);
                }
                ++i;
            }
            K.subInterfaces.set(k);
            ++k;
        }
    }

    BitVector[] closeImplements(BitMatrix R, BitMatrix Rt) {
        BitVector[] rigidImplementors = new BitVector[this.nInterfaces()];
        int iid = 0;
        while (iid < this.nInterfaces()) {
            BitVector I_impls = this.getInterface((int)iid).implementors;
            rigidImplementors[iid] = (BitVector)I_impls.clone();
            int x = I_impls.getLowestSetBit();
            while (x != Integer.MIN_VALUE) {
                rigidImplementors[iid].orAnd(Rt.getRow(x), R.getRow(x));
                x = I_impls.getNextBit(x);
            }
            ++iid;
        }
        int nInt = this.nInterfaces();
        int iid1 = 0;
        while (iid1 < nInt) {
            int iid2 = 0;
            while (iid2 < nInt) {
                if (this.getInterface((int)iid2).subInterfaces.get(iid1)) {
                    rigidImplementors[iid2].or(rigidImplementors[iid1]);
                }
                ++iid2;
            }
            ++iid1;
        }
        return rigidImplementors;
    }

    public void rigidify() {
        S.assume(this.hasBeenInitialized);
        this.R = (BitMatrix)this.C.clone();
        this.R.closure();
        this.Rt = (BitMatrix)this.Ct.clone();
        this.Rt.closure();
        this.m = this.n;
        BitVector[] rigidImplementors = this.closeImplements(this.R, this.Rt);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            this.getInterface((int)iid).rigidImplementors = rigidImplementors[iid];
            ++iid;
        }
        this.domains = new DomainVector(this.m, this.m);
    }

    public void mark() {
        S.assume(this.hasBeenInitialized);
        this.backup = new Backup();
    }

    public void backtrack() {
        if (this.backup == null) {
            return;
        }
        S.assume(this.hasBeenInitialized);
        this.m = this.backup.savedM;
        this.R.setSize(this.m);
        this.Rt.setSize(this.m);
        this.n = this.backup.savedN;
        this.C.setSize(this.n);
        this.Ct.setSize(this.n);
        this.garbage = this.backup.savedGarbage;
        this.domains = this.backup.savedDomains;
        this.minimal.truncate(this.n);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            Interface I = this.getInterface(iid);
            I.setIndexSize(this.n);
            ++iid;
        }
        this.clearTags();
        if (this.backtrackMode == 1) {
            this.backup = this.backup.previous;
        } else {
            this.backup = null;
            this.mark();
        }
        if (debugK0) {
            System.err.println("backtracked #" + this.ID);
        }
    }

    public void ineqIter(IneqIterator iterator) throws Unsatisfiable {
        int to1 = this.n;
        int to2 = this.n;
        int from1 = iterator.range1 == 1 ? this.weakMarkedSize : 0;
        int from2 = iterator.range2 == 1 ? this.weakMarkedSize : 0;
        boolean[] notgarb = new boolean[this.n];
        int i = 0;
        while (i < this.n) {
            notgarb[i] = !this.garbage.get(i);
            ++i;
        }
        int i2 = from1;
        while (i2 < to1) {
            if (notgarb[i2]) {
                int j = this.C.getNextSetInRow(i2, from2 - 1);
                while (j != Integer.MIN_VALUE) {
                    if (notgarb[j]) {
                        iterator.iter(i2, j);
                    }
                    j = this.C.getNextSetInRow(i2, j);
                }
            }
            ++i2;
        }
    }

    public void indexIter(IndexIterator iterator) {
        int i = 0;
        while (i < this.n) {
            if (!this.garbage.get(i)) {
                iterator.iter(i);
            }
            ++i;
        }
    }

    public void implementsIter(ImplementsIterator iterator) throws Unsatisfiable {
        int iid = 0;
        while (iid < this.nInterfaces()) {
            BitVector implementors = this.getInterface((int)iid).implementors;
            int x = implementors.getLowestSetBit();
            while (x != Integer.MIN_VALUE) {
                if (!this.garbage.get(x)) {
                    iterator.iter(x, iid);
                }
                x = implementors.getNextBit(x);
            }
            ++iid;
        }
    }

    public void abstractsIter(AbstractsIterator iterator) throws Unsatisfiable {
        int iid = 0;
        while (iid < this.nInterfaces()) {
            BitVector abstractors = this.getInterface((int)iid).abstractors;
            int x = abstractors.getLowestSetBit();
            while (x != Integer.MIN_VALUE) {
                if (!this.garbage.get(x)) {
                    iterator.iter(x, iid);
                }
                x = abstractors.getNextBit(x);
            }
            ++iid;
        }
    }

    public void weakMark() {
        S.assume(this.weakMarkedSize == -1);
        this.weakMarkedSize = this.n;
        this.weakMarkedM = this.m;
        if (debugK0) {
            System.err.println("weakMark'ed");
        }
    }

    public void weakBacktrack() {
        S.assume(this.weakMarkedSize >= 0);
        this.R.setSize(this.weakMarkedM);
        this.Rt.setSize(this.weakMarkedM);
        int iid = 0;
        while (iid < this.nInterfaces()) {
            this.getInterface((int)iid).rigidImplementors.truncate(this.weakMarkedM);
            ++iid;
        }
        int nMin = this.weakMarkedSize;
        int nMax = this.n;
        this.setSize(this.weakMarkedSize);
        this.weakMarkedSize = -1;
        this.weakMarkedM = -1;
        if (debugK0) {
            System.err.println("weakBacktrack'ed");
        }
    }

    int weakMarkedSize() {
        return this.weakMarkedSize;
    }

    public void startSimplify() {
        S.assume(this.hasBeenInitialized);
        this.weakMark();
        this.posTagged.fill(this.n);
        this.negTagged.fill(this.n);
    }

    public void stopSimplify() {
        S.assume(this.hasBeenInitialized);
        this.weakBacktrack();
    }

    public boolean posTagged(int i) {
        return this.posTagged.get(i);
    }

    public boolean negTagged(int i) {
        return this.negTagged.get(i);
    }

    public void clearTags() {
        this.posTagged.clearAll();
        this.negTagged.clearAll();
    }

    public void tag(int i, int variance) {
        if (variance >= 0) {
            this.posTagged.set(i);
        }
        if (variance <= 0) {
            this.negTagged.set(i);
        }
    }

    public void simplify() {
        S.assume(this.hasBeenInitialized);
        if (this.weakMarkedSize >= 0) {
            if (this.weakMarkedSize == this.n) {
                return;
            }
            if (S.debugSimpl) {
                System.err.println("SIMPL: start simplification");
            }
        } else {
            throw S.panic();
        }
        BitVector simplified = new BitVector(this.n);
        simplified.fill(this.n);
        simplified.fillNot(this.weakMarkedSize);
        new Simplifier(simplified).simplify();
    }

    public void simplify(IndexSelector selector) {
        S.assume(this.hasBeenInitialized);
        BitVector simplified = new BitVector(this.n);
        boolean empty = true;
        int i = 0;
        while (i < this.n) {
            if (selector.select(i)) {
                simplified.set(i);
                empty = false;
            }
            ++i;
        }
        if (!empty) {
            new Simplifier(simplified).simplify();
        }
    }

    public boolean isBeingSimplified(int i) {
        return i >= this.weakMarkedSize;
    }

    public void deleteAllSoft() {
        S.assume(this.hasBeenInitialized);
        this.setSize(this.m);
        this.n = this.m;
    }

    public boolean isLeq(int i1, int i2) {
        return this.R.get(i1, i2);
    }

    public boolean wasEntered(int i1, int i2) {
        return this.C.get(i1, i2);
    }

    private void solveOverloading(int what, int x, BitVector possibilities) {
        S.assume(this.hasBeenInitialized);
        S.assume(this.isValidIndex(x));
        if (this.isRigid(x)) {
            if (what == 0) {
                possibilities.and(this.R.getRow(x));
            } else {
                int iid = possibilities.getLowestSetBit();
                while (iid != Integer.MIN_VALUE) {
                    if (!this.getInterface((int)iid).rigidImplementors.get(x)) {
                        possibilities.clear(iid);
                    }
                    iid = possibilities.getNextBit(iid);
                }
            }
        } else {
            int x0 = possibilities.getLowestSetBit();
            while (x0 != Integer.MIN_VALUE) {
                if (what == 0 && !this.domains.getDomain(x).intersect(this.Rt.getRow(x0))) {
                    possibilities.clear(x0);
                } else if (what == 1 && !this.domains.getDomain(x).containsUnit() && !this.domains.getDomain(x).intersect(this.getInterface((int)x0).rigidImplementors)) {
                    possibilities.clear(x0);
                } else {
                    Object var8_8;
                    Backup savedBackup = this.backup;
                    this.mark();
                    try {
                        try {
                            if (what == 0) {
                                this.leq0(x, x0);
                            } else {
                                this.indexImplements0(x, x0);
                            }
                            this.rawSatisfy();
                        }
                        catch (Unsatisfiable e) {
                            possibilities.clear(x0);
                            var8_8 = null;
                            this.backtrack();
                            this.backup = savedBackup;
                        }
                        var8_8 = null;
                        this.backtrack();
                        this.backup = savedBackup;
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        this.backtrack();
                        this.backup = savedBackup;
                        throw throwable;
                    }
                }
                x0 = possibilities.getNextBit(x0);
            }
        }
    }

    public void solveConstructorOverloading(int x, BitVector possibilities) {
        this.solveOverloading(0, x, possibilities);
    }

    public void solveInterfaceOverloading(int x, BitVector possibilities) {
        this.solveOverloading(1, x, possibilities);
    }

    private final class Simplifier {
        int initN;
        BitVector simplified;
        BitMatrix R;
        BitMatrix Rt;
        BitVector[] implementors;
        DomainVector Sdomains;

        Simplifier(BitVector simplified) {
            this.simplified = simplified;
            this.initN = simplified.getLowestSetBit();
            this.R = (BitMatrix)K0.this.C.clone();
            this.R.closure();
            this.Rt = (BitMatrix)K0.this.Ct.clone();
            this.Rt.closure();
            this.implementors = K0.this.closeImplements(this.R, this.Rt);
            this.Sdomains = new DomainVector(this.initN, K0.this.n, K0.this.n - this.initN);
            int i = this.initN;
            while (i < K0.this.n) {
                if (!simplified.get(i)) {
                    this.Sdomains.clear(i);
                }
                ++i;
            }
        }

        private void computeInitialDomains() {
            if (S.debugSimpl) {
                System.err.println("SIMPL: computing initial domains");
            }
            int x = this.initN;
            while (x < K0.this.n) {
                Domain dx = this.Sdomains.getDomain(x);
                if (dx != null) {
                    BitVector lx;
                    S.assume(x >= K0.this.m0);
                    BitVector ux = this.R.getRow(x);
                    if (ux != null) {
                        int x0 = ux.getLowestSetBit();
                        while (x0 != Integer.MIN_VALUE) {
                            if (!this.simplified.get(x0)) {
                                dx.and(this.Rt.getRow(x0));
                                dx.rawExcludeUnit();
                            }
                            x0 = ux.getNextBit(x0);
                        }
                    }
                    if ((lx = this.Rt.getRow(x)) != null) {
                        int x0 = lx.getLowestSetBit();
                        while (x0 != Integer.MIN_VALUE) {
                            if (!this.simplified.get(x0)) {
                                dx.and(this.R.getRow(x0));
                                dx.rawExcludeUnit();
                            }
                            x0 = lx.getNextBit(x0);
                        }
                    }
                    int iid = 0;
                    while (iid < K0.this.nInterfaces()) {
                        if (this.implementors[iid].get(x)) {
                            dx.and(this.implementors[iid]);
                        }
                        ++iid;
                    }
                    if (K0.this.posTagged(x)) {
                        dx.and(this.Rt.getRow(x));
                        dx.rawExcludeUnit();
                    }
                    if (K0.this.negTagged(x)) {
                        dx.and(this.R.getRow(x));
                        dx.rawExcludeUnit();
                    }
                }
                ++x;
            }
            if (S.debugSimpl) {
                System.err.println("SIMPL: initial domains are : " + K0.this.domainsToString());
            }
        }

        private void findSolution(int[] strategy, int[] solution) throws LowlevelUnsatisfiable {
            block2: {
                RuntimeException abort = new RuntimeException();
                try {
                    Satisfier.enumerateSolutions(strategy, this.Sdomains, K0.this.C, K0.this.Ct, this.R, this.Rt, this.initN, K0.this.n, new LowlevelSolutionHandler(this, solution, abort){
                        private final /* synthetic */ int[] val$solution;
                        private final /* synthetic */ RuntimeException val$abort;
                        private final /* synthetic */ Simplifier this$1;
                        {
                            this.this$1 = this$1;
                            this.val$solution = val$solution;
                            this.val$abort = val$abort;
                        }

                        protected void handle() {
                            int x = this.this$1.initN;
                            while (x < K0.access$400(Simplifier.access$1100(this.this$1))) {
                                this.val$solution[x - this.this$1.initN] = this.this$1.Sdomains.getDomain(x) != null ? this.getSolutionOf(x) : x;
                                ++x;
                            }
                            throw this.val$abort;
                        }
                    });
                }
                catch (RuntimeException e) {
                    if (e == abort) break block2;
                    throw e;
                }
            }
        }

        private int findNonSurjective(int excludedA, int[] strategy, int[] solution) throws Normal {
            while (excludedA >= this.initN) {
                if (!K0.this.garbage.get(excludedA) && this.simplified.get(excludedA)) {
                    Object var8_7;
                    DomainVector savedDomains = (DomainVector)this.Sdomains.clone();
                    try {
                        try {
                            if (S.debugSimpl) {
                                System.err.println("Try excluding " + excludedA);
                            }
                            this.Sdomains.exclude(excludedA);
                            if (S.debugSimpl) {
                                System.err.println("Satisfying with " + this.Sdomains.dump());
                            }
                            this.findSolution(strategy, solution);
                            int n = excludedA;
                            var8_7 = null;
                            this.Sdomains = savedDomains;
                            return n;
                        }
                        catch (LowlevelUnsatisfiable e) {
                            if (S.debugSimpl) {
                                System.err.println("Failed");
                            }
                            var8_7 = null;
                            this.Sdomains = savedDomains;
                        }
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        this.Sdomains = savedDomains;
                        throw throwable;
                    }
                }
                --excludedA;
            }
            throw new Normal();
        }

        private void simplifyIndex(int x, int[] solution, int[] nker) {
            if (S.debugSimpl) {
                System.err.println("x = " + x + " nker[x - initN] = " + nker[x - this.initN] + " garbage.get(x) = " + K0.this.garbage.get(x));
            }
            while (x >= this.initN && this.simplified.get(x) && nker[x - this.initN] == 0) {
                if (S.debugSimpl) {
                    System.err.println("Eliminate " + x);
                }
                try {
                    int y = 0;
                    while (y < K0.this.n) {
                        if (!K0.this.garbage.get(y)) {
                            BitVector lx;
                            BitVector ux;
                            if (x != y && K0.this.C.get(y, x) && (ux = K0.this.C.getRow(x)) != null) {
                                K0.this.C.getRow(y).or(ux);
                            }
                            if (x != y && K0.this.Ct.get(y, x) && (lx = K0.this.Ct.getRow(x)) != null) {
                                K0.this.Ct.getRow(y).or(lx);
                            }
                        }
                        ++y;
                    }
                    this.Sdomains.clear(x);
                    this.Sdomains.exclude(x);
                    K0.this.domains.clear(x);
                    this.simplified.clear(x);
                    K0.this.garbage.set(x);
                    int sx = solution[x - this.initN];
                    if (sx >= this.initN) {
                        int n = sx - this.initN;
                        nker[n] = nker[n] - 1;
                    }
                    if (K0.this.posTagged(x) || K0.this.negTagged(x)) {
                        S.assume(sx >= 0);
                        if (S.debugSimpl) {
                            System.err.println("Merge " + x + " and " + sx);
                        }
                        if (this.simplified.get(sx)) {
                            if (K0.this.posTagged(x) && !K0.this.posTagged(sx)) {
                                this.Sdomains.reduce(sx, false, this.Rt.getRow(sx));
                                K0.this.posTagged.set(sx);
                            }
                            if (K0.this.negTagged(x) && !K0.this.negTagged(sx)) {
                                this.Sdomains.reduce(sx, false, this.R.getRow(sx));
                                K0.this.negTagged.set(sx);
                            }
                        }
                        K0.this.callbacks.indexMerged(x, sx);
                    } else {
                        K0.this.callbacks.indexDiscarded(x);
                    }
                    x = sx;
                }
                catch (Unsatisfiable e) {
                    throw S.panic();
                }
            }
        }

        private void simplifyOnce(int[] solution) {
            int[] nker = new int[K0.this.n - this.initN];
            int x = this.initN;
            while (x < K0.this.n) {
                int sx;
                if (!K0.this.garbage.get(x) && (sx = solution[x - this.initN]) >= this.initN) {
                    int n = sx - this.initN;
                    nker[n] = nker[n] + 1;
                }
                ++x;
            }
            int x2 = this.initN;
            while (x2 < K0.this.n) {
                this.simplifyIndex(x2, solution, nker);
                ++x2;
            }
        }

        String indexToString(int index) {
            return K0.this.indexToString(index) + (K0.this.posTagged(index) ? "+" : "") + (K0.this.negTagged(index) ? "-" : "");
        }

        private void reduce(BitMatrix C, BitMatrix R, BitMatrix Rt) {
            BitVector garbage = K0.this.garbage;
            if (S.debugSimpl) {
                System.err.println("reduce C = " + C + ", R = " + R + ", garbage = " + garbage);
            }
            int k = 0;
            while (k < K0.this.n) {
                if (!garbage.get(k)) {
                    C.clear(k, k);
                    BitVector uk = R.getRow(k);
                    BitVector lk = Rt.getRow(k);
                    int j = lk.getLowestSetBit();
                    while (j != Integer.MIN_VALUE) {
                        BitVector uj;
                        if (!garbage.get(j) && !uk.get(j) && (uj = C.getRow(j)) != null) {
                            if (this.simplified.get(j)) {
                                uj.andNotOr(uk, lk);
                            } else {
                                uj.andNotAndOr(this.simplified, uk, lk);
                            }
                        }
                        j = lk.getNextBit(j);
                    }
                }
                ++k;
            }
            if (S.debugSimpl) {
                System.err.println("reduced C = " + C + ", R = " + R + ", garbage = " + garbage);
            }
        }

        private void reduceImplements() {
            int iid = 0;
            while (iid < K0.this.nInterfaces()) {
                Interface I = K0.this.getInterface(iid);
                BitVector lI = this.implementors[iid];
                BitVector Iimplementors = I.implementors;
                int k = lI.getLowestSetBit();
                while (k != Integer.MIN_VALUE) {
                    if (!K0.this.garbage.get(k)) {
                        Iimplementors.andNotAndOr(this.simplified, this.Rt.getRow(k), this.R.getRow(k));
                    }
                    k = lI.getNextBit(k);
                }
                ++iid;
            }
            int iid2 = 0;
            while (iid2 < K0.this.nInterfaces()) {
                Interface I2 = K0.this.getInterface(iid2);
                BitVector I2sub = I2.subInterfaces;
                BitVector I2implementors = I2.implementors;
                int iid1 = I2sub.getLowestSetBit();
                while (iid1 != Integer.MIN_VALUE) {
                    Interface I1 = K0.this.getInterface(iid1);
                    if (!I1.subInterfaces.get(iid2)) {
                        I2implementors.andNotAnd(this.implementors[iid1], this.simplified);
                    }
                    iid1 = I2sub.getNextBit(iid1);
                }
                ++iid2;
            }
        }

        void reduce() {
            if (S.debugSimpl) {
                System.err.println("starting reduction: K = " + K0.this);
            }
            this.reduce(K0.this.C, this.R, this.Rt);
            this.reduce(K0.this.Ct, this.Rt, this.R);
            this.reduceImplements();
            if (S.debugSimpl) {
                System.err.println("finished reduction: K = " + K0.this);
            }
        }

        void simplify() {
            if (this.initN < 0) {
                return;
            }
            this.computeInitialDomains();
            try {
                int[] solution = new int[K0.this.n - this.initN];
                int[] strategy = Satisfier.compileStrategy(K0.this.C, K0.this.Ct, this.initN, K0.this.n);
                int excludedA = K0.this.n - 1;
                while (true) {
                    if (K0.this.n - K0.this.garbage.bitCount() == 1) {
                        int x = K0.this.garbage.getLowestClearedBit();
                        if (this.simplified.get(x) && !K0.this.posTagged(x) && !K0.this.negTagged(x)) {
                            K0.this.setSize(0);
                            K0.this.callbacks.indexDiscarded(x);
                            return;
                        }
                        if (x != 0) {
                            K0.this.indexMove(x, 0);
                        }
                        K0.this.setSize(1);
                        K0.this.C.clear(0, 0);
                        K0.this.Ct.clear(0, 0);
                        return;
                    }
                    if (S.debugSimpl) {
                        System.err.println("Try to simplify " + K0.this.toString());
                        System.err.println("with domains " + this.Sdomains.dump());
                    }
                    excludedA = this.findNonSurjective(excludedA, strategy, solution);
                    if (S.debugSimpl) {
                        System.err.print(" sigma = {");
                        Separator sep = new Separator(", ");
                        int x = this.initN;
                        while (x < K0.this.n) {
                            if (this.Sdomains.getDomain(x) != null) {
                                System.err.print(sep);
                                System.err.print(this.indexToString(x));
                                System.err.print(" -> ");
                                int sx = solution[x - this.initN];
                                if (sx == -1) {
                                    System.err.print("unit");
                                } else {
                                    System.err.print(this.indexToString(sx));
                                }
                            }
                            ++x;
                        }
                        System.err.println("}");
                    }
                    this.simplifyOnce(solution);
                }
            }
            catch (Normal e) {
                this.reduce();
                K0.this.collect();
                return;
            }
        }

        static /* synthetic */ K0 access$1100(Simplifier x0) {
            return x0.K0.this;
        }

        private class Normal
        extends Exception {
            private Normal() {
            }
        }
    }

    public static abstract class IndexSelector {
        protected abstract boolean select(int var1);
    }

    public static abstract class AbstractsIterator {
        protected abstract void iter(int var1, int var2) throws Unsatisfiable;
    }

    public static abstract class ImplementsIterator {
        protected abstract void iter(int var1, int var2) throws Unsatisfiable;
    }

    public static abstract class IndexIterator {
        protected abstract void iter(int var1);
    }

    public static abstract class IneqIterator {
        int range1;
        int range2;

        public IneqIterator() {
            this.range2 = 0;
            this.range1 = 0;
        }

        public IneqIterator(int range1, int range2) {
            this.range1 = range1;
            this.range2 = range2;
        }

        protected abstract void iter(int var1, int var2) throws Unsatisfiable;
    }

    private class Backup {
        Backup previous;
        int savedM;
        int savedN;
        BitVector savedGarbage;
        DomainVector savedDomains;

        private Backup() {
            this.previous = K0.this.backtrackMode == 1 ? K0.this.backup : null;
            this.savedM = K0.this.m;
            this.savedN = K0.this.n;
            this.savedGarbage = (BitVector)K0.this.garbage.clone();
            this.savedDomains = (DomainVector)K0.this.domains.clone();
        }
    }

    public static abstract class Callbacks {
        protected abstract void indexMerged(int var1, int var2) throws Unsatisfiable;

        protected abstract void indexMoved(int var1, int var2);

        protected abstract void indexDiscarded(int var1);

        protected String getName() {
            return "<k0>";
        }

        protected String indexToString(int x) {
            return Integer.toString(x);
        }

        protected String interfaceToString(int iid) {
            return Integer.toString(iid);
        }
    }
}

