/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import mlsub.typing.lowlevel.InternalError;

public class BackableList {
    private ArrayList content;
    private Stack backups = new Stack();
    private boolean iterationInProgress = false;
    private Stack waitingElements = new Stack();

    public BackableList() {
        this.content = new ArrayList();
    }

    public BackableList(int capacity) {
        this.content = new ArrayList(capacity);
    }

    public void mark() {
        this.backups.push(this.content);
        this.content = (ArrayList)this.content.clone();
    }

    public void backtrack() {
        this.content = (ArrayList)this.backups.pop();
    }

    public void add(Object element) {
        if (this.iterationInProgress) {
            this.waitingElements.push(element);
        } else {
            this.content.add(element);
        }
    }

    public void remove(Object element) {
        if (this.iterationInProgress) {
            throw new InternalError("remove during iteration in BackableList");
        }
        ((AbstractCollection)this.content).remove(element);
    }

    public boolean contains(Object element) {
        return this.content.contains(element);
    }

    public void clear() {
        this.content.clear();
    }

    public Iterator iterator() {
        if (this.iterationInProgress) {
            throw new InternalError("Concurrent iterations in BackableList");
        }
        this.iterationInProgress = true;
        return ((AbstractList)this.content).iterator();
    }

    public void endOfIteration() {
        if (!this.iterationInProgress) {
            throw new InternalError("No iterations to end in BackableList");
        }
        this.iterationInProgress = false;
        while (!this.waitingElements.empty()) {
            this.content.add(this.waitingElements.pop());
        }
    }

    public String toString() {
        return this.content.toString();
    }
}

