/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class PrettyWriter
extends Writer {
    protected Writer out;
    int lineLength = 80;
    public boolean isPrettyPrinting;
    public static int initialBufferSize = 126;
    public char[] buffer = new char[initialBufferSize];
    public int bufferFillPointer;
    int bufferOffset;
    int bufferStartColumn;
    int lineNumber;
    int[] blocks = new int[60];
    private static final int LOGICAL_BLOCK_LENGTH = 6;
    private static final int BLOCK_START_COLUMN = -1;
    private static final int BLOCK_SECTION_COLUMN = -2;
    private static final int BLOCK_PER_LINE_PREFIX_END = -3;
    private static final int BLOCK_PREFIX_LENGTH = -4;
    private static final int BLOCK_SUFFIX_LENGTH = -5;
    private static final int BLOCK_SECTION_START_LINE = -6;
    int blockDepth = 6;
    char[] prefix = new char[initialBufferSize];
    char[] suffix = new char[initialBufferSize];
    static final int QUEUE_INIT_ALLOC_SIZE = 300;
    int[] queueInts = new int[300];
    String[] queueStrings = new String[300];
    int queueTail;
    int queueSize;
    int currentBlock;
    public int pendingBlocksCount;
    static final int QUEUED_OP_TYPE = 0;
    static final int QUEUED_OP_POSN = 1;
    static final int QUEUED_OP_SIZE = 2;
    static final int QUEUED_OP_DUMMY_TYPE = 0;
    static final int QUEUED_OP_SECTION_START_SIZE = 4;
    static final int QUEUED_OP_SECTION_START_DEPTH = 2;
    static final int QUEUED_OP_SECTION_START_SECTION_END = 3;
    static final int QUEUED_OP_NEWLINE_TYPE = 2;
    static final int QUEUED_OP_NEWLINE_SIZE = 5;
    static final int QUEUED_OP_NEWLINE_KIND = 4;
    public static final int NEWLINE_LINEAR = 78;
    public static final int NEWLINE_LITERAL = 76;
    public static final int NEWLINE_FILL = 70;
    public static final int NEWLINE_MISER = 77;
    public static final int NEWLINE_MANDATORY = 82;
    static final int QUEUED_OP_INDENTATION_TYPE = 3;
    static final int QUEUED_OP_INDENTATION_SIZE = 4;
    static final int QUEUED_OP_INDENTATION_KIND = 2;
    static final int QUEUED_OP_INDENTATION_BLOCK = 66;
    static final int QUEUED_OP_INDENTATION_CURRENT = 67;
    static final int QUEUED_OP_INDENTATION_AMOUNT = 3;
    static final int QUEUED_OP_BLOCK_START_TYPE = 4;
    static final int QUEUED_OP_BLOCK_START_SIZE = 5;
    static final int QUEUED_OP_BLOCK_START_BLOCK_END = 4;
    static final int QUEUED_OP_BLOCK_PREFIX = 0;
    static final int QUEUED_OP_BLOCK_START_SUFFIX = 1;
    static final int QUEUED_OP_BLOCK_END_TYPE = 5;
    static final int QUEUED_OP_BLOCK_END_SIZE = 2;
    static final int QUEUED_OP_TAB_TYPE = 6;
    static final int QUEUED_OP_TAB_SIZE = 5;
    static final int QUEUED_OP_TAB_FLAGS = 2;
    static final int QUEUED_OP_TAB_IS_SECTION = 1;
    static final int QUEUED_OP_TAB_IS_RELATIVE = 2;
    static final int QUEUED_OP_TAB_COLNUM = 3;
    static final int QUEUED_OP_TAB_COLINC = 4;
    int miserWidth;

    public PrettyWriter(Writer base) {
        this.out = this.out;
        this.isPrettyPrinting = true;
    }

    public PrettyWriter(Writer out, int lineLength) {
        this.out = out;
        this.lineLength = lineLength;
        this.isPrettyPrinting = lineLength > 1;
    }

    public PrettyWriter(Writer out, boolean isPrettyPrinting) {
        this.out = out;
        this.isPrettyPrinting = isPrettyPrinting;
    }

    private int indexPosn(int index) {
        return index + this.bufferOffset;
    }

    private int posnIndex(int posn) {
        return posn - this.bufferOffset;
    }

    private int posnColumn(int posn) {
        return this.indexColumn(this.posnIndex(posn));
    }

    private int getQueueType(int index) {
        return this.queueInts[index] & 0xFF;
    }

    private int getQueueSize(int index) {
        return this.queueInts[index] >> 16;
    }

    private int getSectionColumn() {
        return this.blocks[this.blockDepth + -2];
    }

    private int getStartColumn() {
        return this.blocks[this.blockDepth + -1];
    }

    private int getPerLinePrefixEnd() {
        return this.blocks[this.blockDepth + -3];
    }

    private int getPrefixLength() {
        return this.blocks[this.blockDepth + -4];
    }

    private int getSuffixLength() {
        return this.blocks[this.blockDepth + -5];
    }

    private int getSectionStartLine() {
        return this.blocks[this.blockDepth + -6];
    }

    public void write(int ch) {
        if (ch == 10 && this.isPrettyPrinting) {
            this.enqueueNewline(76);
        } else {
            this.ensureSpaceInBuffer(1);
            int fillPointer = this.bufferFillPointer;
            this.buffer[fillPointer] = (char)ch;
            this.bufferFillPointer = 1 + fillPointer;
        }
    }

    public void write(String str) {
        this.write(str, 0, str.length());
    }

    public void write(String str, int start, int count) {
        while (count > 0) {
            int cnt = count;
            int available = this.ensureSpaceInBuffer(count);
            if (cnt > available) {
                cnt = available;
            }
            int fillPointer = this.bufferFillPointer;
            count -= cnt;
            while (--cnt >= 0) {
                char ch;
                if ((ch = str.charAt(start++)) == '\n' && this.isPrettyPrinting) {
                    this.bufferFillPointer = fillPointer;
                    this.enqueueNewline(76);
                    fillPointer = this.bufferFillPointer;
                    continue;
                }
                this.buffer[fillPointer++] = ch;
            }
            this.bufferFillPointer = fillPointer;
        }
    }

    public void write(char[] str) {
        this.write(str, 0, str.length);
    }

    public void write(char[] str, int start, int count) {
        int end = start + count;
        block0: while (count > 0) {
            int cnt;
            int i = start;
            while (i < end) {
                if (str[i] == '\n' && this.isPrettyPrinting) {
                    this.write(str, start, i - start);
                    this.enqueueNewline(76);
                    start = i + 1;
                    count = end - start;
                    continue block0;
                }
                ++i;
            }
            do {
                int available;
                cnt = (available = this.ensureSpaceInBuffer(count)) < count ? available : count;
                int fillPointer = this.bufferFillPointer;
                int newFillPtr = fillPointer + cnt;
                int i2 = fillPointer;
                while (i2 < newFillPtr) {
                    this.buffer[i2] = str[start++];
                    ++i2;
                }
                this.bufferFillPointer = newFillPtr;
            } while ((count -= cnt) != 0);
        }
    }

    private void pushLogicalBlock(int column, int perLineEnd, int prefixLength, int suffixLength, int sectionStartLine) {
        int newLength = this.blockDepth + 6;
        if (newLength >= this.blocks.length) {
            int[] newBlocks = new int[2 * this.blocks.length];
            System.arraycopy(this.blocks, 0, newBlocks, 0, this.blockDepth);
            this.blocks = newBlocks;
        }
        this.blockDepth = newLength;
        this.blocks[this.blockDepth + -1] = column;
        this.blocks[this.blockDepth + -2] = column;
        this.blocks[this.blockDepth + -3] = perLineEnd;
        this.blocks[this.blockDepth + -4] = prefixLength;
        this.blocks[this.blockDepth + -5] = suffixLength;
        this.blocks[this.blockDepth + -6] = sectionStartLine;
    }

    void reallyStartLogicalBlock(int column, String prefix, String suffix) {
        int perLineEnd = this.getPerLinePrefixEnd();
        int prefixLength = this.getPrefixLength();
        int suffixLength = this.getSuffixLength();
        this.pushLogicalBlock(column, perLineEnd, prefixLength, suffixLength, this.lineNumber);
        this.setIndentation(column);
        if (prefix != null) {
            this.blocks[this.blockDepth + -3] = column;
            int plen = prefix.length();
            prefix.getChars(0, plen, this.suffix, column - plen);
        }
        if (suffix != null) {
            char[] totalSuffix = this.suffix;
            int totalSuffixLen = totalSuffix.length;
            int additional = suffix.length();
            int newSuffixLen = suffixLength + additional;
            if (newSuffixLen > totalSuffixLen) {
                int newTotalSuffixLen = PrettyWriter.enoughSpace(totalSuffixLen, additional);
                this.suffix = new char[newTotalSuffixLen];
                System.arraycopy(totalSuffix, totalSuffixLen - suffixLength, this.suffix, newTotalSuffixLen - suffixLength, suffixLength);
                totalSuffixLen = newTotalSuffixLen;
            }
            suffix.getChars(0, additional, totalSuffix, totalSuffixLen - newSuffixLen);
            this.blocks[this.blockDepth + -5] = newSuffixLen;
        }
    }

    int enqueueTab(int flags, int colnum, int colinc) {
        int addr = this.enqueue(6, 5);
        this.queueInts[addr + 2] = flags;
        this.queueInts[addr + 3] = colnum;
        this.queueInts[addr + 4] = colinc;
        return addr;
    }

    private static int enoughSpace(int current, int want) {
        int doubled = 2 * current;
        int enough = current + (5 * want >> 2);
        return doubled > enough ? doubled : enough;
    }

    public void setIndentation(int column) {
        char[] prefix = this.prefix;
        int prefixLen = prefix.length;
        int current = this.getPrefixLength();
        int minimum = this.getPerLinePrefixEnd();
        if (minimum > column) {
            column = minimum;
        }
        if (column > prefixLen) {
            prefix = new char[PrettyWriter.enoughSpace(prefixLen, column - prefixLen)];
            System.arraycopy(this.prefix, 0, prefix, 0, current);
            this.prefix = prefix;
        }
        if (column > current) {
            int i = current;
            while (i < column) {
                prefix[i] = 32;
                ++i;
            }
        }
        this.blocks[this.blockDepth + -4] = column;
    }

    void reallyEndLogicalBlock() {
        int oldIndent = this.getPrefixLength();
        this.blockDepth -= 6;
        int newIndent = this.getPrefixLength();
        if (newIndent > oldIndent) {
            int i = oldIndent;
            while (i < newIndent) {
                this.prefix[i] = 32;
                ++i;
            }
        }
    }

    public int enqueue(int kind, int size) {
        int addr;
        int oldLength = this.queueInts.length;
        int endAvail = oldLength - this.queueTail - this.queueSize;
        if (endAvail > 0 && size > endAvail) {
            this.enqueue(0, endAvail);
        }
        if (this.queueSize + size > oldLength) {
            int newLength = PrettyWriter.enoughSpace(oldLength, size);
            int[] newInts = new int[newLength];
            String[] newStrings = new String[newLength];
            int queueHead = this.queueTail + this.queueSize - oldLength;
            if (queueHead > 0) {
                System.arraycopy(this.queueInts, 0, newInts, 0, queueHead);
                System.arraycopy(this.queueStrings, 0, newStrings, 0, queueHead);
            }
            int part1Len = oldLength - this.queueTail;
            int deltaLength = newLength - oldLength;
            System.arraycopy(this.queueInts, this.queueTail, newInts, this.queueTail + deltaLength, part1Len);
            System.arraycopy(this.queueStrings, this.queueTail, newStrings, this.queueTail + deltaLength, part1Len);
            this.queueInts = newInts;
            this.queueStrings = newStrings;
            if (this.currentBlock >= this.queueTail) {
                this.currentBlock += deltaLength;
            }
            this.queueTail += deltaLength;
        }
        if ((addr = this.queueTail + this.queueSize) >= this.queueInts.length) {
            addr -= this.queueInts.length;
        }
        this.queueInts[addr + 0] = kind | size << 16;
        if (size > 1) {
            this.queueInts[addr + 1] = this.indexPosn(this.bufferFillPointer);
        }
        this.queueSize += size;
        return addr;
    }

    public void enqueueNewline(int kind) {
        int depth = this.pendingBlocksCount;
        int newline = this.enqueue(2, 5);
        this.queueInts[newline + 4] = kind;
        this.queueInts[newline + 2] = this.pendingBlocksCount;
        this.queueInts[newline + 3] = 0;
        int entry = this.queueTail;
        int todo = this.queueSize;
        while (todo > 0) {
            if (entry == this.queueInts.length) {
                entry = 0;
            }
            if (entry == newline) break;
            int type = this.getQueueType(entry);
            if ((type == 2 || type == 4) && this.queueInts[entry + 3] == 0 && depth <= this.queueInts[entry + 2]) {
                int delta = newline - entry;
                if (delta < 0) {
                    delta += this.queueInts.length;
                }
                this.queueInts[entry + 3] = delta;
            }
            int size = this.getQueueSize(entry);
            todo -= size;
            entry += size;
        }
        this.maybeOutput(kind == 76 || kind == 82);
    }

    public final void writeBreak(int kind) {
        if (this.isPrettyPrinting) {
            this.enqueueNewline(kind);
        }
    }

    public int enqueueIndent(int kind, int amount) {
        int result = this.enqueue(3, 4);
        this.queueInts[result + 2] = kind;
        this.queueInts[result + 3] = amount;
        return result;
    }

    public void addIndentation(int amount, boolean current) {
        if (this.isPrettyPrinting) {
            this.enqueueIndent(current ? 67 : 66, amount);
        }
    }

    public void startLogicalBlock(String prefix, boolean perLine, String suffix) {
        if (prefix != null) {
            this.write(prefix);
        }
        if (!this.isPrettyPrinting) {
            return;
        }
        int start = this.enqueue(4, 5);
        this.queueInts[start + 2] = this.pendingBlocksCount;
        this.queueStrings[start + 0] = perLine ? prefix : null;
        this.queueStrings[start + 1] = suffix;
        ++this.pendingBlocksCount;
        this.currentBlock -= start;
        if (this.currentBlock > 0) {
            this.currentBlock -= this.queueInts.length;
        }
        this.queueInts[start + 3] = 0;
        this.queueInts[start + 4] = this.currentBlock;
        this.currentBlock = start;
    }

    public void endLogicalBlock() {
        int endFromStart;
        String suffix;
        int end = this.enqueue(5, 2);
        --this.pendingBlocksCount;
        if (this.blockDepth >= 6 * (this.pendingBlocksCount + 2)) {
            int suffixLength = this.blocks[this.blockDepth + -5];
            int suffixPreviousLength = this.blocks[this.blockDepth - 6 + -5];
            if (suffixLength > suffixPreviousLength) {
                this.write(this.suffix, this.suffix.length - suffixLength, suffixLength - suffixPreviousLength);
            }
            return;
        }
        int start = this.currentBlock;
        this.currentBlock = this.queueInts[start + 4];
        this.currentBlock += start;
        if (this.currentBlock < 0) {
            this.currentBlock += this.queueInts.length;
        }
        if ((suffix = this.queueStrings[start + 1]) != null) {
            this.write(suffix);
        }
        if ((endFromStart = end - start) < 0) {
            endFromStart += this.queueInts.length;
        }
        this.queueInts[start + 4] = endFromStart;
    }

    public void endLogicalBlock(String suffix) {
        if (this.isPrettyPrinting) {
            this.endLogicalBlock();
        } else if (suffix != null) {
            this.write(suffix);
        }
    }

    int computeTabSize(int tab, int sectionStart, int column) {
        int flags = this.queueInts[tab + 2];
        boolean isSection = (flags & 1) != 0;
        boolean isRelative = (flags & 2) != 0;
        int origin = isSection ? sectionStart : 0;
        int colnum = this.queueInts[tab + 3];
        int colinc = this.queueInts[tab + 4];
        if (isRelative) {
            int newposn;
            int rem;
            if (colinc > 1 && (rem = (newposn = column + colnum) % colinc) != 0) {
                colinc = rem;
                colnum += colinc;
            }
            return colnum;
        }
        if (column <= colnum + origin) {
            return column + origin - column;
        }
        return colinc - (column - origin) % colinc;
    }

    int indexColumn(int index) {
        int column = this.bufferStartColumn;
        int sectionStart = this.getSectionColumn();
        int endPosn = this.indexPosn(index);
        int op = this.queueTail;
        int todo = this.queueSize;
        while (todo > 0) {
            int posn;
            if (op >= this.queueInts.length - 1) {
                op = 0;
            }
            if ((posn = this.queueInts[op + 1]) >= endPosn) break;
            int type = this.getQueueType(op);
            if (type == 6) {
                column += this.computeTabSize(op, sectionStart, column + this.posnIndex(posn));
            } else if (type == 2 || type == 4) {
                sectionStart = column + this.posnIndex(this.queueInts[op + 1]);
            }
            int size = this.getQueueSize(op);
            todo -= size;
            op += size;
        }
        return column + index;
    }

    void expandTabs(int through) {
        int numInsertions = 0;
        int additional = 0;
        int column = this.bufferStartColumn;
        int sectionStart = this.getSectionColumn();
        int op = this.queueTail;
        int todo = this.queueSize;
        int blocksUsed = 6 * this.pendingBlocksCount;
        while (todo > 0) {
            if (op == this.queueInts.length) {
                op = 0;
            }
            if (op == through) break;
            int type = this.getQueueType(op);
            if (type == 6) {
                int index = this.posnIndex(this.queueInts[op + 1]);
                int tabsize = this.computeTabSize(op, sectionStart, column + index);
                if (tabsize != 0) {
                    if (blocksUsed + 2 * numInsertions + 1 >= this.blocks.length) {
                        int[] newBlocks = new int[2 * this.blocks.length];
                        System.arraycopy(this.blocks, 0, newBlocks, 0, this.blocks.length);
                        this.blocks = newBlocks;
                    }
                    this.blocks[blocksUsed + 2 * numInsertions] = index;
                    this.blocks[blocksUsed + 2 * numInsertions + 1] = tabsize;
                    ++numInsertions;
                    additional += tabsize;
                    column += tabsize;
                }
            } else if (op == 2 || op == 4) {
                sectionStart = column + this.posnIndex(this.queueInts[op + 1]);
            }
            int size = this.getQueueSize(op);
            todo -= size;
            op += size;
        }
        if (numInsertions > 0) {
            char[] buffer;
            int fillPtr = this.bufferFillPointer;
            int newFillPtr = fillPtr + additional;
            char[] newBuffer = buffer = this.buffer;
            int length = buffer.length;
            int end = fillPtr;
            if (newFillPtr > length) {
                int newLength = PrettyWriter.enoughSpace(fillPtr, additional);
                this.buffer = newBuffer = new char[newLength];
            }
            this.bufferFillPointer = newFillPtr;
            this.bufferOffset -= additional;
            int i = numInsertions;
            while (--i >= 0) {
                int srcpos = this.blocks[blocksUsed + 2 * i];
                int amount = this.blocks[blocksUsed + 2 * i + 1];
                int dstpos = srcpos + additional;
                System.arraycopy(buffer, srcpos, newBuffer, dstpos, end - srcpos);
                int j = dstpos - amount;
                while (j < dstpos) {
                    newBuffer[j] = 32;
                    ++j;
                }
                additional -= amount;
                end = srcpos;
            }
            if (newBuffer != buffer) {
                System.arraycopy(buffer, 0, newBuffer, 0, end);
            }
        }
    }

    int ensureSpaceInBuffer(int want) {
        char[] buffer = this.buffer;
        int length = buffer.length;
        int fillPtr = this.bufferFillPointer;
        int available = length - fillPtr;
        if (available > 0) {
            return available;
        }
        if (this.isPrettyPrinting && fillPtr > this.lineLength) {
            if (!this.maybeOutput(false)) {
                this.outputPartialLine();
            }
            return this.ensureSpaceInBuffer(want);
        }
        int newLength = PrettyWriter.enoughSpace(length, want);
        char[] newBuffer = new char[newLength];
        this.buffer = newBuffer;
        int i = fillPtr;
        while (--i >= 0) {
            newBuffer[i] = buffer[i];
        }
        return newLength - fillPtr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean maybeOutput(boolean forceNewlines) {
        boolean outputAnything = false;
        block13: while (this.queueSize > 0) {
            if (this.queueTail >= this.queueInts.length) {
                this.queueTail = 0;
            }
            int next = this.queueTail;
            int type = this.getQueueType(next);
            switch (type) {
                case 2: {
                    boolean cond;
                    switch (this.queueInts[next + 4]) {
                        default: {
                            cond = true;
                            break;
                        }
                        case 77: {
                            cond = this.isMisering();
                            break;
                        }
                        case 70: {
                            if (this.isMisering() || this.lineNumber > this.getSectionStartLine()) {
                                cond = true;
                                break;
                            }
                            int end = this.queueInts[next + 3];
                            if (end == 0) {
                                end = -1;
                            } else if ((end = next + end) >= this.queueInts.length) {
                                end -= this.queueInts.length;
                            }
                            int fits = this.fitsOnLine(end, forceNewlines);
                            if (fits > 0) {
                                cond = false;
                                break;
                            }
                            if (fits >= 0) break block13;
                            cond = true;
                        }
                    }
                    if (!cond) break;
                    outputAnything = true;
                    try {
                        this.outputLine(next);
                        break;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex.toString());
                    }
                }
                case 3: {
                    if (this.isMisering()) break;
                    int kind = this.queueInts[next + 2];
                    int indent = this.queueInts[next + 3];
                    indent = kind == 66 ? (indent += this.getStartColumn()) : (indent += this.posnColumn(this.queueInts[next + 1]));
                    this.setIndentation(indent);
                    break;
                }
                case 4: {
                    int end = this.queueInts[next + 3];
                    end = end > 0 ? (end + next) % this.queueInts.length : -1;
                    int fits = this.fitsOnLine(end, forceNewlines);
                    if (fits > 0) {
                        int endr = this.queueInts[next + 4];
                        next = (endr + next) % this.queueInts.length;
                        this.expandTabs(next);
                        this.queueTail = next;
                        this.queueSize -= endr;
                        break;
                    }
                    if (fits >= 0) break block13;
                    String prefix = this.queueStrings[next + 0];
                    String suffix = this.queueStrings[next + 1];
                    this.reallyStartLogicalBlock(this.posnColumn(this.queueInts[next + 1]), prefix, suffix);
                    break;
                }
                case 5: {
                    this.reallyEndLogicalBlock();
                    break;
                }
                case 6: {
                    this.expandTabs(next);
                }
            }
            int size = this.getQueueSize(this.queueTail);
            this.queueSize -= size;
            this.queueTail = next + size;
        }
        return outputAnything;
    }

    protected int getMiserWidth() {
        return 40;
    }

    boolean isMisering() {
        int mwidth = this.getMiserWidth();
        return mwidth > 0 && this.lineLength - this.getStartColumn() <= mwidth;
    }

    int getMaxLines() {
        return -1;
    }

    boolean printReadably() {
        return true;
    }

    int fitsOnLine(int sectionEnd, boolean forceNewlines) {
        int available = this.lineLength;
        if (!this.printReadably() && this.getMaxLines() == this.lineNumber) {
            available -= 3;
            available -= this.getSuffixLength();
        }
        if (sectionEnd >= 0) {
            return this.posnColumn(this.queueInts[sectionEnd + 1]) <= available ? 1 : -1;
        }
        if (forceNewlines) {
            return -1;
        }
        if (this.indexColumn(this.bufferFillPointer) > available) {
            return -1;
        }
        return 0;
    }

    public void lineAbbreviationHappened() {
    }

    void outputLine(int newline) throws IOException {
        int maxLines;
        int amountToPrint;
        int amountToConsume;
        boolean isLiteral;
        char[] buffer;
        block7: {
            buffer = this.buffer;
            int kind = this.queueInts[newline + 4];
            isLiteral = kind == 76;
            amountToConsume = this.posnIndex(this.queueInts[newline + 1]);
            if (isLiteral) {
                amountToPrint = amountToConsume;
            } else {
                int i = amountToConsume;
                do {
                    if (--i >= 0) continue;
                    amountToPrint = 0;
                    break block7;
                } while (buffer[i] == ' ');
                amountToPrint = i + 1;
            }
        }
        this.out.write(buffer, 0, amountToPrint);
        int lineNumber = this.lineNumber;
        if (!this.printReadably() && (maxLines = this.getMaxLines()) > 0 && ++lineNumber >= maxLines) {
            this.out.write(" ..");
            int suffixLength = this.getSuffixLength();
            if (suffixLength != 0) {
                char[] suffix = this.suffix;
                int len = suffix.length;
                this.out.write(suffix, len - suffixLength, suffixLength);
            }
            this.lineAbbreviationHappened();
        }
        this.lineNumber = lineNumber;
        this.out.write(10);
        this.bufferStartColumn = 0;
        int fillPtr = this.bufferFillPointer;
        int prefixLen = isLiteral ? this.getPerLinePrefixEnd() : this.getPrefixLength();
        int shift = amountToConsume - prefixLen;
        int newFillPtr = fillPtr - shift;
        char[] newBuffer = buffer;
        int bufferLength = buffer.length;
        if (newFillPtr > bufferLength) {
            this.buffer = newBuffer = new char[PrettyWriter.enoughSpace(bufferLength, newFillPtr - bufferLength)];
        }
        System.arraycopy(buffer, amountToConsume, newBuffer, prefixLen, fillPtr - amountToConsume);
        System.arraycopy(this.prefix, 0, buffer, 0, prefixLen);
        this.bufferFillPointer = newFillPtr;
        this.bufferOffset += shift;
        if (!isLiteral) {
            this.blocks[this.blockDepth + -2] = prefixLen;
            this.blocks[this.blockDepth + -6] = lineNumber;
        }
    }

    void outputPartialLine() {
        int fillPtr = this.bufferFillPointer;
        int tail = this.queueTail;
        int count = this.queueSize > 0 ? this.posnIndex(this.queueInts[tail + 1]) : fillPtr;
        int newFillPtr = fillPtr - count;
        if (count <= 0) {
            throw new Error("outputPartialLine called when nothing can be output.");
        }
        try {
            this.out.write(this.buffer, 0, count);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
        this.bufferStartColumn += count;
        System.arraycopy(this.buffer, count, this.buffer, 0, newFillPtr);
        this.bufferFillPointer = newFillPtr;
        this.bufferOffset += count;
    }

    public void forcePrettyOutput() throws IOException {
        this.maybeOutput(false);
        this.expandTabs(-1);
        this.bufferStartColumn = this.getColumnNumber();
        this.out.write(this.buffer, 0, this.bufferFillPointer);
        this.bufferFillPointer = 0;
    }

    public void flush() {
        if (this.out == null) {
            return;
        }
        try {
            this.forcePrettyOutput();
            this.out.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.forcePrettyOutput();
            this.out.close();
            this.out = null;
        }
        this.buffer = null;
    }

    public int getColumnNumber() {
        char ch;
        int i = this.bufferFillPointer;
        do {
            if (--i >= 0) continue;
            return this.bufferStartColumn + this.bufferFillPointer;
        } while ((ch = this.buffer[i]) != '\n' && ch != '\r');
        return this.bufferFillPointer - i;
    }

    public void setColumnNumber(int column) {
        this.bufferStartColumn += column - this.getColumnNumber();
    }

    public void clearBuffer() {
        this.bufferStartColumn = 0;
        this.bufferFillPointer = 0;
        this.lineNumber = 0;
        this.bufferOffset = 0;
        this.blockDepth = 6;
        this.queueTail = 0;
        this.queueSize = 0;
        this.pendingBlocksCount = 0;
    }

    void dumpQueue() {
        PrintWriter out = new PrintWriter(System.err);
        out.println("Queue tail:" + this.queueTail + " size:" + this.queueSize);
        this.dumpQueue(this.queueTail, this.queueSize, out);
        out.flush();
    }

    void dumpQueue(int start, int todo, PrintWriter out) {
        while (todo > 0) {
            if (start == this.queueInts.length) {
                start = 0;
            }
            int type = this.getQueueType(start);
            int size = this.getQueueSize(start);
            out.print('@');
            out.print(start);
            out.print(": ");
            out.print("type:");
            out.print(type);
            switch (type) {
                case 2: {
                    out.print("(newline)");
                    break;
                }
                case 3: {
                    out.print("(indentation)");
                    break;
                }
                case 4: {
                    out.print("(block-start)");
                    break;
                }
                case 5: {
                    out.print("(block-end)");
                    break;
                }
                case 6: {
                    out.print("(tab)");
                }
            }
            out.print(" size:");
            out.print(size);
            out.print(";  @");
            out.print(start + 1);
            out.print(": posn:");
            out.println(this.queueInts[start + 1]);
            if (type == 2 || type == 4) {
                out.print('@');
                out.print(start + 2);
                out.print(": - depth:");
                out.print(this.queueInts[start + 2]);
                out.print(";  @");
                out.print(start + 3);
                out.print(": section-end:");
                out.println(this.queueInts[start + 3]);
            }
            switch (type) {
                case 4: {
                    this.printQueueWord(start, 4, "block-end", out);
                    String prefix = this.queueStrings[start + 0];
                    this.printQueueStringWord(start, 0, "prefix", out);
                    this.printQueueStringWord(start, 1, "suffix", out);
                    break;
                }
                case 2: {
                    out.print('@');
                    out.print(start + 4);
                    out.print(": - kind: ");
                    int kind = this.queueInts[start + 4];
                    String skind = "???";
                    switch (kind) {
                        case 78: {
                            skind = "linear";
                            break;
                        }
                        case 76: {
                            skind = "literal";
                            break;
                        }
                        case 70: {
                            skind = "fill";
                            break;
                        }
                        case 77: {
                            skind = "miser";
                            break;
                        }
                        case 82: {
                            skind = "mandatory";
                        }
                    }
                    out.print(kind);
                    out.print('(');
                    out.print(skind);
                    out.println(')');
                    break;
                }
                default: {
                    int i = 2;
                    while (i < size) {
                        this.printQueueWord(start, i, "word#" + i, out);
                        ++i;
                    }
                    break block7;
                }
            }
            todo -= size;
            start += size;
        }
    }

    private void printQueueWord(int start, int offset, String fname, PrintWriter out) {
        out.print('@');
        out.print(start + offset);
        out.print(": - ");
        out.print(fname);
        out.print(": ");
        out.println(this.queueInts[start + offset]);
    }

    private void printQueueStringWord(int start, int offset, String fname, PrintWriter out) {
        out.print('@');
        out.print(start + offset);
        out.print(": - ");
        out.print(fname);
        out.print(": ");
        String str = this.queueStrings[start + offset];
        if (str == null) {
            out.println("null");
        } else {
            out.print('\"');
            out.print(str);
            out.print('\"');
            out.print(" length: ");
            out.println(str.length());
        }
    }
}

