/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.Dimensions;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DComplex
extends Complex
implements Externalizable {
    double real;
    double imag;

    public DComplex() {
    }

    public DComplex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public RealNum re() {
        return new DFloNum(this.real);
    }

    public double doubleValue() {
        return this.real;
    }

    public RealNum im() {
        return new DFloNum(this.imag);
    }

    public double doubleImagValue() {
        return this.imag;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Complex)) {
            return false;
        }
        Complex y = (Complex)obj;
        return y.unit() == Unit.Empty && Double.doubleToLongBits(this.real) == Double.doubleToLongBits(y.reValue()) && Double.doubleToLongBits(this.imag) == Double.doubleToLongBits(y.imValue());
    }

    public String toString() {
        String imString;
        String reString;
        String prefix = "";
        if (this.real == Double.POSITIVE_INFINITY) {
            prefix = "#i";
            reString = "1/0";
        } else if (this.real == Double.NEGATIVE_INFINITY) {
            prefix = "#i";
            reString = "-1/0";
        } else if (Double.isNaN(this.real)) {
            prefix = "#i";
            reString = "0/0";
        } else {
            reString = Double.toString(this.real);
        }
        if (Double.doubleToLongBits(this.imag) == 0L) {
            return prefix + reString;
        }
        if (this.imag == Double.POSITIVE_INFINITY) {
            prefix = "#i";
            imString = "+1/0i";
        } else if (this.imag == Double.NEGATIVE_INFINITY) {
            prefix = "#i";
            imString = "-1/0i";
        } else if (Double.isNaN(this.imag)) {
            prefix = "#i";
            imString = "+0/0i";
        } else {
            imString = Double.toString(this.imag) + "i";
            if (imString.charAt(0) != '-') {
                imString = "+" + imString;
            }
        }
        return (Double.doubleToLongBits(this.real) == 0L ? prefix : prefix + reString) + imString;
    }

    public String toString(int radix) {
        if (radix == 10) {
            return this.toString();
        }
        return "#d" + this.toString();
    }

    public final Numeric neg() {
        return new DComplex(-this.real, -this.imag);
    }

    public Numeric add(Object y, int k) {
        if (y instanceof Complex) {
            Complex yc = (Complex)y;
            if (yc.dimensions() != Dimensions.Empty) {
                throw new ArithmeticException("units mis-match");
            }
            return new DComplex(this.real + (double)k * yc.reValue(), this.imag + (double)k * yc.imValue());
        }
        return ((Numeric)y).addReversed(this, k);
    }

    public Numeric mul(Object y) {
        if (y instanceof Complex) {
            Complex yc = (Complex)y;
            if (yc.unit() == Unit.Empty) {
                double y_re = yc.reValue();
                double y_im = yc.imValue();
                return new DComplex(this.real * y_re - this.imag * y_im, this.real * y_im + this.imag * y_re);
            }
            return Complex.mul(this, yc);
        }
        return ((Numeric)y).mulReversed(this);
    }

    public Numeric div(Object y) {
        if (y instanceof Complex) {
            Complex yc = (Complex)y;
            return DComplex.div(this.real, this.imag, yc.doubleValue(), yc.doubleImagValue());
        }
        return ((Numeric)y).divReversed(this);
    }

    public static DComplex power(double x_re, double x_im, double y_re, double y_im) {
        double logr = Math.log(DComplex.hypot(x_re, x_im));
        double t = Math.atan2(x_im, x_re);
        double r = Math.exp(logr * y_re - y_im * t);
        t = y_im * logr + y_re * t;
        return Complex.polar(r, t);
    }

    public static Complex log(double x_re, double x_im) {
        return Complex.make(Math.log(DComplex.hypot(x_re, x_im)), Math.atan2(x_im, x_re));
    }

    public static DComplex div(double x_re, double x_im, double y_re, double y_im) {
        double ni;
        double nr;
        double d;
        double ai;
        double ar = Math.abs(y_re);
        if (ar <= (ai = Math.abs(y_im))) {
            double t = y_re / y_im;
            d = y_im * (1.0 + t * t);
            nr = x_re * t + x_im;
            ni = x_im * t - x_re;
        } else {
            double t = y_im / y_re;
            d = y_re * (1.0 + t * t);
            nr = x_re + x_im * t;
            ni = x_im - x_re * t;
        }
        return new DComplex(nr / d, ni / d);
    }

    public static Complex sqrt(double x_re, double x_im) {
        double nr;
        double ni;
        double r = DComplex.hypot(x_re, x_im);
        if (r == 0.0) {
            nr = ni = r;
        } else if (x_re > 0.0) {
            nr = Math.sqrt(0.5 * (r + x_re));
            ni = x_im / nr / 2.0;
        } else {
            ni = Math.sqrt(0.5 * (r - x_re));
            if (x_im < 0.0) {
                ni = -ni;
            }
            nr = x_im / ni / 2.0;
        }
        return new DComplex(nr, ni);
    }

    public static double hypot(double x, double y) {
        double w2;
        double t1;
        int j;
        int ha;
        double a = x;
        double b = y;
        long la = Double.doubleToLongBits(x) << 1 >>> 1;
        long lb = Double.doubleToLongBits(y) << 1 >>> 1;
        int hb = (int)(lb >>> 32);
        if (hb > (ha = (int)(la >>> 32))) {
            j = ha;
            ha = hb;
            hb = j;
            long l = la;
            la = lb;
            lb = l;
        }
        a = Double.longBitsToDouble(la);
        b = Double.longBitsToDouble(lb);
        if (ha - hb > 0x3C00000) {
            return a + b;
        }
        int k = 0;
        j = 0;
        if (ha > 1596981248) {
            if (ha >= 0x7FF00000) {
                double w2 = a + b;
                if ((la & 0xFFFFFFFFFFFFFL) == 0L) {
                    w2 = a;
                }
                if ((lb ^ 0x7FF0000000000000L) == 0L) {
                    w2 = b;
                }
                return w2;
            }
            j = -629145600;
            k += 600;
        }
        if (hb < 0x20B00000) {
            if (hb <= 1048575) {
                if (lb == 0L) {
                    return a;
                }
                t1 = Double.longBitsToDouble(9209861237972664320L);
                b *= t1;
                a *= t1;
                k -= 1022;
            } else {
                k -= 600;
                j = 629145600;
            }
        }
        if (j != 0) {
            ha += j;
            hb += j;
            a = Double.longBitsToDouble(la += (long)(j << 32));
            b = Double.longBitsToDouble(lb += (long)(j << 32));
        }
        if ((w2 = a - b) > b) {
            t1 = Double.longBitsToDouble((long)ha << 32);
            double t2 = a - t1;
            w2 = t1 * t1 - (b * -b - t2 * (a + t1));
        } else {
            a += a;
            double y1 = Double.longBitsToDouble((long)hb << 32);
            double y2 = b - y1;
            t1 = Double.longBitsToDouble((long)(ha + 0x100000) << 32);
            double t2 = a - t1;
            w2 = t1 * y1 - (w2 * -w2 - (t1 * y2 + t2 * b));
        }
        w2 = Math.sqrt(w2);
        if (k != 0) {
            t1 = Double.longBitsToDouble(0x3FF0000000000000L + ((long)k << 52));
            w2 *= t1;
        }
        return w2;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.real);
        out.writeDouble(this.imag);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.real = in.readDouble();
        this.imag = in.readDouble();
    }
}

