/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Named;
import gnu.mapping.WrongArguments;

public abstract class Procedure
implements Named {
    private Object[] properties;
    private static final String nameKey = "name";
    private static final String setterKey = "setter";

    public String getName() {
        return (String)this.getProperty(nameKey, null);
    }

    public final String name() {
        return this.getName();
    }

    public final void setName(String name) {
        this.setProperty(nameKey, name);
    }

    public Procedure() {
    }

    public Procedure(String n) {
        this.setName(n);
    }

    public abstract Object applyN(Object[] var1) throws Throwable;

    public abstract Object apply0() throws Throwable;

    public abstract Object apply1(Object var1) throws Throwable;

    public abstract Object apply2(Object var1, Object var2) throws Throwable;

    public abstract Object apply3(Object var1, Object var2, Object var3) throws Throwable;

    public abstract Object apply4(Object var1, Object var2, Object var3, Object var4) throws Throwable;

    public final int minArgs() {
        return this.numArgs() & 0xFFF;
    }

    public final int maxArgs() {
        return this.numArgs() >> 12;
    }

    public static void checkArgCount(Procedure proc, int argCount) {
        int num = proc.numArgs();
        if (argCount < (num & 0xFFF) || num >= 0 && argCount > num >> 12) {
            throw new WrongArguments(proc, argCount);
        }
    }

    public int numArgs() {
        return -4096;
    }

    public void apply(Runnable ctx) throws Throwable {
    }

    public Procedure getSetter() {
        return null;
    }

    public void set0(Object result) throws Throwable {
    }

    public void set1(Object arg1, Object value) throws Throwable {
    }

    public void setN(Object[] args) throws Throwable {
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("#<procedure ");
        String n = this.getName();
        if (n == null) {
            n = this.getClass().getName();
        }
        sbuf.append(n);
        sbuf.append('>');
        return sbuf.toString();
    }

    public Object getProperty(Object key, Object defaultValue) {
        if (this.properties != null) {
            int i = this.properties.length;
            while ((i -= 2) >= 0) {
                if (this.properties[i] != key) continue;
                return this.properties[i + 1];
            }
        }
        return defaultValue;
    }

    public synchronized void setProperty(Object key, Object value) {
        this.properties = Procedure.setProperty(this.properties, key, value);
    }

    public static Object[] setProperty(Object[] properties, Object key, Object value) {
        int avail;
        Object[] props = properties;
        if (props == null) {
            properties = props = new Object[10];
            avail = 0;
        } else {
            avail = -1;
            int i = props.length;
            while ((i -= 2) >= 0) {
                Object k = props[i];
                if (k == key) {
                    Object old = props[i + 1];
                    props[i + 1] = value;
                    return properties;
                }
                if (k != null) continue;
                avail = i;
            }
            if (avail < 0) {
                avail = props.length;
                properties = new Object[2 * avail];
                System.arraycopy(props, 0, properties, 0, avail);
                props = properties;
            }
        }
        props[avail] = key;
        props[avail + 1] = value;
        return properties;
    }

    public Object removeProperty(Object key) {
        Object[] props = this.properties;
        if (props == null) {
            return null;
        }
        int i = props.length;
        while ((i -= 2) >= 0) {
            Object k = props[i];
            if (k != key) continue;
            Object old = props[i + 1];
            props[i] = null;
            props[i + 1] = null;
            return old;
        }
        return null;
    }
}

