/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Branchable;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class LoopExp
extends Expression {
    private Expression whileExp;
    private Expression loopBody;
    private Expression beforeNextIteration;
    private boolean testFirst;
    private Label continueLabel;

    public LoopExp(Expression whileExp, Expression beforeNextIteration, boolean testFirst) {
        this.whileExp = whileExp;
        this.beforeNextIteration = beforeNextIteration;
        this.testFirst = testFirst;
    }

    public void setBody(Expression loopBody) {
        this.loopBody = loopBody;
    }

    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        Label start = new Label(code);
        Label test2 = new Label(code);
        this.continueLabel = new Label(code);
        if (this.testFirst) {
            code.emitGoto(test2);
        }
        start.define(code);
        if (this.loopBody != null) {
            this.loopBody.compile(comp, Target.Ignore);
        }
        this.continueLabel.define(code);
        this.beforeNextIteration.compile(comp, Target.Ignore);
        test2.define(code);
        this.compileIfJump(comp, this.whileExp, start);
        this.continueLabel = null;
    }

    private void compileIfJump(Compilation comp, Expression ifExp, Label to) {
        Branchable branchOp = ifExp.getBranchable();
        if (branchOp != null) {
            branchOp.compileJump(comp, ((ApplyExp)ifExp).args, to);
            return;
        }
        if (this.whileExp == QuoteExp.trueExp) {
            comp.getCode().emitGoto(to);
            return;
        }
        this.whileExp.compile(comp, Type.boolean_type);
        comp.getCode().emitGotoIfIntNeZero(to);
    }

    public Type getType() {
        return Type.void_type;
    }

    protected Expression walk(ExpWalker w) {
        this.whileExp.walk(w);
        if (this.loopBody != null) {
            this.loopBody.walk(w);
        }
        this.beforeNextIteration.walk(w);
        return this;
    }

    public void print(OutPort out) {
        out.startLogicalBlock("(Loop", ")", 2);
        if (this.whileExp != null) {
            this.whileExp.print(out);
        }
        out.writeSpaceLinear();
        if (this.loopBody != null) {
            this.loopBody.print(out);
        }
        if (this.beforeNextIteration != null) {
            out.writeSpaceLinear();
            out.print("next ");
            this.beforeNextIteration.print(out);
        }
        out.endLogicalBlock(")");
    }

    public class ContinueExp
    extends Expression {
        public void compile(Compilation comp, Target target) {
            comp.getCode().emitGoto(LoopExp.this.continueLabel);
        }

        public Type getType() {
            return Type.void_type;
        }

        public void print(OutPort out) {
            out.print("(Continue)");
        }
    }
}

