/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Special;
import gnu.expr.Symbol;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.CpsProcedure;
import gnu.mapping.Printable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Keyword
extends CpsProcedure
implements Printable,
Externalizable {
    private String name;
    private static Hashtable keywordTable = new Hashtable();

    public Keyword() {
    }

    private Keyword(String name) {
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static Keyword make(String name) {
        Keyword keyword = (Keyword)keywordTable.get(name);
        if (keyword == null) {
            keyword = new Keyword(name);
            keywordTable.put(name, keyword);
        }
        return keyword;
    }

    public static boolean isKeyword(Object obj) {
        return obj instanceof Keyword;
    }

    public final String toString() {
        return this.name + ':';
    }

    public void print(PrintWriter ps) {
        Symbol.print(this.name, ps);
        ps.print(':');
    }

    public static Object searchForKeyword(Object[] vals, int offset, Object keyword) {
        int i = offset;
        while (i < vals.length) {
            if (vals[i] == keyword) {
                return vals[i + 1];
            }
            i += 2;
        }
        return Special.dfault;
    }

    public static Object searchForKeyword(Object[] vals, int offset, Object keyword, Object dfault) {
        int i = offset;
        while (i < vals.length) {
            if (vals[i] == keyword) {
                return vals[i + 1];
            }
            i += 2;
        }
        return dfault;
    }

    public final String getName() {
        return this.name;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
    }

    public Object readResolve() throws ObjectStreamException {
        return Keyword.make(this.name);
    }

    public void apply(CallContext ctx) {
        Consumer out = ctx.consumer;
        String tag = this.getName();
        int nargs = ctx.count;
        out.beginGroup(tag, this);
        int i = 0;
        while (i < nargs) {
            Object arg = ctx.getArgAsObject(i);
            if (arg instanceof Keyword && i + 1 < nargs) {
                Keyword attr = (Keyword)arg;
                arg = ctx.getArgAsObject(++i);
                out.beginAttribute(attr.getName(), attr);
                out.writeObject(arg);
                out.endAttribute();
            } else {
                out.writeObject(arg);
            }
            ++i;
        }
        out.endGroup(tag);
    }
}

