/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConstructorExp;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.ProcedureN;

public class InstantiateProc
extends ProcedureN
implements Inlineable {
    private Method constructor;
    private ConstructorExp method;
    private int dummyArgs;

    public InstantiateProc(Method constructor) {
        this(constructor, 0);
    }

    public InstantiateProc(Method constructor, int dummyArgs) {
        this.constructor = constructor;
        this.dummyArgs = dummyArgs;
    }

    public InstantiateProc(ConstructorExp method) {
        this.method = method;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        if (this.constructor == null) {
            this.constructor = this.method.getMainMethod();
        }
        CodeAttr code = comp.getCode();
        Expression[] args = exp.getArgs();
        Type[] types = this.constructor.getParameterTypes();
        ClassType type = this.constructor.getDeclaringClass();
        code.emitNew(type);
        code.emitDup(type);
        int i = 0;
        while (i < args.length) {
            args[i].compile(comp, types[i]);
            ++i;
        }
        if (this.method != null) {
            this.dummyArgs = this.method.dummyArgs;
        }
        int i2 = 0;
        while (i2 < this.dummyArgs) {
            code.emitPushInt(0);
            ++i2;
        }
        code.emitInvokeSpecial(this.constructor);
        target.compileFromStack(comp, type);
    }

    public Type getReturnType(Expression[] args) {
        if (this.constructor != null) {
            return this.constructor.getDeclaringClass();
        }
        return this.method.getClassType();
    }

    public Object applyN(Object[] args) {
        throw new Error("Not implemented");
    }
}

