/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Branchable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.Parser;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import java.io.PrintWriter;

public abstract class Expression
implements Printable {
    String filename;
    int position;
    public static final Expression[] noExpressions = new Expression[0];
    protected int flags;
    protected static final int NEXT_AVAIL_FLAG = 1;

    public Object eval(Environment env) throws Throwable {
        throw new RuntimeException("internal error - " + this.getClass() + ".eval called");
    }

    public void eval(Environment env, CallContext ctx) throws Throwable {
        Object val = this.eval(env);
        ctx.writeValue(val);
    }

    public final void print(PrintWriter ps) {
        if (ps instanceof OutPort) {
            this.print((OutPort)ps);
        } else {
            OutPort out = new OutPort(ps);
            this.print(out);
            out.flush();
        }
    }

    public abstract void print(OutPort var1);

    public void printLineColumn(OutPort out) {
        int line = this.getLine();
        if (line > 0) {
            out.print("line:");
            out.print(line);
            int column = this.getColumn();
            if (column != 0) {
                out.print(':');
                out.print(column);
            }
            out.writeSpaceFill();
        }
    }

    public abstract void compile(Compilation var1, Target var2);

    public final void compileWithPosition(Compilation comp, Target target) {
        int line = this.getLine();
        if (line > 0) {
            comp.method.compile_linenumber(this.getFile(), line);
            this.compileNotePosition(comp, target);
        } else {
            this.compile(comp, target);
        }
    }

    public final void compileNotePosition(Compilation comp, Target target) {
        String saveFilename = comp.filename;
        int savePosition = comp.position;
        comp.filename = this.filename;
        comp.position = this.position;
        this.compile(comp, target);
        comp.filename = saveFilename;
        comp.position = savePosition;
    }

    public final void compile(Compilation comp, Type type) {
        this.compile(comp, StackTarget.getInstance(type));
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkExpression(this);
    }

    protected void walkChildren(ExpWalker walker) {
    }

    public static Expression makeWhile(Object cond, Object body, Parser parser) {
        Expression[] inits = new Expression[1];
        LetExp let = new LetExp(inits);
        String fname = "%do%loop";
        Declaration fdecl = let.addDeclaration(fname);
        ApplyExp recurse = new ApplyExp(new ReferenceExp(fdecl), noExpressions);
        LambdaExp lexp = new LambdaExp();
        parser.push(lexp);
        lexp.body = new IfExp(parser.parse(cond), new BeginExp(parser.parse(body), recurse), QuoteExp.voidExp);
        lexp.setName(fname);
        parser.pop(lexp);
        inits[0] = lexp;
        fdecl.noteValue(lexp);
        let.setBody(new ApplyExp(new ReferenceExp(fdecl), noExpressions));
        return let;
    }

    public final Expression setLine(Expression old) {
        this.filename = old.filename;
        this.position = old.position;
        return this;
    }

    public final void setFile(String filename) {
        this.filename = filename;
    }

    public final void setLine(int lineno, int colno) {
        this.position = (lineno << 12) + colno;
    }

    public final void setLine(int lineno) {
        this.setLine(lineno, 0);
    }

    public final String getFile() {
        return this.filename;
    }

    public final int getLine() {
        return this.position >> 12;
    }

    public final int getColumn() {
        return this.position & 0xFFF;
    }

    public Type getType() {
        return Type.pointer_type;
    }

    public void setFlag(boolean setting, int flag) {
        this.flags = setting ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public Branchable getBranchable() {
        Object proc;
        Expression func;
        if (this instanceof ApplyExp && (func = ((ApplyExp)this).func) instanceof QuoteExp && (proc = ((QuoteExp)func).getValue()) instanceof Branchable) {
            return (Branchable)proc;
        }
        return null;
    }
}

