/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class BlockExp
extends Expression {
    Declaration label;
    Expression body;
    Expression exitBody;
    Target subTarget;
    Label exitLabel;

    public BlockExp() {
    }

    public BlockExp(Expression body) {
        this.setBody(body);
    }

    public void setBody(Expression body) {
        this.body = body;
    }

    public void setBody(Expression body, Expression exitBody) {
        this.body = body;
        this.exitBody = exitBody;
    }

    public void compile(Compilation comp, Target target) {
        Target subTarget = target instanceof IgnoreTarget || target == Target.pushObject ? target : new StackTarget(this.getType());
        CodeAttr code = comp.getCode();
        this.exitLabel = new Label(code);
        this.subTarget = this.exitBody == null ? subTarget : Target.Ignore;
        this.body.compileWithPosition(comp, subTarget);
        if (this.exitBody != null) {
            Label doneLabel = new Label(code);
            code.emitGoto(doneLabel);
            this.exitLabel.define(code);
            this.exitBody.compileWithPosition(comp, subTarget);
            doneLabel.define(code);
        } else {
            this.exitLabel.define(code);
        }
        if (subTarget != target) {
            target.compileFromStack(comp, subTarget.getType());
        }
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkBlockExp(this);
    }

    protected void walkChildren(ExpWalker walker) {
        this.body = this.body.walk(walker);
        if (walker.exitValue == null && this.exitBody != null) {
            this.exitBody = this.exitBody.walk(walker);
        }
    }

    public void print(OutPort out) {
        out.startLogicalBlock("(Block", ")", 2);
        if (this.label != null) {
            out.print(this.label.getName());
        }
        out.writeSpaceLinear();
        this.body.print(out);
        if (this.exitBody != null) {
            out.writeSpaceLinear();
            out.print("else ");
            this.exitBody.print(out);
        }
        out.endLogicalBlock(")");
    }
}

