/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Scope;
import gnu.bytecode.VarEnumerator;
import gnu.bytecode.Variable;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVarsAttr
extends Attribute {
    private Method method;
    Variable[] used;
    public Scope current_scope;
    Scope parameter_scope;

    public LocalVarsAttr(CodeAttr code) {
        super("LocalVariableTable");
        this.addToFrontOf(code);
        this.method = (Method)code.getContainer();
        code.locals = this;
    }

    public LocalVarsAttr(Method method) {
        super("LocalVariableTable");
        CodeAttr code = method.code;
        this.method = method;
        code.locals = this;
    }

    public final Method getMethod() {
        return this.method;
    }

    public VarEnumerator allVars() {
        return new VarEnumerator(this.parameter_scope);
    }

    public void enterScope(Scope scope) {
        scope.linkChild(this.current_scope);
        this.current_scope = scope;
        CodeAttr code = this.method.getCode();
        Variable var = scope.firstVar();
        while (var != null) {
            if (var.isSimple()) {
                if (!var.isAssigned()) {
                    var.allocateLocal(code);
                } else if (this.used[var.offset] == null) {
                    this.used[var.offset] = var;
                } else if (this.used[var.offset] != var) {
                    throw new Error("inconsistent local variable assignments for " + var + " != " + this.used[var.offset]);
                }
            }
            var = var.nextVar();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isEmpty() {
        Variable var;
        VarEnumerator vars = this.allVars();
        while ((var = vars.nextVar()) != null) {
            void var2_2;
            if (!var2_2.isSimple() || var2_2.name == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int getCount() {
        Variable var;
        int local_variable_count = 0;
        VarEnumerator vars = this.allVars();
        while ((var = vars.nextVar()) != null) {
            void var3_3;
            if (!this.shouldEmit((Variable)var3_3)) continue;
            ++local_variable_count;
        }
        return local_variable_count;
    }

    public final int getLength() {
        return 2 + 10 * this.getCount();
    }

    /*
     * WARNING - void declaration
     */
    public void assignConstants(ClassType cl) {
        Variable var;
        super.assignConstants(cl);
        VarEnumerator vars = this.allVars();
        while ((var = vars.nextVar()) != null) {
            void var3_3;
            if (!var3_3.isSimple() || var3_3.name == null) continue;
            if (var3_3.name_index == 0) {
                var3_3.name_index = cl.getConstants().addUtf8((String)var3_3.getName()).index;
            }
            if (var3_3.signature_index != 0) continue;
            var3_3.signature_index = cl.getConstants().addUtf8((String)var3_3.getType().signature).index;
        }
    }

    private boolean shouldEmit(Variable var) {
        return var.isSimple() && var.name != null && var.start_pc >= 0 && var.end_pc > var.start_pc;
    }

    /*
     * WARNING - void declaration
     */
    public void write(DataOutputStream dstr) throws IOException {
        Variable var;
        VarEnumerator vars = this.allVars();
        dstr.writeShort(this.getCount());
        vars.reset();
        while ((var = vars.nextVar()) != null) {
            void var3_3;
            if (!this.shouldEmit((Variable)var3_3)) continue;
            dstr.writeShort(var3_3.start_pc);
            dstr.writeShort(var3_3.end_pc - var3_3.start_pc);
            dstr.writeShort(var3_3.name_index);
            dstr.writeShort(var3_3.signature_index);
            dstr.writeShort(var3_3.offset);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void print(ClassTypeWriter dst) {
        Variable var;
        VarEnumerator vars = this.allVars();
        dst.print("Attribute \"");
        dst.print(this.getName());
        dst.print("\", length:");
        dst.print(this.getLength());
        dst.print(", count: ");
        dst.println(this.getCount());
        vars.reset();
        while ((var = vars.nextVar()) != null) {
            void var3_3;
            if (!var3_3.isSimple() || var3_3.name == null) continue;
            dst.print("  slot#");
            dst.print(var3_3.offset);
            dst.print(": name: ");
            dst.printOptionalIndex(var3_3.name_index);
            dst.print(var3_3.getName());
            dst.print(", type: ");
            dst.printOptionalIndex(var3_3.signature_index);
            dst.printSignature(var3_3.getType());
            dst.print(" (pc: ");
            dst.print(var3_3.start_pc);
            dst.print(" length: ");
            dst.print(var3_3.end_pc - var3_3.start_pc);
            dst.println(')');
        }
    }
}

