/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExceptionsAttr
extends Attribute {
    ClassType[] exceptions;
    short[] exception_table;

    public ExceptionsAttr(Method meth) {
        super("Exceptions");
        this.addToFrontOf(meth);
    }

    public void setExceptions(short[] indices, ClassType cl) {
        this.exception_table = indices;
        this.exceptions = new ClassType[indices.length];
        ConstantPool cp = cl.getConstants();
        int i = indices.length - 1;
        while (i >= 0) {
            this.exceptions[i] = (ClassType)((CpoolClass)cp.getPoolEntry(indices[i])).getClassType();
            --i;
        }
    }

    public void setExceptions(ClassType[] excep_types) {
        this.exceptions = excep_types;
    }

    public void assignConstants(ClassType cl) {
        super.assignConstants(cl);
        ConstantPool cp = cl.getConstants();
        int count = this.exceptions.length;
        this.exception_table = new short[count];
        int i = count - 1;
        while (i >= 0) {
            this.exception_table[i] = (short)cp.addClass((ObjectType)this.exceptions[i]).index;
            --i;
        }
    }

    public final int getLength() {
        return 2 + 2 * (this.exceptions == null ? 0 : this.exceptions.length);
    }

    public final ClassType[] getExceptions() {
        return this.exceptions;
    }

    public void write(DataOutputStream dstr) throws IOException {
        int count = this.exceptions.length;
        dstr.writeShort(count);
        int i = 0;
        while (i < count) {
            dstr.writeShort(this.exception_table[i]);
            ++i;
        }
    }

    public void print(ClassTypeWriter dst) {
        dst.print("Attribute \"");
        dst.print(this.getName());
        dst.print("\", length:");
        dst.print(this.getLength());
        dst.print(", count: ");
        int count = this.exceptions.length;
        dst.println(count);
        int i = 0;
        while (i < count) {
            int catch_type_index = this.exception_table[i] & 0xFFFF;
            dst.print("  ");
            dst.printOptionalIndex(catch_type_index);
            dst.printConstantTersely(catch_type_index, 7);
            dst.println();
            ++i;
        }
    }
}

