/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Expression;
import bossa.syntax.Monotype;
import bossa.util.Util;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Declaration;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import java.util.List;
import mlsub.typing.Constraint;
import mlsub.typing.Polytype;
import nice.lang.inline.ArrayGetOp;
import nice.tools.code.EnsureTypeProc;
import nice.tools.code.TupleType;
import nice.tools.code.Types;

public class TupleExp
extends Expression {
    private mlsub.typing.Monotype[] components;
    private mlsub.typing.Monotype[] expectedComponents;
    Expression[] expressions;

    public TupleExp(List expressions) {
        this.expressions = Expression.toArray(expressions);
    }

    public boolean isAssignable() {
        int i = 0;
        while (i < this.expressions.length) {
            if (!this.expressions[i].isAssignable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    Expression resolveOverloading(Polytype expectedType) {
        expectedType.simplify();
        this.adjustToExpectedType(expectedType.getMonotype());
        return this;
    }

    void adjustToExpectedType(mlsub.typing.Monotype expectedType) {
        mlsub.typing.Monotype m = Types.equivalent(expectedType);
        if (m instanceof mlsub.typing.TupleType) {
            this.expectedComponents = ((mlsub.typing.TupleType)m).getComponents();
            Expression.adjustToExpectedType(this.expressions, this.expectedComponents);
        }
    }

    Expression noOverloading() {
        int i = this.expressions.length;
        while (i-- > 0) {
            this.expressions[i] = this.expressions[i].noOverloading();
        }
        return this;
    }

    void computeType() {
        Polytype[] types = Expression.getType(this.expressions);
        Constraint cst = Constraint.and(Polytype.getConstraint(types), null, null);
        this.components = Polytype.getMonotype(types);
        mlsub.typing.TupleType tupleType = new mlsub.typing.TupleType(this.components);
        Types.setBytecodeType(this.components);
        if (this.expectedComponents == null) {
            this.expectedComponents = this.components;
        }
        this.type = new Polytype(cst, Monotype.sure(tupleType));
    }

    protected gnu.expr.Expression compile() {
        this.getType();
        return TupleType.createExp(Types.lowestCommonSupertype(this.expectedComponents), Types.javaType(this.expectedComponents), Expression.compile(this.expressions));
    }

    gnu.expr.Expression compileAssign(gnu.expr.Expression array) {
        gnu.expr.Expression tupleExp;
        int len = this.expressions.length;
        LetExp let = null;
        Type arrayType = array.getType();
        TupleType tupleType = null;
        if (arrayType instanceof TupleType) {
            tupleType = (TupleType)arrayType;
        }
        if (!(array instanceof ReferenceExp)) {
            let = new LetExp(new gnu.expr.Expression[]{array});
            Declaration tupleDecl = let.addDeclaration("tupleRef", arrayType);
            tupleDecl.setCanRead(true);
            tupleExp = new ReferenceExp(tupleDecl);
        } else {
            tupleExp = array;
        }
        gnu.expr.Expression[] stmts = new gnu.expr.Expression[len];
        int i = 0;
        while (i < len) {
            gnu.expr.Expression value = new ApplyExp(new ArrayGetOp(null), new gnu.expr.Expression[]{tupleExp, this.intExp(i)});
            if (tupleType != null) {
                value = EnsureTypeProc.ensure(value, tupleType.componentTypes[i]);
            }
            stmts[i] = this.expressions[i].compileAssign(value);
            ++i;
        }
        if (let != null) {
            let.setBody(new BeginExp(stmts));
            return let;
        }
        return new BeginExp(stmts);
    }

    private gnu.expr.Expression intExp(int i) {
        return new QuoteExp(new Integer(i));
    }

    public String toString() {
        return Util.map("(", ", ", ")", this.expressions);
    }
}

