/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Constraint;
import bossa.syntax.Monotype;
import bossa.syntax.Node;
import bossa.syntax.TypeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Polytype
extends Node {
    private Constraint constraint;
    private Monotype monotype;

    public Polytype(Constraint cst, Monotype monotype) {
        super(2);
        this.constraint = cst;
        this.addChild(this.constraint);
        this.monotype = monotype;
    }

    public Polytype(Monotype monotype) {
        this(Constraint.True, monotype);
    }

    static Collection fromMonotypes(Collection monotypes) {
        ArrayList<Polytype> res = new ArrayList<Polytype>(monotypes.size());
        Iterator i = monotypes.iterator();
        while (i.hasNext()) {
            res.add(new Polytype(Constraint.True, (Monotype)i.next()));
        }
        return res;
    }

    Constraint getConstraint() {
        return this.constraint;
    }

    static Collection getMonotype(Collection c) {
        ArrayList<Monotype> res = new ArrayList<Monotype>(c.size());
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res.add(((Polytype)i.next()).getMonotype());
        }
        return res;
    }

    Monotype getMonotype() {
        return this.monotype;
    }

    mlsub.typing.Polytype resolveToLowlevel() {
        return new mlsub.typing.Polytype(this.constraint.resolveToLowlevel(), this.monotype.resolve(this.typeScope));
    }

    mlsub.typing.Polytype resolve(TypeMap s) {
        return new mlsub.typing.Polytype(this.constraint.resolveToLowlevel(), this.monotype.resolve(s));
    }

    public String toString() {
        return this.constraint + " " + this.monotype.toStringExtern();
    }
}

