/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Expression;
import bossa.syntax.Monotype;
import bossa.syntax.PrimitiveType;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeMap;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.ArrayType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import java.util.List;
import mlsub.typing.AtomicConstraint;
import mlsub.typing.Constraint;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeLeqCst;
import mlsub.typing.MonotypeVar;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeConstructorLeqCst;
import mlsub.typing.TypeSymbol;
import nice.tools.code.MultiArrayNewProc;
import nice.tools.code.Types;

public class NewArrayExp
extends Expression {
    private TypeSymbol resolvedType;
    final TypeIdent ident;
    Expression[] knownDimensions;
    private int unknownDimensions;

    public NewArrayExp(TypeIdent type, List knownDimensions, int unknownDimensions) {
        this.ident = type;
        this.knownDimensions = Expression.toArray(knownDimensions);
        this.unknownDimensions = unknownDimensions;
    }

    void resolveTC(TypeMap typeScope) {
        this.resolvedType = this.ident.resolveToTypeSymbol(typeScope);
    }

    void computeType() {
        mlsub.typing.Monotype monotype;
        Constraint cst;
        TypeSymbol[] nullVars;
        boolean zero = NewArrayExp.findZero(this.knownDimensions);
        if (zero) {
            nullVars = new TypeConstructor[this.unknownDimensions + 1];
            int i = 0;
            while (i < nullVars.length) {
                nullVars[i] = new TypeConstructor("n" + i, PrimitiveType.maybeTC.variance, false, false);
                ++i;
            }
        } else {
            nullVars = null;
        }
        if (this.resolvedType instanceof MonotypeVar) {
            TypeSymbol[] vars;
            MonotypeVar res = (MonotypeVar)this.resolvedType;
            TypeConstructor tc = new TypeConstructor("nullness", PrimitiveType.maybeTC.variance, false, false);
            MonotypeVar raw = new MonotypeVar(res.getName() + "raw");
            MonotypeConstructor eq = MonotypeConstructor.apply(tc, raw);
            if (nullVars == null) {
                vars = new TypeSymbol[]{tc, raw};
            } else {
                vars = new TypeSymbol[nullVars.length + 2];
                System.arraycopy(nullVars, 0, vars, 2, nullVars.length);
                vars[0] = tc;
                vars[1] = raw;
            }
            cst = new Constraint(vars, new AtomicConstraint[]{new TypeConstructorLeqCst(tc, PrimitiveType.maybeTC), new MonotypeLeqCst(eq, res), new MonotypeLeqCst(res, eq)});
            monotype = nullVars != null ? MonotypeConstructor.apply((TypeConstructor)nullVars[nullVars.length - 1], raw) : Monotype.maybe(raw);
        } else if (this.resolvedType == TopMonotype.instance) {
            monotype = TopMonotype.instance;
            if (nullVars != null) {
                monotype = MonotypeConstructor.apply(nullVars[nullVars.length - 1], monotype);
                cst = new Constraint(nullVars, null);
            } else {
                monotype = Monotype.maybe(monotype);
                cst = Constraint.True;
            }
        } else {
            if (!(this.resolvedType instanceof TypeConstructor)) {
                User.error((Located)this.ident, this.ident + " should be a class");
            }
            cst = Constraint.True;
            TypeConstructor tc = (TypeConstructor)this.resolvedType;
            monotype = new MonotypeConstructor(tc, MonotypeVar.news(tc.arity()));
            if (Types.isPrimitive(tc)) {
                monotype = Monotype.sure(monotype);
            } else if (nullVars != null) {
                monotype = MonotypeConstructor.apply((TypeConstructor)nullVars[nullVars.length - 1], monotype);
                cst = new Constraint(nullVars, null);
            } else {
                monotype = Monotype.maybe(monotype);
            }
        }
        int i = 0;
        while (i < this.unknownDimensions) {
            monotype = new MonotypeConstructor(PrimitiveType.arrayTC, new mlsub.typing.Monotype[]{monotype});
            monotype = nullVars != null ? MonotypeConstructor.apply((TypeConstructor)nullVars[i], monotype) : Monotype.maybe(monotype);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.knownDimensions.length) {
            monotype = Monotype.sure(MonotypeConstructor.apply(PrimitiveType.arrayTC, monotype));
            ++i2;
        }
        this.type = new Polytype(cst, monotype);
    }

    private static boolean findZero(Expression[] exps) {
        int i = 0;
        while (i < exps.length) {
            if (exps[i].isZero()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public gnu.expr.Expression compile() {
        Type t = Types.javaType(this.type);
        return new ApplyExp(new MultiArrayNewProc((ArrayType)t, this.knownDimensions.length), Expression.compile(this.knownDimensions));
    }

    public String toString() {
        StringBuffer res = new StringBuffer("new " + this.ident + Util.map("[", "][", "]", this.knownDimensions));
        int i = 0;
        while (i < this.unknownDimensions) {
            res.append("[]");
            ++i;
        }
        return res.toString();
    }
}

