/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.CallExp;
import bossa.syntax.Expression;
import bossa.syntax.FieldAccess;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.User;
import gnu.expr.Declaration;
import nice.tools.code.IncrementProc;
import nice.tools.code.Inline;

public class IncrementExp
extends Expression {
    Expression variable;
    private boolean returnOld;
    private boolean increment;

    public IncrementExp(Expression variable, boolean prefix, boolean increment) {
        this.variable = variable;
        this.returnOld = !prefix;
        this.increment = increment;
    }

    void computeType() {
        this.type = this.variable.getType();
    }

    public gnu.expr.Expression compile() {
        FieldAccess access;
        Declaration decl;
        this.variable = this.variable.noOverloading();
        if (!this.variable.isAssignable()) {
            User.error((Located)this, this.variable + " cannot be incremented");
        }
        if ((decl = this.variable.getDeclaration()) != null) {
            return new gnu.expr.IncrementExp(decl, this.increment ? (short)1 : -1, !this.returnOld);
        }
        CallExp call = null;
        if (this.variable instanceof CallExp) {
            call = (CallExp)this.variable;
        }
        if (call == null) {
            Internal.error(this, "\"var\" is assignable and not a local, so it should be a call to a FieldAccessMethod");
        }
        if ((access = call.function.getFieldAccessMethod()) == null) {
            Internal.error(this, "\"var\" is assignable and not a local, so it should be a call to a FieldAccessMethod");
        }
        if (access.isFinal()) {
            User.error((Located)this, "Field " + access + " is final");
        }
        return Inline.inline(new IncrementProc(access.fieldDecl, this.returnOld, this.increment), call.arguments.getExp(0).generateCode());
    }

    public String toString() {
        if (this.returnOld) {
            return this.variable.toString() + (this.increment ? "++" : "--");
        }
        return (this.increment ? "++" : "--") + this.variable.toString();
    }

    String description() {
        return this.increment ? "Incrementation" : "Decrementation";
    }
}

