/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.parser.Loader;
import bossa.parser.ParseException;
import bossa.syntax.Arguments;
import bossa.syntax.Expression;
import bossa.syntax.FunSymbol;
import bossa.syntax.Info;
import bossa.syntax.LocatedString;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.Node;
import bossa.syntax.SymbolExp;
import bossa.syntax.TypeScope;
import bossa.syntax.dispatch;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.Attribute;
import gnu.bytecode.MiscAttr;
import gnu.expr.CopyArgument;
import gnu.expr.Declaration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;

public class FormalParameters
extends Node {
    static final LocatedString thisName = new LocatedString("this", Location.nowhere());
    private Parameter[] parameters;
    int size;

    public FormalParameters(List parameters) {
        super(2);
        if (parameters == null) {
            return;
        }
        this.parameters = parameters.toArray(new Parameter[parameters.size()]);
        this.size = this.parameters.length;
        int i = 0;
        while (i < this.size) {
            if (this.parameters[i] != null) {
                this.addChild(this.parameters[i]);
            }
            ++i;
        }
    }

    FormalParameters(Parameter[] parameters) {
        super(2);
        if (parameters == null) {
            return;
        }
        this.parameters = parameters;
        this.size = parameters.length;
        int i = 0;
        while (i < this.size) {
            if (parameters[i] != null) {
                this.addChild(parameters[i]);
            }
            ++i;
        }
    }

    void addThis(Monotype type) {
        if (this.parameters[0] != null) {
            Internal.error("No room for \"this\"");
        }
        this.parameters[0] = new NamedParameter(type, thisName);
        this.addFirstChild(this.parameters[0]);
    }

    boolean hasThis() {
        return this.parameters != null && this.parameters[0].match("this");
    }

    public LocatedString getName(int rank) {
        return this.parameters[rank].getName();
    }

    boolean hasDefaultValue(int rank) {
        Parameter p = this.parameters[rank];
        return p.value() != null && !p.isOverriden();
    }

    boolean containsAlike() {
        int i = this.size;
        while (--i >= 0) {
            if (this.parameters[i] == null || !this.parameters[i].type.containsAlike()) continue;
            return true;
        }
        return false;
    }

    void substitute(Map map2) {
        int i = this.size;
        while (--i >= 0) {
            if (this.parameters[i] == null) continue;
            this.parameters[i].type = this.parameters[i].type.substitute(map2);
        }
    }

    Monotype[] types() {
        if (this.parameters == null) {
            return null;
        }
        Monotype[] res = new Monotype[this.size];
        int i = 0;
        while (i < this.size) {
            res[i] = this.parameters[i].type;
            ++i;
        }
        return res;
    }

    public MonoSymbol[] getMonoSymbols() {
        if (this.parameters == null) {
            return null;
        }
        MonoSymbol[] res = new MonoSymbol[this.size];
        int i = 0;
        while (i < this.size) {
            res[i] = this.parameters[i].getSymbol();
            ++i;
        }
        return res;
    }

    void typecheck(mlsub.typing.Monotype[] domain) {
        int i = 0;
        while (i < this.size) {
            this.parameters[i].typecheck(domain[i]);
            ++i;
        }
    }

    void doResolve() {
        super.doResolve();
        int i = 0;
        while (i < this.size) {
            if (this.parameters[i].symbol != null) {
                this.parameters[i].symbol.state = 2;
            }
            ++i;
        }
    }

    void resolveCalledFromAnalyse(Info info) {
        int i = 0;
        while (i < this.size) {
            this.parameters[i].resolve(info);
            ++i;
        }
    }

    boolean match(Arguments args, FunSymbol symbol) {
        int[] map2 = new int[this.size];
        int i = 0;
        while (i < args.size()) {
            Arguments.Argument a = args.get(i);
            if (a.name != null && this.fill(map2, a.name.toString(), i)) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < args.size()) {
            Arguments.Argument a = args.get(i2);
            if (a.name == null && this.fill(map2, i2)) {
                return false;
            }
            ++i2;
        }
        Expression[] exps = new Expression[this.size];
        int i3 = 0;
        while (i3 < this.size) {
            if (map2[i3] == 0) {
                exps[i3] = this.parameters[i3].value();
                if (exps[i3] == null) {
                    return false;
                }
            } else {
                exps[i3] = args.getExp(map2[i3] - 1);
            }
            ++i3;
        }
        args.applicationExpressions.put(symbol, exps);
        args.usedArguments.put(symbol, map2);
        return true;
    }

    boolean fill(int[] map2, int num) {
        int i = 0;
        while (i < map2.length && (map2[i] != 0 || this.parameters[i].requiresName())) {
            ++i;
        }
        if (i == map2.length) {
            return true;
        }
        map2[i] = num + 1;
        return false;
    }

    boolean fill(int[] map2, String id, int num) {
        int i = 0;
        while (!(i >= map2.length || map2[i] == 0 && this.parameters[i].match(id))) {
            ++i;
        }
        if (i == map2.length) {
            return true;
        }
        map2[i] = num + 1;
        return false;
    }

    public boolean hasMatchFor(String s) {
        int i = 0;
        while (i < this.size) {
            if (this.parameters[i].match(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return Util.map("", ", ", "", this.parameters);
    }

    public Iterator iterator() {
        if (this.parameters != null) {
            return Arrays.asList(this.parameters).iterator();
        }
        return ((AbstractList)new ArrayList()).iterator();
    }

    public List getNamedParameters() {
        LinkedList<Parameter> res = new LinkedList<Parameter>();
        int i = 0;
        while (i < this.size) {
            Parameter param = this.parameters[i];
            if (param instanceof NamedParameter) {
                res.add(this.parameters[i]);
            }
            ++i;
        }
        return res;
    }

    public List getRequiredParameters() {
        LinkedList<Parameter> res = new LinkedList<Parameter>();
        int i = 0;
        while (i < this.size) {
            Parameter param = this.parameters[i];
            if (!(param instanceof OptionalParameter)) {
                res.add(this.parameters[i]);
            }
            ++i;
        }
        return res;
    }

    public Stack[] getParameterCopies() {
        Stack[] res = null;
        int i = 0;
        while (i < this.size) {
            Parameter param = this.parameters[i];
            if (param.symbol.copies != null) {
                if (res == null) {
                    res = new Stack[this.parameters.length];
                }
                res[i] = param.symbol.copies;
            }
            ++i;
        }
        return res;
    }

    List getParameters(TypeScope scope) {
        ArrayList<Parameter> res = new ArrayList<Parameter>(this.size);
        int i = 0;
        while (i < this.size) {
            Parameter p = this.parameters[i].cloneParam();
            p.type = Monotype.create(p.type.resolve(scope));
            res.add(p);
            ++i;
        }
        return res;
    }

    Attribute asBytecodeAttribute() {
        return new MiscAttr("parameters", this.toString().getBytes());
    }

    static FormalParameters readBytecodeAttribute(MiscAttr attr) {
        String value = new String(attr.data);
        if (Debug.bytecodeAttributes) {
            Debug.println("Read attribute " + attr.getName() + "=\"" + value + "\" from " + attr.getContainer());
        }
        try {
            return Loader.getParser(value).formalParameters(false, null);
        }
        catch (ParseException ex) {
            throw Internal.error("Could not parse '" + attr.getName() + "' bytecode attribute:\n" + "In method: " + attr.getContainer() + "\n" + "Value    : " + value);
        }
    }

    public static class OptionalParameter
    extends NamedParameter {
        Expression defaultValue;
        boolean overriden;

        public OptionalParameter(Monotype type, LocatedString name, Expression defaultValue) {
            super(type, name);
            this.defaultValue = defaultValue;
        }

        public OptionalParameter(Monotype type, LocatedString name, boolean nameRequired, Expression value) {
            this(type, name, value);
            this.nameRequired = nameRequired;
        }

        public OptionalParameter(Monotype type, LocatedString name, boolean nameRequired, Expression value, boolean overriden) {
            this(type, name, nameRequired, value);
            this.overriden = overriden;
        }

        Expression value() {
            return this.defaultValue;
        }

        boolean isOverriden() {
            return this.overriden;
        }

        Parameter cloneParam() {
            return new OptionalParameter(this.type, this.name, this.nameRequired, this.defaultValue, this.overriden);
        }

        void resolve() {
            this.defaultValue = dispatch.analyse(this.defaultValue, this.scope, this.typeScope);
            this.defaultValue = this.defaultValue.noOverloading();
            super.resolve();
        }

        void resolve(Info info) {
            this.defaultValue = dispatch.analyse(this.defaultValue, info);
            this.defaultValue = this.defaultValue.noOverloading();
            super.resolve();
        }

        void typecheck(mlsub.typing.Monotype domain) {
            this.defaultValue = this.defaultValue.noOverloading();
            dispatch.typecheck(this.defaultValue);
            try {
                Typing.leq(this.defaultValue.getType(), domain);
            }
            catch (TypingEx e) {
                User.error((Located)this.name, this.defaultValue + " is not a value of type " + this.type);
            }
        }

        public String toString() {
            this.defaultValue = this.defaultValue.noOverloading();
            return this.type + " " + this.name + " = " + this.defaultValue;
        }
    }

    public static class NamedParameter
    extends Parameter {
        LocatedString name;
        boolean nameRequired = false;

        public NamedParameter(Monotype type, LocatedString name) {
            super(type);
            this.name = name;
        }

        public NamedParameter(Monotype type, LocatedString name, boolean nameRequired) {
            this(type, name);
            this.nameRequired = nameRequired;
        }

        boolean requiresName() {
            return this.nameRequired;
        }

        Parameter cloneParam() {
            NamedParameter res = new NamedParameter(this.type, this.name);
            res.nameRequired = this.nameRequired;
            return res;
        }

        boolean match(String id) {
            return this.name.toString().equals(id);
        }

        public String toString() {
            return this.type + " " + this.name;
        }

        LocatedString getName() {
            return this.name;
        }
    }

    public static class Parameter
    extends Node {
        Monotype type;
        private Symbol symbol;

        public Parameter(Monotype type) {
            super(2);
            this.type = type;
        }

        Parameter cloneParam() {
            return new Parameter(this.type);
        }

        boolean match(String id) {
            return false;
        }

        boolean requiresName() {
            return false;
        }

        void typecheck(mlsub.typing.Monotype domain) {
        }

        Expression value() {
            return null;
        }

        boolean isOverriden() {
            return false;
        }

        void resolve() {
            if (this.symbol != null) {
                this.symbol.state = 1;
            }
        }

        void resolve(Info info) {
            if (this.symbol != null) {
                this.symbol.state = 1;
            }
        }

        public String toString() {
            return this.type.toString();
        }

        LocatedString getName() {
            return null;
        }

        void resetType(Monotype type) {
            this.type = type;
            if (this.symbol != null) {
                this.symbol.syntacticType = type;
            }
        }

        Symbol getSymbol() {
            this.symbol = new Symbol(this.getName(), this.type);
            return this.symbol;
        }

        static class AccessExp
        extends SymbolExp {
            AccessExp(Symbol symbol, Location location) {
                super(symbol, location);
            }

            public boolean isAssignable() {
                return false;
            }

            public gnu.expr.Expression compile() {
                return new CopyArgument(((Symbol)this.getSymbol()).copies);
            }
        }

        static class Symbol
        extends MonoSymbol {
            static final int NOT_ACCESSIBLE = 0;
            static final int ARGUMENT_REFERENCE = 1;
            static final int ACCESSIBLE = 2;
            private int state = 0;
            private Stack copies;

            private Symbol(LocatedString name, Monotype type) {
                super(name, type);
            }

            int getState() {
                if (this.state == 1) {
                    this.copies = new Stack();
                }
                return this.state;
            }

            public void setDeclaration(Declaration declaration, boolean isThis) {
                super.setDeclaration(declaration, isThis);
            }
        }
    }
}

