/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Block;
import bossa.syntax.CallExp;
import bossa.syntax.ClassDefinition;
import bossa.syntax.Constraint;
import bossa.syntax.Contract;
import bossa.syntax.ExpressionStmt;
import bossa.syntax.FormalParameters;
import bossa.syntax.IdentExp;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Monotype;
import bossa.syntax.MonotypeConstructor;
import bossa.syntax.NiceClass;
import bossa.syntax.Node;
import bossa.syntax.OverloadedSymbolExp;
import bossa.syntax.PrimitiveType;
import bossa.syntax.Statement;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeParameters;
import bossa.syntax.TypeScope;
import bossa.syntax.UserOperator;
import bossa.syntax.VarScope;
import bossa.syntax.dispatch;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.MiscAttr;
import gnu.bytecode.Type;
import gnu.expr.ConstructorExp;
import gnu.expr.Expression;
import gnu.expr.InitializeProc;
import gnu.expr.InstantiateProc;
import gnu.expr.QuoteExp;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import mlsub.typing.FunType;
import mlsub.typing.MonotypeVar;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.TypingEx;
import nice.tools.code.Gen;

public abstract class CustomConstructor
extends UserOperator {
    NiceClass classe;

    public static CustomConstructor make(LocatedString className, Constraint cst, FormalParameters params, Block body) {
        return new SourceCustomConstructor(className, cst, params, body);
    }

    CustomConstructor(LocatedString className, Constraint cst, FormalParameters params) {
        super(new LocatedString("<init>", className.location()), cst, CustomConstructor.returnType(className, cst), params, Contract.noContract);
    }

    CustomConstructor(NiceClass def, FormalParameters parameters) {
        super(new LocatedString("<init>", def.definition.location()), def.definition.classConstraint == null ? null : def.definition.classConstraint.shallowClone(), CustomConstructor.returnType(def.definition), parameters, Contract.noContract);
        this.classe = def;
    }

    void addConstructorCallSymbol() {
        Polytype type = new Polytype(this.getType().getConstraint(), new FunType(this.getArgTypes(), PrimitiveType.voidType));
        this.classe.addConstructorCallSymbol(new MethodDeclaration.Symbol(this.name, type){

            Expression compileInCallPosition() {
                return CustomConstructor.this.getInitializationCode(true);
            }
        });
    }

    private static Monotype returnType(LocatedString className, Constraint cst) {
        TypeIdent classe = new TypeIdent(className);
        classe.nullness = (byte)2;
        if (cst == Constraint.True) {
            return classe;
        }
        TypeSymbol[] syms = cst.getBinderArray();
        Monotype[] params = new Monotype[syms.length];
        int i = 0;
        while (i < syms.length) {
            if (!(syms[i] instanceof MonotypeVar)) {
                User.error((Located)classe, syms[i] + " is not a type");
            }
            params[i] = Monotype.create((MonotypeVar)syms[i]);
            ++i;
        }
        MonotypeConstructor res = new MonotypeConstructor(classe, new TypeParameters(params), classe.location());
        res.nullness = (byte)2;
        return res;
    }

    private static Monotype returnType(ClassDefinition def) {
        mlsub.typing.Monotype res = Monotype.sure(new mlsub.typing.MonotypeConstructor(def.tc, def.getTypeParameters()));
        return Monotype.create(res);
    }

    public void printInterface(PrintWriter s) {
    }

    public void compile() {
        this.getCode();
    }

    abstract Expression getInitializationCode(boolean var1);

    public static CustomConstructor load(NiceClass def, Method method) {
        if (!method.isConstructor()) {
            return null;
        }
        MiscAttr attr = (MiscAttr)Attribute.get(method, "parameters");
        if (attr == null) {
            return null;
        }
        return new ImportedCustomConstructor(def, method, attr);
    }

    static class ImportedCustomConstructor
    extends CustomConstructor {
        private Method method;

        ImportedCustomConstructor(NiceClass def, Method method, MiscAttr attr) {
            super(def, FormalParameters.readBytecodeAttribute(attr));
            this.method = method;
            TypeConstructors.addConstructor(this.classe.definition.tc, this);
        }

        void resolve() {
            this.addConstructorCallSymbol();
        }

        protected Expression computeCode() {
            int dummyArgs = this.method.arg_types.length - this.arity;
            return new QuoteExp(new InstantiateProc(this.method, dummyArgs));
        }

        Expression getConstructorInvocation(boolean omitDefaults) {
            int dummyArgs = this.method.arg_types.length - this.arity;
            Method calledMethod = omitDefaults ? this.getMethodUsingDefaults() : this.method;
            return new QuoteExp(new InitializeProc(calledMethod, false, dummyArgs));
        }

        Expression getInitializationCode(boolean implicitThis) {
            int dummyArgs = this.method.arg_types.length - this.arity;
            return new QuoteExp(new InitializeProc(this.method, implicitThis, dummyArgs));
        }

        private Method getMethodUsingDefaults() {
            Type[] fullArgTypes = this.method.arg_types;
            LinkedList<Type> argTypes = new LinkedList<Type>();
            int i = 0;
            while (i < this.parameters.size) {
                if (!this.parameters.hasDefaultValue(i)) {
                    argTypes.add(fullArgTypes[i]);
                }
                ++i;
            }
            Type[] argTypesArray = argTypes.toArray(new Type[argTypes.size()]);
            return this.method.getDeclaringClass().getDeclaredMethod("<init>", argTypesArray);
        }
    }

    static class SourceCustomConstructor
    extends CustomConstructor {
        private VarScope thisScope;
        private TypeScope thisTypeScope;
        LocatedString className;
        Statement body;
        Expression initializationCode;
        Expression initializationCodeImplicitThis;

        SourceCustomConstructor(LocatedString className, Constraint cst, FormalParameters params, Block body) {
            super(className, cst, params);
            this.className = className;
            this.body = body;
        }

        void resolve() {
            TypeConstructor tc = Node.getGlobalTypeScope().globalLookup(this.className);
            TypeConstructors.addConstructor(tc, this);
            this.classe = NiceClass.get(tc);
            if (this.classe == null) {
                User.error((Located)this, "It is impossible to add a constructor to class " + tc);
            }
            this.addConstructorCallSymbol();
            this.thisScope = this.scope;
            this.thisTypeScope = this.typeScope;
        }

        void resolveBody() {
            this.resolveThis((Block)this.body);
            this.body = dispatch.analyse(this.body, this.thisScope, this.thisTypeScope, false);
        }

        private void resolveThis(Block block) {
            Statement last = block.statements[block.statements.length - 1];
            if (last instanceof Block) {
                this.resolveThis((Block)last);
                return;
            }
            try {
                CallExp call = (CallExp)((ExpressionStmt)last).exp;
                IdentExp ident = (IdentExp)call.function;
                if (!call.function.toString().equals("this")) {
                    User.error((Located)this, "The last statement must be a call to 'this' constructor");
                }
                Location loc = ident.location();
                call.function = new OverloadedSymbolExp(this.classe.getConstructorCallSymbols(), FormalParameters.thisName);
                call.function.setLocation(loc);
            }
            catch (ClassCastException ex) {
                User.error((Located)this, "The last statement must be a call to 'this' constructor");
            }
        }

        void innerTypecheck() throws TypingEx {
            super.innerTypecheck();
            dispatch.typecheck(this.body);
        }

        private Map map(TypeSymbol[] source, mlsub.typing.Monotype[] destination) {
            HashMap<String, Monotype> res = new HashMap<String, Monotype>(source.length);
            int i = 0;
            while (i < source.length) {
                res.put(source[i].toString(), Monotype.create(destination[i]));
                ++i;
            }
            return res;
        }

        protected Expression computeCode() {
            ConstructorExp lambda = Gen.createCustomConstructor((ClassType)this.javaReturnType(), this.javaArgTypes(), this.getSymbols());
            Gen.setMethodBody(lambda, this.body.generateCode());
            this.classe.getClassExp().addMethod(lambda);
            mlsub.typing.Constraint cst = this.getType().getConstraint();
            if (mlsub.typing.Constraint.hasBinders(cst)) {
                this.parameters.substitute(this.map(cst.binders(), this.classe.definition.getTypeParameters()));
            }
            lambda.addBytecodeAttribute(this.parameters.asBytecodeAttribute());
            this.initializationCode = new QuoteExp(new InitializeProc(lambda));
            this.initializationCodeImplicitThis = new QuoteExp(new InitializeProc(lambda, true));
            return new QuoteExp(new InstantiateProc(lambda));
        }

        Expression getConstructorInvocation(boolean omitDefaults) {
            this.getCode();
            return this.initializationCode;
        }

        Expression getInitializationCode(boolean implicitThis) {
            this.getCode();
            if (implicitThis) {
                return this.initializationCodeImplicitThis;
            }
            return this.initializationCode;
        }
    }
}

