/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ExpLocalVariable;
import bossa.syntax.Expression;
import bossa.syntax.FormalParameters;
import bossa.syntax.FunSymbol;
import bossa.syntax.LocatedString;
import bossa.syntax.PackageExp;
import bossa.syntax.VarSymbol;
import bossa.util.Internal;
import bossa.util.Util;
import gnu.bytecode.ClassType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Arguments {
    Expression[] computedExpressions;
    Map applicationExpressions = new HashMap();
    Map usedArguments = new HashMap();
    Map types = new HashMap();
    Argument[] arguments;

    public Arguments(List args) {
        this.arguments = args.toArray(new Argument[args.size()]);
    }

    public Arguments(Argument[] arguments) {
        this.arguments = arguments;
    }

    public static Arguments noArguments() {
        return new Arguments(new Argument[0]);
    }

    public void addReceiver(Expression value) {
        if (this.arguments[0] != null) {
            Internal.error("No room for \"receiver\"");
        }
        this.arguments[0] = new Argument(value, null);
    }

    void add(Expression arg, LocatedString name) {
        Argument[] newArgs = new Argument[this.arguments.length + 1];
        System.arraycopy(this.arguments, 0, newArgs, 0, this.arguments.length);
        newArgs[this.arguments.length] = new Argument(arg, name);
        this.arguments = newArgs;
    }

    int size() {
        if (this.computedExpressions != null) {
            return this.computedExpressions.length;
        }
        return this.arguments.length;
    }

    Argument get(int num) {
        return this.arguments[num];
    }

    Expression getExp(int num) {
        if (this.computedExpressions != null) {
            return this.computedExpressions[num];
        }
        return this.arguments[num].value;
    }

    void setExp(int num, Expression value) {
        this.arguments[num].value = value;
    }

    void noOverloading() {
        int i = this.arguments.length;
        while (--i >= 0) {
            this.arguments[i].value = this.arguments[i].value.noOverloading();
        }
    }

    void computeTypes() {
        int i = this.arguments.length;
        while (--i >= 0) {
            this.arguments[i].value.getType();
        }
    }

    Expression[] inOrder() {
        if (this.arguments.length == 0) {
            return Expression.noExpressions;
        }
        Expression[] res = new Expression[this.arguments.length];
        int i = this.arguments.length;
        while (--i >= 0) {
            res[i] = this.arguments[i].value;
        }
        return res;
    }

    PackageExp packageExp() {
        Expression param0;
        if (this.arguments.length == 1 && (param0 = this.getExp(0)) instanceof PackageExp) {
            return (PackageExp)param0;
        }
        return null;
    }

    ClassType staticClass() {
        ClassType res = this.getExp(0).staticClass();
        if (res != null) {
            Argument[] newArgs = new Argument[this.arguments.length - 1];
            System.arraycopy(this.arguments, 1, newArgs, 0, newArgs.length);
            this.arguments = newArgs;
        }
        return res;
    }

    ExpLocalVariable[] extractLocalVars() {
        ArrayList<Expression> res = new ArrayList<Expression>();
        int i = this.arguments.length;
        while (--i >= 0) {
            if (!(this.arguments[i].value instanceof ExpLocalVariable)) continue;
            res.add(this.arguments[i].value);
        }
        if (res.isEmpty()) {
            return null;
        }
        return res.toArray(new ExpLocalVariable[res.size()]);
    }

    Expression[] getExpressions(VarSymbol s) {
        return (Expression[])this.applicationExpressions.get(s);
    }

    int[] getUsedArguments(VarSymbol s) {
        return (int[])this.usedArguments.get(s);
    }

    boolean plainApplication(int arity, VarSymbol symbol) {
        if (this.arguments.length != arity) {
            return false;
        }
        int i = 0;
        while (i < this.arguments.length) {
            if (this.arguments[i].name != null) {
                return false;
            }
            ++i;
        }
        this.applicationExpressions.put(symbol, this.inOrder());
        return true;
    }

    public String toString() {
        return "(" + Util.map("", ", ", "", this.arguments) + ")";
    }

    public String toStringInfix() {
        StringBuffer res = new StringBuffer("(");
        int i = 1;
        while (i < this.arguments.length) {
            res.append(this.arguments[i].toString() + (i + 1 < this.arguments.length ? ", " : ""));
            ++i;
        }
        return res.append(")").toString();
    }

    public String printTypes() {
        StringBuffer res = new StringBuffer("(");
        int i = 0;
        while (i < this.arguments.length) {
            res.append((this.arguments[i].name == null ? "" : this.arguments[i].name + ":") + this.arguments[i].value.getType() + (i + 1 < this.arguments.length ? ", " : ""));
            ++i;
        }
        return res.append(")").toString();
    }

    String explainNoMatch(List noMatches) {
        LinkedList<String> argnames = new LinkedList<String>();
        int i = 0;
        while (i < this.arguments.length) {
            if (this.arguments[i].name != null) {
                argnames.add(this.arguments[i].name.toString());
            }
            ++i;
        }
        if (!argnames.isEmpty()) {
            Iterator i2 = noMatches.iterator();
            while (i2.hasNext()) {
                Object noMatch = i2.next();
                if (!(noMatch instanceof FunSymbol)) continue;
                argnames.retainAll(this.noMatchByName(((FunSymbol)noMatch).parameters));
            }
            if (!argnames.isEmpty()) {
                return " has an argument named " + argnames.get(0);
            }
            return " has compatible named arguments";
        }
        return " has " + this.arguments.length + " arguments";
    }

    List noMatchByName(FormalParameters parameters) {
        LinkedList<String> res = new LinkedList<String>();
        int i = 0;
        while (i < this.arguments.length) {
            if (this.arguments[i].name != null) {
                String s = this.arguments[i].name.toString();
                if (parameters == null || !parameters.hasMatchFor(s)) {
                    res.add(s);
                }
            }
            ++i;
        }
        return res;
    }

    List missingArgs(FormalParameters parameters) {
        LinkedList<FormalParameters.Parameter> missing = new LinkedList<FormalParameters.Parameter>();
        Iterator reqParams = parameters.getRequiredParameters().iterator();
        int lastUsedPositional = -1;
        while (reqParams.hasNext()) {
            int i;
            boolean found = false;
            FormalParameters.Parameter param = (FormalParameters.Parameter)reqParams.next();
            if (param.value() != null) continue;
            if (param instanceof FormalParameters.NamedParameter) {
                i = 0;
                while (i < this.arguments.length) {
                    String s;
                    if (this.arguments[i].name != null && param.match(s = this.arguments[i].name.toString())) {
                        found = true;
                        break;
                    }
                    ++i;
                }
            } else {
                i = lastUsedPositional + 1;
                while (i < this.arguments.length) {
                    if (this.arguments[i].name == null) {
                        found = true;
                        lastUsedPositional = i;
                        break;
                    }
                    ++i;
                }
            }
            if (found) continue;
            missing.add(param);
        }
        return missing;
    }

    public static class Argument {
        private Expression value;
        LocatedString name;

        public Argument(Expression value) {
            this.value = value;
        }

        public Argument(Expression value, LocatedString name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return (this.name == null ? "" : this.name + ":") + this.value;
        }
    }
}

