/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.DefaultMethodImplementation;
import bossa.syntax.Definition;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodContainer;
import bossa.syntax.TypeIdent;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import mlsub.typing.Interface;
import mlsub.typing.KindingEx;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;

public class AbstractInterface
extends MethodContainer {
    private Interface itf;
    private List extensions;
    private Interface[] surinterfaces;

    public AbstractInterface(LocatedString name, MethodContainer.Constraint typeParameters, List typeParametersVariances, List extensions) {
        super(name, 1, typeParameters, typeParametersVariances);
        this.extensions = extensions;
        this.itf = new Interface(this.variance, name.toString());
        this.addTypeSymbol(this.itf);
    }

    public void addMethod(Definition m) {
        this.addChild(m);
    }

    TypeSymbol getTypeSymbol() {
        return this.itf;
    }

    void resolve() {
        super.resolve();
        this.surinterfaces = TypeIdent.resolveToItf(this.typeScope, this.extensions);
        this.extensions = null;
        this.createContext();
    }

    void resolveBody() {
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                Object child = i.next();
                if (!(child instanceof DefaultMethodImplementation)) continue;
                ((DefaultMethodImplementation)child).resolveBody();
            }
        }
    }

    private void createContext() {
        if (this.surinterfaces != null) {
            try {
                Typing.assertLeq(this.itf, this.surinterfaces);
            }
            catch (KindingEx e) {
                User.error((Located)this.name, this.name + " cannot extends one of the surinterfaces " + " because they don't have the same number or kind of " + " type parameters");
            }
        }
    }

    public void printInterface(PrintWriter w) {
        super.printInterface(w);
        w.print("abstract interface " + this.getSimpleName() + this.printTypeParameters() + Util.map(" extends ", ", ", "", this.surinterfaces) + "{}\n");
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof Definition)) continue;
                ((Definition)o).printInterface(w);
            }
        }
    }

    public void compile() {
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof Definition)) continue;
                ((Definition)o).compile();
            }
        }
    }

    public String toString() {
        return this.name.toString();
    }
}

