/*
 * Decompiled with CFR 0.152.
 */
package bossa.modules;

import bossa.modules.Compilation;
import bossa.modules.CompiledContent;
import bossa.modules.Content;
import bossa.modules.DirectoryCompiledContent;
import bossa.modules.DirectorySourceContent;
import bossa.modules.JarCompiledContent;
import bossa.modules.Package;
import bossa.util.Debug;
import bossa.util.User;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.jar.JarFile;
import nice.tools.util.System;

final class Locator {
    private final Object[] sourceRoots;
    private final Object[] packageRoots;

    Locator(Compilation compilation, String classpath) {
        this.sourceRoots = Locator.splitPath(compilation.sourcePath);
        this.packageRoots = Locator.splitPath(classpath);
    }

    Content find(Package pkg) {
        DirectorySourceContent source = null;
        CompiledContent compiled = null;
        String filesystemName = pkg.getName().replace('.', File.separatorChar);
        int i = 0;
        while (source == null && i < this.sourceRoots.length) {
            if (this.sourceRoots[i] instanceof File) {
                source = DirectorySourceContent.create(pkg, new File((File)this.sourceRoots[i], filesystemName));
            }
            ++i;
        }
        int i2 = 0;
        while (compiled == null && i2 < this.packageRoots.length) {
            compiled = this.packageRoots[i2] instanceof File ? DirectoryCompiledContent.create(pkg, new File((File)this.packageRoots[i2], filesystemName)) : JarCompiledContent.create(pkg, (JarFile)this.packageRoots[i2]);
            ++i2;
        }
        Content res = new Content(pkg, source, compiled);
        if (Debug.modules) {
            Debug.println("Locating " + pkg.getName() + ":\n" + res);
        }
        return res;
    }

    private static Object[] splitPath(String path) {
        LinkedList<Object> res = new LinkedList<Object>();
        int start = 0;
        while (start < path.length() && path.charAt(start) == File.pathSeparatorChar) {
            ++start;
        }
        while (start < path.length()) {
            String pathComponent;
            int end = path.indexOf(File.pathSeparatorChar, start);
            if (end == -1) {
                end = path.length();
            }
            if ((pathComponent = path.substring(start, end)).length() > 0) {
                File f = System.getFile(pathComponent).getAbsoluteFile();
                if (f.exists()) {
                    if (pathComponent.endsWith(".jar")) {
                        try {
                            res.add(new JarFile(f));
                        }
                        catch (IOException e) {}
                    } else if (f.isDirectory()) {
                        res.add(f);
                    } else {
                        User.warning("Path " + f + " is not valid");
                    }
                } else {
                    User.warning("Path " + f + " does not exist");
                }
            }
            start = end + 1;
        }
        return res.toArray(new Object[res.size()]);
    }
}

