/* $Id: cfunc.mod,v 1.2 2003/08/05 17:20:45 pnenzi Exp $ */


#define CLK_STATE       0


void ucm_real_delay (ARGS)
{

    double              *in;
    double              *out;

    Digital_State_t     *state;
    Digital_State_t     *old_state;


    if(INIT) {
        state = (void *) cm_event_alloc(CLK_STATE, sizeof(Digital_State_t));
        old_state = state;
        *state = INPUT_STATE(clk);
    }
    else {
        state = (void *) cm_event_get_ptr(CLK_STATE, 0);
        old_state = (void *) cm_event_get_ptr(CLK_STATE, 1);
    }

    if(ANALYSIS != TRANSIENT)
        OUTPUT_CHANGED(out) = FALSE;
    else {
        *state = INPUT_STATE(clk);
        if(*state == *old_state)
            OUTPUT_CHANGED(out) = FALSE;
        else if(*state != ONE)
            OUTPUT_CHANGED(out) = FALSE;
        else {
            in = INPUT(in);
            out = OUTPUT(out);
            *out = *in;
            OUTPUT_DELAY(out) = PARAM(delay);
        }
    }
}




