/*
 *  This file is part of the nfdump project.
 *
 *  Copyright (c) 2008, SWITCH - Teleinformatikdienste fuer Lehre und Forschung
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions are met:
 *  
 *   * Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright notice, 
 *     this list of conditions and the following disclaimer in the documentation 
 *     and/or other materials provided with the distribution.
 *   * Neither the name of SWITCH nor the names of its contributors may be 
 *     used to endorse or promote products derived from this software without 
 *     specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 *  POSSIBILITY OF SUCH DAMAGE.
 *  
 *  $Author: peter $
 *
 *  $Id: collector_inline.c 100 2008-08-15 11:36:21Z peter $
 *
 *  $LastChangedRevision: 100 $
 *	
 */


static inline FlowSource_t *GetFlowSource(struct sockaddr *sa) {
FlowSource_t	*fs;
void 			*ptr;
uint64_t		ip[2];
char			addrstr[100];

	switch (sa->sa_family) {
		case PF_INET:
#ifdef HAVE_SOCKADDR_SA_LEN
			if (sa->sa_len != sizeof(struct sockaddr_in) ) {
				// malformed struct
				syslog(LOG_ERR, "Malformed IPv4 socket struct in '%s', line '%d'", __FILE__, __LINE__ );
				return NULL;
			}
#endif
			ptr = &((struct sockaddr_in *)sa)->sin_addr;
			ip[0] = *(uint32_t *)ptr & 0xffffffffLL ;
			ip[1] = 0;
			break;
		case PF_INET6:
#ifdef HAVE_SOCKADDR_SA_LEN
			if (sa->sa_len != sizeof(struct sockaddr_in6) ) {
				// malformed struct
				syslog(LOG_ERR, "Malformed IPv6 socket struct in '%s', line '%d'", __FILE__, __LINE__ );
				return NULL;
			}
#endif
			ptr = &((struct sockaddr_in6 *)sa)->sin6_addr;
			ip[0] = ((uint64_t *)ptr)[0];
			ip[1] = ((uint64_t *)ptr)[1];
			break;
		default:
			// keep compiler happy
			ip[0] = 0;
			ip[1] = 0;
			ptr = NULL;
			// cheep trick if reading from pcap file
			if ( !(sa->sa_family == 1 ))  {
				syslog(LOG_ERR, "Unknown sa fanily: %d in '%s', line '%d'", sa->sa_family, __FILE__, __LINE__ );
				return NULL;
			}
	}

	fs = FlowSource;
	while ( fs ) {
		if ( ip[0] ==  fs->ip[0] && ip[1] == fs->ip[1] )
			return fs; 

		// if we match any source, store the current IP address - works as faster cache next time
		if ( fs->any_source ) {
			fs->ip[0] = ip[0];
			fs->ip[1] = ip[1];
			return fs;
		}
		fs = fs->next;
	}

	inet_ntop (sa->sa_family, ptr, addrstr, 100);
	addrstr[99] = '\0';
	syslog(LOG_DEBUG, "UDP packet from: '%s'" , addrstr);
	syslog(LOG_ERR, "Unknown flow source: '%s'" , addrstr);

	return NULL;

} // End of GetFlowSource



