#! /bin/sh

### BEGIN INIT INFO
# Provides:          netswitch
# Required-Start:    $local_fs $remote_fs
# Required-Stop:
# Default-Start:     S 1 2 3 4 5
# Default-Stop:      0 6
### END INIT INFO

N=/etc/init.d/netswitch

set -e

case "$1" in
  start)
	# Find the profile to activate from Kernel command line
	PROFILE=`cat /proc/cmdline|sed 's/.*netswitch=\([^ ]*\).*/\1/'`
	if [ -n "`netswitch list|grep \"$PROFILE\"`" ]; then
		netswitch profile on $PROFILE
	fi
	;;
  stop)
	netswitch profile off 
	;;
  restart)
	$N stop
	$N start
	;;
  *)
	echo "Usage: $N {start|stop|restart}" >&2
	exit 1
	;;
esac

exit 0
