/*
Copyright (C) 1998 Pyrosoft Inc. (www.pyrosoftgames.com), Matthew Bogue
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _UNITBASE_HPP
#define _UNITBASE_HPP

#include "UnitBlackBoard.hpp"
#include "UnitState.hpp"
#include "UnitMessage.hpp"
#include "UnitID.hpp"
#include "UnitOpcodes.hpp"
#include "SpriteSorter.hpp"

class UnitBase : public UnitBlackBoard
{
public:
    UnitID    unit_id;
    UnitState unit_state;
    bool	 in_sync_flag;

    UnitBase()
    { }
    virtual ~UnitBase()
    { }

    virtual void processMessage( UnitMessage *message )
    {  }

    virtual void evalCommandOpcode( UnitOpcodeStruct *opcode )
    { }

    virtual void updateState( void )
    { }

    virtual void syncUnit( void )
    { }

    virtual void offloadGraphics( SpriteSorter &sorter )
    { }

    virtual void soundSelected() = 0;

protected:
    UnitBase *groupLinkNext;

};

#endif // ** _UNITBASE_HPP
