const char * ngscript[] = {
"#userlevel 1..standard user 2..power-user 3..developer\n",\
"\n",\
"set userlevel 3\n",\
"if { [Ng_GetCommandLineParameter expert]==\"defined\" } {\n",\
"    set userlevel 3\n",\
"}\n",\
"\n",\
"set progname \"NETGEN\"\n",\
"\n",\
"set ngdir \"\"\n",\
"if { [lsearch [array names env] NETGENDIR] != -1 } {\n",\
"    set ngdir $env(NETGENDIR) \n",\
"}\n",\
"if { [string length $ngdir] == 0 } {\n",\
"    set ngdir \".\" \n",\
"}\n",\
"\n",\
"\n",\
"catch {\n",\
"     wm withdraw .\n",\
"     \n",\
"     wm title . $progname\n",\
"     wm geometry . =800x600\n",\
"     wm minsize . 400 300\n",\
"}\n",\
"\n",\
"# netgen global tcl-variables\n",\
"\n",\
"set drawmode rotate\n",\
"set selectvisual geometry\n",\
"\n",\
"set dirname .\n",\
"set basefilename filename\n",\
"\n",\
"set meshoptions.fineness 3\n",\
"set meshoptions.firststep ag\n",\
"set meshoptions.laststep ov\n",\
"set options.memory 0\n",\
"\n",\
"set options.localh 1\n",\
"set options.delaunay 1\n",\
"set options.checkoverlap 1\n",\
"set options.checkchartboundary 1\n",\
"set options.startinsurface 0\n",\
"set options.blockfill 1\n",\
"set options.debugmode 0\n",\
"set options.dooptimize 1\n",\
"set options.parthread 1\n",\
"set options.elsizeweight 0.2\n",\
"set options.secondorder 0\n",\
"set options.elementorder 1\n",\
"set options.quad 0\n",\
"set options.inverttets 0\n",\
"set options.inverttrigs 0\n",\
"\n",\
"\n",\
"set options.meshsize 1000\n",\
"\n",\
"set options.curvaturesafety 2\n",\
"set options.segmentsperedge 2\n",\
"set options.meshsizefilename \"\"\n",\
"set options.badellimit 175\n",\
"set options.optsteps2d 3\n",\
"set options.optsteps3d 5\n",\
"set options.opterrpow 2\n",\
"\n",\
"set options.grading 0.5\n",\
"set options.printmsg 2\n",\
"\n",\
"set debug.slowchecks 0\n",\
"set debug.debugoutput 0\n",\
"set debug.haltexistingline 0\n",\
"set debug.haltoverlap 0\n",\
"set debug.haltsuccess 0\n",\
"set debug.haltnosuccess 0\n",\
"set debug.haltlargequalclass 0\n",\
"set debug.haltsegment 0\n",\
"set debug.haltnode 0\n",\
"set debug.haltface 0\n",\
"set debug.haltfacenr 0\n",\
"set debug.haltsegmentp1 0\n",\
"set debug.haltsegmentp2 0\n",\
"\n",\
"set geooptions.drawcsg 1\n",\
"set geooptions.detail 0.001\n",\
"set geooptions.accuracy 1e-6\n",\
"set geooptions.facets 20\n",\
"set geooptions.minx -1000\n",\
"set geooptions.miny -1000\n",\
"set geooptions.minz -1000\n",\
"set geooptions.maxx 1000\n",\
"set geooptions.maxy 1000\n",\
"set geooptions.maxz 1000\n",\
"\n",\
"set viewqualityplot 0\n",\
"set showsensitivehelp 0\n",\
"set showhelpline 0\n",\
"\n",\
"set viewoptions.specpointvlen 0.3\n",\
"set viewoptions.light.amb 0.3\n",\
"set viewoptions.light.diff 0.7\n",\
"set viewoptions.light.spec 1\n",\
"set viewoptions.light.locviewer 0\n",\
"set viewoptions.mat.shininess 50\n",\
"set viewoptions.mat.transp 0.3\n",\
"set viewoptions.colormeshsize 0\n",\
"set viewoptions.whitebackground 1\n",\
"set viewoptions.drawcoordinatecross 1\n",\
"set viewoptions.drawcolorbar 1\n",\
"set viewoptions.drawnetgenlogo 1\n",\
"set viewoptions.stereo 0\n",\
"set viewoptions.shrink 1\n",\
"\n",\
"set viewoptions.drawfilledtrigs 1\n",\
"set viewoptions.drawedges 0\n",\
"set viewoptions.drawbadels 0\n",\
"set viewoptions.centerpoint 0\n",\
"set viewoptions.drawelement 0\n",\
"set viewoptions.drawoutline 1\n",\
"set viewoptions.drawtets 0\n",\
"set viewoptions.drawtetsdomain 0\n",\
"set viewoptions.drawprisms 0\n",\
"set viewoptions.drawpyramids 0\n",\
"set viewoptions.drawhexes 0\n",\
"set viewoptions.drawidentified 0\n",\
"set viewoptions.drawpointnumbers 0\n",\
"set viewoptions.drawedgenumbers 0\n",\
"set viewoptions.drawfacenumbers 0\n",\
"set viewoptions.drawelementnumbers 0\n",\
"set viewoptions.drawdomainsurf 0\n",\
"\n",\
"set viewoptions.drawededges 1\n",\
"set viewoptions.drawedpoints 1\n",\
"set viewoptions.drawedpointnrs 0\n",\
"set viewoptions.drawedtangents 0\n",\
"set viewoptions.drawededgenrs 0\n",\
"set viewoptions.drawmetispartition 0\n",\
"\n",\
"set viewoptions.drawcurveproj 0\n",\
"set viewoptions.drawcurveprojedge 1\n",\
"\n",\
"set viewoptions.clipping.nx 0\n",\
"set viewoptions.clipping.ny 1\n",\
"set viewoptions.clipping.nz 0\n",\
"set viewoptions.clipping.dist 0\n",\
"set viewoptions.clipping.enable 0\n",\
"\n",\
"set viewoptions.usecentercoords 0\n",\
"set viewoptions.centerx 0\n",\
"set viewoptions.centery 0\n",\
"set viewoptions.centerz 0\n",\
"\n",\
"\n",\
"set stloptions.showtrias 0\n",\
"set stloptions.showfilledtrias 1\n",\
"set stloptions.showedges 1\n",\
"set stloptions.showmarktrias 0\n",\
"set stloptions.showactivechart 0\n",\
"set stloptions.yangle 30\n",\
"set stloptions.contyangle 20\n",\
"set stloptions.edgecornerangle 60\n",\
"set stloptions.chartangle 15\n",\
"set stloptions.outerchartangle 70\n",\
"set stloptions.usesearchtree 0\n",\
"set stloptions.chartnumber 1\n",\
"set stloptions.charttrignumber 1\n",\
"set stloptions.chartnumberoffset 0\n",\
"\n",\
"set stloptions.atlasminh 0.1\n",\
"set stloptions.resthsurfcurvfac 2\n",\
"set stloptions.resthsurfcurvenable 0\n",\
"set stloptions.resthatlasfac 2\n",\
"set stloptions.resthatlasenable 1\n",\
"set stloptions.resthchartdistfac 1.2\n",\
"set stloptions.resthchartdistenable 1\n",\
"set stloptions.resthlinelengthfac 0.5\n",\
"set stloptions.resthlinelengthenable 1\n",\
"set stloptions.resthcloseedgefac 1\n",\
"set stloptions.resthcloseedgeenable 1\n",\
"set stloptions.resthedgeanglefac 1\n",\
"set stloptions.resthedgeangleenable 0\n",\
"set stloptions.resthsurfmeshcurvfac 1\n",\
"set stloptions.resthsurfmeshcurvenable 0\n",\
"set stloptions.recalchopt 1\n",\
"\n",\
"set stldoctor.drawmeshededges 1\n",\
"set stldoctor.geom_tol_fact 0.000001\n",\
"set stldoctor.useexternaledges 0\n",\
"set stldoctor.showfaces 0\n",\
"set stldoctor.conecheck 1\n",\
"set stldoctor.spiralcheck 1\n",\
"set stldoctor.selecttrig 0\n",\
"set stldoctor.selectmode 1\n",\
"set stldoctor.longlinefact 0\n",\
"set stldoctor.showexcluded 1\n",\
"set stldoctor.edgeselectmode 0\n",\
"set stldoctor.nodeofseltrig 1\n",\
"set stldoctor.showtouchedtrigchart 0\n",\
"set stldoctor.showedgecornerpoints 0\n",\
"set stldoctor.showmarkedtrigs 1\n",\
"set stldoctor.dirtytrigfact 0.01\n",\
"set stldoctor.smoothangle 90\n",\
"set stldoctor.selectwithmouse 1\n",\
"set stldoctor.showvicinity 0\n",\
"set stldoctor.vicinity 50\n",\
"set stldoctor.smoothnormalsweight 0.2\n",\
"\n",\
"set occoptions.showvolumenr 0\n",\
"set occoptions.showsurfaces 1\n",\
"set occoptions.showedges 1\n",\
"set occoptions.visproblemfaces 0\n",\
"set occoptions.zoomtohighlightedentity 0\n",\
"set occoptions.deflection 1\n",\
"set occoptions.tolerance 1e-3\n",\
"set occoptions.fixsmalledges 1\n",\
"set occoptions.fixspotstripfaces 1\n",\
"set occoptions.sewfaces 1\n",\
"set occoptions.makesolids 1\n",\
"\n",\
"set meshdoctor.active 0\n",\
"set meshdoctor.markedgedist 1\n",\
"\n",\
"\n",\
"# variablenname mit punkt problematisch!\n",\
"set status_np 0\n",\
"set status_ne 0\n",\
"set status_nse 0\n",\
"set status_working \" \"\n",\
"set status_task \" \"\n",\
"set status_percent 0\n",\
"set status_filename 0\n",\
"set status_tetqualclasses \"10 20 30 40 10 20 30 40 10 20 30 40 10 20 30 40 10 20 30 40\"\n",\
"\n",\
"set exportfiletype PERMAS\n",\
"\n",\
"set preproc.facenr 0\n",\
"set preproc.selectmode query\n",\
"set preproc.numtrig 0\n",\
"\n",\
"set mem_moveable 0\n",\
"\n",\
"\n",\
"set multithread_pause 0\n",\
"set multithread_testmode 0\n",\
"set multithread_redraw 0\n",\
"set multithread_drawing 0\n",\
"set multithread_terminate 0\n",\
"set multithread_running 0\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"set level 0\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"set optlist {\n",\
"    options.localh \n",\
"    options.delaunay \n",\
"    options.checkoverlap \n",\
"    options.startinsurface \n",\
"    options.blockfill \n",\
"    options.dooptimize \n",\
"    options.elsizeweight \n",\
"    options.meshsize \n",\
"    options.curvaturesafety \n",\
"    options.optsteps2d \n",\
"    options.optsteps3d \n",\
"    options.secondorder\n",\
"}\n",\
"\n",\
"\n",\
"set visoptions.usetexture 0\n",\
"set visoptions.invcolor 0\n",\
"set visoptions.imaginary 0\n",\
"set visoptions.lineartexture 0\n",\
"set visoptions.numtexturecols 16\n",\
"set visoptions.showclipsolution 1\n",\
"set visoptions.showsurfacesolution 0\n",\
"set visoptions.drawfieldlines 0\n",\
"set visoptions.numfieldlines 100\n",\
"set visoptions.fieldlinesrandomstart 0\n",\
"set visoptions.clipsolution none\n",\
"set visoptions.scalfunction none\n",\
"set visoptions.vecfunction none\n",\
"set visoptions.evaluate abs\n",\
"set visoptions.gridsize 20\n",\
"set visoptions.xoffset 0\n",\
"set visoptions.yoffset 0\n",\
"set visoptions.autoscale 1\n",\
"set visoptions.lineartexture 1\n",\
"set visoptions.redrawperiodic 0\n",\
"set visoptions.logscale 0\n",\
"set visoptions.mminval 0\n",\
"set visoptions.mmaxval 1\n",\
"set visoptions.isolines 0\n",\
"set visoptions.subdivisions 1\n",\
"set visoptions.numiso 10\n",\
"set visoptions.autoredraw 0\n",\
"set visoptions.autoredrawtime 2\n",\
"set visoptions.simulationtime 0\n",\
"set visoptions.multidimcomponent 0\n",\
"\n",\
"# deform by vector function\n",\
"set visoptions.deformation 0\n",\
"set visoptions.scaledeform1 1\n",\
"set visoptions.scaledeform2 1\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"if { [file exists ng.opt] == 1 } {\n",\
"    set datei [open ng.opt r]\n",\
"    while { [gets $datei line] >= 0 } {\n",\
"	set [lindex $line 0] [lindex $line 1]\n",\
"    }\n",\
"    close $datei\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc saveoptions { } {\n",\
"    uplevel 1  {\n",\
"	set file ng.opt \n",\
"	\n",\
"	if {$file != \"\"} {\n",\
"	    set datei [open $file w]\n",\
"	    \n",\
"	    puts $datei \"meshoptions.fineness  ${meshoptions.fineness}\"\n",\
"	    puts $datei \"meshoptions.firststep ${meshoptions.firststep}\"\n",\
"	    puts $datei \"meshoptions.laststep  ${meshoptions.laststep}\" \n",\
"	    puts $datei \"options.localh  ${options.localh}\"\n",\
"	    puts $datei \"options.delaunay  ${options.delaunay}\"\n",\
"	    puts $datei \"options.checkoverlap  ${options.checkoverlap}\"\n",\
"	    puts $datei \"options.checkchartboundary  ${options.checkchartboundary}\"\n",\
"	    puts $datei \"options.startinsurface  ${options.startinsurface}\" \n",\
"	    puts $datei \"options.blockfill  ${options.blockfill}\" \n",\
"	    puts $datei \"options.debugmode  ${options.debugmode}\" \n",\
"	    puts $datei \"options.dooptimize ${options.dooptimize}\" \n",\
"	    puts $datei \"options.parthread  ${options.parthread}\"  \n",\
"	    puts $datei \"options.elsizeweight  ${options.elsizeweight}\" \n",\
"	    puts $datei \"options.secondorder  ${options.secondorder}\" \n",\
"	    puts $datei \"options.elementorder  ${options.elementorder}\" \n",\
"	    puts $datei \"options.memory  ${options.memory}\" \n",\
"	    puts $datei \"options.quad  ${options.quad}\" \n",\
"	    puts $datei \"options.inverttets  ${options.inverttets}\" \n",\
"	    puts $datei \"options.inverttrigs  ${options.inverttrigs}\" \n",\
"	    puts $datei \"options.meshsize  ${options.meshsize}\" \n",\
"	    puts $datei \"options.curvaturesafety  ${options.curvaturesafety}\" \n",\
"	    puts $datei \"options.segmentsperedge  ${options.segmentsperedge}\" \n",\
"	    puts $datei \"options.meshsizefilename  ${options.meshsizefilename}\" \n",\
"	    puts $datei \"options.badellimit  ${options.badellimit}\" \n",\
"	    puts $datei \"options.optsteps2d  ${options.optsteps2d}\" \n",\
"	    puts $datei \"options.optsteps3d  ${options.optsteps3d}\" \n",\
"	    puts $datei \"options.opterrpow  ${options.opterrpow}\" \n",\
"	    puts $datei \"options.grading  ${options.grading}\" \n",\
"	    puts $datei \"options.printmsg  ${options.printmsg}\" \n",\
"	    puts $datei \"geooptions.drawcsg  ${geooptions.drawcsg}\" \n",\
"	    puts $datei \"geooptions.detail  ${geooptions.detail}\" \n",\
"	    puts $datei \"geooptions.accuracy  ${geooptions.accuracy}\" \n",\
"	    puts $datei \"geooptions.facets  ${geooptions.facets}\" \n",\
"	    puts $datei \"geooptions.minx  ${geooptions.minx}\" \n",\
"	    puts $datei \"geooptions.miny  ${geooptions.miny}\" \n",\
"	    puts $datei \"geooptions.minz  ${geooptions.minz}\" \n",\
"	    puts $datei \"geooptions.maxx  ${geooptions.maxx}\" \n",\
"	    puts $datei \"geooptions.maxy  ${geooptions.maxy}\" \n",\
"	    puts $datei \"geooptions.maxz  ${geooptions.maxz}\" \n",\
"	    puts $datei \"viewoptions.specpointvlen  ${viewoptions.specpointvlen}\" \n",\
"	    puts $datei \"viewoptions.light.amb  ${viewoptions.light.amb}\" \n",\
"	    puts $datei \"viewoptions.light.diff ${viewoptions.light.diff}\"\n",\
"	    puts $datei \"viewoptions.light.spec ${viewoptions.light.spec}\"\n",\
"	    puts $datei \"viewoptions.light.locviewer ${viewoptions.light.locviewer}\"\n",\
"	    puts $datei \"viewoptions.mat.shininess  ${viewoptions.mat.shininess}\" \n",\
"	    puts $datei \"viewoptions.mat.transp  ${viewoptions.mat.transp}\" \n",\
"	    puts $datei \"viewoptions.colormeshsize ${viewoptions.colormeshsize}\"\n",\
"	    puts $datei \"viewoptions.whitebackground  ${viewoptions.whitebackground}\" \n",\
"	    puts $datei \"viewoptions.drawcolorbar  ${viewoptions.drawcolorbar}\" \n",\
"	    puts $datei \"viewoptions.drawcoordinatecross  ${viewoptions.drawcoordinatecross}\" \n",\
"	    puts $datei \"viewoptions.drawnetgenlogo  ${viewoptions.drawnetgenlogo}\" \n",\
"	    puts $datei \"viewoptions.stereo  ${viewoptions.stereo}\" \n",\
"	    puts $datei \"viewoptions.drawfilledtrigs  ${viewoptions.drawfilledtrigs}\" \n",\
"	    puts $datei \"viewoptions.drawedges  ${viewoptions.drawedges}\" \n",\
"	    puts $datei \"viewoptions.drawbadels  ${viewoptions.drawbadels}\" \n",\
"	    puts $datei \"viewoptions.centerpoint  ${viewoptions.centerpoint}\" \n",\
"	    puts $datei \"viewoptions.drawelement  ${viewoptions.drawelement}\" \n",\
"	    puts $datei \"viewoptions.drawoutline  ${viewoptions.drawoutline}\" \n",\
"	    puts $datei \"viewoptions.drawtets  ${viewoptions.drawtets}\"\n",\
"	    puts $datei \"viewoptions.drawprisms  ${viewoptions.drawprisms}\"\n",\
"	    puts $datei \"viewoptions.drawpyramids  ${viewoptions.drawpyramids}\" \n",\
"	    puts $datei \"viewoptions.drawhexes  ${viewoptions.drawhexes}\" \n",\
"	    puts $datei \"viewoptions.drawidentified  ${viewoptions.drawidentified}\" \n",\
"	    puts $datei \"viewoptions.drawpointnumbers  ${viewoptions.drawpointnumbers}\" \n",\
"	    \n",\
"	    puts $datei \"viewoptions.drawededges  ${viewoptions.drawededges}\" \n",\
"	    puts $datei \"viewoptions.drawedpoints  ${viewoptions.drawedpoints}\" \n",\
"	    puts $datei \"viewoptions.drawedpointnrs  ${viewoptions.drawedpointnrs}\" \n",\
"	    puts $datei \"viewoptions.drawedtangents  ${viewoptions.drawedtangents}\" \n",\
"	    puts $datei \"viewoptions.shrink  ${viewoptions.shrink}\" \n",\
"	    \n",\
"	    puts $datei \"stloptions.showtrias  ${stloptions.showtrias}\" \n",\
"	    puts $datei \"stloptions.showfilledtrias  ${stloptions.showfilledtrias}\" \n",\
"	    puts $datei \"stloptions.showedges  ${stloptions.showedges}\" \n",\
"	    puts $datei \"stloptions.showmarktrias  ${stloptions.showmarktrias}\" \n",\
"	    puts $datei \"stloptions.showactivechart  ${stloptions.showactivechart}\" \n",\
"	    puts $datei \"stloptions.yangle  ${stloptions.yangle}\" \n",\
"	    puts $datei \"stloptions.contyangle  ${stloptions.contyangle}\" \n",\
"	    puts $datei \"stloptions.edgecornerangle  ${stloptions.edgecornerangle}\" \n",\
"	    puts $datei \"stloptions.chartangle  ${stloptions.chartangle}\" \n",\
"	    puts $datei \"stloptions.outerchartangle  ${stloptions.outerchartangle}\" \n",\
"	    puts $datei \"stloptions.usesearchtree  ${stloptions.usesearchtree}\" \n",\
"	    puts $datei \"stloptions.chartnumber  ${stloptions.chartnumber}\" \n",\
"	    puts $datei \"stloptions.charttrignumber  ${stloptions.charttrignumber}\" \n",\
"	    puts $datei \"stloptions.chartnumberoffset  ${stloptions.chartnumberoffset}\" \n",\
"	    puts $datei \"stloptions.atlasminh  ${stloptions.atlasminh}\" \n",\
"	    puts $datei \"stloptions.resthsurfcurvfac  ${stloptions.resthsurfcurvfac}\" \n",\
"	    puts $datei \"stloptions.resthsurfcurvenable  ${stloptions.resthsurfcurvenable}\" \n",\
"	    puts $datei \"stloptions.resthatlasfac  ${stloptions.resthatlasfac}\" \n",\
"	    puts $datei \"stloptions.resthatlasenable  ${stloptions.resthatlasenable}\" \n",\
"	    puts $datei \"stloptions.resthchartdistfac  ${stloptions.resthchartdistfac}\" \n",\
"	    puts $datei \"stloptions.resthchartdistenable  ${stloptions.resthchartdistenable}\" \n",\
"	    puts $datei \"stloptions.resthlinelengthfac  ${stloptions.resthlinelengthfac}\" \n",\
"	    puts $datei \"stloptions.resthlinelengthenable  ${stloptions.resthlinelengthenable}\" \n",\
"	    puts $datei \"stloptions.resthcloseedgefac  ${stloptions.resthcloseedgefac}\" \n",\
"	    puts $datei \"stloptions.resthcloseedgeenable  ${stloptions.resthcloseedgeenable}\" \n",\
"	    puts $datei \"stloptions.resthedgeanglefac  ${stloptions.resthedgeanglefac}\" \n",\
"	    puts $datei \"stloptions.resthedgeangleenable  ${stloptions.resthedgeangleenable}\" \n",\
"	    puts $datei \"stloptions.resthsurfmeshcurvfac  ${stloptions.resthsurfmeshcurvfac}\" \n",\
"	    puts $datei \"stloptions.resthsurfmeshcurvenable  ${stloptions.resthsurfmeshcurvenable}\" \n",\
"	    puts $datei \"stloptions.recalchopt  ${stloptions.recalchopt}\" \n",\
"	    \n",\
"	    puts $datei \"visoptions.subdivisions ${visoptions.subdivisions}\"\n",\
"\n",\
"\n",\
"	    # trafo options   \n",\
"	    # if exist trafooptions then ...\n",\
"	    if { [info exists trafooptions.solver] == 1 } {\n",\
"		puts $datei \"trafooptions.solver ${trafooptions.solver}\" \n",\
"		puts $datei \"trafooptions.levels ${trafooptions.levels}\" \n",\
"		puts $datei \"trafooptions.linits ${trafooptions.linits}\" \n",\
"		puts $datei \"trafooptions.nonlinits ${trafooptions.nonlinits}\" \n",\
"		puts $datei \"trafooptions.stabcurrent ${trafooptions.stabcurrent}\" \n",\
"		puts $datei \"trafooptions.checkcond ${trafooptions.checkcond}\" \n",\
"		puts $datei \"trafooptions.maxdirect ${trafooptions.maxdirect}\" \n",\
"		puts $datei \"trafooptions.secondorder ${trafooptions.secondorder}\" \n",\
"		puts $datei \"trafooptions.homogenizedcore ${trafooptions.homogenizedcore}\" \n",\
"		puts $datei \"trafooptions.ordercore ${trafooptions.ordercore}\" \n",\
"		puts $datei \"trafooptions.simplecurrents ${trafooptions.simplecurrents}\" \n",\
"		puts $datei \"trafooptions.assemblecomplexmatrix ${trafooptions.assemblecomplexmatrix}\" \n",\
"\n",\
"		puts $datei \"trafooptions.meshcasing  ${trafooptions.meshcasing}\" \n",\
"		puts $datei \"trafooptions.meshcore    ${trafooptions.meshcore}\" \n",\
"		puts $datei \"trafooptions.meshclumps  ${trafooptions.meshclumps}\" \n",\
"		puts $datei \"trafooptions.meshshields ${trafooptions.meshshields}\" \n",\
"		puts $datei \"trafooptions.meshcoils   ${trafooptions.meshcoils}\" \n",\
"		puts $datei \"trafooptions.bcmdirectory  ${trafooptions.bcmdirectory}\" \n",\
"		puts $datei \"trafooptions.lossdensityfile  ${trafooptions.lossdensityfile}\" \n",\
"	    }\n",\
"	    \n",\
"	    \n",\
"	    close $datei\n",\
"	}\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"# the ini file is save on demand :\n",\
"proc saveinifile { } {\n",\
"    uplevel 1  {\n",\
"	set datei [open ng.ini w]\n",\
"	for { set i [.ngmenu.file.recent index last] } { $i >= 1 } { incr i -1 } {\n",\
"	    puts $datei \"recentfile \\\"[.ngmenu.file.recent entrycget $i -label]\\\"\"\n",\
"	}\n",\
"	\n",\
"	close $datei\n",\
"    }\n",\
"}\n",\
"\n",\
"proc loadinifile { } {\n",\
"    if { [file exists ng.ini] == 1 } {\n",\
"	set datei [open ng.ini r]\n",\
"	while { [gets $datei line] >= 0 } {\n",\
"	    if {[lindex $line 0] == \"recentfile\"} {\n",\
"		set filename [lindex $line 1]\n",\
"		AddRecentFile $filename\n",\
"	    }\n",\
"	}\n",\
"	close $datei\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"proc setgranularity { gran } {\n",\
"#\n",\
"#    puts \"set granularity $gran\"\n",\
"#\n",\
"    set gran [expr $gran - 1]\n",\
"#\n",\
"    global options.curvaturesafety\n",\
"    set surfcurvlist { 1 1.5 2 3 5 }\n",\
"    set options.curvaturesafety [lindex $surfcurvlist $gran]\n",\
"\n",\
"    global options.segmentsperedge\n",\
"    set spelist { 0.3 0.5 1 2 3 }\n",\
"    set options.segmentsperedge [lindex $spelist $gran]\n",\
"    \n",\
"    global stloptions.resthsurfcurvfac\n",\
"    set surfcurvfaclist { 0.25 0.5 1 1.5 3 }\n",\
"    set stloptions.resthsurfcurvfac [lindex $surfcurvfaclist $gran]\n",\
"\n",\
"    global stloptions.resthchartdistfac\n",\
"    set chartdistfaclist { 0.8 1 1.5 2 5 }\n",\
"    set stloptions.resthchartdistfac [lindex $chartdistfaclist $gran]\n",\
"\n",\
"    global stloptions.resthlinelengthfac\n",\
"    set linelengthfaclist { 0.2 0.35 0.5 1.5 3 }\n",\
"    set stloptions.resthlinelengthfac [lindex $linelengthfaclist $gran]\n",\
"\n",\
"    global stloptions.resthcloseedgefac\n",\
"    set closeedgefaclist { 0.5 1 2 3.5 5 }\n",\
"    set stloptions.resthcloseedgefac [lindex $closeedgefaclist $gran]\n",\
"\n",\
"    global stloptions.resthedgeanglefac\n",\
"    set edgeanglefaclist { 0.25 0.5 1 1.5 3 }\n",\
"    set stloptions.resthedgeanglefac [lindex $edgeanglefaclist $gran]\n",\
"\n",\
"\n",\
"    global stloptions.resthsurfmeshcurvfac \n",\
"    set surfmeshcurvlist { 1 1.5 2 3 5 }\n",\
"    set stloptions.resthsurfmeshcurvfac [lindex $surfmeshcurvlist $gran]\n",\
"\n",\
"\n",\
"    global options.grading\n",\
"    set gradinglist { 0.7 0.5 0.3 0.2 0.1 }\n",\
"    set options.grading [lindex $gradinglist $gran]\n",\
"    \n",\
"}\n",\
"\n",\
"catch { \n",\
"\n",\
"# netgen menus:\n",\
"\n",\
"menu .ngmenu -tearoff 0  -relief raised -bd 2\n",\
". configure -menu .ngmenu\n",\
"\n",\
".ngmenu add cascade -label \"File\" -menu .ngmenu.file -underline 0\n",\
".ngmenu add cascade -label \"Geometry\" -menu .ngmenu.geometry -underline 0\n",\
".ngmenu add cascade -label \"Mesh\" -menu .ngmenu.mesh -underline 0\n",\
".ngmenu add cascade -label \"View\" -menu .ngmenu.view -underline 0\n",\
".ngmenu add cascade -label \"Refinement\" -menu .ngmenu.meshsize -underline 5\n",\
"\n",\
"if { $userlevel == 3} {\n",\
"    .ngmenu add cascade -label \"Special\" -menu .ngmenu.special -underline 3\n",\
"}\n",\
"\n",\
".ngmenu add cascade -label \"Help\" -menu .ngmenu.help -underline 0\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Menu File                                     #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"\n",\
"menu .ngmenu.file\n",\
"\n",\
".ngmenu.file add command -label \"Load Geometry\" -accelerator \"<l><g>\" \\\n",\
"    -command { \n",\
"	set types {\n",\
"	    {\"All Geometry types\"  {.stl .stlb .step .stp .geo .in2d .igs .iges} }\n",\
"	    {\"IGES Geometry\"	{.igs .iges} }\n",\
"	    {\"STL Geometry\"        {.stl} }\n",\
"	    {\"Binary STL Geometry\"    {.stlb} }\n",\
"	    {\"STEP Geometry\"    {.step .stp} }\n",\
"	    {\"Geometry file\"       {.geo} }\n",\
"	    {\"2D Geometry\"   {.in2d } } \n",\
"	} \n",\
"#		{\"Naomi Geometry\"      {.nao} }\n",\
"#		{\"New Geometry file\"   {.ngg} } \n",\
"\n",\
"\n",\
"	set file [tk_getOpenFile -filetypes $types]\n",\
"	if {$file != \"\"} {\n",\
"	    AddRecentFile $file\n",\
"	    Ng_LoadGeometry $file \n",\
"	    Ng_ParseGeometry\n",\
"#	    if { [Ng_STLInfo status]==\"ERROR\" } {\n",\
"#		tk_messageBox -message  \"STL ERROR: \\n [Ng_STLInfo statustext]\" -type ok\n",\
"#	    }\n",\
"	    set selectvisual geometry\n",\
"	    Ng_SetVisParameters\n",\
"	    redraw\n",\
"	    wm title . [concat \"$progname - \" $file]\n",\
"	    set dirname [file dirname $file]\n",\
"	    set basefilename [file tail [file rootname $file]]\n",\
"\n",\
"	    rebuildoccdialog\n",\
"	}\n",\
"    }\n",\
"\n",\
"\n",\
"\n",\
".ngmenu.file add command -label \"Save Geometry\" \\\n",\
"    -command { \n",\
"	set occgeometryloaded [Ng_OCCCommand isoccgeometryloaded]\n",\
"	puts $occgeometryloaded\n",\
"	if {$occgeometryloaded == 1 } {\n",\
"	    set types {\n",\
"		{\"IGES Geometry file\"   {.igs} } \n",\
"		{\"STEP Geometry file\"   {.stp} } \n",\
"		{\"STL Geometry file\"   {.stl} } \n",\
"		{\"STL BIN Geometry file\"   {.stlb} } \n",\
"	    }\n",\
"	} {\n",\
"	    set types {\n",\
"		{\"STL Geometry file\"   {.stl} } \n",\
"		{\"STL BIN Geometry file\"   {.stlb} } \n",\
"	    }\n",\
"	}\n",\
"#	set file [tk_getSaveFile -filetypes $types -defaultextension \".stl\" -initialdir $dirname -initialfile $basefilename ]\n",\
"	set file [tk_getSaveFile -filetypes $types -initialdir $dirname -initialfile $basefilename ]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_SaveGeometry $file \n",\
"	}\n",\
"    }\n",\
" \n",\
"\n",\
"\n",\
".ngmenu.file add cascade -label \"Recent Files\" -menu .ngmenu.file.recent \n",\
"menu .ngmenu.file.recent\n",\
"\n",\
"\n",\
"proc AddRecentFile { filename } {\n",\
"    global progname\n",\
"    global dirname\n",\
"    catch { [.ngmenu.file.recent delete $filename] }\n",\
"    .ngmenu.file.recent insert 0 command -label $filename \\\n",\
"	-command \"AddRecentFile {$filename}; \n",\
"                  Ng_LoadGeometry {$filename}; \n",\
"		  Ng_ParseGeometry;\n",\
"		  set selectvisual geometry;\n",\
"		  Ng_SetVisParameters;\n",\
"	          redraw;\n",\
"		  wm title . [concat \\\" $progname - $filename \\\"];\n",\
"                  set dirname {[file dirname $filename]};\n",\
"                  set basefilename {[file tail [file rootname $filename]]};\n",\
"                  rebuildoccdialog;\"\n",\
"    \n",\
"    if { [.ngmenu.file.recent index last] >= 6 } {\n",\
"	.ngmenu.file.recent delete last }\n",\
"    \n",\
"    saveinifile;\n",\
"    }\n",\
"loadinifile;\n",\
"\n",\
"\n",\
".ngmenu.file add separator\n",\
"\n",\
"\n",\
".ngmenu.file add command -label \"Load Mesh\" -accelerator \"<l><m>\" \\\n",\
"    -command {\n",\
"	set types {\n",\
"	    {\"Mesh file\"   {.vol}	} }\n",\
"	set file [tk_getOpenFile -filetypes $types -defaultextension \".vol\"]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_LoadMesh $file; \n",\
"	    set selectvisual mesh\n",\
"	    Ng_SetVisParameters\n",\
"	    redraw\n",\
"	    Ng_ReadStatus; \n",\
"#	    Ng_MeshSizeFromSurfaceMesh \n",\
"	    set dirname {[file dirname $file]}\n",\
"	    set basefilename {[file tail [file rootname $file]]}\n",\
"	}\n",\
"    }\n",\
"\n",\
"\n",\
"\n",\
".ngmenu.file add command -label \"Save Mesh\" -accelerator \"<s><m>\" \\\n",\
"    -command {\n",\
"	set types {\n",\
"	    {\"Mesh file\"   {.vol}	} }\n",\
"\n",\
"	set file [tk_getSaveFile -filetypes $types -defaultextension \".vol\" -initialfile $basefilename -initialdir $dirname ]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_SaveMesh $file }\n",\
"    }\n",\
"\n",\
".ngmenu.file add command -label \"Merge Mesh\" \\\n",\
"    -command {\n",\
"	set types {\n",\
"	    {\"Mesh file\"   {.vol}	} }\n",\
"	set file [tk_getOpenFile -filetypes $types -defaultextension \".vol\"]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_MergeMesh $file; \n",\
"	    set selectvisual mesh\n",\
"	    Ng_SetVisParameters\n",\
"	    redraw\n",\
"	    Ng_ReadStatus; \n",\
"	}\n",\
"    }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
".ngmenu.file add command -label \"Import Mesh\" \\\n",\
"    -command { \n",\
"	set types {\n",\
"	    {\"Neutral format\"  {.mesh .emt} }\n",\
"	    {\"Surface mesh format\"  {.surf} }\n",\
"	    {\"Universal format\"  {.unv} }\n",\
"	    {\"Olaf format\"  {.emt} }\n",\
"	          }\n",\
"	set file [tk_getOpenFile -filetypes $types ]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_ImportMesh $file \n",\
"	    set selectvisual mesh\n",\
"	    Ng_SetVisParameters\n",\
"	    redraw\n",\
"	    Ng_ReadStatus; \n",\
"	}\n",\
"    }\n",\
"\n",\
".ngmenu.file add command -label \"Export Mesh\" \\\n",\
"    -command {\n",\
"	if { $exportfiletype == \"Elmer Format\" } {\n",\
"	    set file [tk_chooseDirectory]\n",\
"        } else {\n",\
"	    set file [tk_getSaveFile]\n",\
"	}\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_ExportMesh $file $exportfiletype \n",\
"	}\n",\
"    }\n",\
"\n",\
".ngmenu.file add cascade -label \"Export Filetype\" -menu .ngmenu.file.filetype \n",\
"\n",\
"menu .ngmenu.file.filetype \n",\
"# .ngmenu.file.filetype add radio -label \"Neutral Format\" \\\n",\
"#    -variable exportfiletype -value neutral\n",\
"# if { $userlevel == 3} {\n",\
"# .ngmenu.file.filetype add radio -label \"Fepp Format\" \\\n",\
"#    -variable exportfiletype -value fepp\n",\
"# }\n",\
"# .ngmenu.file.filetype add radio -label \"Fepp Format 2D\" \\\n",\
"#    -variable exportfiletype -value fepp2d\n",\
"#\n",\
"# .ngmenu.file.filetype add radio -label \"Surface mesh\" \\\n",\
"#    -variable exportfiletype -value surface\n",\
"# .ngmenu.file.filetype add radio -label \"Abaqus Format\" \\\n",\
"#    -variable exportfiletype -value Abaqus\n",\
"# .ngmenu.file.filetype add radio -label \"PERMAS Format\" \\\n",\
"#    -variable exportfiletype -value PERMAS\n",\
"# .ngmenu.file.filetype add radio -label \"Feap Format\" \\\n",\
"#    -variable exportfiletype -value Feap\n",\
"\n",\
"# .ngmenu.file.filetype add radio -label \"DIFFPACK format\" \\\n",\
"#    -variable exportfiletype -value DIFFPACK\n",\
"# .ngmenu.file.filetype add radio -label \"DIFFPACK 2D format\" \\\n",\
"#    -variable exportfiletype -value DIFFPACK2\n",\
"# .ngmenu.file.filetype add radio -label \"Tochnog format\" \\\n",\
"#    -variable exportfiletype -value TOCHNOG\n",\
"\n",\
"# .ngmenu.file.filetype add radio -label \"STL Format\" \\\n",\
"#    -variable exportfiletype -value STL\n",\
"# .ngmenu.file.filetype add radio -label \"VRML Format\" \\\n",\
"#    -variable exportfiletype -value VRML\n",\
"# .ngmenu.file.filetype add radio -label \"Chemnitz Format\" \\\n",\
"#    -variable exportfiletype -value Chemnitz\n",\
"\n",\
"\n",\
"# .ngmenu.file.filetype invoke 1\n",\
"\n",\
"\n",\
"\n",\
".ngmenu.file add separator\n",\
"\n",\
"\n",\
".ngmenu.file add command -label \"Save Solution\" \\\n",\
"    -command { \n",\
"	set types { {\"Solution File\"  {.sol} } }\n",\
"	set file [tk_getSaveFile -filetypes $types -defaultextension \".sol\"  ]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_SaveSolution $file \n",\
"	}\n",\
"    }\n",\
"\n",\
".ngmenu.file add command -label \"Import Solution\" \\\n",\
"    -command { \n",\
"	set types { {\"Solution File\"  {.sol} } }\n",\
"	set file [tk_getOpenFile -filetypes $types -defaultextension \".sol\"  ]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_ImportSolution $file \n",\
"	    set selectvisual solution\n",\
"	    Ng_SetVisParameters\n",\
"	    redraw\n",\
"	}\n",\
"    }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"set demostarttime [clock clicks -millisecond]\n",\
"set stopdemo 0\n",\
"proc demoredraw { } {\n",\
"    global demostarttime\n",\
"    global stopdemo\n",\
"    set curtime [clock clicks -millisecond]\n",\
"    set result [ Ng_DemoSetTime [expr $curtime - $demostarttime] ]\n",\
"    redraw\n",\
"    if { $result == 0 && $stopdemo == 0 } {\n",\
"	after 1 { demoredraw }\n",\
"    }\n",\
"}\n",\
".ngmenu.file add command -label \"Show Demo\" \\\n",\
"    -command {\n",\
"	set types { {\"Demo File\"  {.dem} } }\n",\
"	set file [tk_getOpenFile -filetypes $types -defaultextension \".dem\"  ]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_ShowDemo $file \n",\
"	    set demostarttime [clock clicks -millisecond]\n",\
"	    set stopdemo 0\n",\
"	    demoredraw\n",\
"	}\n",\
"    }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
".ngmenu.file add separator\n",\
"\n",\
".ngmenu.file add command -label \"Snapshot\" \\\n",\
"    -command { \n",\
"	set types { \n",\
"	    {\"JPG file\" {.jpg} } \n",\
"	    {\"GIF file\" {.gif} } \n",\
"	    {\"PPM file\" {.ppm} } \n",\
"	}\n",\
"	set file [tk_getSaveFile -filetypes $types]\n",\
"#  -defaultextension \".ppm\"]\n",\
"	if {$file != \"\"} {\n",\
"	    .ndraw Ng_SnapShot $file }\n",\
"    }\n",\
"\n",\
"\n",\
".ngmenu.file add command -label \"Save Options\" \\\n",\
"    -command { saveoptions }\n",\
"\n",\
"\n",\
"    \n",\
"\n",\
".ngmenu.file add separator\n",\
"\n",\
".ngmenu.file add command -label \"Quit\" -accelerator \"<q>\" \\\n",\
"    -command { puts \"Thank you for using $progname\"; Ng_Exit; exit }\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Menu Mesh                                     #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"\n",\
"menu .ngmenu.mesh\n",\
".ngmenu.mesh add command -label \"Generate Mesh\" -accelerator \"<g><m>\" \\\n",\
"    -command { \n",\
"	Ng_GenerateMesh ${meshoptions.firststep} ${meshoptions.laststep}\n",\
"	Ng_ReadStatus\n",\
"	set selectvisual mesh\n",\
"	Ng_SetVisParameters\n",\
"	redraw\n",\
"    }\n",\
"\n",\
".ngmenu.mesh add command -label \"Stop Meshing\" \\\n",\
"    -command { Ng_StopMeshing }\n",\
"\n",\
".ngmenu.mesh add command -label \"Meshing Options\" \\\n",\
"    -command meshingoptionsdialog\n",\
"\n",\
".ngmenu.mesh add separator\n",\
"\n",\
".ngmenu.mesh add command -label \"Delete Mesh\" \\\n",\
"    -command { Ng_New mesh; Ng_ReadStatus; redraw }\n",\
"\n",\
".ngmenu.mesh add command -label \"Delete Vol Mesh\" \\\n",\
"    -command { Ng_DeleteVolMesh; Ng_ReadStatus; redraw }\n",\
"\n",\
"\n",\
".ngmenu.mesh add command -label \"Mesh Info\" \\\n",\
"    -command {\n",\
"	set dim [Ng_MeshInfo dim]\n",\
"	set np [Ng_MeshInfo np]\n",\
"	set ne [Ng_MeshInfo ne]\n",\
"	set nse [Ng_MeshInfo nse]\n",\
"	set nseg [Ng_MeshInfo nseg]\n",\
"	set bbox [Ng_MeshInfo bbox]\n",\
"	tk_messageBox -message  \"Dimension: $dim\\nPoints: $np\\nElements: $ne\\nSurface Els: $nse\\nSegments: $nseg\\nxmin [lindex $bbox 0] xmax [lindex $bbox 1]\\nymin [lindex $bbox 2] ymax [lindex $bbox 3]\\nzmin [lindex $bbox 4] zmax [lindex $bbox 5]\"\n",\
"    }\n",\
"\n",\
"\n",\
".ngmenu.mesh add command -label \"Mesh Quality\" \\\n",\
"    -command {\n",\
"	set inplanemin 0\n",\
"	set inplanemax 0\n",\
"	set betplanemin 0\n",\
"	set betplanemax 0\n",\
"	Ng_MeshQuality inplanemin inplanemax betplanemin betplanemax\n",\
"	puts \"Triangle angles : $inplanemin - $inplanemax\"\n",\
"	puts \"Tet angles      : $betplanemin - $betplanemax\"\n",\
"	tk_messageBox -message  \"Triangle angles : $inplanemin - $inplanemax \\n Tet angles      : $betplanemin - $betplanemax\"\n",\
"    }\n",\
"\n",\
"# .ngmenu.mesh add command -label \"Quality Plot\" \\\n",\
"#    -command { qualityviewdialog 1 }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
".ngmenu.mesh add command -label \"Check Surface Mesh\" \\\n",\
"    -command { Ng_CheckSurfaceMesh }\n",\
".ngmenu.mesh add command -label \"Check Volume Mesh\" \\\n",\
"    -command { Ng_CheckVolumeMesh }\n",\
"\n",\
".ngmenu.mesh add command -label \"Edit Boundary Conditions\" \\\n",\
"    -command { bcpropdialog }\n",\
"\n",\
"if { $userlevel == 3 } {\n",\
"    .ngmenu.mesh add command -label \"Mesh Doctor\" \\\n",\
"	-command { meshdoctordialog }\n",\
"}\n",\
"\n",\
".ngmenu.mesh add command -label \"METIS Mesh Partitioning\" \\\n",\
"	-command { METISdialog }\n",\
"\n",\
".ngmenu.mesh add separator\n",\
"\n",\
".ngmenu.mesh add command -label \"Analyze Geometry\" \\\n",\
"    -command { Ng_GenerateMesh ag ag; Ng_ReadStatus; redraw }\n",\
".ngmenu.mesh add command -label \"Mesh Edges\" \\\n",\
"    -command { Ng_GenerateMesh me me; Ng_ReadStatus; redraw }\n",\
".ngmenu.mesh add command -label \"Mesh Surface\" \\\n",\
"    -command { set selectvisual mesh; Ng_SetVisParameters; \\\n",\
"		   Ng_GenerateMesh ms ms; Ng_ReadStatus; redraw }\n",\
"\n",\
".ngmenu.mesh add command -label \"Optimize Surface\" \\\n",\
"    -command { Ng_GenerateMesh os os cmsmSm; redraw }\n",\
"\n",\
".ngmenu.mesh add cascade -label \"Surface Optim. Step\" -menu .ngmenu.mesh.surfoptstep \n",\
"\n",\
"menu .ngmenu.mesh.surfoptstep \n",\
".ngmenu.mesh.surfoptstep add command -label \"Mesh Smoothing\" \\\n",\
"    -command { Ng_GenerateMesh os os m; redraw}\n",\
".ngmenu.mesh.surfoptstep add command -label \"Edge swapping (topologic)\" \\\n",\
"    -command { Ng_GenerateMesh os os s; redraw}\n",\
".ngmenu.mesh.surfoptstep add command -label \"Edge swapping (metric)\" \\\n",\
"    -command { Ng_GenerateMesh os os S; redraw}\n",\
".ngmenu.mesh.surfoptstep add command -label \"Combine points\" \\\n",\
"    -command { Ng_GenerateMesh os os c; redraw}\n",\
"\n",\
"\n",\
".ngmenu.mesh add separator\n",\
".ngmenu.mesh add command -label \"Mesh Volume\" \\\n",\
"    -command { Ng_GenerateMesh mv mv; Ng_ReadStatus }\n",\
".ngmenu.mesh add command -label \"Optimize Volume\" \\\n",\
"    -command { Ng_GenerateMesh ov ov; Ng_ReadStatus }\n",\
".ngmenu.mesh add command -label \"Smooth Opt Volume\" \\\n",\
"    -command { Ng_GenerateMesh ov ov m; Ng_ReadStatus }\n",\
".ngmenu.mesh add command -label \"Smooth Opt Volume Jacobian\" \\\n",\
"    -command { Ng_GenerateMesh ov ov j; Ng_ReadStatus }\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Menu Geometry                                 #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"\n",\
"menu .ngmenu.geometry\n",\
".ngmenu.geometry add command -label \"Scan CSG Geometry\" -command { Ng_ParseGeometry }\n",\
".ngmenu.geometry add command -label \"CSG Options\" -command geometryoptionsdialog\n",\
"# only intern version !\n",\
"# .ngmenu.geometry add separator\n",\
"# .ngmenu.geometry add command -label \"New Primitive\"  \\\n",\
"#     -command newprimitivedialog -accelerator \"<n><p>\"\n",\
"# .ngmenu.geometry add command -label \"Edit Primitive\" \\\n",\
"#     -command editprimitivedialog -accelerator \"<e><p>\"\n",\
"# .ngmenu.geometry add command -label \"Edit Solid\" \\\n",\
"#     -command newsoliddialog -accelerator \"<e><s>\"\n",\
"# .ngmenu.geometry add command -label \"Choose Top Level \" \\\n",\
"#     -command topleveldialog \n",\
"# .ngmenu.geometry add command -label \"Identify\" \\\n",\
"#     -command identifydialog \n",\
".ngmenu.geometry add command -label \"CSG Properties\" \\\n",\
"    -command topleveldialog2 \n",\
"\n",\
".ngmenu.geometry add separator\n",\
"\n",\
".ngmenu.geometry add command -label \"STL Doctor\" \\\n",\
"    -command { stldoctordialog; }\n",\
"\n",\
".ngmenu.geometry add command -label \"STL Info\" \\\n",\
"    -command {\n",\
"	set notriangles 0\n",\
"	set minx 0\n",\
"	set maxx 0\n",\
"	set miny 0\n",\
"	set maxy 0\n",\
"	set minz 0\n",\
"	set maxz 0\n",\
"	set trigscons 0\n",\
"	Ng_STLInfo notriangles minx maxx miny maxy minz maxz trigscons\n",\
"	set msgtext \"NO STL-Triangles : $notriangles\\nGeometry:\\nX = $minx - $maxx\\nY = $miny - $maxy\\nZ = $minz - $maxz\\nConsistency Check = $trigscons\\n\"\n",\
"	set msgtext \"$msgtext Status: [Ng_STLInfo status]\"\n",\
"	tk_messageBox -title \"STL Info\" -message  $msgtext -type ok \n",\
"    }\n",\
"\n",\
".ngmenu.geometry add separator\n",\
"\n",\
".ngmenu.geometry add command -label \"IGES/STEP Topology Explorer/Doctor\" \\\n",\
"    -command { occdialog; }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Menu View                                     #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"\n",\
"menu .ngmenu.view\n",\
".ngmenu.view add command -label \"Zoom all\" \\\n",\
"    -command { Ng_ZoomAll; redraw }\n",\
".ngmenu.view add command -label \"Center\" \\\n",\
"    -command { Ng_Center; redraw }\n",\
"\n",\
".ngmenu.view add command -label \"x-y plane\" \\\n",\
"    -command { Ng_StandardRotation xy; redraw }\n",\
".ngmenu.view add command -label \"y-x plane\" \\\n",\
"    -command { Ng_StandardRotation yx; redraw }\n",\
".ngmenu.view add command -label \"x-z plane\" \\\n",\
"    -command { Ng_StandardRotation xz; redraw }\n",\
".ngmenu.view add command -label \"z-x plane\" \\\n",\
"    -command { Ng_StandardRotation zx; redraw }\n",\
".ngmenu.view add command -label \"y-z plane\" \\\n",\
"    -command { Ng_StandardRotation yz; redraw }\n",\
".ngmenu.view add command -label \"z-y plane\" \\\n",\
"    -command { Ng_StandardRotation zy; redraw }\n",\
"\n",\
".ngmenu.view add command -label \"Viewing Options\" \\\n",\
"    -command { viewingoptionsdialog; redraw }\n",\
".ngmenu.view add command -label \"Clipping Plane\" \\\n",\
"    -command { clippingdialog; redraw }\n",\
".ngmenu.view add command -label \"Solution Data\" \\\n",\
"    -command { visual_dialog; redraw }\n",\
".ngmenu.view add checkbutton -variable viewqualityplot \\\n",\
"    -label \"Quality Plot\" \\\n",\
"    -command { qualityviewdialog $viewqualityplot }\n",\
"\n",\
"# .ngmenu.view add radiobutton -label \"Cross\" -variable selectvisual -value cross -command { Ng_SetVisParameters; redraw }\n",\
"# .ngmenu.view add radiobutton -label \"Geometry\" -variable selectvisual -value geometry -command { Ng_SetVisParameters; redraw }\n",\
"# .ngmenu.view add radiobutton -label \"Mesh\" -variable selectvisual -value mesh -command { Ng_SetVisParameters; redraw }\n",\
"# .ngmenu.view add radiobutton -label \"Special Points\" -variable selectvisual -value specpoints -command { Ng_SetVisParameters; redraw }\n",\
"# .ngmenu.view add radiobutton -label \"Surface meshing\" -variable selectvisual -value surfmeshing -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Menu Refinement                               #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"#\n",\
"# Mesh size menu\n",\
"#\n",\
"menu .ngmenu.meshsize\n",\
".ngmenu.meshsize add command -label \"Refine uniform\" \\\n",\
"    -command { Ng_Refine; Ng_HighOrder ${options.elementorder}; Ng_ReadStatus; redraw }\n",\
"\n",\
".ngmenu.meshsize add command -label \"Second Order\" \\\n",\
"    -command { Ng_SecondOrder; Ng_ReadStatus; redraw }\n",\
"\n",\
".ngmenu.meshsize add command -label \"Validate Second Order\" \\\n",\
"    -command { Ng_ValidateSecondOrder; Ng_ReadStatus; redraw }\n",\
"\n",\
".ngmenu.meshsize add command -label \"High Order\" \\\n",\
"    -command { Ng_HighOrder ${options.elementorder}; Ng_ReadStatus; redraw }\n",\
"\n",\
".ngmenu.meshsize add separator\n",\
"\n",\
".ngmenu.meshsize add command -label \"Refinement Dialog\" \\\n",\
"    -command { refinementdialog }\n",\
".ngmenu.meshsize add command -label \"Load Meshsize\" \\\n",\
"    -command {\n",\
"	set types {\n",\
"	    {\"Meshsize file\"   {.msz}	} }\n",\
"	set file [tk_getOpenFile -filetypes $types]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_LoadMeshSize $file; \n",\
"	}\n",\
"    }\n",\
".ngmenu.meshsize add command -label \"MS from Surf Mesh\" \\\n",\
"    -command { Ng_MeshSizeFromSurfaceMesh }\n",\
"\n",\
"\n",\
"if { $userlevel == 3 } {\n",\
".ngmenu.meshsize add command -label \"Singular point ms\" \\\n",\
"    -command { Ng_SingularPointMS; }\n",\
"\n",\
".ngmenu.meshsize add command -label \"Singular edge ms\" \\\n",\
"    -command { Ng_SingularEdgeMS; }\n",\
"\n",\
".ngmenu.meshsize add separator\n",\
"\n",\
".ngmenu.meshsize add command -label \"Bisection\" \\\n",\
"    -command { Ng_ReadStatus; set oldnp 0; set newnp $status_np; \n",\
"#	Ng_BisectCopyMesh; \n",\
"#	Ng_Split2Tets;\n",\
"	Ng_ReadStatus;\n",\
"	\n",\
"	while { $oldnp < $newnp } {\n",\
"#	    if { $level == 0 } {\n",\
"#		Ng_ExportMesh feppmesh.vol fepp;\n",\
"#	    } {\n",\
"#		Ng_ExportMesh feppmesh$level feppml \n",\
"#	    }\n",\
"	    set level [expr $level+1]\n",\
"	    Ng_Bisect; \n",\
"	    Ng_HighOrder ${options.elementorder}\n",\
"#	    Ng_Split2Tets;\n",\
"	    Ng_ReadStatus;\n",\
"	    redraw; \n",\
"	    set oldnp $newnp\n",\
"	    set newnp $status_np\n",\
"	    puts \"oldnp $oldnp newnp $newnp\"\n",\
"	}\n",\
"    }\n",\
"#    -command { Ng_Bisect; Ng_ReadStatus; redraw }\n",\
"#    -command { exec netgen abc >outfile 2>errfile; Ng_ReadStatus; redraw }\n",\
"\n",\
"}\n",\
"\n",\
".ngmenu.meshsize add command -label \"Z-Refinement\" \\\n",\
"    -command { Ng_ZRefinement 2; Ng_ReadStatus; redraw }\n",\
"\n",\
"\n",\
"# .ngmenu.meshsize add command -label \"hp-Refinement\" \\\n",\
"\\#    -command { Ng_HPRefinement 4; Ng_ReadStatus; redraw }\n",\
"\n",\
".ngmenu.meshsize add cascade -label \"hp-Refinement\" -menu .ngmenu.meshsize.hpref\n",\
"menu .ngmenu.meshsize.hpref\n",\
".ngmenu.meshsize.hpref add command -label \"1 Level\" \\\n",\
"    -command { Ng_HPRefinement 1; Ng_ReadStatus; redraw }\n",\
".ngmenu.meshsize.hpref add command -label \"2 Levels\" \\\n",\
"    -command { Ng_HPRefinement 2; Ng_ReadStatus; redraw }\n",\
".ngmenu.meshsize.hpref add command -label \"3 Levels\" \\\n",\
"    -command { Ng_HPRefinement 3; Ng_ReadStatus; redraw }\n",\
".ngmenu.meshsize.hpref add command -label \"4 Levels\" \\\n",\
"    -command { Ng_HPRefinement 4; Ng_ReadStatus; redraw }\n",\
".ngmenu.meshsize.hpref add command -label \"6 Levels\" \\\n",\
"    -command { Ng_HPRefinement 6; Ng_ReadStatus; redraw }\n",\
".ngmenu.meshsize.hpref add command -label \"8 Levels\" \\\n",\
"    -command { Ng_HPRefinement 8; Ng_ReadStatus; redraw }\n",\
".ngmenu.meshsize.hpref add command -label \"10 Levels\" \\\n",\
"    -command { Ng_HPRefinement 10; Ng_ReadStatus; redraw }\n",\
"\n",\
"\n",\
".ngmenu.meshsize add command -label \"Split to Tets\" \\\n",\
"    -command { Ng_Split2Tets; Ng_ReadStatus; redraw }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Menu Special                                  #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"\n",\
"menu .ngmenu.special\n",\
".ngmenu.special add command -label \"Insert virtual boundary layer\" \\\n",\
"    -command { Ng_InsertVirtualBL; redraw }\n",\
".ngmenu.special add command -label \"Cut off and combine with other\" \\\n",\
"    -command { \n",\
"	set types { {\"Mesh file\"   {.vol}	} }\n",\
"	set file [tk_getOpenFile -filetypes $types]\n",\
"	if {$file != \"\"} {\n",\
"	    Ng_CutOffAndCombine $file;  }\n",\
"	redraw \n",\
"    }\n",\
".ngmenu.special add command -label \"Helmholtz Mesh grading\" \\\n",\
"    -command { Ng_HelmholtzMesh; }\n",\
"\n",\
"\n",\
"\n",\
"# menu .mbar.stl.menu\n",\
"# .mbar.stl.menu add command -label \"STL options\" \\\n",\
"#     -command { stloptionsdialog; }\n",\
"#.mbar.stl.menu add command -label \"STL Doctor\" \\\n",\
"#    -command { stldoctordialog; }\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Menu Help                                     #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"\n",\
"\n",\
"menu .ngmenu.help\n",\
".ngmenu.help add command -label \"Ng Help\" \\\n",\
"	-command { help_main }\n",\
"# .ngmenu.view add checkbutton -variable showsensitivehelp \\\n",\
"#	-label \"Sensitve Help\" \\\n",\
"#	-command { sensitivehelpdialog $showsensitivehelp }\n",\
".ngmenu.view add checkbutton -label \"Help Line\" -variable showhelpline \\\n",\
"	-command {\n",\
"    if { $showhelpline == 1} {\n",\
"	pack .helpline -before .statbar -side bottom -fill x -padx 3p\n",\
"    } {\n",\
"	pack forget .helpline \n",\
"    }\n",\
"} \n",\
"\n",\
".ngmenu.help add command -label \"About\" \\\n",\
"    -command {\n",\
"tk_messageBox -message \"This is NETGEN \\n mainly written by \\n Joachim Schberl \\n thanks to \\n R. Gaisbauer, J. Gerstmayr\"\n",\
"}\n",\
"\n",\
"# tk_menuBar .mbar .mbar.file .mbar.mesh .mbar.test .mbar.help\n",\
"# focus .mbar\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Button bar                                    #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"\n",\
"frame .bubar -relief raised -bd 2\n",\
"pack .bubar -side top -fill x\n",\
"\n",\
"button .bubar.testb -text \"Test\" -command { Ng_SaveGeometry }\n",\
"button .bubar.surfm -text \"Generate Mesh\" -command \\\n",\
"    { set selectvisual mesh; \n",\
"	Ng_SetVisParameters;\n",\
"	Ng_GenerateMesh ${meshoptions.firststep} ${meshoptions.laststep}\n",\
"	redraw \n",\
"    }\n",\
"button .bubar.stopm -text \"Stop\" -command \\\n",\
"    { Ng_StopMeshing;  set stopdemo 1 }\n",\
"button .bubar.exitb -text \"Quit\" \\\n",\
"    -command { .ngmenu.file invoke \"Quit\" }\n",\
"pack  .bubar.exitb .bubar.surfm .bubar.stopm -side left\n",\
"\n",\
"#button .bubar.scan -text \"Scan\" \\\n",\
"#    -command { Ng_ParseGeometry; set selectvisual geometry; Ng_SetVisParameters; redraw }\n",\
"\n",\
"\n",\
"button .bubar.zoomall -text \"Zoom All\" \\\n",\
"    -command { Ng_ZoomAll; redraw }\n",\
"\n",\
"button .bubar.center -text \"Center\" \\\n",\
"    -command { Ng_Center; redraw }\n",\
"\n",\
"# tk_optionMenu .bubar.modesel drawmode \"rotate\" \"move  \" \"zoom  \"\n",\
"tixOptionMenu .bubar.modesel \\\n",\
"    -options {\n",\
"	label.width  0\n",\
"	label.anchor e\n",\
"	menubutton.width 6\n",\
"    } \\\n",\
"    -variable drawmode\n",\
"\n",\
".bubar.modesel add command rotate -label Rotate\n",\
".bubar.modesel add command move -label Move\n",\
".bubar.modesel add command zoom -label Zoom\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"set viewvals { geometry specpoints mesh solution}\n",\
"if { $userlevel >= 3} {\n",\
"    set viewvals { geometry mesh specpoints surfmeshing modelview solution}\n",\
"}\n",\
"\n",\
"set viewvallabs(cross)     \"Cross\" \n",\
"set viewvallabs(geometry)  \"Geometry\" \n",\
"set viewvallabs(mesh)      \"Mesh\" \n",\
"set viewvallabs(specpoints) \"Edges\" \n",\
"set viewvallabs(surfmeshing) \"Mesh Gen\" \n",\
"set viewvallabs(modelview)     \"Modeller\" \n",\
"set viewvallabs(solution)     \"Solution\" \n",\
"\n",\
"tixOptionMenu .bubar.selview \\\n",\
"    -options {\n",\
"	label.width  0\n",\
"	label.anchor e\n",\
"	menubutton.width 10\n",\
"    } \\\n",\
"\n",\
"foreach viewv $viewvals {\n",\
"    .bubar.selview add command $viewv -label $viewvallabs($viewv)\n",\
"}\n",\
"\n",\
"\n",\
".bubar.selview config -variable selectvisual\n",\
".bubar.selview config -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"\n",\
"# pack .bubar.modesel -side right\n",\
"pack .bubar.center .bubar.zoomall .bubar.selview -side right\n",\
"\n",\
"\n",\
"\n",\
"#####################################################\n",\
"#                                                   #\n",\
"#     Status bar                                    #\n",\
"#                                                   #\n",\
"#####################################################\n",\
"\n",\
"label .helpline -text \"None\"\n",\
"pack forget .helpline -side bottom -fill x\n",\
"\n",\
"frame .statbar -relief flat -bd 2\n",\
"pack .statbar -side bottom -fill x\n",\
"\n",\
"label .statbar.ptslabel -text \"Points: \"\n",\
"label .statbar.ptsval -textvariable status_np\n",\
"label .statbar.elslabel -text \"   Elements: \"\n",\
"label .statbar.elsval -textvariable status_ne\n",\
"label .statbar.selslabel -text \"   Surf Elements: \"\n",\
"label .statbar.selsval -textvariable status_nse\n",\
"label .statbar.memlabel -text \"   Mem: \"\n",\
"label .statbar.memval -textvariable mem_moveable\n",\
"label .statbar.task -textvariable status_task\n",\
"\n",\
"pack .statbar.ptslabel .statbar.ptsval -side left -ipady 3p \n",\
"pack .statbar.elslabel .statbar.elsval -side left -ipady 3p \n",\
"pack .statbar.selslabel .statbar.selsval -side left -ipady 3p\n",\
"\n",\
"if { $userlevel >= 3 } {\n",\
"    pack .statbar.memlabel .statbar.memval -side left -ipady 3p\n",\
"}\n",\
"\n",\
"\n",\
"tixMeter .statbar.per -value 0 -text 0%\n",\
".statbar.per configure -fillcolor blue\n",\
"\n",\
"pack .statbar.per -side right\n",\
"pack .statbar.task -side right -ipady 4\n",\
"\n",\
"\n",\
"proc timer2 { } {\n",\
"    global status_np\n",\
"    global status_ne\n",\
"    global status_nse\n",\
"    global multithread_running\n",\
"    global multithread_redraw\n",\
"    global status_working\n",\
"    global status_task\n",\
"    global status_percent\n",\
"    global status_tetqualclasses\n",\
"    \n",\
"\n",\
"    Ng_ReadStatus \n",\
"\n",\
"    if { $multithread_redraw == 1 } {\n",\
"	set multithread_redraw 0;\n",\
"	redraw;\n",\
"    }\n",\
"\n",\
"    global mem_moveable\n",\
"    set mem_moveable [Ng_MemInfo moveable]\n",\
"\n",\
"\n",\
"    .statbar.per config -value [expr $status_percent/100] -text [expr 0.1*int(10*$status_percent)]%\n",\
"\n",\
"\n",\
"    if { $multithread_running } {\n",\
"	pack .statbar.per -side right -before .statbar.task -padx 6\n",\
"    } { \n",\
"	pack forget .statbar.per\n",\
"    }\n",\
"	\n",\
"\n",\
"    \n",\
"    # tet quality\n",\
"    if {[winfo exists .qualityview_dlg] == 1} {\n",\
"	\n",\
"	global qualbar\n",\
"	global qualbarnull\n",\
"	global qualbaraxis\n",\
"\n",\
"	set maxval 0\n",\
"	for {set i 0} {$i < 20} {incr i} {\n",\
"	    if {[lindex $status_tetqualclasses $i] > $maxval} {\n",\
"		set maxval [lindex $status_tetqualclasses $i]\n",\
"	    }\n",\
"	} \n",\
"\n",\
"	set ubound 1\n",\
"	while { $ubound < $maxval } {\n",\
"	    set ubound [expr {10 * $ubound}]\n",\
"	}\n",\
"	if { $ubound/5 > $maxval } {\n",\
"	    set ubound [expr $ubound/5]\n",\
"	}\n",\
"	if { $ubound/2 > $maxval } {\n",\
"	    set ubound [expr $ubound/2]\n",\
"	}\n",\
"\n",\
"\n",\
"	\n",\
"	for {set i 1} {$i <= 5} {incr i} {\n",\
"	    global qualbaraxis($i)\n",\
"\n",\
"	    set value [expr { $i * $ubound / 5 }]\n",\
"	    .qualityview_dlg.c dchars $qualbaraxis($i) 0 end\n",\
"	    .qualityview_dlg.c insert $qualbaraxis($i) end $value  \n",\
"	}\n",\
"\n",\
"	\n",\
"	for {set i 0} {$i < 20} {incr i} {\n",\
"	    set x1 [expr {100 + ($i*15) + 2}]\n",\
"	    set x2 [expr {$x1+10}]\n",\
"	    \n",\
"	    set nbrs [lindex $status_tetqualclasses $i]\n",\
"	    set y [expr (249 - (200 * $nbrs / $ubound ) )]\n",\
"	    \n",\
"	    global qualbar($i)\n",\
"	    .qualityview_dlg.c coords $qualbar($i) $x1 250 $x2 $y\n",\
"\n",\
"	    global qualbarnull($i)\n",\
"	    if { $nbrs == 0 } {\n",\
"		.qualityview_dlg.c itemconfigure $qualbarnull($i) -text 0\n",\
"	    } {\n",\
"		.qualityview_dlg.c itemconfigure $qualbarnull($i) -text \"\" \n",\
"	    }		\n",\
"	}\n",\
"	\n",\
"    }\n",\
"\n",\
"    after 200 { timer2 }\n",\
"}\n",\
"# after 1000 { timer2 }\n",\
"timer2\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc bgerror { error } {\n",\
"    global errorInfo userlevel\n",\
"    if { $userlevel == 3} {\n",\
"	puts \"ERROR: $error\" \n",\
"	puts \"errinfo: $errorInfo\"\n",\
"    }\n",\
"    tk_messageBox -title \"Error Message\" -message $error -type ok \n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc smh2 { menuitem } {\n",\
"    if {[catch {$menuitem entrycget active -label} name]} {\n",\
"	set name \"    \"\n",\
"    } \n",\
"    show_menu_help $name \n",\
"    update idletasks\n",\
"}\n",\
"\n",\
"bind .ngmenu <<MenuSelect>> { smh2 %W }\n",\
"bind .ngmenu.file <<MenuSelect>> { smh2 %W }\n",\
"bind .ngmenu.geometry <<MenuSelect>> { smh2 %W }\n",\
"bind .ngmenu.mesh <<MenuSelect>> { smh2 %W }\n",\
"bind .ngmenu.view <<MenuSelect>> { smh2 %W }\n",\
"bind .ngmenu.meshsize <<MenuSelect>> { smh2 %W }\n",\
"bind .ngmenu.special <<MenuSelect>> { smh2 %W }\n",\
"bind .ngmenu.help <<MenuSelect>> { smh2 %W }\n",\
"\n",\
"\n",\
"# command bindings  \n",\
"bind . <q> { .ngmenu.file invoke \"Quit\" }\n",\
"bind . <l><g> { .ngmenu.file invoke \"Load Geometry\" }  ; \n",\
"bind . <l><m> { .ngmenu.file invoke \"Load Mesh\" }  ;\n",\
"bind . <s><m> { .ngmenu.file invoke \"Save Mesh\" }  ;\n",\
"bind . <r><f> { .ngmenu.file activate \"Recent Files\" }  ;\n",\
"bind . <n><p> { newprimitivedialog }      ; # \n",\
"bind . <e><p> { editprimitivedialog }\n",\
"bind . <e><s> { newsoliddialog }\n",\
"bind . <g><m> { .ngmenu.mesh invoke \"Generate Mesh\" }  ;\n",\
"\n",\
"# bind . <v><m> { .bubar.selview configure activate  mesh }  ;\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"}\n",\
"catch { \n",\
"    proc meshingoptionsdialog { } {\n",\
"\n",\
"    set w .options_dlg\n",\
"    \n",\
"    if {[winfo exists .options_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"\n",\
"	toplevel $w\n",\
"\n",\
"#	global options.meshsize\n",\
"\n",\
"	tixNoteBook $w.nb -ipadx 6 -ipady 6\n",\
"	\n",\
"	$w.nb add general -label \"General\" -underline 0\n",\
"	$w.nb add meshsize -label \"Mesh Size\"   -underline 0\n",\
"	$w.nb add chartopt -label \"STL Charts\" -underline 0\n",\
"	$w.nb add optimizer -label \"Optimizer\"   -underline 0\n",\
"	$w.nb add insider -label \"Insider\"   -underline 0\n",\
"	$w.nb add debug -label \"Debug\"   -underline 0\n",\
"\n",\
"\n",\
"	pack $w.nb -expand yes -fill both -padx 5 -pady 5 -side top	\n",\
"\n",\
"\n",\
"	# General meshing options\n",\
"\n",\
"	set f [$w.nb subwidget general]\n",\
"\n",\
"	set finevals { 1 2 3 4 5 }\n",\
"	set finelabs(1) \"very coarse\" \n",\
"	set finelabs(2) \"coarse\" \n",\
"	set finelabs(3) \"moderate\" \n",\
"	set finelabs(4) \"fine\" \n",\
"	set finelabs(5) \"very fine\" \n",\
"\n",\
"	tixOptionMenu $f.fine -label \"Mesh granularity : \" \\\n",\
"	    -options {\n",\
"		label.width  19\n",\
"		label.anchor e\n",\
"		menubutton.width 15\n",\
"	    } \n",\
"\n",\
"\n",\
"	foreach finev $finevals {\n",\
"	    $f.fine add command $finev -label $finelabs($finev)\n",\
"	}\n",\
"	$f.fine config -variable meshoptions.fineness\n",\
"	$f.fine config -command { setgranularity }\n",\
"	global meshoptions.fineness\n",\
"#	setgranularity ${meshoptions.fineness}\n",\
"	pack $f.fine\n",\
"\n",\
"\n",\
"	\n",\
"\n",\
"\n",\
"	set mgsteps { ag me ms os mv ov }\n",\
"	set mgsteplabel(ag) \"Analyze Geometry\"\n",\
"	set mgsteplabel(me) \"Mesh Edges\"\n",\
"	set mgsteplabel(ms) \"Mesh Surface\"\n",\
"	set mgsteplabel(os) \"Optimize Surface\"\n",\
"	set mgsteplabel(mv) \"Mesh Volume\"\n",\
"	set mgsteplabel(ov) \"Optimize Volume\"\n",\
"\n",\
"	\n",\
"	tixOptionMenu $f.first -label \"First Step : \" \\\n",\
"	    -options {\n",\
"		label.width  19\n",\
"		label.anchor e\n",\
"		menubutton.width 15\n",\
"	    } \n",\
"\n",\
"	tixOptionMenu $f.last -label \"Last Step : \" \\\n",\
"	    -options {\n",\
"		label.width  19\n",\
"		label.anchor e\n",\
"		menubutton.width 15\n",\
"	    } \n",\
"\n",\
"	foreach step $mgsteps {\n",\
"	    $f.first add command $step -label $mgsteplabel($step)\n",\
"	    $f.last add command $step -label $mgsteplabel($step)\n",\
"	}\n",\
"\n",\
"	$f.first config -variable meshoptions.firststep \n",\
"	$f.last config  -variable meshoptions.laststep \n",\
"\n",\
"	pack $f.first $f.last\n",\
"	\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	set msg(1) \"Least\"\n",\
"	set msg(2) \"Little\"\n",\
"	set msg(3) \"Moderate\"\n",\
"	set msg(4) \"Much\"\n",\
"	set msg(5) \"Most\"\n",\
"	\n",\
"	tixOptionMenu $f.msg -label \"Print Messages : \" \\\n",\
"	    -options {\n",\
"		label.width  19\n",\
"		label.anchor e\n",\
"		menubutton.width 15\n",\
"	    } \n",\
"\n",\
"	foreach step { 1 2 3 4 5 } {\n",\
"	    $f.msg add command $step -label $msg($step)\n",\
"	}\n",\
"\n",\
"	$f.msg config -variable options.printmsg \n",\
"	pack $f.msg\n",\
"	\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	\n",\
"\n",\
"	checkbutton $f.parthread -text \"Parallel meshing thread\" \\\n",\
"	    -variable options.parthread\n",\
"	checkbutton $f.second -text \"Second order elements\" \\\n",\
"	    -variable options.secondorder\n",\
"	checkbutton $f.quad -text \"Quad dominated\" \\\n",\
"	    -variable options.quad -command {\n",\
"		if { ${options.quad} } {\n",\
"		    set meshoptions.laststep os\n",\
"		}\n",\
"	    }\n",\
"	checkbutton $f.invtets -text \"Invert volume elements\" \\\n",\
"	    -variable options.inverttets\n",\
"	checkbutton $f.invtrigs -text \"Invert surface elements\" \\\n",\
"	    -variable options.inverttrigs\n",\
"\n",\
"	pack $f.parthread $f.second $f.quad $f.invtets $f.invtrigs \n",\
"\n",\
"\n",\
"\n",\
"	tixControl $f.elementorder -label \"Element order: \" -integer true \\\n",\
"	    -variable options.elementorder -min 1 -max 20 \\\n",\
"	    -options {\n",\
"		entry.width 2\n",\
"		label.width 20\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"        pack $f.elementorder\n",\
"\n",\
"\n",\
"	tixControl $f.memory -label \"Large Memory \\[MB\\]: \" -integer true \\\n",\
"	    -variable options.memory -min 0 -max 2000 \\\n",\
"	    -options {\n",\
"		entry.width 5\n",\
"		label.width 20\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	global userlevel\n",\
"	if { $userlevel >= 3} { pack $f.memory }\n",\
"\n",\
"\n",\
"	# Mesh - Size options\n",\
"	set f [$w.nb subwidget meshsize]\n",\
"\n",\
"	tixControl $f.meshsize -label \"max mesh-size: \" -integer false \\\n",\
"	    -variable options.meshsize -min 1e-9 -max 1e6 \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	tixControl $f.grading -label \"mesh-size grading: \" -integer false \\\n",\
"	    -variable options.grading -min 0.1 -max 1 -step 0.1 \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"	\n",\
"	pack $f.meshsize $f.grading\n",\
"\n",\
"\n",\
"\n",\
"	frame $f.msf \n",\
"	pack $f.msf\n",\
"\n",\
" 	tixLabelEntry $f.msf.ent -label \"mesh-size file: \"  \\\n",\
" 	    -labelside top \\\n",\
" 	    -options {  \n",\
" 		entry.textVariable options.meshsizefilename \n",\
" 		entry.width 35\n",\
" 		label.width 25\n",\
" 		label.anchor w\n",\
" 	    }	\n",\
" 	button $f.msf.btn -text \"Browse\" -command {\n",\
"	    global options.meshsizefilename\n",\
"	    set types {\n",\
"		{\"Meshsize file\"   {.msz}	} }\n",\
"	    set options.meshsizefilename [tk_getOpenFile -filetypes $types -initialfile ${options.meshsizefilename}]\n",\
"	}\n",\
"\n",\
" 	pack $f.msf.ent -side left -expand yes -fill x -anchor s -padx 4 -pady 4\n",\
" 	pack $f.msf.btn -side left -anchor s -padx 4 -pady 4\n",\
"\n",\
"\n",\
"	label $f.lab -text \"Additional mesh size restrictions:\"\n",\
"\n",\
"	#csg-meshsize options\n",\
"\n",\
"	frame $f.csg -relief groove -borderwidth 3\n",\
"	pack $f.csg -fill x\n",\
"\n",\
"\n",\
"	frame $f.csg.curv\n",\
"	pack $f.csg.curv -anchor w\n",\
"\n",\
"	scale $f.csg.curv.sc -orient horizontal -length 200 -from 0.2 -to 5 \\\n",\
"	    -resolution 0.1 -variable options.curvaturesafety\n",\
"	label $f.csg.curv.la -text \"Elements per curvature radius\"\n",\
"	pack $f.csg.curv.sc $f.csg.curv.la -side left \n",\
"\n",\
"	frame $f.csg.elen\n",\
"	pack $f.csg.elen -anchor w\n",\
"	scale $f.csg.elen.sc -orient horizontal -length 200 -from 0.2 -to 5 \\\n",\
"	    -resolution 0.1 -variable options.segmentsperedge\n",\
"	label $f.csg.elen.la -text \"Elements per edge\"\n",\
"	pack $f.csg.elen.sc $f.csg.elen.la -side left\n",\
"	\n",\
"\n",\
"	#stl-meshsize options\n",\
"\n",\
"	frame $f.stl -relief groove -borderwidth 3\n",\
"	pack $f.stl -fill x\n",\
"\n",\
"	frame $f.stl.r2\n",\
"	pack $f.stl.r2 -anchor w\n",\
"	scale $f.stl.r2.sc -orient horizontal -length 200 -from 0.2 -to 5 \\\n",\
"	    -resolution 0.1 -variable stloptions.resthchartdistfac\n",\
"	checkbutton $f.stl.r2.bu -text \"STL - chart distance\" \\\n",\
"	    -variable stloptions.resthchartdistenable\n",\
"	pack $f.stl.r2.sc $f.stl.r2.bu -side left\n",\
"	\n",\
"	frame $f.stl.r6\n",\
"	pack $f.stl.r6 -anchor w\n",\
"	scale $f.stl.r6.sc -orient horizontal -length 200 -from 0.2 -to 5 \\\n",\
"	    -resolution 0.1 -variable stloptions.resthlinelengthfac\n",\
"	checkbutton $f.stl.r6.bu -text \"STL - line length\" \\\n",\
"	    -variable stloptions.resthlinelengthenable\n",\
"	pack $f.stl.r6.sc $f.stl.r6.bu -side left\n",\
"	\n",\
"	frame $f.stl.r3\n",\
"	pack $f.stl.r3 -anchor w\n",\
"	scale $f.stl.r3.sc -orient horizontal -length 200 -from 0.2 -to 8 \\\n",\
"	    -resolution 0.1 -variable stloptions.resthcloseedgefac\n",\
"	checkbutton $f.stl.r3.bu -text \"STL/IGES/STEP - close edges\" \\\n",\
"	-variable stloptions.resthcloseedgeenable\n",\
"	pack $f.stl.r3.sc $f.stl.r3.bu -side left\n",\
"	\n",\
"	frame $f.stl.r1\n",\
"	pack $f.stl.r1 -anchor w\n",\
"	scale $f.stl.r1.sc -orient horizontal -length 200 -from 0.2 -to 5 \\\n",\
"	    -resolution 0.1 -variable stloptions.resthsurfcurvfac\n",\
"	checkbutton $f.stl.r1.bu -text \"STL - surface curvature\" \\\n",\
"	    -variable stloptions.resthsurfcurvenable\n",\
"	pack $f.stl.r1.sc $f.stl.r1.bu -side left\n",\
"\n",\
"	frame $f.stl.r3b\n",\
"	pack $f.stl.r3b -anchor w\n",\
"	scale $f.stl.r3b.sc -orient horizontal -length 200 -from 0.2 -to 5 \\\n",\
"	    -resolution 0.1 -variable stloptions.resthedgeanglefac\n",\
"	checkbutton $f.stl.r3b.bu -text \"STL - edge angle\" \\\n",\
"	-variable stloptions.resthedgeangleenable\n",\
"	pack $f.stl.r3b.sc $f.stl.r3b.bu -side left\n",\
"	\n",\
"	frame $f.stl.r5\n",\
"	pack $f.stl.r5 -anchor w\n",\
"	scale $f.stl.r5.sc -orient horizontal -length 200 -from 0.2 -to 5 \\\n",\
"	    -resolution 0.1 -variable stloptions.resthsurfmeshcurvfac\n",\
"	checkbutton $f.stl.r5.bu -text \"STL - surface mesh curv\" \\\n",\
"	    -variable stloptions.resthsurfmeshcurvenable\n",\
"	pack $f.stl.r5.sc $f.stl.r5.bu -side left\n",\
"	\n",\
"	\n",\
"	checkbutton $f.stl.recalch -text \"STL - Recalc mesh size for surface optimization\" \\\n",\
"	    -variable stloptions.recalchopt\n",\
"	pack $f.stl.recalch\n",\
"\n",\
"	button $f.stl.calch -text \"Calc New H\" -command { redraw; Ng_STLCalcLocalH }\n",\
"	pack $f.stl.calch\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	set f [$w.nb subwidget chartopt]\n",\
"\n",\
"\n",\
"	label $f.lab1 -text \"Yellow Edges Angle ()\"\n",\
"	scale $f.scale1 -orient horizontal -length 300 \\\n",\
"	    -from 0 -to 90 -resolution 1  -tickinterval 10 \\\n",\
"	    -variable  stloptions.yangle \n",\
"\n",\
"	pack $f.lab1 $f.scale1\n",\
"\n",\
"	label $f.lab2e -text \"Edge Corner Angle ()\"\n",\
"	scale $f.scale2e -orient horizontal -length 360 -from 0 -to 180 \\\n",\
"	    -resolution 1  -tickinterval 20 \\\n",\
"	    -variable  stloptions.edgecornerangle \n",\
"	pack $f.lab2e $f.scale2e\n",\
"	\n",\
"	label $f.lab2 -text \"Chart Angle ()\"\n",\
"	scale $f.scale2 -orient horizontal -length 360 -from 0 -to 180 \\\n",\
"	    -resolution 1  -tickinterval 20 \\\n",\
"	    -variable  stloptions.chartangle \n",\
"	pack $f.lab2 $f.scale2\n",\
"	\n",\
"	label $f.lab2b -text \"Outer Chart Angle ()\"\n",\
"	scale $f.scale2b -orient horizontal -length 360 -from 0 -to 180 \\\n",\
"	    -resolution 1  -tickinterval 20 \\\n",\
"	    -variable  stloptions.outerchartangle \n",\
"	pack $f.lab2b $f.scale2b\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	# Optimization options\n",\
"	\n",\
"	set f [$w.nb subwidget optimizer]\n",\
"\n",\
"	\n",\
"\n",\
"\n",\
"	tixControl $f.os2d -label \"Surface opt steps: \" -integer true \\\n",\
"	    -variable options.optsteps2d -min 0 -max 99 -step 1 \\\n",\
"	    -options {\n",\
"		entry.width 3\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	tixControl $f.os3d -label \"Volume opt steps: \" -integer true \\\n",\
"	    -variable options.optsteps3d -min 0 -max 99 -step 1 \\\n",\
"	    -options {\n",\
"		entry.width 3\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"	\n",\
"	tixControl $f.elw -label \"Element size weight: \" -integer false \\\n",\
"	    -variable options.elsizeweight -min 0 -max 1 -step 0.1 \\\n",\
"	    -options {\n",\
"		entry.width 3\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	tixControl $f.wem -label \"Worst element measure: \" -integer false \\\n",\
"	    -variable options.opterrpow -min 1 -max 10 -step 1 \\\n",\
"	    -options {\n",\
"		entry.width 3\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	pack $f.os2d $f.os3d $f.elw $f.wem\n",\
"	\n",\
"	frame $f.badellimit\n",\
"	pack $f.badellimit -fill x\n",\
"	label $f.badellimit.lab -text \"bad element criterion\";\n",\
"	scale $f.badellimit.scale -orient horizontal -length 150 \\\n",\
"	    -from 160 -to 180 -resolution 1 \\\n",\
"	-variable options.badellimit\n",\
"	pack $f.badellimit.scale $f.badellimit.lab -side right -anchor s\n",\
"\n",\
"\n",\
"	# insider options\n",\
"	set f [$w.nb subwidget insider]\n",\
"	\n",\
"\n",\
"\n",\
"	checkbutton $f.localh -text \"Use Local Meshsize\" \\\n",\
"	    -variable options.localh\n",\
"	checkbutton $f.delauney -text \"Use Delaunay\" \\\n",\
"	    -variable options.delaunay\n",\
"	checkbutton $f.checkoverlap -text \"Check Overlapping\" \\\n",\
"	    -variable options.checkoverlap\n",\
"	checkbutton $f.checkcb -text \"Check Chart Boundary\" \\\n",\
"	    -variable options.checkchartboundary\n",\
"	checkbutton $f.blockfill -text \"Do Blockfilling\" \\\n",\
"	    -variable options.blockfill\n",\
"\n",\
"	pack  $f.localh  $f.delauney $f.checkoverlap  $f.blockfill $f.checkcb   -anchor w\n",\
"\n",\
"\n",\
"\n",\
"	\n",\
"	# debugging options\n",\
"	set f [$w.nb subwidget debug]\n",\
"\n",\
"	frame $f.cb\n",\
"	pack $f.cb -side top\n",\
"\n",\
"	\n",\
"\n",\
"	checkbutton $f.cb.slowchecks -text \"Slow checks\" \\\n",\
"	    -variable debug.slowchecks -command { Ng_SetDebugParameters }\n",\
"	checkbutton $f.cb.debugoutput -text \"Debugging outout\" \\\n",\
"	    -variable debug.debugoutput -command { Ng_SetDebugParameters }\n",\
"	checkbutton $f.cb.haltexline -text \"Halt on exising line\" \\\n",\
"	    -variable debug.haltexistingline  -command { Ng_SetDebugParameters }\n",\
"	checkbutton $f.cb.haltoverlap -text \"Halt on Overlap\" \\\n",\
"	    -variable debug.haltoverlap  -command { Ng_SetDebugParameters }\n",\
"	checkbutton $f.cb.haltsuc -text \"Halt on success\" \\\n",\
"	    -variable debug.haltsuccess  -command { Ng_SetDebugParameters }\n",\
"	checkbutton $f.cb.haltnosuc -text \"Halt on no success\" \\\n",\
"	    -variable debug.haltnosuccess  -command { Ng_SetDebugParameters }\n",\
"	checkbutton $f.cb.haltlargequal -text \"Halt on large quality class\" \\\n",\
"	    -variable debug.haltlargequalclass  -command { Ng_SetDebugParameters }\n",\
"	checkbutton $f.cb.haltseg -text \"Halt on Segment:\" \\\n",\
"	    -variable debug.haltsegment  -command { Ng_SetDebugParameters }\n",\
"	checkbutton $f.cb.haltnode -text \"Halt on Node:\" \\\n",\
"	    -variable debug.haltnode  -command { Ng_SetDebugParameters }\n",\
"\n",\
"\n",\
"	pack $f.cb.slowchecks $f.cb.debugoutput $f.cb.haltexline $f.cb.haltoverlap $f.cb.haltsuc $f.cb.haltnosuc $f.cb.haltlargequal  $f.cb.haltseg   $f.cb.haltnode \n",\
"\n",\
"	frame $f.cb.hf\n",\
"	pack $f.cb.hf -pady 5\n",\
"	checkbutton $f.cb.hf.cb -text \"Halt on Face:\" \\\n",\
"	    -variable debug.haltface  -command { Ng_SetDebugParameters }\n",\
"	entry $f.cb.hf.ent -textvariable debug.haltfacenr -width 5  \n",\
"	pack $f.cb.hf.cb $f.cb.hf.ent -side left \n",\
"\n",\
"	checkbutton $f.cb.showactivechart -text \"Show Active Meshing-Chart\" \\\n",\
"	    -variable stloptions.showactivechart -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	pack $f.cb.showactivechart\n",\
"	\n",\
"\n",\
"	frame $f.segs\n",\
"	pack $f.segs -pady 5\n",\
"	label $f.segs.lab1 -text \"P1:\";\n",\
"	entry $f.segs.ent1 -width 8 -relief sunken \\\n",\
"	    -textvariable debug.haltsegmentp1 \n",\
"	label $f.segs.lab2 -text \"P2:\";\n",\
"	entry $f.segs.ent2 -width 8 -relief sunken \\\n",\
"	    -textvariable debug.haltsegmentp2 \n",\
"	pack $f.segs.lab1 $f.segs.ent1 $f.segs.lab2 $f.segs.ent2  -side left\n",\
"\n",\
"\n",\
"\n",\
"	frame $f.cont -relief groove -borderwidth 3\n",\
"	pack $f.cont \n",\
"	#-fill x \n",\
"	\n",\
"	checkbutton $f.cont.multidrawing -text \"Draw Meshing\" \\\n",\
"	    -variable multithread_drawing \n",\
"	pack $f.cont.multidrawing\n",\
"	\n",\
"	checkbutton $f.cont.multitestmode -text \"Meshing Testmode\" \\\n",\
"	-variable multithread_testmode \n",\
"	pack $f.cont.multitestmode\n",\
"	\n",\
"	button $f.cont.goon -text \"Go On\" -command { set multithread_pause 0 }\n",\
"	pack $f.cont.multidrawing $f.cont.multitestmode $f.cont.goon -side left -expand yes\n",\
"	\n",\
"\n",\
"\n",\
"\n",\
"	global userlevel\n",\
"	if { $userlevel < 3} {\n",\
"	    $w.nb delete insider\n",\
"	    $w.nb delete debug\n",\
"	}\n",\
"\n",\
"\n",\
"\n",\
"# 	tixButtonBox $w.bbox -orientation horizontal\n",\
"# 	$w.bbox add ok    -text Apply  -underline 0 -width 5 \\\n",\
"# 	    -command { \n",\
"# 		[.options_dlg.nb subwidget meshsize].meshsize invoke\n",\
"# 		[.options_dlg.nb subwidget meshsize].grading invoke\n",\
"# 		[.options_dlg.nb subwidget optimizer].os2d invoke\n",\
"# 		[.options_dlg.nb subwidget optimizer].os3d invoke\n",\
"# 		[.options_dlg.nb subwidget optimizer].elw invoke\n",\
"# 		[.options_dlg.nb subwidget optimizer].wem invoke\n",\
"		\n",\
"# 		Ng_SetMeshingParameters \n",\
"# 	    }\n",\
"	\n",\
"# 	$w.bbox add close -text Done   -underline 0 -width 5 \\\n",\
"# 	    -command {\n",\
"# 		[.options_dlg.nb subwidget meshsize].meshsize invoke\n",\
"# 		[.options_dlg.nb subwidget meshsize].grading invoke\n",\
"# 		[.options_dlg.nb subwidget optimizer].os2d invoke\n",\
"# 		[.options_dlg.nb subwidget optimizer].os3d invoke\n",\
"# 		[.options_dlg.nb subwidget optimizer].elw invoke\n",\
"# 		[.options_dlg.nb subwidget optimizer].wem invoke\n",\
"		\n",\
"# 		Ng_SetMeshingParameters\n",\
"# 		destroy .options_dlg\n",\
"# 	    }\n",\
"	\n",\
"# 	pack $w.bbox -side bottom -fill x\n",\
"\n",\
"	\n",\
"	frame $w.bu\n",\
"	pack $w.bu -fill x -ipady 3\n",\
"\n",\
"	button $w.bu.apl -text \"Apply\" -command { \n",\
"	    [.options_dlg.nb subwidget meshsize].meshsize invoke\n",\
"	    [.options_dlg.nb subwidget meshsize].grading invoke\n",\
"	    [.options_dlg.nb subwidget optimizer].os2d invoke\n",\
"	    [.options_dlg.nb subwidget optimizer].os3d invoke\n",\
"	    [.options_dlg.nb subwidget optimizer].elw invoke\n",\
"	    [.options_dlg.nb subwidget optimizer].wem invoke\n",\
"\n",\
"	    Ng_SetMeshingParameters \n",\
"	    Ng_SetDebugParameters\n",\
"	}\n",\
"\n",\
"	button $w.bu.ok -text \"Done\" -command {\n",\
"	    [.options_dlg.nb subwidget meshsize].meshsize invoke\n",\
"	    [.options_dlg.nb subwidget meshsize].grading invoke\n",\
"	    [.options_dlg.nb subwidget optimizer].os2d invoke\n",\
"	    [.options_dlg.nb subwidget optimizer].os3d invoke\n",\
"	    [.options_dlg.nb subwidget optimizer].elw invoke\n",\
"	    [.options_dlg.nb subwidget optimizer].wem invoke\n",\
"\n",\
"	    Ng_SetMeshingParameters\n",\
"	    Ng_SetDebugParameters\n",\
"	    wm withdraw .options_dlg\n",\
"#	    destroy .options_dlg\n",\
"	}\n",\
"\n",\
"	pack  $w.bu.apl $w.bu.ok -side left -expand yes\n",\
"    \n",\
"	\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Meshing Options\"\n",\
"	focus .options_dlg\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"meshingoptionsdialog\n",\
"wm withdraw .options_dlg\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc geometryoptionsdialog { } {\n",\
"\n",\
"\n",\
"    set w .geometry_dlg\n",\
"    \n",\
"    if {[winfo exists .geometry_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"\n",\
"	toplevel $w\n",\
"	\n",\
"	global geooptions\n",\
"	\n",\
"	Ng_GeometryOptions get\n",\
"\n",\
"	checkbutton $w.drawcsg -text \"Draw Geometry\" \\\n",\
"	-variable geooptions.drawcsg \n",\
"	pack $w.drawcsg\n",\
"\n",\
"	frame $w.fac\n",\
"	pack $w.fac -pady 5\n",\
"	label $w.fac.lab -text \"Facets:\";\n",\
"	entry $w.fac.ent -width 8 -relief sunken \\\n",\
"	    -textvariable geooptions.facets\n",\
"	pack $w.fac.lab $w.fac.ent  -side left\n",\
"	\n",\
" \n",\
"	frame $w.det\n",\
"	pack $w.det -pady 5\n",\
"	label $w.det.lab -text \"Detail:\";\n",\
"	entry $w.det.ent -width 8 -relief sunken \\\n",\
"	    -textvariable geooptions.detail\n",\
"	pack $w.det.lab $w.det.ent  -side left\n",\
"	\n",\
"	frame $w.cox\n",\
"	pack $w.cox -pady 5\n",\
"	label $w.cox.lab -text \"min/max x:\";\n",\
"	entry $w.cox.ent1 -width 8 -relief sunken \\\n",\
"	    -textvariable geooptions.minx\n",\
"	entry $w.cox.ent2 -width 8 -relief sunken \\\n",\
"	    -textvariable geooptions.maxx\n",\
"	pack $w.cox.lab $w.cox.ent1 \\\n",\
"	    $w.cox.ent2  -side left\n",\
"	\n",\
"	frame $w.coy\n",\
"	pack $w.coy -pady 5\n",\
"	label $w.coy.lab -text \"min/max y:\";\n",\
"	entry $w.coy.ent1 -width 8 -relief sunken \\\n",\
"	    -textvariable geooptions.miny\n",\
"	entry $w.coy.ent2 -width 8 -relief sunken \\\n",\
"	    -textvariable geooptions.maxy\n",\
"	pack $w.coy.lab $w.coy.ent1 \\\n",\
"	    $w.coy.ent2  -side left\n",\
"	\n",\
"	frame $w.coz\n",\
"	pack $w.coz -pady 5\n",\
"	label $w.coz.lab -text \"min/max z:\";\n",\
"	entry $w.coz.ent1 -width 8 -relief sunken \\\n",\
"	    -textvariable geooptions.minz\n",\
"	entry $w.coz.ent2 -width 8 -relief sunken \\\n",\
"	    -textvariable geooptions.maxz\n",\
"	pack $w.coz.lab $w.coz.ent1 \\\n",\
"	    $w.coz.ent2  -side left\n",\
"	\n",\
"\n",\
"\n",\
"# 	tixButtonBox $w.bbox -orientation horizontal\n",\
"# 	$w.bbox add ok    -text Apply  -underline 0 -width 5 \\\n",\
"# 	    -command { Ng_GeometryOptions set }\n",\
"	\n",\
"# 	$w.bbox add close -text Done   -underline 0 -width 5 \\\n",\
"# 	    -command { \n",\
"# 		Ng_GeometryOptions set\n",\
"# 		destroy .geometry_dlg\n",\
"# 	    }\n",\
"# 	pack $w.bbox -side bottom -fill x\n",\
"	\n",\
"\n",\
" 	frame $w.bu\n",\
"	pack $w.bu -fill x -ipady 3\n",\
"\n",\
"\n",\
" 	button $w.bu.app -text \"Apply\" -command {\n",\
" 	    Ng_GeometryOptions set\n",\
" 	}\n",\
" 	button $w.bu.ok -text \"Done\" -command {\n",\
" 	    Ng_GeometryOptions set\n",\
" 	    destroy .geometry_dlg\n",\
" 	}\n",\
" 	pack  $w.bu.app $w.bu.ok -side left -expand yes\n",\
"    \n",\
"\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Geometry options\"\n",\
"	focus $w\n",\
"    }\n",\
"}\n",\
"\n",\
"#\n",\
"#\n",\
"#  Viewing dialog\n",\
"#\n",\
"#\n",\
"proc viewingoptionsdialog { } {\n",\
"\n",\
"    global userlevel\n",\
"\n",\
"    set w .viewopts_dlg\n",\
"    \n",\
"    if {[winfo exists .viewopts_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"	toplevel $w\n",\
" \n",\
"\n",\
"\n",\
"\n",\
"	tixNoteBook $w.nb -ipadx 6 -ipady 6\n",\
"	\n",\
"	$w.nb add general -label \"general\" -underline 0\n",\
"	$w.nb add stl -label \"STL\" -underline 0\n",\
"	$w.nb add occ -label \"IGES/STEP\" -underline 0\n",\
"	$w.nb add mesh -label \"Mesh\"   -underline 0\n",\
"	$w.nb add light -label \"Light\"   -underline 0\n",\
"	$w.nb add edges -label \"Edges\"   -underline 0\n",\
"\n",\
"\n",\
"	pack $w.nb -expand yes -fill both -padx 5 -pady 5 -side top	\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	# general\n",\
"	set f [$w.nb subwidget general]\n",\
"\n",\
"	checkbutton $f.backcol -text \"White Background\" \\\n",\
"	-variable viewoptions.whitebackground \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	checkbutton $f.cross -text \"Draw Coordinate Cross\" \\\n",\
"	-variable viewoptions.drawcoordinatecross \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	checkbutton $f.color -text \"Draw Color-bar\" \\\n",\
"	-variable viewoptions.drawcolorbar \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	checkbutton $f.netgen -text \"Draw Netgen-logo\" \\\n",\
"	-variable viewoptions.drawnetgenlogo \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	pack $f.backcol $f.cross $f.color $f.netgen\n",\
"\n",\
"# 	checkbutton $f.stereo -text \"Stereo View\" \\\n",\
"# 	-variable viewoptions.stereo \\\n",\
"# 	-command { Ng_SetVisParameters; redraw }\n",\
"# 	pack $f.stereo\n",\
"\n",\
"	# stl geometry \n",\
"	set f [$w.nb subwidget stl]\n",\
"\n",\
"	frame $f.show -relief groove -borderwidth 3\n",\
"	pack $f.show\n",\
"	checkbutton $f.show.showtrias -text \"Show STL-Triangles\" \\\n",\
"	    -variable stloptions.showtrias -command { Ng_SetVisParameters; redraw }\n",\
"	pack $f.show.showtrias -anchor w\n",\
"	\n",\
"	checkbutton $f.show.showfilledtrias -text \"Show Filled Triangles\" \\\n",\
"	    -variable stloptions.showfilledtrias -command { Ng_SetVisParameters; redraw }\n",\
"	pack $f.show.showfilledtrias -anchor w\n",\
"	\n",\
"	checkbutton $f.show.showactivechart -text \"Show Active Meshing-Chart\" \\\n",\
"	    -variable stloptions.showactivechart -command { Ng_SetVisParameters; redraw }\n",\
"	pack $f.show.showactivechart -anchor w\n",\
"	\n",\
"	checkbutton $f.show.showedges -text \"Show Edges\" \\\n",\
"	    -variable stloptions.showedges -command { Ng_SetVisParameters; redraw }\n",\
"	pack $f.show.showedges -anchor w\n",\
"	\n",\
"	frame $f.special -relief groove -borderwidth 3\n",\
"	pack $f.special\n",\
"	checkbutton $f.special.showmarktrias -text \"Show Chart Triangles\" \\\n",\
"	    -variable stloptions.showmarktrias \\\n",\
"	    -command {set stldoctor.showfaces 0; Ng_STLDoctor; Ng_SetVisParameters; redraw }\n",\
"	pack $f.special.showmarktrias -side left\n",\
"\n",\
"	checkbutton $f.special.showfaces -text \"Show Faces\" \\\n",\
"	    -variable stldoctor.showfaces \\\n",\
"	    -command {set stloptions.showmarktrias 0; Ng_STLDoctor; Ng_SetVisParameters; redraw}    \n",\
"	pack $f.special.showfaces -side left\n",\
"\n",\
"	frame $f.fn -relief groove -borderwidth 3\n",\
"	pack $f.fn\n",\
"	label $f.fn.lab3 -text \"Chart/Face number:\"\n",\
"	scale $f.fn.scale3 -orient horizontal -length 200 -from 0 -to 200 \\\n",\
"	    -resolution 1  -tickinterval 50 \\\n",\
"	    -command { Ng_SetVisParameters; redraw } -variable  stloptions.chartnumber \n",\
"	pack $f.fn.lab3 $f.fn.scale3 -side left\n",\
"	\n",\
"	frame $f.fo -relief groove -borderwidth 3\n",\
"	pack $f.fo\n",\
"	label $f.fo.lab -text \"Chart/Face Offset:\";\n",\
"	entry $f.fo.ent -width 5 -relief sunken \\\n",\
"	    -textvariable stloptions.chartnumberoffset\n",\
"	pack $f.fo.lab $f.fo.ent -side left\n",\
"\n",\
"	frame $f.mt\n",\
"	pack $f.mt -fill x\n",\
"	checkbutton $f.mt.bu -text \"Show Marked (Dirty) Triangles\" \\\n",\
"	    -variable stldoctor.showmarkedtrigs \\\n",\
"	    -command {Ng_STLDoctor; redraw}    \n",\
"	pack $f.mt.bu\n",\
"\n",\
"	frame $f.ep\n",\
"	pack $f.ep -fill x\n",\
"	checkbutton $f.ep.bu -text \"show edge corner points\" \\\n",\
"	    -variable stldoctor.showedgecornerpoints \\\n",\
"	    -command {Ng_STLDoctor; redraw}    \n",\
"	pack $f.ep.bu\n",\
"\n",\
"	frame $f.stt\n",\
"	pack $f.stt -fill x\n",\
"	checkbutton $f.stt.bu -text \"show touched triangle chart\" \\\n",\
"	    -variable stldoctor.showtouchedtrigchart \\\n",\
"	    -command {set stldoctor.showfaces 0; set stloptions.showmarktrias 1; \\\n",\
"			  Ng_STLDoctor; Ng_SetVisParameters; redraw}    \n",\
"	pack $f.stt.bu\n",\
"\n",\
"	frame $f.sml\n",\
"	pack $f.sml -fill x\n",\
"	checkbutton $f.sml.bu -text \"draw meshed edges\" \\\n",\
"	    -variable stldoctor.drawmeshededges \\\n",\
"	    -command {Ng_STLDoctor;}    \n",\
"	pack $f.sml.bu\n",\
"	\n",\
"	\n",\
"	frame $f.sm\n",\
"	pack $f.sm -fill x\n",\
"	checkbutton $f.sm.bu -text \"select with mouse\" \\\n",\
"	    -variable stldoctor.selectwithmouse\n",\
"	pack $f.sm.bu\n",\
"	\n",\
"	frame $f.st -relief groove -borderwidth 3\n",\
"	pack $f.st -fill x\n",\
"	label $f.st.lab -text \"Select triangle by number\";\n",\
"	entry $f.st.ent -width 5 -relief sunken \\\n",\
"	    -textvariable stldoctor.selecttrig\n",\
"	pack $f.st.ent $f.st.lab -side left -expand yes\n",\
"	\n",\
"	frame $f.vc -relief groove -borderwidth 3\n",\
"	pack $f.vc -fill x\n",\
"	checkbutton $f.vc.bu -text \"show vicinity\" \\\n",\
"	    -variable stldoctor.showvicinity \\\n",\
"	    -command {Ng_STLDoctor vicinity; redraw}\n",\
"	label $f.vc.lab -text \"vicinity size\";\n",\
"	scale $f.vc.sc -orient horizontal -length 200 -from 0 -to 200 \\\n",\
"	    -resolution 1 -variable stldoctor.vicinity \\\n",\
"	    -command { Ng_STLDoctor vicinity; redraw }\n",\
"	pack $f.vc.bu $f.vc.lab $f.vc.sc -expand yes\n",\
"	\n",\
"\n",\
"\n",\
"	# IGES/STEP\n",\
"	set f [$w.nb subwidget occ]\n",\
"	\n",\
"	checkbutton $f.occshowsurfaces -text \"Show surfaces \" \\\n",\
"	    -variable occoptions.showsurfaces \\\n",\
"	    -command { Ng_SetOCCVisParameters; redraw }\n",\
"\n",\
"	checkbutton $f.occshowedges -text \"Show edges \" \\\n",\
"	    -variable occoptions.showedges \\\n",\
"	    -command { Ng_SetOCCVisParameters; redraw }\n",\
"\n",\
"	frame $f.deflection -relief groove -borderwidth 3\n",\
"	pack $f.deflection -fill x\n",\
"	button $f.deflection.lab -text \"Rebuild visualization data\" \\\n",\
"	    -command {\n",\
"		Ng_SetOCCVisParameters\n",\
"		Ng_OCCCommand buildvisualizationmesh\n",\
"		redraw\n",\
"	    }\n",\
"\n",\
"	tixControl $f.deflection.ent -label \"Visualization smoothness\" -integer false \\\n",\
"	    -variable occoptions.deflection -min 0.1 -max 3 -step 0.1 \\\n",\
"	    -options { entry.width 3 } \\\n",\
"	    -command { Ng_SetOCCVisParameters }\n",\
"\n",\
"	pack $f.deflection.ent $f.deflection.lab -side left  -expand yes\n",\
"\n",\
"	pack $f.occshowsurfaces $f.occshowedges\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	# mesh options\n",\
"	set f [$w.nb subwidget mesh]\n",\
"\n",\
"	checkbutton $f.showcolor -text \"Colored Meshsize Visualization\" \\\n",\
"	    -variable viewoptions.colormeshsize \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"\n",\
"	checkbutton $f.showfilledtrigs -text \"Show filled triangles\" \\\n",\
"	-variable viewoptions.drawfilledtrigs \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"	\n",\
"	checkbutton $f.showedges -text \"Show edges\" \\\n",\
"	-variable viewoptions.drawedges \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"	\n",\
"\n",\
"	checkbutton $f.showoutline -text \"Show Triangle Outline\" \\\n",\
"	    -variable viewoptions.drawoutline \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"\n",\
"	tixControl $f.subdiv -label \"Subdivision\" -integer true \\\n",\
"            -variable visoptions.subdivisions -min 0 -max 5 \\\n",\
"	    -options { entry.width 2 } \\\n",\
"	    -command { Ng_SetVisParameters; Ng_Vis_Set parameters; Ng_SetNextTimeStamp; redraw }\n",\
"	\n",\
"	\n",\
"	checkbutton $f.showbadels -text \"Show bad elements\" \\\n",\
"	    -variable viewoptions.drawbadels \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"\n",\
"\n",\
"	checkbutton $f.showprisms -text \"Show prisms\" \\\n",\
"	    -variable viewoptions.drawprisms \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	checkbutton $f.showpyramids -text \"Show pyramids\" \\\n",\
"	    -variable viewoptions.drawpyramids \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	checkbutton $f.showhexes -text \"Show hexes\" \\\n",\
"	    -variable viewoptions.drawhexes \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	frame $f.fshrink\n",\
"	label $f.fshrink.lab -text \"Shrink elements\"\n",\
"	scale $f.fshrink.scale -orient horizontal -length 200 -from 0 -to 1.0001 \\\n",\
"	    -resolution 0.01  -tickinterval 0.25 \\\n",\
"	    -command { Ng_SetVisParameters; redraw } -variable  viewoptions.shrink\n",\
"\n",\
"\n",\
"	checkbutton $f.showidentified -text \"Show identified points\" \\\n",\
"	    -variable viewoptions.drawidentified \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	checkbutton $f.showmetispartition -text \"Show METIS Partition\" \\\n",\
"	    -variable viewoptions.drawmetispartition \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	checkbutton $f.showpointnumbers -text \"Show Point-numbers\" \\\n",\
"	    -variable viewoptions.drawpointnumbers \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	checkbutton $f.showedgenumbers -text \"Show Edge-numbers\" \\\n",\
"	    -variable viewoptions.drawedgenumbers \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	checkbutton $f.showfacenumbers -text \"Show Face-numbers\" \\\n",\
"	    -variable viewoptions.drawfacenumbers \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	checkbutton $f.showelementnumbers -text \"Show Element-numbers\" \\\n",\
"	    -variable viewoptions.drawelementnumbers \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	\n",\
"	# label $f.showdomainlab -text \"Domain Surface\"\n",\
"#	scale $f.showdomain -orient horizontal -length 100 -from 0 -to 50 \\\n",\
"	    -resolution 1 -variable  viewoptions.drawdomainsurf    \\\n",\
"	    -command { Ng_SetVisParameters; redraw } \\\n",\
"	    -label \"Domain Surface\" \n",\
"\n",\
"	tixControl $f.showdomain -label \"Show surface of domain\" -integer true \\\n",\
"            -variable viewoptions.drawdomainsurf -min 0 -max 50 \\\n",\
"	    -options { entry.width 2 } \\\n",\
"	    -command { Ng_SetVisParameters; Ng_Vis_Set parameters; redraw }\n",\
"    \n",\
"    \n",\
"    \n",\
"\n",\
"	if {$userlevel == 3} {\n",\
"	    frame $f.center -relief groove -borderwidth 3\n",\
"	    pack $f.center -fill x\n",\
"	    button $f.center.lab -text \"Set Center Point\" \\\n",\
"		-command { Ng_SetVisParameters; Ng_Center; redraw }\n",\
"	    entry $f.center.ent -width 5 -relief sunken \\\n",\
"		-textvariable viewoptions.centerpoint \n",\
"	    pack $f.center.ent $f.center.lab -side left  -expand yes\n",\
"	    \n",\
"	    frame $f.drawel -relief groove -borderwidth 3\n",\
"	    pack $f.drawel -fill x\n",\
"	    button $f.drawel.lab -text \"Draw Element\" \\\n",\
"		-command { Ng_SetVisParameters; Ng_ZoomAll; redraw }\n",\
"	    entry $f.drawel.ent -width 5 -relief sunken \\\n",\
"		-textvariable viewoptions.drawelement \n",\
"	    pack $f.drawel.ent $f.drawel.lab -side left  -expand yes\n",\
"	}\n",\
"\n",\
"        pack $f.showfilledtrigs\n",\
"	pack $f.showoutline $f.subdiv $f.showedges  $f.showbadels \n",\
"	# pack $f.showdomainlab \n",\
"	pack $f.showdomain \n",\
"	pack $f.showpointnumbers \n",\
"	pack $f.showedgenumbers $f.showfacenumbers $f.showelementnumbers \n",\
"	pack $f.showmetispartition\n",\
"\n",\
"\n",\
"	frame $f.frametets\n",\
"	checkbutton $f.frametets.showtets -text \"Show Tets in domain \" \\\n",\
"	    -variable viewoptions.drawtets \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	tixControl $f.frametets.showtetsdomain -label \"\" -integer true \\\n",\
"	    -variable viewoptions.drawtetsdomain -min 0 -max 50 \\\n",\
"	    -options { entry.width 2 } \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	pack $f.frametets\n",\
"	pack $f.frametets.showtets $f.frametets.showtetsdomain -side left\n",\
"\n",\
"\n",\
"	if {$userlevel == 3} {\n",\
"	    pack $f.showcolor    $f.showpyramids $f.showprisms $f.showhexes $f.showidentified\n",\
"\n",\
"	    pack $f.fshrink \n",\
"	    pack $f.fshrink.lab $f.fshrink.scale -side left\n",\
"	}	\n",\
"	\n",\
"	if {$userlevel == 3} {\n",\
"	    frame $f.framecurveproj\n",\
"	    checkbutton $f.framecurveproj.showcurveproj -text \"Show curved edge projection \" \\\n",\
"		-variable viewoptions.drawcurveproj \\\n",\
"		-command { Ng_SetVisParameters; redraw }\n",\
"	    tixControl $f.framecurveproj.showcurveprojedge -label \"\" -integer true \\\n",\
"		-variable viewoptions.drawcurveprojedge -min 1 -max 99999 \\\n",\
"		-options { entry.width 5 } \\\n",\
"		-command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	    pack $f.framecurveproj\n",\
"	    pack $f.framecurveproj.showcurveproj $f.framecurveproj.showcurveprojedge -side left\n",\
"	}\n",\
"	\n",\
"	\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	# light options\n",\
"	set f [$w.nb subwidget light]\n",\
"	\n",\
"	label $f.lab1 -text \"Ambient Light\"\n",\
"	scale $f.scale1 -orient horizontal -length 300 -from 0 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.2 \\\n",\
"	    -command { Ng_SetVisParameters; redraw } -variable  viewoptions.light.amb \n",\
"	label $f.lab2 -text \"Diffuse Light\"\n",\
"	scale $f.scale2 -orient horizontal -length 300 -from 0 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.2 \\\n",\
"	    -command { Ng_SetVisParameters; redraw } -variable  viewoptions.light.diff \n",\
"	label $f.lab3 -text \"Specular Light\"\n",\
"	scale $f.scale3 -orient horizontal -length 300 -from 0 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.2 \\\n",\
"	    -command { Ng_SetVisParameters; redraw } -variable  viewoptions.light.spec \n",\
"	label $f.lab4 -text \"Material Shininess\"\n",\
"	scale $f.scale4 -orient horizontal -length 300 -from 0 -to 128 \\\n",\
"	    -resolution 1  -tickinterval 32 \\\n",\
"	    -command { Ng_SetVisParameters; redraw } -variable  viewoptions.mat.shininess \n",\
"	label $f.lab5 -text \"Material Transparency\"\n",\
"	scale $f.scale5 -orient horizontal -length 300 -from 0 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.2 \\\n",\
"	-command { Ng_SetVisParameters; redraw } -variable  viewoptions.mat.transp \n",\
"	\n",\
"	pack $f.lab1 $f.scale1 $f.lab2 $f.scale2 $f.lab3 $f.scale3 $f.lab4 $f.scale4 $f.lab5 $f.scale5\n",\
"	\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	# edges options\n",\
"	set f [$w.nb subwidget edges]\n",\
"\n",\
"	checkbutton $f.showedges -text \"Show Edges\" \\\n",\
"	    -variable viewoptions.drawededges \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	checkbutton $f.showpoints -text \"Show Points\" \\\n",\
"	    -variable viewoptions.drawedpoints \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	checkbutton $f.showpointnrs -text \"Show Points Nrs\" \\\n",\
"	    -variable viewoptions.drawedpointnrs \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	checkbutton $f.showtang -text \"Show CP Tangents\" \\\n",\
"	    -variable viewoptions.drawedtangents \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	checkbutton $f.drawedgenrs -text \"Show Edge Nrs\" \\\n",\
"	    -variable viewoptions.drawededgenrs \\\n",\
"	    -command { Ng_SetVisParameters; redraw }\n",\
"	\n",\
"	pack $f.showedges $f.showpoints $f.showpointnrs $f.showtang $f.drawedgenrs\n",\
"\n",\
"	frame $f.center -relief groove -borderwidth 3\n",\
"	pack $f.center -fill x\n",\
"	button $f.center.lab -text \"Set Center Point\" \\\n",\
"	    -command { Ng_SetVisParameters; Ng_Center; redraw }\n",\
"	entry $f.center.ent -width 5 -relief sunken \\\n",\
"	    -textvariable viewoptions.centerpoint \n",\
"	pack $f.center.ent $f.center.lab -side left  -expand yes\n",\
"	\n",\
"\n",\
"\n",\
"	frame $f.f1\n",\
"	pack $f.f1 -pady 5\n",\
"	label $f.f1.lab -text \"SpecPoint Veclen\"\n",\
"	entry $f.f1.ent -width 5 -relief sunken -textvariable viewoptions.specpointvlen\n",\
"	pack $f.f1.lab $f.f1.ent\n",\
"	\n",\
"\n",\
"\n",\
"\n",\
"	\n",\
"	frame $w.bu\n",\
"	pack $w.bu -fill x -ipady 3\n",\
"\n",\
"\n",\
"	button $w.bu.done -text \"Done\" -command {\n",\
"	    Ng_SetVisParameters;\n",\
"	    redraw\n",\
"	    destroy .viewopts_dlg\n",\
"	}\n",\
"	button $w.bu.apply -text \"Apply\" -command {\n",\
"	    Ng_SetVisParameters;\n",\
"	    redraw\n",\
"	}\n",\
"	pack $w.bu.apply $w.bu.done -expand yes -side left\n",\
"	\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Viewing options\"\n",\
"	focus $w\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#\n",\
"#  clipping dialog\n",\
"#\n",\
"# \n",\
"proc clippingdialog { } {\n",\
"\n",\
"    set w .clipping_dlg\n",\
"    \n",\
"    if {[winfo exists .clipping_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"\n",\
"	toplevel $w\n",\
"\n",\
"\n",\
"	label $w.lab1 -text \"Normal x\"\n",\
"	scale $w.scale1 -orient horizontal -length 300 -from -1 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.5 \\\n",\
"	    -variable  viewoptions.clipping.nx \\\n",\
"	    -command { \n",\
"		Ng_SetVisParameters; \n",\
"		if { ${viewoptions.clipping.enable} == 1 } { redraw };\n",\
"		Ng_SetVisParameters }\n",\
"	label $w.lab2 -text \"Normal y\"\n",\
"	scale $w.scale2 -orient horizontal -length 300 -from -1 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.5 \\\n",\
"	    -variable  viewoptions.clipping.ny \\\n",\
"	    -command { \n",\
"		Ng_SetVisParameters; \n",\
"		if { ${viewoptions.clipping.enable} == 1 } { redraw }; \n",\
"		Ng_SetVisParameters }\n",\
"	label $w.lab3 -text \"Normal z\"\n",\
"	scale $w.scale3 -orient horizontal -length 300 -from -1 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.5 \\\n",\
"	    -variable  viewoptions.clipping.nz \\\n",\
"	    -command { \n",\
"		Ng_SetVisParameters; \n",\
"		if { ${viewoptions.clipping.enable} == 1 } { redraw }; \n",\
"		Ng_SetVisParameters }\n",\
"	label $w.lab4 -text \"Distance\"\n",\
"	scale $w.scale4 -orient horizontal -length 300 -from -1 -to 1.001 \\\n",\
"	    -resolution 0.0001  -tickinterval 0.5 \\\n",\
"	    -variable  viewoptions.clipping.dist \\\n",\
"	    -command { \n",\
"		Ng_SetVisParameters; \n",\
"		if { ${viewoptions.clipping.enable} == 1 } { redraw }; \n",\
"		Ng_SetVisParameters }	\n",\
"	\n",\
"	pack $w.lab1 $w.scale1 $w.lab2 $w.scale2 $w.lab3 $w.scale3 $w.lab4 $w.scale4 \n",\
"\n",\
"	\n",\
"	checkbutton $w.cb1 -text \"Enable clipping\" \\\n",\
"	    -variable viewoptions.clipping.enable \\\n",\
"	    -command { Ng_SetVisParameters; redraw } \n",\
"	\n",\
"	pack $w.cb1\n",\
"	\n",\
"\n",\
"	\n",\
"	frame $w.bu\n",\
"#	pack $w.bu -fill x\n",\
"	pack $w.bu -fill x -ipady 3\n",\
"\n",\
"	button $w.bu.cancle -text \"Done\" -command \"destroy $w\"\n",\
"	pack $w.bu.cancle  -expand yes\n",\
"	\n",\
"	\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Clipping Plane\"\n",\
"	#    grab $w\n",\
"	focus $w\n",\
"\n",\
"\n",\
"#	$w.scale1 configure -command { puts \"call1b\"; Ng_SetVisParameters; redraw } \n",\
"#	puts \"after\"\n",\
"\n",\
"\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#  refinement dialog\n",\
"#\n",\
"#\n",\
"proc refinementdialog { } {\n",\
"\n",\
"    set w .refinement_dlg\n",\
"    \n",\
"    if {[winfo exists .refinement_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"\n",\
"	toplevel $w\n",\
"\n",\
"	\n",\
"	tixControl $w.meshsize -label \"max mesh-size: \" -integer false \\\n",\
"	    -variable options.meshsize -min 1e-6 -max 1e6 \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	pack $w.meshsize\n",\
"\n",\
"	global localh\n",\
"	set localh 1\n",\
"	tixControl $w.loch -label \"local mesh-size: \" -integer false \\\n",\
"	    -variable localh -min 1e-6 -max 1e6 \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"	\n",\
"	pack $w.loch\n",\
"	\n",\
"	\n",\
"	button $w.restface -text \"Restrict H at face\"  \\\n",\
"	    -command {\n",\
"		.refinement_dlg.meshsize invoke\n",\
"		.refinement_dlg.loch invoke\n",\
"		Ng_RestrictH face $localh\n",\
"	    }\n",\
"	button $w.restedge -text \"Restrict H at edge\"  \\\n",\
"	    -command {\n",\
"		.refinement_dlg.meshsize invoke\n",\
"		.refinement_dlg.loch invoke\n",\
"		Ng_RestrictH edge $localh\n",\
"	    }\n",\
"	button $w.restelement -text \"Restrict H at element\"  \\\n",\
"	    -command {\n",\
"		.refinement_dlg.meshsize invoke\n",\
"		.refinement_dlg.loch invoke\n",\
"		Ng_RestrictH element $localh\n",\
"	    }\n",\
"	button $w.restpoint -text \"Restrict H at point\"  \\\n",\
"	    -command {\n",\
"		.refinement_dlg.meshsize invoke\n",\
"		.refinement_dlg.loch invoke\n",\
"		Ng_RestrictH point $localh\n",\
"	    }\n",\
"\n",\
"\n",\
"	pack $w.restface $w.restedge $w.restelement $w.restpoint\n",\
"\n",\
"\n",\
"\n",\
"	button $w.anisoedge -text \"Declare Anisotropic edge\"  \\\n",\
"	    -command {\n",\
"		Ng_Anisotropy edge \n",\
"	    }\n",\
"	pack $w.anisoedge\n",\
"	\n",\
"\n",\
"	frame $w.bu\n",\
"	pack $w.bu -fill x -ipady 3\n",\
"\n",\
"\n",\
"	button $w.bu.cancle -text \"Done\" -command \"destroy .refinement_dlg\"\n",\
"	button $w.bu.refine -text \"Refine\"  \\\n",\
"	    -command { \n",\
"#		Ng_BisectCopyMesh; \n",\
"		set oldnp 0; set newnp $status_np; \n",\
"		while { $oldnp < $newnp } {\n",\
"		    set level [expr $level+1]\n",\
"		    Ng_Bisect; \n",\
"		    Ng_HighOrder ${options.elementorder}\n",\
"		    Ng_ReadStatus;\n",\
"		redraw; \n",\
"		    set oldnp $newnp\n",\
"		    set newnp $status_np\n",\
"		    puts \"oldnp $oldnp newnp $newnp\"\n",\
"		}\n",\
"	    }	 \n",\
"	button $w.bu.zrefine -text \"Z-Refine\"  \\\n",\
"	    -command { Ng_ZRefinement; Ng_ReadStatus; redraw; }\n",\
"   \n",\
"	pack $w.bu.zrefine $w.bu.refine $w.bu.cancle  -expand yes -side left\n",\
"		\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Select Refinement\"\n",\
"	focus $w\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#  boundcondessing dialog\n",\
"#\n",\
"#\n",\
"proc bcpropdialog { } {\n",\
"\n",\
"    set w .bcprop_dlg\n",\
"    \n",\
"    if {[winfo exists .bcprop_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"    } {\n",\
"	toplevel $w\n",\
"	\n",\
"	frame $w.face  -borderwidth 3\n",\
"	pack $w.face -fill x\n",\
"	label $w.face.lab -text \"face index:\"\n",\
"	label $w.face.ent -text 1 -padx 4\n",\
"	button $w.face.next -text \"next\" -command {\n",\
"	    set w .bcprop_dlg;	\n",\
"	    set facenr [$w.face.ent cget -text]\n",\
"	    if {$facenr == [Ng_BCProp getnfd]} {\n",\
"		set facenr 1 \n",\
"	    } {\n",\
"		set facenr [expr $facenr + 1]\n",\
"	    }\n",\
"	    $w.face.ent configure -text $facenr\n",\
"	    Ng_BCProp setactive $facenr\n",\
"	    set bcnr [Ng_BCProp getbc $facenr]\n",\
"	    $w.bc.ent delete 0 end\n",\
"	    $w.bc.ent insert 0 $bcnr\n",\
"\n",\
"	    redraw\n",\
"	} \n",\
"	button $w.face.prev -text \"prev\" -command {\n",\
"	    set w .bcprop_dlg;	\n",\
"	    set facenr [$w.face.ent cget -text]\n",\
"	    if {$facenr == 1} {\n",\
"		set facenr [Ng_BCProp getnfd]\n",\
"	    } {\n",\
"		set facenr [expr $facenr - 1]\n",\
"	    }\n",\
"	    $w.face.ent configure -text $facenr\n",\
"	    Ng_BCProp setactive $facenr\n",\
"	    set bcnr [Ng_BCProp getbc $facenr]\n",\
"	    $w.bc.ent delete 0 end\n",\
"	    $w.bc.ent insert 0 $bcnr\n",\
"\n",\
"	    redraw\n",\
"	} \n",\
"	\n",\
"	\n",\
"	pack $w.face.lab $w.face.ent $w.face.prev $w.face.next  -side left  \n",\
"	\n",\
"	frame $w.bc  -borderwidth 3\n",\
"	pack $w.bc -fill x\n",\
"	label $w.bc.lab -text \"bc property:\"\n",\
"	entry $w.bc.ent -width 5 -relief sunken \n",\
"	button $w.bc.but -text \"change\" -command { \n",\
"	    set w .bcprop_dlg;	    \n",\
"	    Ng_BCProp setbc [$w.face.ent cget -text] [$w.bc.ent get]; \n",\
"	}\n",\
"	button $w.bc.but2 -text \"all\" -command { \n",\
"	    set w .bcprop_dlg;	    \n",\
"	    Ng_BCProp setall [$w.bc.ent get]; \n",\
"	}\n",\
"	pack $w.bc.lab $w.bc.ent $w.bc.but $w.bc.but2 -side left  -expand yes\n",\
"	\n",\
"\n",\
"	frame $w.bu\n",\
"	pack $w.bu -fill x -ipady 3\n",\
"\n",\
"	button $w.bu.close -text \"Close\" -command { destroy .bcprop_dlg }\n",\
"\n",\
"	pack $w.bu.close  -expand yes -side left\n",\
"		\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Boundary Conditions\"\n",\
"    }\n",\
"\n",\
"    focus $w \n",\
"\n",\
"    set facenr [Ng_BCProp getactive]\n",\
"    $w.face.ent configure -text $facenr\n",\
"    \n",\
"    set bcnr [Ng_BCProp getbc $facenr]\n",\
"    $w.bc.ent delete 0 end\n",\
"    $w.bc.ent insert 0 $bcnr\n",\
"\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#  METIS dialog\n",\
"#\n",\
"#\n",\
"proc METISdialog { } {\n",\
"\n",\
"    set w .metis_dlg\n",\
"    set w.parts 64\n",\
"    \n",\
"    if {[winfo exists .metis_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"    } {\n",\
"	toplevel $w\n",\
"	\n",\
"	frame $w.a -borderwidth 0\n",\
"	frame $w.b -borderwidth 0\n",\
"	pack $w.a $w.b\n",\
"\n",\
"	label $w.a.lab -text \"Number of partitions:\"\n",\
"	entry $w.a.ent -textvariable w.parts -width 4 -relief sunken\n",\
"\n",\
"	button $w.b.start -text \"Start METIS\" -command { \n",\
"	    Ng_Metis ${w.parts}\n",\
"	    redraw\n",\
"	}\n",\
"	button $w.b.cancel -text \"Cancel\" -command { destroy .metis_dlg }\n",\
"	pack $w.a.lab $w.a.ent -side left  -expand yes\n",\
"	pack $w.b.start $w.b.cancel -side left\n",\
"\n",\
"\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"METIS Partitioning\"\n",\
"	focus $w\n",\
" \n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#  STL dialog\n",\
"#\n",\
"proc stloptionsdialog { } {\n",\
"\n",\
"    set w .stlopts_dlg\n",\
"    \n",\
"    if {[winfo exists .stlopts_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"	toplevel $w\n",\
"\n",\
"	tixNoteBook $w.nb -ipadx 6 -ipady 6\n",\
"	#	$w config -bg gray\n",\
"	#	$w.nb subwidget nbframe config -backpagecolor gray\n",\
"	\n",\
"	# Create the two tabs on the notebook. The -underline option\n",\
"	# puts a underline on the first character of the labels of the tabs.\n",\
"	# Keyboard accelerators will be defined automatically according\n",\
"	# to the underlined character.	\n",\
"	#\n",\
"	\n",\
"# 	$w.nb add chartopt -label \"Chart Options\" -underline 0\n",\
"# 	#$w.nb add meshsize   -label \"Mesh Size\"   -underline 0\n",\
"# 	pack $w.nb -expand yes -fill both -padx 5 -pady 5 -side top	\n",\
"\n",\
"\n",\
"# 	set f [$w.nb subwidget chartopt]\n",\
"\n",\
"\n",\
"# 	label $f.lab1 -text \"Yellow Edges Angle ()\"\n",\
"# 	scale $f.scale1 -orient horizontal -length 300 \\\n",\
"# 	    -from 0 -to 90 -resolution 1  -tickinterval 10 \\\n",\
"# 	    -variable  stloptions.yangle \n",\
"\n",\
"# 	pack $f.lab1 $f.scale1\n",\
"\n",\
"# 	label $f.lab2e -text \"Edge Corner Angle ()\"\n",\
"# 	scale $f.scale2e -orient horizontal -length 360 -from 0 -to 180 \\\n",\
"# 	    -resolution 1  -tickinterval 20 \\\n",\
"# 	    -variable  stloptions.edgecornerangle \n",\
"# 	pack $f.lab2e $f.scale2e\n",\
"	\n",\
"# 	label $f.lab2 -text \"Chart Angle ()\"\n",\
"# 	scale $f.scale2 -orient horizontal -length 360 -from 0 -to 180 \\\n",\
"# 	    -resolution 1  -tickinterval 20 \\\n",\
"# 	    -variable  stloptions.chartangle \n",\
"# 	pack $f.lab2 $f.scale2\n",\
"	\n",\
"# 	label $f.lab2b -text \"Outer Chart Angle ()\"\n",\
"# 	scale $f.scale2b -orient horizontal -length 360 -from 0 -to 180 \\\n",\
"# 	    -resolution 1  -tickinterval 20 \\\n",\
"# 	    -variable  stloptions.outerchartangle \n",\
"# 	pack $f.lab2b $f.scale2b\n",\
"	\n",\
"#	frame $f.r4\n",\
"#	pack $f.r4 -anchor w\n",\
"#	scale $f.r4.sc -orient horizontal -length 200 -from 0.1 -to 10 \\\n",\
"#	    -resolution 0.1 -variable stloptions.resthatlasfac\n",\
"#	checkbutton $f.r4.bu -text \"Restrict h for Calc Atlas (Faster)\" \\\n",\
"#	    -variable stloptions.resthatlasenable\n",\
"#	pack $f.r4.sc $f.r4.bu -side left\n",\
"	\n",\
"\n",\
"	#set f [$w.nb subwidget meshsize]\n",\
"\n",\
"	\n",\
"\n",\
"#    checkbutton $w.seat -text \"Use Searchtrees\" \\\n",\
"#	-variable stloptions.usesearchtree\n",\
"#   pack $w.seat\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	frame $w.bu\n",\
"#    pack $w.bu\n",\
"	pack $w.bu -fill x -ipady 3\n",\
"\n",\
"# -fill x\n",\
"\n",\
"    button $w.bu.apply -text \"Apply\" -command { redraw; Ng_GenerateMesh 1 2}\n",\
"	button $w.bu.cancle -text \"Done\" -command { destroy .stlopts_dlg }\n",\
"    pack $w.bu.cancle  $w.bu.apply  -side left -expand yes\n",\
"    \n",\
"\n",\
"    wm withdraw $w\n",\
"    wm geom $w +100+100\n",\
"    wm deiconify $w\n",\
"	wm title $w \"STL Options\"\n",\
"#    grab $w\n",\
"	focus $w\n",\
"    }\n",\
"}\n",\
"\n",\
"proc stldoctordialog { } {\n",\
"\n",\
"#d\n",\
"    set wd .stldoctor_dlg\n",\
"\n",\
"    if {[winfo exists .stldoctor_dlg] == 1} {\n",\
"	wm withdraw $wd\n",\
"	wm deiconify $wd\n",\
"	focus $wd \n",\
"    } {\n",\
"	\n",\
"    toplevel $wd\n",\
"\n",\
"    tixNoteBook $wd.nb -ipadx 6 -ipady 6\n",\
"	\n",\
"    $wd.nb add general -label \"General\" -underline 0\n",\
"    $wd.nb add topology -label \"Edit Topology\"  -underline 5\n",\
"    $wd.nb add edges -label \"Edit Edges\"   -underline 5\n",\
"    $wd.nb add normals -label \"Edit Normals\"   -underline 5\n",\
"    $wd.nb add advanced -label \"Advanced\"   -underline 0\n",\
"\n",\
"\n",\
"    pack $wd.nb -expand yes -fill both -padx 5 -pady 5 -side top	\n",\
"\n",\
"\n",\
"    # GENERAL *****************************\n",\
"\n",\
"    set f [$wd.nb subwidget general]\n",\
"\n",\
"\n",\
"    frame $f.show\n",\
"    pack $f.show -fill x\n",\
"    checkbutton $f.show.showtrias -text \"Show STL-Triangles\" \\\n",\
"	-variable stloptions.showtrias -command { Ng_SetVisParameters; redraw }\n",\
"    pack $f.show.showtrias -anchor w\n",\
"    \n",\
"    checkbutton $f.show.showfilledtrias -text \"Show Filled Triangles\" \\\n",\
"	-variable stloptions.showfilledtrias -command { Ng_SetVisParameters; redraw }\n",\
"    pack $f.show.showfilledtrias -anchor w\n",\
"\n",\
"    set selmodevals { 0 1 2 3 4 }\n",\
"    set selmodelabs(0) \"triangle\" \n",\
"    set selmodelabs(1) \"edge\" \n",\
"    set selmodelabs(2) \"point\" \n",\
"    set selmodelabs(3) \"line\" \n",\
"    set selmodelabs(4) \"line cluster\" \n",\
"\n",\
"    tixOptionMenu $f.selmode -label \"Double Click selects :\" \\\n",\
"	-options {\n",\
"	    label.width  19\n",\
"	    label.anchor e\n",\
"	    menubutton.width 15\n",\
"	} \n",\
"\n",\
"    foreach selmodev $selmodevals {\n",\
"	$f.selmode add command $selmodev -label $selmodelabs($selmodev)\n",\
"    }\n",\
"    $f.selmode config -variable stldoctor.selectmode\n",\
"    $f.selmode config -command { Ng_STLDoctor }\n",\
"    global stldoctor.selectmode\n",\
"    pack $f.selmode\n",\
"\n",\
"    frame $f.sm\n",\
"    pack $f.sm -fill x\n",\
"    checkbutton $f.sm.bu -text \"select with mouse\" \\\n",\
"	-variable stldoctor.selectwithmouse\n",\
"    pack $f.sm.bu \n",\
"\n",\
"    frame $f.st -relief groove -borderwidth 3\n",\
"    pack $f.st -fill x\n",\
"    label $f.st.lab -text \"Select triangle by number\";\n",\
"    entry $f.st.ent -width 5 -relief sunken \\\n",\
"	-textvariable stldoctor.selecttrig\n",\
"    pack $f.st.ent $f.st.lab -side left -expand yes\n",\
"\n",\
"    frame $f.vc -relief groove -borderwidth 3\n",\
"    pack $f.vc -fill x\n",\
"    checkbutton $f.vc.bu -text \"show vicinity\" \\\n",\
"	-variable stldoctor.showvicinity \\\n",\
"	-command {Ng_STLDoctor vicinity; redraw}\n",\
"    label $f.vc.lab -text \"vicinity size\";\n",\
"    scale $f.vc.sc -orient horizontal -length 200 -from 0 -to 200 \\\n",\
"	-resolution 1 -variable stldoctor.vicinity \\\n",\
"	-command { Ng_STLDoctor vicinity; redraw }\n",\
"    pack $f.vc.bu $f.vc.lab $f.vc.sc -expand yes\n",\
"\n",\
"    frame $f.ge -relief groove -borderwidth 3\n",\
"    pack $f.ge -fill x\n",\
"    button $f.ge.neighbourangles -text \"calc neighbourangles\" -command {Ng_STLDoctor neighbourangles}\n",\
"    button $f.ge.showcoords -text \"show coords of touched triangle\" -command {Ng_STLDoctor showcoords}\n",\
"    button $f.ge.moveptm -text \"move point to middle of trianglepoints\" -command {Ng_STLDoctor movepointtomiddle; redraw}\n",\
"    button $f.ge.destroy0trigs -text \"destroy 0-volume triangles\" -command {Ng_STLDoctor destroy0trigs}\n",\
"    pack $f.ge.neighbourangles $f.ge.showcoords $f.ge.moveptm $f.ge.destroy0trigs -expand yes \n",\
"\n",\
"\n",\
"    button $f.ge.cancle -text \"Done\" -command {destroy .stldoctor_dlg }\n",\
"    pack $f.ge.cancle -expand yes\n",\
"\n",\
"    # TOPOLOGY ********************\n",\
"    set f [$wd.nb subwidget topology]\n",\
"\n",\
"    frame $f.oc -relief groove -borderwidth 3\n",\
"    pack $f.oc -fill x\n",\
"    button $f.oc.bu -text \"invert orientation of selected trig\" -command {Ng_STLDoctor invertselectedtrig; redraw }\n",\
"    button $f.oc.bu2 -text \"orient after selected trig\" -command {Ng_STLDoctor orientafterselectedtrig; redraw }\n",\
"    pack $f.oc.bu $f.oc.bu2 -side left  -expand yes\n",\
"\n",\
"    button $f.toperr -text \"mark inconsistent triangles\" -command {Ng_STLDoctor marktoperrortrigs; redraw }\n",\
"\n",\
"    button $f.deltrig -text \"delete selected triangle\" -command {Ng_STLDoctor deleteselectedtrig; redraw }\n",\
"    button $f.geosmooth -text \"geometric smoothing\" -command {Ng_STLDoctor smoothgeometry; redraw }\n",\
"\n",\
"    pack $f.toperr $f.deltrig $f.geosmooth\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"    # EDGES ***********************\n",\
"    set f [$wd.nb subwidget edges]\n",\
"\n",\
"\n",\
"    frame $f.be -relief groove -borderwidth 3 \n",\
"    pack $f.be -fill x\n",\
"    label $f.be.lab -text \"build edges with yellow angle:\";\n",\
"    scale $f.be.sc -orient horizontal -length 200 -from 0 -to 100 \\\n",\
"	-resolution 0.5\n",\
"    $f.be.sc config -variable stloptions.yangle \n",\
"    $f.be.sc config -command { Ng_SetSTLParameters; Ng_STLDoctor buildedges; redraw }\n",\
"    label $f.be.lab2 -text \"continue edges with yellow angle:\";\n",\
"    scale $f.be.sc2 -orient horizontal -length 200 -from 0 -to 100 \\\n",\
"	-resolution 0.5\n",\
"    $f.be.sc2 config -variable stloptions.contyangle \n",\
"    $f.be.sc2 config -command { Ng_SetSTLParameters; Ng_STLDoctor buildedges; redraw }\n",\
"\n",\
"\n",\
"\n",\
"    button $f.be.buildedges -text \"Build Edges\" -command {Ng_STLDoctor buildedges; redraw}\n",\
"    pack $f.be.lab $f.be.sc $f.be.lab2 $f.be.sc2 $f.be.buildedges -expand yes\n",\
"\n",\
"    frame $f.se\n",\
"    pack $f.se -fill x\n",\
"    checkbutton $f.se.bu -text \"show excluded\" \\\n",\
"	-variable stldoctor.showexcluded \\\n",\
"	-command {Ng_STLDoctor; redraw}\n",\
"    pack $f.se.bu \n",\
"\n",\
"    # edgeselectmode ******\n",\
"\n",\
"    set edgeselmodevals { 0 1 2 3 4 }\n",\
"    set edgeselmodelabs(0) \"no change\" \n",\
"    set edgeselmodelabs(1) \"undefined\" \n",\
"    set edgeselmodelabs(2) \"confirmed\" \n",\
"    set edgeselmodelabs(3) \"candidate\"\n",\
"    set edgeselmodelabs(4) \"excluded\"\n",\
"\n",\
"    tixOptionMenu $f.edgeselmode -label \"Double Click sets edge :\" \\\n",\
"	-options {\n",\
"	    label.width  19\n",\
"	    label.anchor e\n",\
"	    menubutton.width 15\n",\
"	} \n",\
"\n",\
"    foreach edgeselmodev $edgeselmodevals {\n",\
"	$f.edgeselmode add command $edgeselmodev -label $edgeselmodelabs($edgeselmodev)\n",\
"    }\n",\
"    $f.edgeselmode config -variable stldoctor.edgeselectmode\n",\
"    $f.edgeselmode config -command { Ng_STLDoctor }\n",\
"    global stldoctor.edgeselectmode\n",\
"    pack $f.edgeselmode\n",\
"\n",\
"    # edge buttons\n",\
"\n",\
"    frame $f.edg -relief groove -borderwidth 3\n",\
"    pack $f.edg -fill x\n",\
"\n",\
"#    checkbutton $f.edg.bu -text \"use external edges\" \\\n",\
"#	-variable stldoctor.useexternaledges \\\n",\
"#	-command {Ng_STLDoctor; redraw}\n",\
"#   pack $f.edg.bu -expand yes\n",\
"\n",\
"\n",\
"    frame $f.edg.f0\n",\
"    pack $f.edg.f0\n",\
"    button $f.edg.f0.confirmedge -text \"confirm\" -command {Ng_STLDoctor confirmedge; redraw}\n",\
"    button $f.edg.f0.candidateedge -text \"candidate\" -command {Ng_STLDoctor candidateedge; redraw}\n",\
"    button $f.edg.f0.excludeedge -text \"exclude\" -command {Ng_STLDoctor excludeedge; redraw}\n",\
"    button $f.edg.f0.undefinededge -text \"undefined\" -command {Ng_STLDoctor undefinededge; redraw}\n",\
"    pack $f.edg.f0.confirmedge $f.edg.f0.candidateedge $f.edg.f0.excludeedge $f.edg.f0.undefinededge  -side left\n",\
"\n",\
"    frame $f.edg.fa\n",\
"    pack $f.edg.fa\n",\
"    button $f.edg.fa.setallundefined -text \"all undefined\" -command {Ng_STLDoctor setallundefinededges; redraw}\n",\
"    button $f.edg.fa.erasecandidates -text \"candidates to undefined\" -command {Ng_STLDoctor erasecandidateedges; redraw}\n",\
"    pack $f.edg.fa.setallundefined $f.edg.fa.erasecandidates -side left\n",\
"\n",\
"\n",\
"    frame $f.edg.fb\n",\
"    pack $f.edg.fb\n",\
"    button $f.edg.fb.confirmcandidates -text \"candidates to confirmed\" -command {Ng_STLDoctor confirmcandidateedges; redraw}\n",\
"    button $f.edg.fb.confirmedtocandidates -text \"confirmed to candidates\" -command {Ng_STLDoctor confirmedtocandidateedges; redraw}\n",\
"    pack $f.edg.fb.confirmcandidates $f.edg.fb.confirmedtocandidates -side left\n",\
"\n",\
"    frame $f.edg.f1\n",\
"    frame $f.edg.f2\n",\
"    frame $f.edg.f3\n",\
"    frame $f.edg.f4\n",\
"    pack $f.edg.f1 $f.edg.f2 $f.edg.f3 $f.edg.f4\n",\
"\n",\
"    button $f.edg.f1.exportedges -text \"export edges\" -command {Ng_STLDoctor exportedges}\n",\
"    button $f.edg.f1.importedges -text \"import edges\" -command {Ng_STLDoctor importedges; redraw}\n",\
"    button $f.edg.f1.saveedgedata -text \"save edgedata\" \\\n",\
"	-command { \n",\
"	    set types {\n",\
"		{\"Netgen Edgedata\"   {.ned} } \n",\
"	    }\n",\
"	    set file [tk_getSaveFile -filetypes $types -defaultextension \".ned\"]\n",\
"	    if {$file != \"\"} {\n",\
"		Ng_STLDoctor saveedgedata $file\n",\
"	}\n",\
"    }\n",\
"\n",\
"    button $f.edg.f1.loadedgedata -text \"load edgedata\" \\\n",\
"	-command { \n",\
"	    set types {\n",\
"		{\"Netgen Edgedata\"  {.ned} }\n",\
"	    }\n",\
"	    set file [tk_getOpenFile -filetypes $types -defaultextension \".ned\"]\n",\
"	    if {$file != \"\"} {\n",\
"		Ng_STLDoctor loadedgedata $file \n",\
"		puts \"loading done\"\n",\
"		\n",\
"		redraw\n",\
"		\n",\
"#		wm title . [concat \"NETGEN - \" $file]\n",\
"	    }\n",\
"	} \n",\
"\n",\
"    button $f.edg.f1.importAVLedges -text \"import AVL edges\" \\\n",\
"	-command {\n",\
"	    set types {{\"Edge file\"  {.edg }}}\n",\
"\n",\
"	    set file [tk_getOpenFile -filetypes $types -defaultextension \".edg\"]\n",\
"	    if {$file != \"\"} {\n",\
"		Ng_STLDoctor importexternaledges $file; \n",\
"	    }\n",\
"	}\n",\
"\n",\
"    pack $f.edg.f1.importAVLedges $f.edg.f1.loadedgedata $f.edg.f1.saveedgedata -side left\n",\
"\n",\
"#    button $f.edg.f1.buildedges -text \"build external edges\" -command {Ng_STLDoctor buildexternaledges; redraw}\n",\
"    frame $f.edg2 -relief groove -borderwidth 3\n",\
"    pack $f.edg2 -fill x\n",\
"\n",\
"\n",\
"#    button $f.edg2.addlonglines -text \"make long lines candidates (% of diam)\" -command {Ng_STLDoctor addlonglines; redraw}\n",\
"    label $f.edg2.lab -text \"length (%):\"\n",\
"    scale $f.edg2.sc -orient horizontal -length 200 -from 0 -to 100 \\\n",\
"	-resolution 0.5 \\\n",\
"        -variable stldoctor.longlinefact \n",\
"\n",\
" #   button $f.edg2.deletedirtyedges -text \"make dirty edges candidates\" -command {Ng_STLDoctor deletedirtyedges; redraw}\n",\
"    button $f.edg2.undoedge -text \"undo last edge change\" -command {Ng_STLDoctor undoedgechange; redraw}\n",\
"    \n",\
" #   pack $f.edg2.addlonglines $f.edg2.deletedirtyedges -expand yes\n",\
" #   pack $f.edg2.lab $f.edg2.sc -side left\n",\
"    pack $f.edg2.undoedge -expand yes\n",\
"\n",\
"\n",\
"\n",\
"    # NORMALS ***********************\n",\
"    set f [$wd.nb subwidget normals]\n",\
"\n",\
"    frame $f.dt -relief groove -borderwidth 3\n",\
"    pack $f.dt -fill x\n",\
"    label $f.dt.lab -text \"dirty triangle factor\";\n",\
"    entry $f.dt.ent -width 5 -relief sunken \\\n",\
"	-textvariable stldoctor.dirtytrigfact\n",\
"    pack $f.dt.ent $f.dt.lab -side left  -expand yes\n",\
"\n",\
"    frame $f.srt -relief groove -borderwidth 3\n",\
"    pack $f.srt -fill x\n",\
"    button $f.srt.bu -text \"smooth reverted triangles geometric\" -command {Ng_STLDoctor smoothrevertedtrigs; redraw }\n",\
"    entry $f.srt.ent -width 5 -relief sunken \\\n",\
"	-textvariable stldoctor.smoothangle\n",\
"    pack $f.srt.ent $f.srt.bu -side left  -expand yes\n",\
"\n",\
"    frame $f.bdt -relief groove -borderwidth 3\n",\
"    pack $f.bdt -fill x\n",\
"    button $f.bdt.bu -text \"mark dirty triangles\" -command {Ng_STLDoctor markdirtytrigs; redraw }\n",\
"    button $f.bdt.bu2 -text \"smooth dirty triangles normal\" -command {Ng_STLDoctor smoothdirtytrigs; redraw }\n",\
"    pack $f.bdt.bu $f.bdt.bu2 -side left  -expand yes\n",\
"\n",\
"    \n",\
"    frame $f.sno -relief groove -borderwidth 3\n",\
"    pack $f.sno\n",\
"    \n",\
"    label $f.sno.labrough -text \"rough\"\n",\
"    scale $f.sno.scsmooth -orient horizontal -length 100 -from 0 -to 0.8 \\\n",\
"	-resolution 0.01 -variable stldoctor.smoothnormalsweight \\\n",\
"	-command { Ng_SetSTLParameters }\n",\
"    label $f.sno.labsmooth -text \"smooth\"\n",\
"    button $f.sno.smoothnormals -text \"smooth normals\" -command { Ng_STLDoctor smoothnormals; redraw}\n",\
"\n",\
"\n",\
"\n",\
"    pack $f.sno.labrough $f.sno.scsmooth $f.sno.labsmooth $f.sno.smoothnormals -side left -padx 5\n",\
"\n",\
"    frame $f.no -relief groove -borderwidth 3\n",\
"    pack $f.no -fill x\n",\
"\n",\
"    button $f.no.marknonsmoothnormals -text \"mark non-smooth triangles\" -command {Ng_STLDoctor marknonsmoothnormals; redraw}\n",\
"    button $f.no.calcnormals -text \"calculate normals from geometry\" -command {Ng_STLDoctor calcnormals; redraw}\n",\
"\n",\
"    pack  $f.no.marknonsmoothnormals $f.no.calcnormals -expand yes\n",\
"\n",\
"\n",\
"    # ADVANCED **************************\n",\
"    set f [$wd.nb subwidget advanced]\n",\
"\n",\
"\n",\
"    frame $f.sc\n",\
"    pack $f.sc -fill x\n",\
"    checkbutton $f.sc.bu -text \"spiral check\" \\\n",\
"	-variable stldoctor.spiralcheck \\\n",\
"	-command {Ng_STLDoctor;}    \n",\
"    checkbutton $f.sc.bu2 -text \"cone check\" \\\n",\
"	-variable stldoctor.conecheck \\\n",\
"	-command {Ng_STLDoctor;}    \n",\
"    pack $f.sc.bu $f.sc.bu2\n",\
"\n",\
"\n",\
"    tixControl $f.gtol -label \"load-geometry tolerance factor\" -integer false \\\n",\
"	-variable stldoctor.geom_tol_fact \\\n",\
"	-options {\n",\
"	    entry.width 8\n",\
"	    label.width 30\n",\
"	    label.anchor e\n",\
"	}	\n",\
"    pack $f.gtol\n",\
"\n",\
"    button $f.adap -text \"Apply\" -command {\n",\
"	[.stldoctor_dlg.nb subwidget advanced].gtol invoke\n",\
"	Ng_STLDoctor; \n",\
"    }\n",\
"    pack $f.adap -expand yes\n",\
"\n",\
"#    frame $f.gtol -relief groove -borderwidth 3\n",\
"#    pack $f.gtol -fill x\n",\
"#    label $f.gtol.lab -text \"Geometry-Load-Tolerance-Factor\";\n",\
"#    entry $f.gtol.ent -width 5 -relief sunken \\\n",\
"#	-textvariable stldoctor.geom_tol_fact\n",\
"#   pack $f.gtol.lab $f.gtol.ent -side left -expand yes\n",\
"\n",\
"    #*******************************    \n",\
"    wm withdraw $wd\n",\
"    wm geom $wd +100+100\n",\
"    wm deiconify $wd\n",\
"    wm title $wd \"STL Doctor\"\n",\
"\n",\
"    focus $wd\n",\
"}\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc meshdoctordialog { } {\n",\
"\n",\
"    set w .meshdoc_dlg\n",\
"    global meshdoctor.active\n",\
"\n",\
"    if {[winfo exists .meshdoc_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"	toplevel $w\n",\
"\n",\
"	set meshdoctor.active 1\n",\
"	Ng_MeshDoctor;\n",\
"\n",\
"\n",\
"	frame $w.vis -relief groove -borderwidth 3\n",\
"	pack $w.vis\n",\
"\n",\
"	checkbutton $w.vis.showfilledtrigs -text \"Show filled triangles\" \\\n",\
"	-variable viewoptions.drawfilledtrigs \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"	\n",\
"	checkbutton $w.vis.showedges -text \"Show edges\" \\\n",\
"	-variable viewoptions.drawedges \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"	\n",\
"\n",\
"	checkbutton $w.vis.showoutline -text \"Show Triangle Outline\" \\\n",\
"	-variable viewoptions.drawoutline \\\n",\
"	-command { Ng_SetVisParameters; redraw }\n",\
"\n",\
"	pack $w.vis.showfilledtrigs  $w.vis.showoutline $w.vis.showedges\n",\
"\n",\
"	tixControl $w.markedgedist -label \"Mark edge dist: \" -integer true \\\n",\
"	    -min 0 -max 999  \\\n",\
"	    -variable meshdoc.markedgedist \\\n",\
"	    -options {\n",\
"		entry.width 3\n",\
"		label.width 20\n",\
"		label.anchor e\n",\
"	    } \\\n",\
"	    -command {\n",\
"		Ng_MeshDoctor markedgedist ${meshdoc.markedgedist}\n",\
"		redraw\n",\
"	    }\n",\
"	pack $w.markedgedist\n",\
"	\n",\
"	button $w.deledge -text \"Delete marked segments\" -command {\n",\
"	    Ng_MeshDoctor deletemarkedsegments\n",\
"	    redraw\n",\
"	}\n",\
"	pack $w.deledge\n",\
"	\n",\
"	button $w.close -text \"Close\" -command { \n",\
"	    set meshdoctor.active 0;\n",\
"	    Ng_MeshDoctor;\n",\
"	    destroy .meshdoc_dlg \n",\
"	}\n",\
"	pack $w.close -expand yes\n",\
"	\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Mesh Doctor\"\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#  Quality viewer\n",\
"#\n",\
"proc qualityviewdialog { show } {\n",\
"\n",\
"    set w .qualityview_dlg\n",\
"    \n",\
"    if {[winfo exists .qualityview_dlg] == 1} {\n",\
"\n",\
"	if { $show == 1 } {\n",\
"	    wm withdraw .qualityview_dlg\n",\
"	    wm deiconify $w\n",\
"	    focus $w \n",\
"	} {\n",\
"	    wm withdraw $w\n",\
"	}\n",\
"    } {\n",\
"	toplevel $w\n",\
"	\n",\
"	set c $w.c\n",\
"\n",\
"	canvas $c -relief raised -width 450 -height 300\n",\
"	pack $w.c -side top -fill x\n",\
"\n",\
"	set plotFont {Helvetica 18}\n",\
"	set smallFont {Helvetica 12}\n",\
"\n",\
"	$c create line 100 250 400 250 -width 2\n",\
"	$c create line 100 250 100 50 -width 2\n",\
"\n",\
"	for {set i 0} {$i <= 10} {incr i} {\n",\
"	    set x [expr {100 + ($i*30)}]\n",\
"	    $c create line $x 250 $x 245 -width 2\n",\
"	    if { [expr {$i % 2}] == 0 } {\n",\
"		$c create text $x 254 -text [expr 0.1*$i] -anchor n -font $plotFont\n",\
"	    }\n",\
"	}\n",\
"\n",\
"	global qualbar\n",\
"	global qualbarnull\n",\
"	global qualbaraxis\n",\
"\n",\
"	for {set i 0} {$i <= 5} {incr i} {\n",\
"	    set y [expr {250 - ($i*40)}]\n",\
"	    $c create line 100 $y 105 $y -width 2\n",\
"\n",\
"	    global qualbaraxis($i)\n",\
"	    set qualbaraxis($i) \\\n",\
"		[$c create text 96 $y -text [expr $i*50].0 -anchor e -font $plotFont]\n",\
"	}\n",\
"\n",\
"	for {set i 0} {$i < 20} {incr i} {\n",\
"	    set x1 [expr {100 + ($i*15) + 2}]\n",\
"	    set x2 [expr {$x1+10}]\n",\
"	    set y [expr {250 - 10 * $i}]\n",\
"	    global qualbar($i)\n",\
"	    set qualbar($i) [$c create rectangle $x1 250 $x2 245 -fill blue]\n",\
"	    set qualbarnull($i) [$c create text [expr {($x1+$x2)/2}] 245 -text 0 -anchor s -font $smallFont -fill blue]	\n",\
"	}\n",\
"\n",\
"	frame $w.bu\n",\
"	pack $w.bu\n",\
"	# -fill x\n",\
"	\n",\
"	button $w.close -text \"Close\" \\\n",\
"	    -command { \n",\
"		wm withdraw .qualityview_dlg\n",\
"		set viewqualityplot 0\n",\
"	    }\n",\
"	pack $w.close\n",\
"    \n",\
"	\n",\
"	if { $show == 1 } {\n",\
"	    wm withdraw $w\n",\
"	    wm geom $w +100+100\n",\
"	    wm deiconify $w\n",\
"	    wm title $w \"Mesh Quality\"\n",\
"	    focus $w\n",\
"	}\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"#\n",\
"#  STL INFO dialog\n",\
"#\n",\
"proc STLinfodialog { show } {\n",\
"\n",\
"    set w .STLinfo_dlg\n",\
"    \n",\
"    if {[winfo exists .STLinfo_dlg] == 1} {\n",\
"\n",\
"	if { $show == 1 } {\n",\
"	    wm withdraw .STLinfo_dlg\n",\
"	    wm deiconify $w\n",\
"	    focus $w \n",\
"	} {\n",\
"	    wm withdraw $w\n",\
"	}\n",\
"    } {\n",\
"	toplevel $w\n",\
"	\n",\
"	set c $w.c\n",\
"\n",\
"	canvas $c -relief raised -width 450 -height 300\n",\
"	pack $w.c -side top -fill x\n",\
"\n",\
"	set plotFont {Helvetica 18}\n",\
"	set smallFont {Helvetica 12}\n",\
"\n",\
"	$c create line 100 250 400 250 -width 2\n",\
"	$c create line 100 250 100 50 -width 2\n",\
"\n",\
"	frame $w.bu\n",\
"	pack $w.bu\n",\
"	# -fill x\n",\
"	\n",\
"	button $w.close -text \"Close\" \\\n",\
"	    -command { \n",\
"		wm withdraw .STLinfo_dlg\n",\
"		#set STLinfoopen 0\n",\
"	    }\n",\
"	pack $w.close\n",\
"    \n",\
"	\n",\
"	if { $show == 1 } {\n",\
"	    wm withdraw $w\n",\
"	    wm geom $w +100+100\n",\
"	    wm deiconify $w\n",\
"	    wm title $w \"STL Geometry Info\"\n",\
"	    focus $w\n",\
"	}\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#\n",\
"#   Edit primitive\n",\
"#\n",\
"#\n",\
"proc editprimitivedialog2 { name } {\n",\
"\n",\
"    global w classname\n",\
"\n",\
"    set w .ep_dlg\n",\
"    toplevel .$w\n",\
"\n",\
"    Ng_GetPrimitiveData $name classname valuelist\n",\
"        \n",\
"    \n",\
"    label $w.lab1 -text \"Primitive Name:  $name\";\n",\
"    label $w.lab2 -text \"Primitive Class: $classname\";\n",\
"    pack $w.lab1 $w.lab2 -fill x -pady 1m -padx 5m \n",\
"    \n",\
"    frame $w.specific -relief groove\n",\
"\n",\
"    global spec\n",\
"    set spec(sphere) { cx cy cz rad }\n",\
"    set spec(cylinder) { ax ay az bx by bz rad }\n",\
"    set spec(plane) { px py pz nx ny nz }\n",\
"    set spec(cone) { ax ay az bx by bz ra rb }\n",\
"    set spec(brick) { p1x p1y p1z p2x p2y p2z p3x p3y p3z p4x p4y p4z } \n",\
"   \n",\
"    set cnt 0\n",\
"    foreach field $spec($classname) {\n",\
"\n",\
"	frame $w.specific.f$cnt \n",\
"	pack $w.specific.f$cnt -side top -anchor ne\n",\
"\n",\
"	label $w.specific.f$cnt.lab -text \"$field\"\n",\
"	entry $w.specific.f$cnt.ent -textvariable dataval($cnt) \\\n",\
"	    -width 6 -relief sunken\n",\
"	pack $w.specific.f$cnt.ent $w.specific.f$cnt.lab -side right\n",\
"	$w.specific.f$cnt.ent delete 0 end\n",\
"	$w.specific.f$cnt.ent insert 0 [lindex $valuelist $cnt]\n",\
"	set cnt [expr $cnt + 1]\n",\
"    }\n",\
"    pack $w.specific\n",\
"\n",\
"\n",\
"    button $w.cancel -text \"cancel\" -command {\n",\
"	destroy $w \n",\
"    }\n",\
"\n",\
"    button $w.ok -text \"ok\" -command {\n",\
"\n",\
"	set valuelist \"\"\n",\
"	set cnt 0\n",\
"	foreach field $spec($classname) {\n",\
"	    lappend valuelist $dataval($cnt)\n",\
"	    set cnt [expr $cnt + 1]\n",\
"	}\n",\
"	Ng_SetPrimitiveData $name $valuelist\n",\
"	destroy $w\n",\
"    }\n",\
"    pack  $w.cancel $w.ok -side left -expand yes\n",\
"\n",\
"    bind $w <Return> { $w.ok  invoke}\n",\
"    bind $w <Escape> { $w.cancel  invoke}\n",\
"    \n",\
"\n",\
"    wm withdraw $w\n",\
"    wm geom $w +100+100\n",\
"    wm deiconify $w\n",\
"\n",\
"#    grab $w\n",\
"    focus $w.specific.f0.ent\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#\n",\
"#      Select primitve to edit\n",\
"#\n",\
"#\n",\
"\n",\
"proc editprimitivedialog { } {\n",\
"    global w\n",\
"\n",\
"    set w .ep_dlg\n",\
"    toplevel $w\n",\
"\n",\
"    frame $w.frame -borderwidth 5m\n",\
"    pack $w.frame -side top -expand yes -fill y\n",\
"\n",\
"    listbox $w.frame.list -yscroll \"$w.frame.scroll set\" -setgrid 1 -height 12\n",\
"    scrollbar $w.frame.scroll -command \"$w.frame.list yview\"\n",\
"    pack $w.frame.scroll -side right -fill y\n",\
"    pack $w.frame.list -side left -expand 1 -fill both\n",\
"    \n",\
"\n",\
"    Ng_GetPrimitiveList primlist\n",\
"    foreach el $primlist {\n",\
"	$w.frame.list insert end $el }\n",\
"\n",\
"    button $w.cancel -text \"cancel\" -command { destroy $w }\n",\
"    button $w.ok -text \"ok\" -command {\n",\
"	set name [.ep_dlg.frame.list get active]\n",\
"	puts \"name=($name)\"\n",\
"	destroy $w\n",\
"	if { $name != \"\" } { editprimitivedialog2 $name }\n",\
"    }\n",\
"    \n",\
"    bind $w <Escape> { $w.cancel invoke }\n",\
"    bind $w <Return> { $w.ok invoke }\n",\
"    \n",\
"\n",\
"    pack  $w.cancel $w.ok -side left -expand yes\n",\
"\n",\
"    wm withdraw $w\n",\
"    wm geom $w +100+100\n",\
"    wm deiconify $w\n",\
"\n",\
"#    grab $w\n",\
"    focus $w.frame.list\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#\n",\
"#         Create new primitive\n",\
"#\n",\
"#\n",\
"proc newprimitivedialog { } {\n",\
"\n",\
"    global w name\n",\
"\n",\
"    set w .ap_dlg\n",\
"    \n",\
"    toplevel $w\n",\
"\n",\
"    set name \"\"\n",\
"    frame $w.f1\n",\
"    pack $w.f1 -pady 2m\n",\
"    label $w.f1.lab -text \"Primitive Name: \";\n",\
"    entry $w.f1.ent -width 5 -relief sunken \\\n",\
"	-textvariable name\n",\
"    pack $w.f1.lab $w.f1.ent -side left\n",\
"    \n",\
"    frame $w.frame -borderwidth .5c\n",\
"    pack $w.frame -side top -expand yes -fill y\n",\
"\n",\
"    listbox $w.frame.list -yscroll \"$w.frame.scroll set\" -setgrid 1 -height 8 \n",\
"    scrollbar $w.frame.scroll -command \"$w.frame.list yview\"\n",\
"    pack $w.frame.scroll -side right -fill y\n",\
"    pack $w.frame.list -side left -expand 1 -fill both\n",\
"    \n",\
"    $w.frame.list insert 0 sphere cylinder plane cone brick\n",\
"    $w.frame.list activate 0\n",\
"    \n",\
"    button $w.ok -text \"ok\" -command {\n",\
"	Ng_CreatePrimitive [$w.frame.list get active]  $name\n",\
"	destroy $w\n",\
"	editprimitivedialog2 $name\n",\
"    }\n",\
"\n",\
"    button $w.cancel -text \"cancel\" -command {\n",\
"	destroy $w\n",\
"    }\n",\
"    \n",\
"    pack  $w.cancel $w.ok -side left -expand yes -pady 2m\n",\
"\n",\
"\n",\
"    bind $w <Escape> { $w.cancel invoke }\n",\
"    bind $w <Return> { $w.ok invoke }\n",\
"\n",\
"    wm withdraw $w\n",\
"    wm geom $w +100+100\n",\
"    wm deiconify $w\n",\
"\n",\
"#    grab $w\n",\
"    focus $w.f1.ent\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc newsoliddialog { } {\n",\
"\n",\
"    global w name val sollist\n",\
"\n",\
"    set w .ns_dlg\n",\
"    toplevel $w\n",\
"\n",\
"    set name \"\"\n",\
"    frame $w.f1\n",\
"    label $w.f1.lab -text \"Solid Name: \";\n",\
"    entry $w.f1.ent -width 5 -relief sunken \\\n",\
"	-textvariable name\n",\
"    $w.f1.ent delete 0 end\n",\
"    button $w.f1.getsel -text \"Get Selected\" -command { \n",\
"	$w.f1.ent delete 0 end\n",\
"	$w.f1.ent insert 0 [$w.f3.list get active]\n",\
"	$w.bu.get invoke\n",\
"    }\n",\
"    pack $w.f1.getsel -side bottom\n",\
"    pack $w.f1.ent $w.f1.lab -side right\n",\
"\n",\
"\n",\
"    frame $w.f3 -borderwidth .5c\n",\
"    listbox $w.f3.list -yscroll \"$w.f3.scroll set\" -setgrid 1 -height 12\n",\
"    scrollbar $w.f3.scroll -command \"$w.f3.list yview\"\n",\
"    pack $w.f3.scroll -side right -fill y\n",\
"    pack $w.f3.list -side left -expand 1 -fill both\n",\
"    \n",\
"    Ng_GetSolidList sollist\n",\
"    foreach el $sollist {\n",\
"	$w.f3.list insert end $el }\n",\
"\n",\
"    frame $w.f2\n",\
"    label $w.f2.lab -text \"Solid Description: \";\n",\
"    pack $w.f2.lab\n",\
"\n",\
"\n",\
"    entry $w.f2.ent -width 100 -relief sunken \\\n",\
"	-textvariable val  -xscrollcommand \"$w.f2.scr set\"\n",\
"    scrollbar $w.f2.scr -relief sunken -orient horiz -command \\\n",\
"	\"$w.f2.ent xview\"\n",\
"    $w.f2.ent delete 0 end\n",\
"    pack $w.f2.ent $w.f2.scr -fill x\n",\
"\n",\
"\n",\
"\n",\
"    frame $w.bu\n",\
"    button $w.bu.close -text \"close\" -command {\n",\
"	destroy $w\n",\
"    }\n",\
"\n",\
"    button $w.bu.get -text \"get data\" -command {\n",\
"	Ng_GetSolidData $name val\n",\
"    }\n",\
"\n",\
"    button $w.bu.set -text \"set data\" -command {\n",\
"	Ng_SetSolidData $name $val\n",\
"    }\n",\
"\n",\
"    pack $w.bu.get $w.bu.set $w.bu.close -side left \n",\
"\n",\
"\n",\
"    pack $w.bu -pady 5 -side bottom                     ;# buttons\n",\
"    pack $w.f2 -pady 5 -side bottom                     ;# edit field\n",\
"    pack $w.f1 -pady 5 -side left                       ;# name\n",\
"    pack $w.f3 -side left -expand yes -fill y           ;# listbox\n",\
"\n",\
"\n",\
"\n",\
"    bind $w <Escape> { $w.bu.close invoke }\n",\
"\n",\
"    wm withdraw $w\n",\
"    wm geom $w +100+100\n",\
"    wm deiconify $w\n",\
"\n",\
"#    grab $w\n",\
"    focus $w\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"#\n",\
"#  Edit top level objects\n",\
"#\n",\
"#\n",\
"\n",\
"\n",\
"proc toplevelproperties { w solname surfname } {\n",\
"\n",\
"    global properties\n",\
"\n",\
"    Ng_TopLevel getprop $solname $surfname properties\n",\
"\n",\
"\n",\
"    set w .tlprop_dlg\n",\
"\n",\
"    if {[winfo exists $w] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"	toplevel $w\n",\
"    \n",\
"	label $w.lab1 -text \"Red\"\n",\
"	scale $w.scale1 -orient horizontal -length 300 -from 0 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.2 \\\n",\
"	    -command { Ng_TopLevel setprop $solname $surfname properties; redraw } -variable  properties(red)\n",\
"	\n",\
"	label $w.lab2 -text \"Green\"\n",\
"	scale $w.scale2 -orient horizontal -length 300 -from 0 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.2 \\\n",\
"	-command { Ng_TopLevel setprop $solname $surfname properties; redraw } -variable  properties(green)\n",\
"	\n",\
"	label $w.lab3 -text \"Blue\"\n",\
"	scale $w.scale3 -orient horizontal -length 300 -from 0 -to 1 \\\n",\
"	    -resolution 0.01  -tickinterval 0.2 \\\n",\
"	    -command { Ng_TopLevel setprop $solname $surfname properties; redraw } -variable  properties(blue)\n",\
"\n",\
"	\n",\
"	pack $w.lab1 $w.scale1 $w.lab2 $w.scale2 $w.lab3 $w.scale3\n",\
"\n",\
"	checkbutton $w.cb4 -text \"Visible\" \\\n",\
"	    -command { Ng_TopLevel setprop $solname $surfname properties; redraw } \\\n",\
"	    -variable properties(visible)\n",\
"	\n",\
"	checkbutton $w.cb5 -text \"Transparent\" \\\n",\
"	    -command { Ng_TopLevel setprop $solname $surfname properties; redraw } \\\n",\
"	    -variable properties(transp)\n",\
"	\n",\
"	\n",\
"	pack  $w.cb4 $w.cb5\n",\
"	\n",\
"	\n",\
"	frame $w.bu\n",\
"	pack $w.bu -fill x\n",\
"	button $w.bu.ok -text \"Ok\" -command \"destroy .tlprop_dlg\"\n",\
"	pack $w.bu.ok  -expand yes\n",\
"    \n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	focus $w\n",\
"    }\n",\
"    wm title $w \"Properties $solname $surfname\"\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc topleveldialog { } {\n",\
"\n",\
"    global w name val sollist\n",\
"\n",\
"    set w .tl_dlg\n",\
"    toplevel $w\n",\
"\n",\
"\n",\
"\n",\
"    frame $w.sol -borderwidth .5c\n",\
"    listbox $w.sol.list -yscroll \"$w.sol.scroll set\" -setgrid 1 -height 12\n",\
"    scrollbar $w.sol.scroll -command \"$w.sol.list yview\"\n",\
"    pack $w.sol.scroll -side right -fill y\n",\
"    pack $w.sol.list -side left -expand 1 -fill both\n",\
"    \n",\
"    Ng_GetSolidList sollist\n",\
"    foreach el $sollist {\n",\
"	$w.sol.list insert end $el }\n",\
"    Ng_GetPrimitiveList sollist\n",\
"    foreach el $sollist {\n",\
"	$w.sol.list insert end $el }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"    frame $w.sul -borderwidth .5c\n",\
"    listbox $w.sul.list -yscroll \"$w.sul.scroll set\" -setgrid 1 -height 12\n",\
"    scrollbar $w.sul.scroll -command \"$w.sul.list yview\"\n",\
"    pack $w.sul.scroll -side right -fill y\n",\
"    pack $w.sul.list -side left -expand 1 -fill both\n",\
"    \n",\
"    Ng_GetSurfaceList sollist\n",\
"    foreach el $sollist {\n",\
"	$w.sul.list insert end $el }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"    frame $w.topl -borderwidth .5c\n",\
"    listbox $w.topl.list -yscroll \"$w.topl.scroll set\" -setgrid 1 -height 12 \\\n",\
"	-command { puts hi }\n",\
"    scrollbar $w.topl.scroll -command \"$w.topl.list yview\"\n",\
"    pack $w.topl.scroll -side right -fill y\n",\
"    pack $w.topl.list -side left -expand 1 -fill both\n",\
"    \n",\
"    Ng_TopLevel getlist sollist\n",\
"    puts $sollist\n",\
"    foreach el $sollist {\n",\
"	set hel \"[ lindex $el 0 ]\"\n",\
"	if { [ llength $el ] == 2 } {\n",\
"	    set hel \"[ lindex $el 1 ] on [ lindex $el 0 ]\"\n",\
"	}\n",\
"	$w.topl.list insert end $hel \n",\
"    }\n",\
"\n",\
"\n",\
"    frame $w.bu\n",\
"\n",\
"    button $w.bu.close -text \"close\" -command {\n",\
"	destroy $w\n",\
"    }\n",\
"    button $w.bu.addsol -text \"Add Solid\" -command {\n",\
"	set solname [$w.sol.list get active]\n",\
"	Ng_TopLevel set $solname \"\"\n",\
"	Ng_ParseGeometry\n",\
"	$w.topl.list insert end $solname\n",\
"    }\n",\
"\n",\
"    button $w.bu.addsurf -text \"Add Surface\" -command {\n",\
"	set solname [$w.sol.list get active]\n",\
"	set surfname [$w.sul.list get active]\n",\
"	Ng_TopLevel set $solname $surfname\n",\
"	Ng_ParseGeometry\n",\
"	puts \"$solname on $surfname\"\n",\
"	$w.topl.list insert end \"$surfname on $solname\"\n",\
"    }\n",\
"\n",\
"    button $w.bu.remsol -text \"Remove\" -command {\n",\
"	set solname [$w.topl.list get active]\n",\
"	set surfname \"\"\n",\
"	if { [llength $solname] == 3 } {\n",\
"	    set surfname [lindex $solname 0]\n",\
"	    set solname [lindex $solname 2]\n",\
"	}\n",\
"	Ng_TopLevel remove $solname $surfname\n",\
"	Ng_ParseGeometry\n",\
"	$w.topl.list delete active\n",\
"    }\n",\
"\n",\
"    button $w.bu.prop -text \"Properties\" -command {\n",\
"	set solname [$w.topl.list get active]\n",\
"	set surfname \"\"\n",\
"	if { [llength $solname] == 3 } {\n",\
"	    set surfname [lindex $solname 0]\n",\
"	    set solname [lindex $solname 2]\n",\
"	}\n",\
"	toplevelproperties tlp $solname $surfname\n",\
"    }\n",\
"\n",\
"\n",\
"    \n",\
"\n",\
"    pack  $w.bu.close $w.bu.addsol $w.bu.addsurf $w.bu.remsol $w.bu.prop  -side left \n",\
"\n",\
"\n",\
"    pack $w.bu -side bottom\n",\
"    pack $w.sol -side left -expand yes -fill y           ;# listbox\n",\
"    pack $w.sul -side left -expand yes -fill y           ;# listbox\n",\
"    pack $w.topl -side left -expand yes -fill y           ;# listbox\n",\
"\n",\
"\n",\
"    bind $w <Escape> { $w.bu.close invoke }\n",\
"\n",\
"    wm withdraw $w\n",\
"    wm geom $w +100+100\n",\
"    wm deiconify $w\n",\
"\n",\
"#    grab $w\n",\
"    focus $w\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc topleveldialog2 { } {\n",\
"    set w .tl2_dlg\n",\
"    \n",\
"    if {[winfo exists .tl2_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"	toplevel $w\n",\
"\n",\
"	global name val sollist\n",\
"\n",\
"	frame $w.topl -borderwidth .5c\n",\
"	listbox $w.topl.list -yscroll \"$w.topl.scroll set\" -setgrid 1 -height 12\n",\
"	scrollbar $w.topl.scroll -command \"$w.topl.list yview\"\n",\
"	pack $w.topl.scroll -side right -fill y\n",\
"	pack $w.topl.list -side left -expand 1 -fill both\n",\
"	\n",\
"	Ng_TopLevel getlist sollist\n",\
"	puts $sollist\n",\
"	foreach el $sollist {\n",\
"	    set hel \"[ lindex $el 0 ]\"\n",\
"	    if { [ llength $el ] == 2 } {\n",\
"		set hel \"[ lindex $el 1 ] on [ lindex $el 0 ]\"\n",\
"	    }\n",\
"	    $w.topl.list insert end $hel }\n",\
"	\n",\
"	\n",\
"	frame $w.bu\n",\
"	\n",\
"	button $w.bu.close -text \"close\" -command {\n",\
"	    destroy .tl2_dlg\n",\
"	}\n",\
"	\n",\
"\n",\
"	button $w.bu.prop -text \"Properties\" -command {\n",\
"	    set solname [.tl2_dlg.topl.list get active]\n",\
"	    set surfname \"\"\n",\
"	    if { [llength $solname] == 3 } {\n",\
"		set surfname [lindex $solname 0]\n",\
"		set solname [lindex $solname 2]\n",\
"	    }\n",\
"	    toplevelproperties tlp $solname $surfname\n",\
"	}\n",\
"	\n",\
"	pack $w.bu.close $w.bu.prop  -side left \n",\
"	pack $w.bu -side bottom\n",\
"	pack $w.topl -side left -expand yes -fill y           ;# listbox\n",\
"		\n",\
"	bind .tl2_dlg.topl.list <Double-1> {\n",\
"	    set solname [.tl2_dlg.topl.list get  @%x,%y]\n",\
"	    set surfname \"\"\n",\
"	    if { [llength $solname] == 3 } {\n",\
"		set surfname [lindex $solname 0]\n",\
"		set solname [lindex $solname 2]\n",\
"	    }\n",\
"	    toplevelproperties tlp $solname $surfname\n",\
"	}\n",\
"	\n",\
"	bind .tl2_dlg <Escape> { .tl2_dlg.bu.close invoke }\n",\
"	\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Top-Level Options\"	\n",\
"	focus $w\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc logwindow { } {\n",\
"    set w .logwindow\n",\
"    \n",\
"    if {[winfo exists .logwindow] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {\n",\
"	toplevel $w\n",\
"\n",\
"	text $w.edit -yscroll \"$w.scrolly set\" -setgrid 1 -height 12\n",\
"	scrollbar $w.scrolly -command \"$w.edit yview\"	\n",\
"	pack $w.edit -side left -fill both -expand 1\n",\
"	pack $w.scrolly -side left -fill both -expand 0\n",\
"\n",\
"	.logwindow.edit insert end \"Netgen Log Window\\n\"\n",\
"\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Netgen Log\"	\n",\
"	focus $w\n",\
"    }\n",\
"}\n",\
"# logwindow\n",\
"\n",\
"\n",\
"set entities [ ]\n",\
"\n",\
"\n",\
"proc occdialogbuildtree {} {\n",\
"    global entities\n",\
"\n",\
"    set w .occ_dlg\n",\
"    set hlist [$w.mtre subwidget hlist]\n",\
"\n",\
"    set entities [Ng_GetOCCData getentities]\n",\
"    set nrentities [expr [llength $entities]]\n",\
"\n",\
"\n",\
"    if {$nrentities != 0} {\n",\
"\n",\
"	$hlist add Topology -itemtype text -text \"Topology\"\n",\
"	\n",\
"	$hlist add Topology/CompSolids   -itemtype text -text \"Composite Solids\" -data \"Composite Solids\"\n",\
"	$hlist add Topology/FreeSolids   -itemtype text -text \"Free Solids\" -data \"Free Solids\"\n",\
"	$hlist add Topology/FreeShells   -itemtype text -text \"Free Shells\" -data \"Free Shells\"\n",\
"	$hlist add Topology/FreeFaces    -itemtype text -text \"Free Faces\" -data \"Free Faces\"\n",\
"	$hlist add Topology/FreeWires    -itemtype text -text \"Free Wires\" -data \"Free Wires\"\n",\
"	$hlist add Topology/FreeEdges    -itemtype text -text \"Free Edges\" -data \"Free Edges\"\n",\
"	$hlist add Topology/FreeVertices -itemtype text -text \"Free Vertices\" -data \"Free Vertices\"\n",\
"	\n",\
"	set i [expr 0]\n",\
"	while {$i < $nrentities} {\n",\
"	    set entity [lindex $entities [expr $i]]\n",\
"	    incr i 1\n",\
"	    set entityname [lindex $entities [expr $i]]\n",\
"	    $hlist add Topology/$entity -text $entityname -data $entityname\n",\
"	    incr i 1\n",\
"	    $w.mtre close Topology/$entity\n",\
"	}\n",\
"	\n",\
"	$w.mtre autosetmode\n",\
"	\n",\
"	$w.mtre open Topology\n",\
"	$w.mtre close Topology/CompSolids\n",\
"	$w.mtre close Topology/FreeSolids\n",\
"	$w.mtre close Topology/FreeShells\n",\
"	$w.mtre close Topology/FreeFaces\n",\
"	$w.mtre close Topology/FreeWires\n",\
"	$w.mtre close Topology/FreeEdges\n",\
"	$w.mtre close Topology/FreeVertices\n",\
"	\n",\
"	set i [expr 0]\n",\
"	while {$i < $nrentities} {\n",\
"	    set entity [lindex $entities [expr $i]]\n",\
"	    $w.mtre close Topology/$entity\n",\
"	    incr i 2\n",\
"	}\n",\
"	\n",\
"	set faces [Ng_OCCCommand getunmeshedfaceinfo]    \n",\
"	set nrfaces [expr [llength $faces]]\n",\
"	if {$nrfaces >= 2} {\n",\
"	    $hlist add ErrorFaces -itemtype text -text \"Faces with surface meshing error\"\n",\
"	    $w.mtre open ErrorFaces\n",\
"	    set i [expr 0]\n",\
"	    while {$i < $nrfaces} {\n",\
"		set entity [lindex $faces [expr $i]]\n",\
"		incr i 1\n",\
"		set entityname [lindex $faces [expr $i]]\n",\
"		$hlist add ErrorFaces/$entity -text $entityname -data $entityname\n",\
"		incr i 1\n",\
"	    }\n",\
"	}\n",\
"	\n",\
"\n",\
"	set faces [Ng_OCCCommand getnotdrawablefaces]    \n",\
"	set nrfaces [expr [llength $faces]]\n",\
"	if {$nrfaces >= 2} {\n",\
"	    $hlist add NotDrawableFaces -itemtype text -text \"Faces impossible to visualize\"\n",\
"	    $w.mtre open NotDrawableFaces\n",\
"	    set i [expr 0]\n",\
"	    while {$i < $nrfaces} {\n",\
"		set entity [lindex $faces [expr $i]]\n",\
"		incr i 1\n",\
"		set entityname [lindex $faces [expr $i]]\n",\
"		$hlist add NotDrawableFaces/$entity -text $entityname -data $entityname\n",\
"		incr i 1\n",\
"	    }\n",\
"	}\n",\
"\n",\
"\n",\
"	$w.mtre autosetmode\n",\
"\n",\
"	puts \"done\"\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"proc rebuildoccdialog {} {\n",\
"    if {[winfo exists .occ_dlg] == 1} {\n",\
"	[.occ_dlg.mtre subwidget hlist] delete all\n",\
"	occdialogbuildtree \n",\
"    }\n",\
"}\n",\
"\n",\
"proc checkoccloaded { } {\n",\
"    set isoccgeometryloaded [Ng_OCCCommand isoccgeometryloaded]\n",\
"    if {$isoccgeometryloaded == 0} {\n",\
"	puts \"no IGES/STEP geometry loaded\"\n",\
"	destroy .occ_dlg\n",\
"    }\n",\
"}\n",\
"\n",\
"#proc setocctolerance { } {\n",\
"#    set w .setocctolerance\n",\
"#}\n",\
"\n",\
"\n",\
"proc selectentity { entityname } {\n",\
"    global entities\n",\
"    set nrentities [expr [llength $entities]]\n",\
"    set i [expr 0]\n",\
"    while {$i < $nrentities} {\n",\
"	set entitylength []\n",\
"			\n",\
"	set entity2 [lindex $entities [expr $i]]\n",\
"	incr i 1\n",\
"	set entityname2 [lindex $entities [expr $i]]\n",\
"	incr i 1\n",\
"	set entityname2 [string range $entityname2 0 [expr [string length $entityname]-1]]\n",\
"	\n",\
"	if {$entityname == $entityname2} {\n",\
"	    set hlist [.occ_dlg.mtre subwidget hlist]\n",\
"	    .occ_dlg.mtre open Topology\n",\
"	    set slashpos [string last \"/\" $entity2]\n",\
"	    set entity3 [string range $entity2 0 [expr $slashpos-1]]\n",\
"	    while {$slashpos != -1} {\n",\
"		.occ_dlg.mtre open Topology/$entity3\n",\
"		\n",\
"		set slashpos [string last \"/\" $entity3]\n",\
"		set entity3 [string range $entity3 0 [expr $slashpos-1]]\n",\
"	    }\n",\
"	    $hlist selection clear\n",\
"	    $hlist see Topology/$entity2\n",\
"	    $hlist selection set Topology/$entity2\n",\
"	} \n",\
"    }	    \n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"proc occdialog { } {\n",\
"	\n",\
"    uplevel 1 {\n",\
"\n",\
"    global entities\n",\
"    set selectvisual geometry\n",\
"    Ng_SetVisParameters\n",\
"    redraw\n",\
"\n",\
"    set w .occ_dlg\n",\
"    \n",\
"    if {[winfo exists .occ_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w \n",\
"    } {	\n",\
"	toplevel $w\n",\
"\n",\
"	tixTree $w.mtre -options { separator \"/\" }\n",\
"	pack $w.mtre -fill both -expand yes\n",\
"\n",\
"	occdialogbuildtree\n",\
"\n",\
"	set hlist [$w.mtre subwidget hlist]\n",\
"\n",\
"\n",\
"	set solname {\"\"}\n",\
"\n",\
"	\n",\
"	bind $hlist <Double-1> {\n",\
"	    set oldsolname {$solname}\n",\
"	    set solname [[.occ_dlg.mtre subwidget hlist] info selection]\n",\
"	    if {$solname != \"\" && $oldsolname != $solname } {\n",\
"		set seppos [string first \"/\" $solname]\n",\
"		set rootname [string range $solname 0 [expr $seppos-1]]\n",\
"\n",\
"		set entityname [[.occ_dlg.mtre subwidget hlist] info data $solname]\n",\
"		set spacepos [string first \" \" $entityname]\n",\
"		set entitytype [string range $entityname 0 [expr $spacepos-1]]\n",\
"		set helpstring [string range $entityname [expr $spacepos+1] [expr [string length $entityname]-1]]\n",\
"		set spacepos2 [string first \" \" $helpstring]\n",\
"		set entitynumber [string range $helpstring 0 [expr $spacepos2-1]]\n",\
"		if {$rootname == \"Topology\"} {\n",\
"		    Ng_OCCCommand highlightentity $entitytype $entitynumber\n",\
"		    set selectvisual geometry\n",\
"		    redraw\n",\
"		} {\n",\
"		    set brackpos [string first \" (\" $entityname]\n",\
"		    if {$brackpos != -1} {\n",\
"			set entityname [string range $entityname 0 $brackpos]\n",\
"		    }\n",\
"\n",\
"		    selectentity $entityname\n",\
"		}\n",\
"	    }\n",\
"	}\n",\
"	\n",\
"	button $w.cl -text \"Close\" -command {\n",\
"	    destroy .occ_dlg\n",\
"	}\n",\
"	\n",\
"	button $w.swaporientation -text \"Swap orientation\" -command {\n",\
"	    set solname [[.occ_dlg.mtre subwidget hlist] info selection]\n",\
"	    set entityname [[.occ_dlg.mtre subwidget hlist] info data $solname]\n",\
"	    set spacepos [string first \" \" $entityname]\n",\
"	    set entitytype [string range $entityname 0 [expr $spacepos-1]]\n",\
"	    set helpstring [string range $entityname [expr $spacepos+1] [expr [string length $entityname]-1]]\n",\
"	    set spacepos2 [string first \" \" $helpstring]\n",\
"	    set entitynumber [string range $helpstring 0 [expr $spacepos2-1]]\n",\
"\n",\
"	    Ng_OCCCommand swaporientation $entitytype $entitynumber\n",\
"	    set selectvisual geometry\n",\
"#	    Ng_SetVisParameters\n",\
"	    redraw\n",\
"\n",\
"	    [.occ_dlg.mtre subwidget hlist] delete all\n",\
"	    occdialogbuildtree	\n",\
"	}\n",\
"\n",\
"	button $w.checkentities -text \"Analyze geometry\" -command {\n",\
"	    set irregent [Ng_OCCCommand findsmallentities]\n",\
"\n",\
"	    set w .occ_dlg\n",\
"	    set hlist [$w.mtre subwidget hlist]\n",\
"	    \n",\
"	    $hlist add ProblematicEntities -text \"Problematic Entities\"\n",\
"	    $hlist delete offsprings ProblematicEntities\n",\
"\n",\
"	    set nritems [expr [llength $irregent]]\n",\
"	    set i [expr 0]\n",\
"	    while {$i < $nritems} {\n",\
"		set entity [lindex $irregent [expr $i]]\n",\
"		incr i 1\n",\
"		set entityname [lindex $irregent [expr $i]]\n",\
"		$hlist add ProblematicEntities/$entity -text $entityname -data $entityname\n",\
"		incr i 1\n",\
"	    }\n",\
"	    $w.mtre open ProblematicEntities\n",\
"	    $w.mtre autosetmode\n",\
"	}\n",\
"\n",\
"	checkbutton $w.zoomtohighlightedentity -text \"Zoom to highlighted entity\" \\\n",\
"	    -variable occoptions.zoomtohighlightedentity \\\n",\
"	    -command {\n",\
"		Ng_SetOCCVisParameters\n",\
"		if { ${occoptions.zoomtohighlightedentity} == 1} {\n",\
"		    set selectvisual geometry\n",\
"#		    Ng_SetVisParameters\n",\
"		    Ng_OCCCommand redrawstatus 1\n",\
"		    redraw\n",\
"		} {\n",\
"		    Ng_OCCCommand redrawstatus 0\n",\
"		}\n",\
"	    }\n",\
"\n",\
"\n",\
"\n",\
"	frame $w.healing -relief groove -borderwidth 3\n",\
"\n",\
"	tixControl $w.healing.tolerance -label \"Healing tolerance: \" -integer false \\\n",\
"	    -variable occoptions.tolerance -min 1e-9 -max 1e6 \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 25\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	checkbutton $w.healing.fixsmalledges -text \"Fix small edges\" \\\n",\
"	    -variable occoptions.fixsmalledges\n",\
"	\n",\
"	checkbutton $w.healing.fixspotstripfaces -text \"Fix spot/strip faces\" \\\n",\
"	    -variable occoptions.fixspotstripfaces\n",\
"	\n",\
"	checkbutton $w.healing.sewfaces -text \"Sew faces\" \\\n",\
"	    -variable occoptions.sewfaces\n",\
"	\n",\
"	checkbutton $w.healing.makesolids -text \"Make solids\" \\\n",\
"	    -variable occoptions.makesolids\n",\
"	\n",\
"	button $w.healing.heal -text \"Heal geometry\" -command { \n",\
"	    .occ_dlg.healing.tolerance invoke\n",\
"	    Ng_OCCCommand shapehealing\n",\
"	    redraw \n",\
"	    [.occ_dlg.mtre subwidget hlist] delete all\n",\
"	    occdialogbuildtree\n",\
"	}\n",\
"\n",\
"	pack $w.healing.tolerance $w.healing.fixsmalledges \\\n",\
"	    $w.healing.fixspotstripfaces $w.healing.sewfaces \\\n",\
"	    $w.healing.makesolids -anchor w\n",\
"\n",\
"	pack $w.healing.heal	\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	pack $w.zoomtohighlightedentity -anchor w\n",\
"	pack $w.checkentities\n",\
"	pack $w.swaporientation\n",\
"	pack $w.healing -fill x\n",\
"	pack $w.cl\n",\
" \n",\
"	\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"IGES/STEP Topology Explorer/Doctor\"\n",\
"	focus .occ_dlg\n",\
"    }\n",\
"}\n",\
"}\n",\
"\n",\
"}\n",\
"	    #\n",\
"#  Creates a drawing frame, and binds mouse events\n",\
"#\n",\
"set oldmousex 0\n",\
"set oldmousey 0\n",\
"#\n",\
"# if { 1 } {\n",\
"if {[catch {togl .ndraw -width 400 -height 300  -rgba true -double true -depth true -privatecmap false -stereo false}] } {    \n",\
"    puts \"sorry, no OpenGL\" \n",\
"} {\n",\
"    #\n",\
"    pack .ndraw -expand true -fill both -padx 10 -pady 10\n",\
"    #\n",\
"    bind .ndraw <Button-1> {\n",\
"	set oldmousex %x; set oldmousey %y;\n",\
"    }\n",\
"    bind .ndraw <Button-2> {\n",\
"	set oldmousex %x; set oldmousey %y;\n",\
"    }\n",\
"    bind .ndraw <Button-3> {\n",\
"	set oldmousex %x; set oldmousey %y;\n",\
"    }\n",\
"    bind .ndraw <B1-Motion> {\n",\
"	Ng_MouseMove $oldmousex $oldmousey %x %y $drawmode\n",\
"	.ndraw render\n",\
"	set oldmousex %x; set oldmousey %y;\n",\
"    }\n",\
"\n",\
"    bind .ndraw <Double-1> {\n",\
"	Ng_MouseDblClick %x %y\n",\
"	.ndraw render\n",\
"	if { [winfo exists .bcprop_dlg] } { bcpropdialog }\n",\
"    }\n",\
"\n",\
"    bind .ndraw <B2-Motion> {\n",\
"	Ng_MouseMove $oldmousex $oldmousey %x %y move\n",\
"	.ndraw render\n",\
"	set oldmousex %x; set oldmousey %y;\n",\
"    }\n",\
"\n",\
"    bind .ndraw <B3-Motion> {\n",\
"	Ng_MouseMove $oldmousex $oldmousey %x %y zoom\n",\
"	.ndraw render\n",\
"	set oldmousex %x; set oldmousey %y;\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"proc redraw { {x 0} } {\n",\
"    if {[winfo exists .ndraw]} { .ndraw render } \n",\
"}\n",\
"\n",\
"\n",\
"bind . <Left> { Ng_MouseMove 0 0 -10 0 rotate; redraw }\n",\
"bind . <Right> { Ng_MouseMove 0 0 10 0 rotate; redraw }\n",\
"bind . <Up> { Ng_MouseMove 0 0 0 -10 rotate; redraw }\n",\
"bind . <Down> { Ng_MouseMove 0 0 0 10 rotate; redraw }\n",\
"bind . <Shift-Left> { Ng_MouseMove 0 0 -10 0 move; redraw }\n",\
"bind . <Shift-Right> { Ng_MouseMove 0 0 10 0 move; redraw }\n",\
"bind . <Shift-Up> { Ng_MouseMove 0 0 0 -10 move; redraw }\n",\
"bind . <Shift-Down> { Ng_MouseMove 0 0 0 10 move; redraw }\n",\
"bind . <Control-Up> { Ng_MouseMove 0 0 0 -10 zoom; redraw }\n",\
"bind . <Control-Down> { Ng_MouseMove 0 0 0 10 zoom; redraw }\n",\
"bind all <MouseWheel> { puts \"surprise !!! mousewheel is working\"; redraw }\n",\
"\n",\
"\n",\
"\n",\
"catch { \n",\
"    proc print_commandline_help { } {\n",\
"    \n",\
"    puts \"Usage: ng { options }\"\n",\
"\n",\
"    puts \"-geofile=filename    Input geometry file (alternative:  ng filename)\"\n",\
"    puts \"-meshfile=filename   Output mesh file\"\n",\
"    puts \"-verycoarse, -coarse, -moderate, -fine, -veryfine\"\n",\
"    puts \"                     Automatic mesh-size selection\"\n",\
"    puts \"-meshfiletype={\\\"Neutral Format\\\", ...}\"\n",\
"    puts \"                     Filetype of output file, default is netgen file\"\n",\
"    puts \"-batchmode           Run Netgen in batchmode\"\n",\
"    puts \"-V                   Print additional information\"\n",\
"\n",\
"    if { [catch { NGS_GetData } ] == 0 } { \n",\
"	puts \"\\nNGSolve parameters:\"\n",\
"	puts \"-pdefile=filename   Load pde input file\"\n",\
"	puts \"-solve              Solve pde once\"\n",\
"	puts \"-solve=n            Solve pde by n adaptive refinement steps\"\n",\
"	puts \"-recent             Load and solve most recently loaded pde\"\n",\
"    }\n",\
"\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"proc set_menu_help { entry helpmsg } {\n",\
"    global menuhelps\n",\
"#    puts \"set menu help: $entry $helpmsg\"\n",\
"    set menuhelps($entry) $helpmsg\n",\
"}\n",\
"\n",\
"proc show_menu_help { entry } {\n",\
"    global menuhelps\n",\
"\n",\
"\n",\
"    if {[catch {set helptext $menuhelps($entry)}]} {\n",\
"	set helptext \"no help available   \"\n",\
"    }    \n",\
"\n",\
"    .helpline configure -text $helptext\n",\
"    \n",\
"    if {[winfo exists .senshelp_dlg]==1} {\n",\
"	.senshelp_dlg.text delete 1.0 end\n",\
"	.senshelp_dlg.text insert end \"Menu item: $entry\\n\\n\"\n",\
"	.senshelp_dlg.text insert end $helptext\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"tixBalloon .balloon -statusbar .helpline\n",\
"\n",\
"proc set_control_help { control helpmsg } {\n",\
"    bind $control <Enter> \"show_control_help {$helpmsg}\"\n",\
"    bind $control <Leave> \"show_control_help {None}\"\n",\
"    .balloon bind  $control -balloonmsg $helpmsg -statusmsg $helpmsg\n",\
"#    puts \"Add Help to $control\"\n",\
"}\n",\
"\n",\
"proc show_control_help { helpmsg } {\n",\
"    .helpline configure -text $helpmsg\n",\
"    if {[winfo exists .senshelp_dlg]==1} {\n",\
"	.senshelp_dlg.text delete 1.0 end\n",\
"	.senshelp_dlg.text insert end $helpmsg\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"proc sensitivehelpdialog { show } {\n",\
"\n",\
"    set w .senshelp_dlg\n",\
"    \n",\
"    if {[winfo exists .senshelp_dlg] == 1} {\n",\
"\n",\
"	if { $show == 1 } {\n",\
"	    wm withdraw .senshelp_dlg\n",\
"	    wm deiconify $w\n",\
"	    focus $w \n",\
"	} {\n",\
"	    wm withdraw $w\n",\
"	}\n",\
"    } {\n",\
"	toplevel $w\n",\
"#	wm minsize $w 200 150\n",\
"\n",\
"	global senshelptext\n",\
"\n",\
"	text $w.text -yscrollcommand \"$w.scroll set\" -setgrid true \\\n",\
"	    -width 40 -height 10  -wrap word\n",\
"	scrollbar $w.scroll -command \"$w.text yview\"\n",\
"	pack $w.scroll -side right -fill y\n",\
"	pack $w.text -expand yes -fill both\n",\
"\n",\
"	frame $w.bu\n",\
"	pack $w.bu\n",\
"	# -fill x\n",\
"	\n",\
"	button $w.close -text \"Close\" \\\n",\
"	    -command { \n",\
"		wm withdraw .senshelp_dlg\n",\
"		set showsensitivehelp 0\n",\
"	    }\n",\
"	pack $w.close\n",\
"    \n",\
"	\n",\
"	if { $show == 1 } {\n",\
"	    wm withdraw $w\n",\
"	    wm geom $w +100+100\n",\
"	    wm deiconify $w\n",\
"	    wm title $w \"Help\"\n",\
"	    focus $w\n",\
"	}\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"set_menu_help \"File\"  \"In File menu you can load and store geometries, meshes etc.\" \n",\
"\n",\
"set_menu_help \"New Geometry\"  \"Deletes current geometry\"\n",\
"set_menu_help \"Load Geometry\"  \"Loads Geometry file in one of the formats STL (ASCII or binary), Constructive Solid Geometry (.geo) or 2D geometry. Please have a look into Netgen User's manuel for more details.\"\n",\
"set_menu_help \"Save Geometry\" \"Saves STL Geometry in in either ASCII or binary STL format.\"\n",\
"set_menu_help \"Load Mesh\" \"Loads surface and volume mesh in Netgen internal format.\"\n",\
"set_menu_help \"Save Mesh\" \"Saves surface and volume mesh in Netgen internal format.\"\n",\
"set_menu_help \"Write EPS File\" \"Dumps OpenGL rendering to EPS File.\"\n",\
"set_menu_help \"Save Options\" \"Saves current options in file \\\"ng.opt\\\". These options will be loaded again when starting ng in the same directory.\"\n",\
"set_menu_help \"Export Mesh\" \"Exports mesh in format defined by Export Filetype.\"\n",\
"set_menu_help \"Export Filetype\" \"Selects file format for exporting mesh. Please have a look into the Netgen User's manual for more information.\"\n",\
"set_menu_help \"Import Mesh\" \"Imports surface or volume mesh in exchange format.\"\n",\
"set_menu_help \"Quit\" \"Quits Netgen\"\n",\
"\n",\
"set_menu_help \"Geometry\" \"Preparing geometries, visualiztion of geometries.\"\n",\
"set_menu_help \"Scan CSG Geometry\" \"Generates surface triangulation for rendering\"\n",\
"set_menu_help \"CSG Options\" \"Sets Options for CSG visualization (bounding box, detail size, number of facets).\"\n",\
"set_menu_help \"CSG Properties\" \"Defines appearence of current CSG geometry (color, visibility, transparency)\"\n",\
"set_menu_help \"STL Doctor\" \"Calls STL Doctor for preprocessing STL geometry files.\"\n",\
"set_menu_help \"STL Info\" \"Retrieves information about current STL geometry.\"\n",\
"\n",\
"set_menu_help \"Mesh\" \"Menu for mesh generation\"\n",\
"set_menu_help \"Generate Mesh\" \"Generates mesh from geometry, same as Button \\\"Generate Mesh\\\"\"\n",\
"set_menu_help \"Stop Meshing\" \"Terminates meshgeneration. It may take a while until meshing terminates, please be patient.\"\n",\
"set_menu_help \"Meshing Options\" \"Set options for mesh generation.\"\n",\
"set_menu_help \"Delete Mesh\" \"Deletes mesh. Not necessary before generation of new mesh.\"\n",\
"set_menu_help \"Delete Vol Mesh\" \"Deletes only volume mesh.\"\n",\
"set_menu_help \"Mesh Quality\" \"Computs element shape measures. Triangle angles are inner angles of all triangles (faces of tetrahedra). Tet angles are angles between faces of tetrahedra.\"\n",\
"set_menu_help \"Check Surface Mesh\" \"Checks consistency and overlap of surface mesh. Marks overlapping elements as bad elements, please enable visualization of bad elements in View->Mesh.\"\n",\
"set_menu_help \"Check Volume Mesh\" \"Checks conformity of volume mesh.\"\n",\
"set_menu_help \"Edit Boundary Conditions\" \"Open dialog for setting boundary condition numbers for individual faces.\"\n",\
"set_menu_help \"Analyze Geometry\" \"Perform only first step in mesh generation. Action depends on geometry type, e.g. generates charts for STL mesh, find vertices in CSG geometries.\"\n",\
"set_menu_help \"Mesh Edges\" \"Meshes edges\"\n",\
"set_menu_help \"Mesh Surface\" \"Generates surface mesh. Includes already surface optimization for some geomtry types.\"\n",\
"set_menu_help \"Optimize Surface\" \"Optimizes surface mesh.\"\n",\
"set_menu_help \"Surface Optim. Step\" \"Performs a specific surface optimiztion step. Mesh smoothing moves nodes. edge swapping swaps the diagonal of a quadrilateral built by two triangles, criterion either by number of nodes, or anlges. Combine points eliminates triangles by combining points (in the center of gravity).\"\n",\
"set_menu_help \"Mesh Volume\" \"Performs volume meshing. Algorithm is a combination of Delaunay and Rule-based Advancing Front\"\n",\
"set_menu_help \"Optimize Volume\" \"Performs additional volume optimization steps\"\n",\
"set_menu_help \"Smooth Opt Volume\" \"Performs optimization steps by smoothing iterations\"\n",\
"set_menu_help \"Smooth Opt Volume Jacobian\" \"Volume optimization by smoothing iterations. Criterion is optimization of Jacobi determinants. This optimization step is also available for 10-node tetrahedra.\"\n",\
"\n",\
"set_menu_help \"View\" \"Sets viewing options\"\n",\
"set_menu_help \"Zoom all\" \"Zooms scene to show whole object\"\n",\
"set_menu_help \"Center\" \"Defines center of rotation\"\n",\
"set_menu_help \"Viewing Options\" \"Sets viewing options for geometry, mesh, lighting\"\n",\
"set_menu_help \"Clipping Plane\" \"Introduces clipping plane. The clipping plane is defined by the normal vector, and a scaled offset. Clipping of performed by OpenGl rendering\"\n",\
"set_menu_help \"Quality Plot\" \"Shows the element quality distribution histogram. Measure is volume scaled by edge-length to the third. Optimal elements have measure 1.\"\n",\
"set_menu_help \"Sensitve Help\" \"Shows this help window\"\n",\
"\n",\
"set_menu_help \"Mesh-size\" \"Manipulations of existing mesh\"\n",\
"set_menu_help \"Refine uniform\" \"Refines mesh by splitting elements into eight childs (algorithm of J. Bey)\"\n",\
"set_menu_help \"Second Order\" \"Converts 4 node elements to 10 node elements. Edge-midpoitns are projected to the geometry.\"\n",\
"set_menu_help \"Refinement Dialog\" \"Controls local mesh refinement\"\n",\
"set_menu_help \"Load Meshsize\" \"Loads mesh-size file for local mesh refinement.\"\n",\
"set_menu_help \"MS from Surf Mesh\" \"Defines mesh-size by the surface mesh.\"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"set f .options_dlg.nb.nbframe.general\n",\
"# set_control_help $f \"General meshing page\"\n",\
"set_control_help $f.fine \"Controls relative mesh size.\\nThis control affects other mesh-size controls in common\"\n",\
"set_control_help $f.first \"First step in mesh generation. Usually, meshing  starts from \\\"analyze geometry\\\". If the surface mesh is already available \\\"First step\\\" should be set to \\\"mesh volume\\\"\"\n",\
"set_control_help $f.last \"Last step in mesh generation. If only the surface mesh is required, please set \\\"Last Step\\\" to \\\"Optimize Surface\\\"\"\n",\
"\n",\
"\n",\
"proc help_item { helptext } {\n",\
"    puts $helptext\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc show_help { } {\n",\
"    \n",\
"    set w .help\n",\
"    \n",\
"    if {[winfo exists .help] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconif $w\n",\
"	focus $w \n",\
"    } {\n",\
"	\n",\
"	toplevel $w\n",\
"	\n",\
"	frame $w.buttons\n",\
"	pack $w.buttons -side bottom -fill x -pady 2m\n",\
"	button $w.buttons.done -text Done -command \"destroy $w\"\n",\
"	pack $w.buttons.done  -side left -expand 1\n",\
"\n",\
"	text $w.text -yscrollcommand \"$w.scroll set\" -setgrid true \\\n",\
"	    -width 60 -height 24 -wrap word\n",\
"	scrollbar $w.scroll -command \"$w.text yview\"\n",\
"	pack $w.scroll -side right -fill y\n",\
"	pack $w.text -expand yes -fill both\n",\
"\n",\
"    }\n",\
"    $w.text configure -state normal\n",\
"    $w.text delete 1.0 end\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"set bold \"-background #43ce80 -relief raised -borderwidth 1\"\n",\
"set normal \"-background {} -relief flat\"\n",\
"\n",\
"\n",\
"proc help_main { } {\n",\
"\n",\
"    show_help;\n",\
"    set w .help\n",\
"    global bold\n",\
"    global normal\n",\
"\n",\
"\n",\
"    \n",\
"    $w.text insert 0.0 \\\n",\
"	{NETGEN Help}\n",\
"    $w.text insert end \\n\\n\n",\
"    $w.text insert end \\\n",\
"	{1. General} d1\n",\
"    $w.text insert end \\n\\n\n",\
"    $w.text insert end \\\n",\
"	{2. Menu items } d2\n",\
"    $w.text insert end \\n\\n\n",\
"\n",\
"    foreach tag {d1 d2} {\n",\
"	$w.text tag bind $tag <Any-Enter> \"$w.text tag configure $tag $bold\"\n",\
"	$w.text tag bind $tag <Any-Leave> \"$w.text tag configure $tag $normal\"\n",\
"    }\n",\
"    \n",\
"    $w.text tag bind d1 <1> { puts \"general\"; help_general }\n",\
"    $w.text tag bind d2 <1> { help_menus }\n",\
"\n",\
"    $w.text configure -state disabled\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc help_general { } {\n",\
"\n",\
"    show_help;\n",\
"    set w .help\n",\
"    global bold\n",\
"    global normal\n",\
"\n",\
"    puts \"general called\"\n",\
"\n",\
"    $w.text insert 0.0 \\\n",\
"	{NETGEN is an automatic three dimensional tetrahedral mesh generation system. It accepts input from constructive solid geometry (CSG) or boundary representation (BRep) from STEP or STL file format. NETGEN contains modules for mesh optimization and hierarchical mesh refinement.}\n",\
"\n",\
"    $w.text configure -state disabled\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"proc help_menus { } {\n",\
"\n",\
"    show_help;\n",\
"    set w .help\n",\
"    global bold\n",\
"    global normal\n",\
"\n",\
"\n",\
"    $w.text insert 0.0 \\\n",\
"	{The NETGEN Menu items are}\n",\
"    $w.text insert end \\n\\n\n",\
"    $w.text insert end \\\n",\
"	{1. File} d1\n",\
"    $w.text insert end \\n\\n\n",\
"    $w.text insert end \\\n",\
"	{2. Geometry } d2\n",\
"    $w.text insert end \\n\\n\n",\
"    $w.text insert end \\\n",\
"	{3. Mesh } d3\n",\
"    $w.text insert end \\n\\n\n",\
"    $w.text insert end \\\n",\
"	{4. View } d4\n",\
"    $w.text insert end \\n\\n\n",\
"    $w.text insert end \\\n",\
"	{5. Mesh-size } d5\n",\
"    $w.text insert end \\n\\n\n",\
"    $w.text insert end \\\n",\
"	{6. STL } d6\n",\
"\n",\
"    foreach tag {d1 d2 d3 d4 d5 d6} {\n",\
"	$w.text tag bind $tag <Any-Enter> \"$w.text tag configure $tag $bold\"\n",\
"	$w.text tag bind $tag <Any-Leave> \"$w.text tag configure $tag $normal\"\n",\
"    }\n",\
"    \n",\
"    $w.text tag bind d1 <1> {puts \"File menu\"}\n",\
"    $w.text tag bind d2 <1> {puts \"Geometry menu\"}\n",\
"    $w.text tag bind d3 <1> {puts \"Mesh menu\"}\n",\
"    $w.text tag bind d4 <1> {puts \"View menu\"}\n",\
"    $w.text tag bind d5 <1> {puts \"Mesh-size menu\"}\n",\
"    $w.text tag bind d6 <1> {puts \"STL menu\"}\n",\
"\n",\
"    $w.text configure -state disabled\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"}\n",\
"catch { \n",\
"    Ng_Vis_Set parameters\n",\
"\n",\
"\n",\
"\n",\
"set viscnt 0\n",\
"proc snapshottimer { } {\n",\
"    after 2000 { snapshottimer }\n",\
"\n",\
"    global viscnt\n",\
"    set viscnt [expr $viscnt+1]\n",\
"    set s1 0000$viscnt\n",\
"#    puts $s1\n",\
"    set cnt [string range $s1 [expr [string length $s1]-4] end]\n",\
"    set filename \"p$cnt.jpg\"\n",\
"#    puts \"cnt = $cnt\"\n",\
"#    puts \"filename = $filename\"\n",\
"#    .ndraw Ng_SnapShot pictures/$filename\n",\
"}\n",\
"snapshottimer\n",\
"\n",\
"\n",\
"\n",\
"proc redrawtimer { } {\n",\
"    global visoptions.autoredraw\n",\
"    global visoptions.autoredrawtime\n",\
"\n",\
"    set delay [expr int(${visoptions.autoredrawtime}*1000)]\n",\
"    if { ${visoptions.autoredraw} == 1 } { redraw; }\n",\
"    after $delay { redrawtimer } \n",\
"}\n",\
"redrawtimer\n",\
"\n",\
"\n",\
"set perstarttime [clock clicks -millisecond]\n",\
"proc redrawperiodic { } {\n",\
"    global visoptions.redrawperiodic\n",\
"    global perstarttime\n",\
"    set curtime [clock clicks -millisecond]\n",\
"#    puts \"redraw periodic, time = $curtime\"\n",\
"    Ng_Vis_Set time [expr ($curtime - $perstarttime) / 5]\n",\
"    redraw\n",\
"    if { ${visoptions.redrawperiodic} == 1 } { after 100 { redrawperiodic } };\n",\
"\n",\
"}\n",\
"\n",\
"proc visual_dialog { } {\n",\
"\n",\
"    set w .visoptions_dlg\n",\
"\n",\
"    if {[winfo exists .visoptions_dlg] == 1} {\n",\
"	wm withdraw $w\n",\
"	wm deiconify $w\n",\
"	focus $w\n",\
"    } {\n",\
"\n",\
"	toplevel $w\n",\
"\n",\
"	checkbutton $w.imaginary -text \"Imaginary Part\" \\\n",\
"	    -variable visoptions.imaginary \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	checkbutton $w.usetexture -text \"Use Textures\" \\\n",\
"	    -variable visoptions.usetexture \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"	\n",\
"	checkbutton $w.invcolor -text \"Inverse Color\" \\\n",\
"	    -variable visoptions.invcolor \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"	\n",\
"	checkbutton $w.redrawperiodic -text \"Animate periodic\" \\\n",\
"	    -variable visoptions.redrawperiodic \\\n",\
"	    -command { \n",\
"		redrawperiodic\n",\
"		Ng_Vis_Set parameters; \n",\
"		redraw \n",\
"	    }\n",\
"	\n",\
"\n",\
"	frame $w.fieldlines  -relief groove -borderwidth 3\n",\
"	checkbutton $w.fieldlines.enable -text \"Field-lines\" \\\n",\
"	    -variable visoptions.drawfieldlines \\\n",\
"	    -command { \n",\
"		# set visoptions.redrawperiodic ${visoptions.drawfieldlines}\n",\
"		# redrawperiodic\n",\
"		# redrawperiodic # sonst \n",\
"		Ng_Vis_Set parameters; \n",\
"		redraw \n",\
"	    }\n",\
"	tixControl $w.fieldlines.num -label \"Num: \" -integer true \\\n",\
"	    -variable visoptions.numfieldlines \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw } \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 12\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	checkbutton $w.fieldlines.randomstart -text \"Random start\" \\\n",\
"	    -variable visoptions.fieldlinesrandomstart \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw}\n",\
"\n",\
"	checkbutton $w.logscale -text \"Log Scale\" \\\n",\
"	    -variable visoptions.logscale \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"	\n",\
"	checkbutton $w.lineartexture -text \"Use Linear Texture\" \\\n",\
"	    -variable visoptions.lineartexture \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"	\n",\
"	scale $w.numcols -orient horizontal -length 100 -from 0 -to 50 \\\n",\
"	    -resolution 1   \\\n",\
"	    -variable  visoptions.numtexturecols \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	checkbutton $w.showclipsolution -text \"Draw Clipping Plane Solution\" \\\n",\
"	    -variable visoptions.showclipsolution \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	checkbutton $w.showsurfsolution -text \"Draw Surface Solution\" \\\n",\
"	    -variable visoptions.showsurfacesolution \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"\n",\
"\n",\
"	frame $w.grid -relief groove -borderwidth 3\n",\
"	# change to: max gridsize 200\n",\
"	scale $w.grid.size -orient horizontal -length 100 -from 1 -to 200 \\\n",\
"	    -label \"Grid\" \\\n",\
"	    -resolution 1    \\\n",\
"	    -variable  visoptions.gridsize \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	# x- and y- offset\n",\
"	scale $w.grid.xoffset -orient horizontal -length 80 -from 0 -to 1 \\\n",\
"	    -label \"x-Offset\" \\\n",\
"	    -resolution 0.05    \\\n",\
"	    -variable  visoptions.xoffset \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	scale $w.grid.yoffset -orient horizontal -length 80 -from 0 -to 1 \\\n",\
"	    -label \"y-Offset\" \\\n",\
"	    -resolution 0.05    \\\n",\
"	    -variable  visoptions.yoffset \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"\n",\
"	# pack $w.showclipsolution \n",\
"	pack $w.showsurfsolution\n",\
"	pack $w.grid -fill x -ipady 3\n",\
"	pack $w.grid.size $w.grid.xoffset $w.grid.yoffset -side left -expand yes\n",\
"\n",\
"\n",\
"\n",\
"	#	pack $w.lineartexture $w.numcols \n",\
"\n",\
"\n",\
"\n",\
"	frame $w.deform -relief groove -borderwidth 3\n",\
"	checkbutton $w.deform.cb -text \"Deformation\" \\\n",\
"	    -variable visoptions.deformation \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	tixControl $w.deform.sc1 -label \"Scale: \" -integer false \\\n",\
"	    -variable visoptions.scaledeform1 \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw } \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 7\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	scale $w.deform.sc2 -orient horizontal -length 100 -from 0 -to 1 \\\n",\
"	    -resolution 0.01    \\\n",\
"	    -variable  visoptions.scaledeform2 \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	pack $w.deform -fill x -ipady 2\n",\
"	pack $w.deform.cb $w.deform.sc1 $w.deform.sc2 -side left -expand yes\n",\
"	\n",\
"\n",\
"	frame $w.as -relief groove -borderwidth 3\n",\
"	checkbutton $w.as.autoscale -text \"Autoscale\" \\\n",\
"	    -variable visoptions.autoscale \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	tixControl $w.as.minval -label \"Min-value: \" -integer false \\\n",\
"	    -variable visoptions.mminval \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw } \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 12\n",\
"		label.anchor e\n",\
"	    }	\n",\
"	tixControl $w.as.maxval -label \"Max-value: \" -integer false \\\n",\
"	    -variable visoptions.mmaxval \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw } \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 12\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"	pack $w.as -fill x -ipady 3\n",\
"	pack $w.as.autoscale $w.as.minval $w.as.maxval -side left\n",\
"\n",\
"	checkbutton $w.lintexture -text \"Linear Texture\" \\\n",\
"	    -variable visoptions.lineartexture \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"	pack $w.lintexture\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	frame $w.iso -relief groove -borderwidth 3\n",\
"	checkbutton $w.iso.isolines -text \"Iso-lines\" \\\n",\
"	    -variable visoptions.isolines \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	scale $w.iso.numiso -orient horizontal -length 100 -from 2 -to 50 \\\n",\
"	    -label \"\" \\\n",\
"	    -resolution 1    \\\n",\
"	    -variable  visoptions.numiso \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	pack $w.iso -fill x -ipady 3\n",\
"	pack $w.iso.isolines $w.iso.numiso -side left\n",\
"\n",\
"\n",\
"	scale $w.iso.subdiv -orient horizontal -length 100 -from 0 -to 5 \\\n",\
"	    -label \"subdivision\" \\\n",\
"	    -resolution 1    \\\n",\
"	    -variable  visoptions.subdivisions \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw }\n",\
"# ; Ng_SetNextTimeStamp\n",\
"	pack $w.iso.subdiv $w.iso.numiso -side left\n",\
"\n",\
"\n",\
"#	scale $w.iso.zpos -orient horizontal -length 100 -from 0 -to 1 \\\n",\
"#	    -label \"z-position\" \\\n",\
"#	    -resolution 0.01 \\\n",\
"#	    -variable visoptions.zposition \\\n",\
"#	    -command {\n",\
"#		catch {NGS_Set zpos ${visoptions.zposition};}\n",\
"#		redraw }\n",\
"#	pack $w.iso.zpos -side right\n",\
"\n",\
"\n",\
"\n",\
"	frame $w.redraw -relief groove -borderwidth 3\n",\
"	checkbutton $w.redraw.auto -text \"Auto-redraw\" \\\n",\
"	    -variable visoptions.autoredraw \n",\
"\n",\
"	tixControl $w.redraw.val -label \" after (sec) \" -integer false \\\n",\
"	    -variable visoptions.autoredrawtime \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 0\n",\
"		label.anchor w\n",\
"	    }	\n",\
"\n",\
"	pack $w.redraw -fill x -ipady 3\n",\
"	pack $w.redraw.auto  $w.redraw.val -side left\n",\
"\n",\
"	\n",\
"	tixControl $w.redraw.simtime -label \" Simulation Time (1e-6 s)\" -integer false \\\n",\
"	    -variable visoptions.simulationtime \\\n",\
"	    -command { \n",\
"		Ng_Vis_Set time ${visoptions.simulationtime}; \n",\
"		catch {NGS_Set time ${visoptions.simulationtime};}\n",\
"		redraw } \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 0\n",\
"		label.anchor w\n",\
"	    }	\n",\
"	pack $w.redraw.simtime -side left\n",\
"	\n",\
"\n",\
"\n",\
"\n",\
"	tixOptionMenu $w.clipsol -label \"Clipping Plane Sol: \" \\\n",\
"	    -options {\n",\
"		label.width  18\n",\
"		label.anchor e\n",\
"		menubutton.width 12\n",\
"	    }\n",\
"\n",\
"	set none 1\n",\
"	$w.clipsol add command none -label None\n",\
"	$w.clipsol add command scal -label \"Scalar Function\"\n",\
"	$w.clipsol add command vec -label \"Vector Function\"\n",\
"\n",\
"	$w.clipsol configure -variable visoptions.clipsolution\n",\
"	$w.clipsol configure -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"	pack $w.clipsol\n",\
"\n",\
"\n",\
"\n",\
"	tixOptionMenu $w.scalfun -label \"Scalar Function: \" \\\n",\
"	    -options {\n",\
"		label.width  18\n",\
"		label.anchor e\n",\
"		menubutton.width 12\n",\
"	    }\n",\
"\n",\
"	tixOptionMenu $w.vecfun -label \"Vector Function: \" \\\n",\
"	    -options {\n",\
"		label.width  18\n",\
"		label.anchor e\n",\
"		menubutton.width 12\n",\
"	    }\n",\
"\n",\
"\n",\
"	$w.scalfun add command none -label None\n",\
"	for { set i 1 } { $i <= [Ng_Vis_Field getnfieldnames] } { incr i } {\n",\
"	    set fname [Ng_Vis_Field getfieldname $i]\n",\
"	    set fcomp [Ng_Vis_Field getfieldcomponents $i]\n",\
"	    if { $fcomp == 1 } {\n",\
"		$w.scalfun add command $fname.1 -label $fname\n",\
"	    } {\n",\
"		for { set j 1 } { $j <= $fcomp } { incr j } {\n",\
"		    $w.scalfun add command $fname.$j -label \"$fname ($j)\"\n",\
"		}\n",\
"		$w.scalfun add command $fname.0 -label \"func ($fname)\"\n",\
"	    }\n",\
"	}\n",\
"\n",\
"	$w.vecfun add command none -label None \n",\
"	for { set i 1 } { $i <= [Ng_Vis_Field getnfieldnames] } { incr i } {\n",\
"	    set fname [Ng_Vis_Field getfieldname $i]\n",\
"	    set fcomp [Ng_Vis_Field getfieldcomponents $i]\n",\
"	    set iscomplex [Ng_Vis_Field iscomplex $i]\n",\
"	    set sdim [Ng_Vis_Field getdimension]\n",\
"	    if { $iscomplex == 1 } { set fcomp [expr $fcomp / 2] }\n",\
"	    if { ($fcomp == $sdim) || ($fcomp == 3) } {\n",\
"		$w.vecfun add command $fname -label $fname\n",\
"	    } \n",\
"	}\n",\
"\n",\
"	$w.scalfun configure -variable visoptions.scalfunction\n",\
"	$w.scalfun configure -command { Ng_Vis_Set parameters; redraw }\n",\
"	$w.vecfun configure -variable visoptions.vecfunction\n",\
"	$w.vecfun configure -command { Ng_Vis_Set parameters; redraw }\n",\
"\n",\
"\n",\
"	# puts \"sclfunction = ${visoptions.scalfunction}\"\n",\
"\n",\
"\n",\
"	tixOptionMenu $w.evaluate -label \"Evaluate: \" \\\n",\
"	    -options {\n",\
"		label.width  18\n",\
"		label.anchor e\n",\
"		menubutton.width 12\n",\
"	    }	\n",\
"	$w.evaluate add command abs -label \"|.|\"\n",\
"	$w.evaluate add command abstens -label \"|tensor|\"\n",\
"	$w.evaluate add command mises -label \"Mises\"\n",\
"	$w.evaluate add command main  -label \"Main\"\n",\
"	$w.evaluate configure -variable visoptions.evaluate\n",\
"	$w.evaluate configure -command { \n",\
"	    Ng_Vis_Set parameters; \n",\
"	    redraw \n",\
"	}\n",\
"\n",\
"	pack $w.scalfun $w.vecfun $w.evaluate\n",\
"\n",\
"	tixControl $w.multidimcomp -label \"multidim-component: \" -integer true \\\n",\
"	    -variable visoptions.multidimcomponent -min 0 \\\n",\
"	    -command { Ng_Vis_Set parameters; redraw } \\\n",\
"	    -options {\n",\
"		entry.width 6\n",\
"		label.width 18\n",\
"		label.anchor e\n",\
"	    }	\n",\
"\n",\
"\n",\
"	pack $w.multidimcomp\n",\
"\n",\
"	pack $w.imaginary $w.logscale $w.usetexture $w.invcolor $w.redrawperiodic\n",\
"	pack $w.fieldlines \n",\
"	pack $w.fieldlines.enable $w.fieldlines.num $w.fieldlines.randomstart -side left\n",\
"\n",\
"\n",\
"	\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	frame $w.bu\n",\
"	pack $w.bu  -pady 5\n",\
"\n",\
"	button $w.bu.showsol -text \"Show Solution\" -command { \n",\
"	    set selectvisual solution\n",\
"	    Ng_SetVisParameters\n",\
"	    redraw\n",\
"	}\n",\
"	button $w.bu.clipping -text \"Clipping\" -command { \n",\
"	    clippingdialog; \n",\
"	}\n",\
"	button $w.bu.done -text \"Close\" -command { \n",\
"	    destroy .visoptions_dlg\n",\
"	}\n",\
"\n",\
"	pack $w.bu.showsol $w.bu.clipping $w.bu.done -side left -expand yes\n",\
"\n",\
"	wm withdraw $w\n",\
"	wm geom $w +100+100\n",\
"	wm deiconify $w\n",\
"	wm title $w \"Visualization\"\n",\
"\n",\
"    }\n",\
"}\n",\
"\n",\
"}\n",\
"\n",\
"catch { \n",\
"    # check some NGS command\n",\
"if { [catch { NGS_GetData } ] == 0 } { \n",\
"\n",\
"    set progname \"NGSolve\"\n",\
"    wm title . $progname\n",\
"\n",\
"    .ngmenu add cascade -label \"Solve\" -menu .ngmenu.solve -underline 1\n",\
"\n",\
"    # menubutton .mbar.solve -text Solve -underline 0 -menu .mbar.solve.menu\n",\
"    # pack .mbar.solve -side left\n",\
"\n",\
"    menu .ngmenu.solve\n",\
"    .ngmenu.solve add command -label \"Print Equations\" \\\n",\
"	-command { NGS_PrintRegistered }\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"    menu .ngmenusolvehelp\n",\
"    .ngmenu.solve add cascade -label \"Help\" -menu .ngmenusolvehelp\n",\
"\n",\
"    .ngmenusolvehelp add command -label \"Coefficient\" \\\n",\
"	-command { tk_messageBox -title \"Help\" -message  [ NGS_Help  coefficient ] -type ok }\n",\
"    .ngmenusolvehelp add command -label \"Bilinear-form\" \\\n",\
"	-command { tk_messageBox -title \"Help\" -message  [ NGS_Help  bilinearform ] -type ok }\n",\
"    .ngmenusolvehelp add command -label \"Linear-form\" \\\n",\
"	-command { tk_messageBox -title \"Help\" -message  [ NGS_Help  linearform ] -type ok }\n",\
"\n",\
"    # defined in C++ code:\n",\
"    .ngmenusolvehelp add cascade -label \"Numprocs\" -menu .ngmenusolvehelpnp \n",\
"    \n",\
"    .ngmenusolvehelp add command -label \"Latest News \"  \\\n",\
"	-command { tk_messageBox -title \"Latest News\" -message \\\n",\
"	    { \n",\
"06042004 online documentation (JS) \n",\
"	    } -type ok }  ;\n",\
"\n",\
"\n",\
"\n",\
"    .ngmenu.solve add command -label \"Load PDE\" -accelerator \"<l><p>\"\\\n",\
"	-command { \n",\
"	    set types { {\"Partial Differential Equation\"   {.pde}	} }\n",\
"	    set file [tk_getOpenFile -filetypes $types]\n",\
"	    if {$file != \"\"} {\n",\
"		AddRecentNGSFile $file;\n",\
"		NGS_LoadPDE  $file;  \n",\
"	    }\n",\
"	}\n",\
"\n",\
"    .ngmenu.solve add cascade -label \"Recent Files\" -menu .ngmenu.solve.recent \n",\
"    menu .ngmenu.solve.recent\n",\
"\n",\
"    .ngmenu.solve add command -label \"Components\" \\\n",\
"	-command { componentsdialog }\n",\
"\n",\
"\n",\
"    .ngmenu.solve add command -label \"Print Report\" \\\n",\
"	-command { NGS_PrintPDE }\n",\
"\n",\
"    .ngmenu.solve add command -label \"Memory Usage\" \\\n",\
"	-command { NGS_PrintMemoryUsage }\n",\
"\n",\
"\n",\
"#    .ngmenu.solve add command -label \"Play anim\" \\\n",\
"# 	-command { \n",\
"# 	    set selectvisual mesh;\n",\
"# 	    for { set i 1 } { $i <= 1000 } { incr i } {\n",\
"# 		#	    NGS_PlayAnim 5 175 kurbc;\n",\
"# 		#	    NGS_PlayAnim kurb 2 500;\n",\
"# 		NGS_PlayAnim 1 50 kurbc \n",\
"# 		update \n",\
"# 		.ndraw render;\n",\
"# 	    }\n",\
"\n",\
"	    #	set types { {\"MBS Solution Data\"   {.sol}	} }\n",\
"	    #	set file [tk_getOpenFile -filetypes $types]\n",\
"	    #	if {$file != \"\"} {\n",\
"	    #	    NGS_PlayAnim  $file;\n",\
"	    #	}\n",\
"#	}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"    .ngmenu.solve add command -label \"Solve Recent PDE\" -accelerator \"<s><r>\"\\\n",\
"	-command { \n",\
"	    NGS_LoadPDE  [.ngmenu.solve.recent entrycget 1 -label]\n",\
"	    NGS_SolvePDE\n",\
"	    set selectvisual solution\n",\
"	    Ng_SetVisParameters	\n",\
"	    redraw\n",\
"	}\n",\
"\n",\
"#    .ngmenu.solve add command -label \"Test Reissner-Mindlin\" \\\n",\
"\\#	-command { \n",\
"#	    NGS_TestRM\n",\
"#	}\n",\
"\n",\
"\n",\
"\n",\
"    button .bubar.pde -text \"Recent\" \\\n",\
"	-command { .ngmenu.solve invoke \"Solve Recent PDE\"; }\n",\
"    pack .bubar.pde -side right\n",\
"\n",\
"    button .bubar.solve -text \"Solve\" \\\n",\
"	-command { .ngmenu.solve invoke \"Solve PDE\"; }\n",\
"    pack .bubar.solve -side right\n",\
"\n",\
"\n",\
"\n",\
"    .ngmenu.solve add command -label \"Solve PDE\" -accelerator \"<s><p>\"\\\n",\
"	-command { \n",\
"	    NGS_SolvePDE\n",\
"	    set selectvisual solution\n",\
"	    Ng_SetVisParameters	\n",\
"	    redraw\n",\
"	}\n",\
"\n",\
"#     .ngmenu.solve add command -label \"Solve PDE 5x\" \\\n",\
"# 	-command { \n",\
"# 	    for { set i 1 } { $i <= 5 } { incr i } {\n",\
"# 		NGS_SolvePDE\n",\
"# 		set selectvisual solution\n",\
"# 		Ng_SetVisParameters	\n",\
"# 		redraw\n",\
"# 	    }\n",\
"# 	}\n",\
"\n",\
"#     .ngmenu.solve add command -label \"Solve PDE 8x\" \\\n",\
"# 	-command { \n",\
"# 	    for { set i 1 } { $i <= 8 } { incr i } {\n",\
"# 		NGS_SolvePDE\n",\
"# 		set selectvisual solution\n",\
"# 		Ng_SetVisParameters	\n",\
"# 		redraw\n",\
"# 	    }\n",\
"# 	}\n",\
"\n",\
"#     .ngmenu.solve add command -label \"Solve PDE 20x\" \\\n",\
"# 	-command { \n",\
"# 	    for { set i 1 } { $i <= 20 } { incr i } {\n",\
"# 		NGS_SolvePDE\n",\
"# 		set selectvisual solution\n",\
"# 		Ng_SetVisParameters	\n",\
"# 		redraw\n",\
"# 	    }\n",\
"# 	}\n",\
"\n",\
"\n",\
"    .ngmenu.solve add cascade -label \"Solve PDE x\" -menu .ngmenu.solve.solvex\n",\
"    menu .ngmenu.solve.solvex\n",\
"\n",\
"    proc SolveX { num } {\n",\
"	for { set i 1 } { $i <= $num } { incr i } {\n",\
"	    uplevel 1 {\n",\
"		NGS_SolvePDE\n",\
"	    }\n",\
"	}\n",\
"    }\n",\
"\n",\
"    \n",\
"    .ngmenu.solve.solvex  add command -label \"1 Level\" -command { SolveX 1 }\n",\
"    .ngmenu.solve.solvex  add command -label \"2 Level\" -command { SolveX 2 }\n",\
"    .ngmenu.solve.solvex  add command -label \"3 Level\" -command { SolveX 3 }\n",\
"    .ngmenu.solve.solvex  add command -label \"4 Level\" -command { SolveX 4 }\n",\
"    .ngmenu.solve.solvex  add command -label \"5 Level\" -command { SolveX 5 }\n",\
"    .ngmenu.solve.solvex  add command -label \"6 Level\" -command { SolveX 6 }\n",\
"    .ngmenu.solve.solvex  add command -label \"7 Level\" -command { SolveX 7 }\n",\
"    .ngmenu.solve.solvex  add command -label \"8 Level\" -command { SolveX 8 }\n",\
"    .ngmenu.solve.solvex  add command -label \"9 Level\" -command { SolveX 9 }\n",\
"    .ngmenu.solve.solvex  add command -label \"10 Level\" -command { SolveX 10 }\n",\
"    .ngmenu.solve.solvex  add command -label \"11 Level\" -command { SolveX 11 }\n",\
"    .ngmenu.solve.solvex  add command -label \"12 Level\" -command { SolveX 12 }\n",\
"    .ngmenu.solve.solvex  add command -label \"13 Level\" -command { SolveX 13 }\n",\
"    .ngmenu.solve.solvex  add command -label \"14 Level\" -command { SolveX 14 }\n",\
"    .ngmenu.solve.solvex  add command -label \"15 Level\" -command { SolveX 15 }\n",\
"    .ngmenu.solve.solvex  add command -label \"16 Level\" -command { SolveX 16 }\n",\
"    .ngmenu.solve.solvex  add command -label \"17 Level\" -command { SolveX 17 }\n",\
"    .ngmenu.solve.solvex  add command -label \"18 Level\" -command { SolveX 18 }\n",\
"    .ngmenu.solve.solvex  add command -label \"19 Level\" -command { SolveX 19 }\n",\
"    .ngmenu.solve.solvex  add command -label \"20 Level\" -command { SolveX 20 }\n",\
"\n",\
"#    for { set lev 1 } { $lev <= 20 } { incr lev } {\n",\
"#	set a { puts $lev; }\n",\
"#	.ngmenu.solve.solvex  add command -label \"$lev Level\" \\\n",\
"\\#	    -command { $a }\n",\
"#    }\n",\
"#		for { set i 1 } { $i <= $lev } { incr i } {\n",\
"#		    puts \"i = $i, lev = [expr $lev]\"\n",\
"#		    NGS_SolvePDE\n",\
"#    }\n",\
"\n",\
"\n",\
"    #    .ngmenu.solve add command -label \"Solve MBS\" \n",\
"    #  -command  { NGS_MBSSolver \"examples/kurbel.mbs\" }\n",\
"    #	set types { {\"MBS File\"   {.mbs}	} }\n",\
"    #	set file [tk_getOpenFile -filetypes $types]\n",\
"    #	if {$file != \" \"} {\n",\
"    #	    NGS_MBSSolver $file;  }\n",\
"\n",\
"\n",\
"    .ngmenu.solve add command -label \"Visualization\" \\\n",\
"	-command { \n",\
"	    visual_dialog;\n",\
"	}\n",\
"    \n",\
"\n",\
"#     .ngmenu.solve add command -label \"Demo session\" \\\n",\
"# 	-command {\n",\
"# 	    tk_messageBox -message \"Load PDE file\";\n",\
"# 	    NGS_LoadPDE ngsolve/pde_tutorial/d7_coil.pde;\n",\
"\n",\
"# 	    tk_messageBox -message \"Solve PDE\";\n",\
"# 	    NGS_SolvePDE\n",\
"\n",\
"# 	    tk_messageBox -message \"Switch to solution\";\n",\
"# 	    set selectvisual solution\n",\
"# 	    Ng_SetVisParameters	\n",\
"# 	    redraw\n",\
"\n",\
"# 	    tk_messageBox -message \"Define clipping plane\";\n",\
"# #	    clippingdialog\n",\
"# 	    set viewoptions.clipping.enable 1\n",\
"# 	    Ng_SetVisParameters; \n",\
"# 	    redraw;\n",\
"\n",\
"# 	    tk_messageBox -message \"Open visualization dialog\"\n",\
"# 	    visual_dialog;\n",\
"# 	    tk_messageBox -message \"Define clipping plane\";\n",\
"# 	}\n",\
"\n",\
"    \n",\
"    .ngmenu.solve add command -label \"Save Solution\" \\\n",\
"	-command { \n",\
"	    set types { {\"Solution File\"  {.sol} } }\n",\
"	    set file [tk_getSaveFile -filetypes $types -defaultextension \".sol\"  ]\n",\
"	    if {$file != \"\"} {\n",\
"		NGS_SaveSolution $file \n",\
"	    }\n",\
"	}\n",\
"    \n",\
"    .ngmenu.solve add command -label \"Load Solution\" \\\n",\
"	-command { \n",\
"	    set types { {\"Solution File\"  {.sol} } }\n",\
"	    set file [tk_getOpenFile -filetypes $types -defaultextension \".sol\"  ]\n",\
"	    if {$file != \"\"} {\n",\
"		NGS_LoadSolution $file \n",\
"		set selectvisual solution\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"	    }\n",\
"	}\n",\
"\n",\
"\n",\
"#    .ngmenu.solve add separator\n",\
"\n",\
"    if { 1 == 0 } {\n",\
"	.ngmenu.solve add command -label \"Load example mesh\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/cube.vol\"\n",\
"		Ng_LoadGeometry \"examples/cube.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Load Fichera\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/fichera0b.vol\"\n",\
"		Ng_LoadGeometry \"examples/fichera.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Load example charges\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/charges.vol\"\n",\
"		Ng_LoadGeometry \"examples/charges.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Load SAW\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"ngusers/saw_3d.vol\"\n",\
"		Ng_LoadGeometry \"ngusers/saw_3d.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Load emagnet\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/emagnet.vol\"\n",\
"		Ng_LoadGeometry \"examples/emagnet.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Load coil\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/coil.vol\"\n",\
"		Ng_LoadGeometry \"examples/coil.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Load magshield\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/magshield.vol\"\n",\
"		Ng_LoadGeometry \"examples/magshield.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Load coilshield\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/coilshield.vol\"\n",\
"		Ng_LoadGeometry \"examples/coilshield.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Prismatic mesh\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/lshape3dprism.vol\"\n",\
"		Ng_LoadGeometry \"examples/lshape3dprism.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"\n",\
"	.ngmenu.solve add command -label \"Edge refined mesh\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/lshape3daniso2.vol\"\n",\
"		Ng_LoadGeometry \"examples/lshape3d.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"	.ngmenu.solve add command -label \"Load Kaese\" \\\n",\
"	    -command { \n",\
"		Ng_LoadMesh \"examples/kaese.vol\"\n",\
"		Ng_LoadGeometry \"examples/kaese.geo\"\n",\
"		Ng_ParseGeometry\n",\
"\n",\
"		set selectvisual mesh\n",\
"		Ng_SetVisParameters\n",\
"		redraw\n",\
"		Ng_ReadStatus; \n",\
"	    }\n",\
"\n",\
"	.ngmenu.solve add separator\n",\
"	.ngmenu.solve add command -label \"Solve Laplace\" \\\n",\
"	    -command { \n",\
"		NGS_SolveBVP laplace\n",\
"	    }\n",\
"\n",\
"	.ngmenu.solve add command -label \"Solve Elasticity\" \\\n",\
"	    -command { \n",\
"		NGS_SolveBVP elasticity\n",\
"	    }\n",\
"\n",\
"	.ngmenu.solve add command -label \"Solve Maxwell\" \\\n",\
"	    -command { \n",\
"		NGS_SolveBVP maxwell\n",\
"	    }\n",\
"\n",\
"	.ngmenu.solve add command -label \"Solve 5 Laplace\" \\\n",\
"	    -command { \n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"	    }\n",\
"\n",\
"	.ngmenu.solve add command -label \"Solve 20 Laplace\" \\\n",\
"	    -command { \n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"		NGS_SolveBVP laplace\n",\
"	    }\n",\
"\n",\
"	.ngmenu.solve add command -label \"Solve Laplace P\" \\\n",\
"	    -command { \n",\
"		NGS_SolveBVP laplacep 3\n",\
"	    }\n",\
"    }\n",\
"\n",\
"\n",\
"#    .ngmenu.solve add command -label \"Waves\" \\\n",\
"#	-command { \n",\
"	    #	Ng_LoadGeometry examples/quad.in2d\n",\
"	    #	Ng_LoadMesh examples/quad4.vol; \n",\
"	    #	NGS_Waves 50 11\n",\
"#	    Ng_LoadGeometry examples/piezo2d2round.in2d\n",\
"#	    Ng_LoadMesh examples/piezo2d2roundf.vol; \n",\
"	    #	NGS_Waves 1.5708 31\n",\
"#	    NGS_Waves 2.5 29\n",\
"#	    NGS_Waves interpolate\n",\
"#	}\n",\
"\n",\
"#    .ngmenu.solve add command -label \"Interpolate Waves\" \\\n",\
"#	-command { \n",\
"#	    NGS_Waves interpolate\n",\
"#	}\n",\
"\n",\
"\n",\
"\n",\
"    .ngmenu.help delete \"About\"\n",\
"    .ngmenu.help add command -label \"About\" \\\n",\
"	-command {\n",\
"	    tk_messageBox -message \\\n",\
"		\"This is NETGEN/NGSolve \\n mainly written by \\n Joachim Schberl \\n\\\n",\
"                 at Johannes Kepler University, Linz, Austria \\n\\\n",\
"                 supported by the Austrian Science Foundation FWF \\n\\\n",\
"                 thanks to \\n\\\n",\
"                 F. Bachinger, A. Becirovic, R. Gaisbauer, J. Gerstmayr, U. Langer, S. Zaglmayr\"\n",\
"	}\n",\
"    \n",\
"\n",\
"\n",\
"\n",\
"    proc AddRecentNGSFile { filename } {\n",\
"	global progname\n",\
"	catch { [.ngmenu.solve.recent delete $filename] }\n",\
"	.ngmenu.solve.recent insert 0 command -label $filename \\\n",\
"	    -command \"AddRecentNGSFile {$filename}; \n",\
"		NGS_LoadPDE  {$filename};\n",\
"                wm title . [concat \\\" $progname - $filename \\\"];\"\n",\
"	\n",\
"	if { [.ngmenu.solve.recent index last] >= 6 } {\n",\
"	    .ngmenu.solve.recent delete last }\n",\
"	\n",\
"	savengsinifile;\n",\
"    }\n",\
"    \n",\
"\n",\
"    # the ini file is saved  on demand :\n",\
"    proc savengsinifile { } {\n",\
"	uplevel 1  {\n",\
"	    set datei [open ngs.ini w]\n",\
"	    for { set i [.ngmenu.solve.recent index last] } { $i >= 1 } { incr i -1 } {\n",\
"		puts $datei \"recentfile \\\"[.ngmenu.solve.recent entrycget $i -label]\\\"\"\n",\
"	    }\n",\
"	\n",\
"	    close $datei\n",\
"	}\n",\
"    }\n",\
"    \n",\
"    proc loadngsinifile { } {\n",\
"	if { [file exists ngs.ini] == 1 } {\n",\
"	    set datei [open ngs.ini r]\n",\
"	    while { [gets $datei line] >= 0 } {\n",\
"		if {[lindex $line 0] == \"recentfile\"} {\n",\
"		    AddRecentNGSFile [lindex $line 1]\n",\
"		}\n",\
"	    }\n",\
"	    close $datei\n",\
"	}\n",\
"    }\n",\
"\n",\
"    loadngsinifile;\n",\
"    \n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"    proc componentsdialog { } {\n",\
"	\n",\
"	set w .components_dlg\n",\
"	\n",\
"	if {[winfo exists .components_dlg] == 1} {\n",\
"	    wm withdraw $w\n",\
"	    wm deiconify $w\n",\
"	    focus $w \n",\
"	} {\n",\
"\n",\
"	    toplevel $w\n",\
"\n",\
"\n",\
"	    tixTree $w.mtre -options { separator \"\\\\\" }\n",\
"	    pack $w.mtre -fill both -expand y\n",\
"	    set hlist [$w.mtre subwidget hlist]\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"	    $hlist add coeffs -itemtype text -text \"Coefficients\"\n",\
"	    set coefs [NGS_GetData coefficients]\n",\
"	    foreach coef $coefs {\n",\
"		$hlist add coeffs\\\\$coef -itemtype text -text $coef\n",\
"	    }\n",\
"\n",\
"\n",\
" 	    $hlist add spaces -itemtype text -text \"Spaces\"\n",\
"	    set spaces [NGS_GetData spaces]\n",\
"	    foreach space $spaces {\n",\
"		$hlist add spaces\\\\$space -itemtype text -text $space\n",\
"	    }\n",\
"\n",\
" 	    $hlist add biforms -itemtype text -text \"Bilinear-forms\"\n",\
"	    set biforms [NGS_GetData bilinearforms]\n",\
"	    foreach biform $biforms {\n",\
"		$hlist add biforms\\\\$biform -itemtype text -text $biform\n",\
"	    }\n",\
"\n",\
" 	    $hlist add liforms -itemtype text -text \"Linear-forms\"\n",\
"	    set liforms [NGS_GetData linearforms]\n",\
"	    foreach liform $liforms {\n",\
"		$hlist add liforms\\\\$liform -itemtype text -text $liform\n",\
"	    }\n",\
"\n",\
" 	    $hlist add gridfuns -itemtype text -text \"Grid-functions\"\n",\
"	    set gridfuns [NGS_GetData gridfunctions]\n",\
"	    foreach gridfun $gridfuns {\n",\
"		$hlist add gridfuns\\\\$gridfun -itemtype text -text $gridfun\n",\
"	    }\n",\
"\n",\
" 	    $hlist add preconds -itemtype text -text \"Preconditioners\"\n",\
"	    set preconds [NGS_GetData preconditioners]\n",\
"	    foreach precond $preconds {\n",\
"		$hlist add preconds\\\\$precond -itemtype text -text $precond\n",\
"	    }\n",\
"\n",\
" 	    $hlist add numprocs -itemtype text -text \"NumProcs\"\n",\
"	    set numprocs [NGS_GetData numprocs]\n",\
"	    foreach numproc $numprocs {\n",\
"		$hlist add numprocs\\\\$numproc -itemtype text -text $numproc\n",\
"	    }\n",\
"\n",\
"#	    $hlist add varis -itemtype text -text \"Variables\"\n",\
"#	    set varis [NGS_GetData variables]\n",\
"#	    foreach vari $varis {\n",\
"#		$hlist add varis\\\\$vari -itemtype text -text $vari\n",\
"#	    }\n",\
"\n",\
"#	    $hlist add varis2 -itemtype text -text \"Variables2\"\n",\
"#	    set varis2 [NGS_GetData variablesval]\n",\
"#	    foreach vari $varis2 {\n",\
"#		scan $vari \"val%fname%s\" vval vname\n",\
"#		$hlist add varis2\\\\$vari  -itemtype text -text [format \"%s %1.3e\" $vname $vval]\n",\
"#	    }\n",\
"\n",\
"	    \n",\
"\n",\
"\n",\
"\n",\
"# 	    for { set i 1 } { $i <= $nspaces } { incr i } {\n",\
"# 		set name [NGS_GetData spacename $i]\n",\
"# 		$hlist add spaces\\\\$name -itemtype text -text $name\n",\
"# 	    }\n",\
"\n",\
"# 	    $hlist add gridfunctions -itemtype text -text \"Grid-functions\"\n",\
"# 	    set ngf [NGS_GetData numgridfunctions]\n",\
"# 	    for { set i 1 } { $i <= $ngf } { incr i } {\n",\
"# 		set name [NGS_GetData gridfunctionname $i]\n",\
"# 		$hlist add gridfunctions\\\\$name -itemtype text -text $name\n",\
"# 	    }\n",\
"\n",\
"# 	    $hlist add bf -itemtype text -text \"Bilinear-forms\"\n",\
"# 	    set nbf [NGS_GetData numbilinearforms]\n",\
"# 	    for { set i 1 } { $i <= $nbf } { incr i } {\n",\
"# 		set name [NGS_GetData bilinearformname $i]\n",\
"# 		$hlist add bf\\\\$name -itemtype text -text $name\n",\
"\n",\
"# 		set nbfi [NGS_GetData numbilinearformcomps $name]\n",\
"# 		for { set j 1 } { $j <= $nbfi } { incr j } {\n",\
"# 		    set compname [NGS_GetData bilinearformcompname $name $j]\n",\
"# 		    $hlist add bf\\\\$name\\\\$j -itemtype text -text $compname\n",\
"# 		}\n",\
"# 	    }\n",\
"\n",\
"# 	    $hlist add lf -itemtype text -text \"Linear-forms\"\n",\
"# 	    set nlf [NGS_GetData numlinearforms]\n",\
"# 	    for { set i 1 } { $i <= $nlf } { incr i } {\n",\
"# 		set name [NGS_GetData linearformname $i]\n",\
"# 		$hlist add lf\\\\$name -itemtype text -text $name\n",\
"\n",\
"# 		set nlfi [NGS_GetData numlinearformcomps $name]\n",\
"# 		for { set j 1 } { $j <= $nlfi } { incr j } {\n",\
"# 		    set compname [NGS_GetData linearformcompname $name $j]\n",\
"# 		    $hlist add lf\\\\$name\\\\$j -itemtype text -text $compname\n",\
"# 		}\n",\
"# 	    }\n",\
"\n",\
"	    $w.mtre autosetmode\n",\
"	    \n",\
"\n",\
"	    bind $hlist <Double-1> {\n",\
"		set solname [[.components_dlg.mtre subwidget hlist] info selection]\n",\
"		puts $solname\n",\
"		set seppos [string first \\\\ $solname]\n",\
"		if { $seppos != -1 } {\n",\
"		    set field [string range $solname 1 [expr $seppos-1]]\n",\
"		    set name [string range $solname [expr $seppos+1] [expr [string length $solname]-2]]\n",\
"		    puts \"field = $field, name = $name\"\n",\
"		    NGS_PrintPDE $field $name\n",\
"		}\n",\
"	    }\n",\
"\n",\
"	    button $w.cl -text \"Close\" -command {\n",\
"		destroy .components_dlg\n",\
"	    }\n",\
"\n",\
"	    pack  $w.cl\n",\
"	    \n",\
"	    \n",\
"	    wm withdraw $w\n",\
"	    wm geom $w +100+100\n",\
"	    wm deiconify $w\n",\
"	    wm title $w \"Components\"\n",\
"	    focus .components_dlg\n",\
"	}\n",\
"    }\n",\
"\n",\
"    bind . <l><p> { .ngmenu.solve invoke \"Load PDE\" }  ; \n",\
"    bind . <s><r> { .ngmenu.solve invoke \"Solve Recent PDE\" }  ; \n",\
"    bind . <s><p> { .ngmenu.solve invoke \"Solve PDE\" }  ; \n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"}\n",\
"\n",\
"\n",\
"# trafo/zugstange : menu\n",\
"##################################################\n",\
"set zugstange 0\n",\
"\n",\
"\n",\
"setgranularity ${meshoptions.fineness}\n",\
"\n",\
"Ng_SetMeshingParameters\n",\
"Ng_SetVisParameters\n",\
"Ng_SetDebugParameters\n",\
"Ng_STLDoctor\n",\
"Ng_GeometryOptions set\n",\
"\n",\
"catch { \n",\
"     wm protocol . WM_DELETE_WINDOW { .ngmenu.file invoke \"Quit\" }\n",\
"     wm deiconify .\n",\
"}\n",\
"\n",\
"set trafoapp 0\n",\
"\n",\
"set geofilename [Ng_GetCommandLineParameter geofile]\n",\
"if { $geofilename != \"undefined\" && \n",\
"     [info exists trafo] == 0 && $zugstange == 0} {\n",\
"\n",\
"    if { [ catch { Ng_LoadGeometry $geofilename } errstring] == 0 } {\n",\
"	AddRecentFile $geofilename\n",\
"	Ng_ParseGeometry\n",\
"	set selectvisual geometry\n",\
"	Ng_SetVisParameters\n",\
"	redraw\n",\
"	wm title . [concat \"$progname - \" $geofilename]\n",\
"	set dirname [file dirname $geofilename]\n",\
"	set basefilename [file tail [file rootname $geofilename]]\n",\
"    } {\n",\
"	puts \"Problem with input file:\"\n",\
"	puts \"$errstring\"\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"set cnt 0\n",\
"foreach { gran } { verycoarse coarse moderate fine veryfine } {\n",\
"    set cnt [expr $cnt + 1]\n",\
"    if { [Ng_GetCommandLineParameter $gran] == \"defined\" } {\n",\
"	set meshoptions.fineness $cnt\n",\
"	setgranularity ${meshoptions.fineness}\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"set meshfilename [Ng_GetCommandLineParameter meshfile]\n",\
"if { $meshfilename == \"undefined\" } {\n",\
"    set meshfilename out.mesh\n",\
"}\n",\
"\n",\
"set meshfiletype [Ng_GetCommandLineParameter meshfiletype]\n",\
"if { $meshfiletype == \"undefined\" } {\n",\
"    set meshfiletype netgen\n",\
"}\n",\
"\n",\
"\n",\
"set batchmode [Ng_GetCommandLineParameter batchmode]\n",\
"if { $batchmode == \"defined\" } {\n",\
"\n",\
"    set options.parthread 0\n",\
"\n",\
"#    set selectvisual mesh\n",\
"#    Ng_SetVisParameters\n",\
"\n",\
"    Ng_GenerateMesh ${meshoptions.firststep} ${meshoptions.laststep}\n",\
"\n",\
"    if { $meshfiletype == \"netgen\" } {\n",\
"	Ng_SaveMesh $meshfilename\n",\
"    } {\n",\
"	if { [catch { Ng_ExportMesh $meshfilename $meshfiletype } ] == 1 } {\n",\
"	    puts \"Unknown file format $meshfiletype\"\n",\
"	}\n",\
"    }\n",\
"    \n",\
"    exit\n",\
"}\n",\
"\n",\
"\n",\
"set stereo [Ng_GetCommandLineParameter stereo]\n",\
"if { $stereo == \"defined\" } {\n",\
"    set viewoptions.stereo 1 \n",\
"    puts \"use stereo mode\" \n",\
"    Ng_SetVisParameters; \n",\
"    redraw \n",\
"}\n",\
"\n",\
"\n",\
"set scriptfilename [Ng_GetCommandLineParameter script]\n",\
"if { $scriptfilename != \"undefined\" } {\n",\
"    if { [catch { source $scriptfilename } errstring] == 1 } {\n",\
"	puts \"Error in input: $errstring\"\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"if { [Ng_GetCommandLineParameter help]==\"defined\" } {\n",\
"    if { $zugstange == 1 } {\n",\
"	print_zug_commandline_help\n",\
"	exit;\n",\
"    } {\n",\
"	if { $trafoapp == 1 } {\n",\
"	    print_trafo_commandline_help;\n",\
"	} {\n",\
"	    print_commandline_help; \n",\
"	}\n",\
"    }\n",\
"}\n",\
"\n",\
"if { [file exists startup.tcl] } {\n",\
"    source startup.tcl }\n",\
"\n",\
"if { [Ng_GetCommandLineParameter recent]==\"defined\" } {\n",\
"    if { [catch { .ngmenu.solve invoke \"Solve Recent PDE\";  } errstring] == 1 } {\n",\
"	puts \"TCL-ERROR handler:\\n $errstring\";\n",\
"	exit;\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"set pdefilename [Ng_GetCommandLineParameter pdefile]\n",\
"if { $pdefilename != \"undefined\" } {\n",\
"    NGS_LoadPDE  $pdefilename;  \n",\
"\n",\
"    set solve [Ng_GetCommandLineParameter solve]\n",\
"    if { $zugstange == 1 } {\n",\
"	set options.parthread 0\n",\
"	NGS_SolvePDE;\n",\
"    } {\n",\
"	if { $solve == \"defined\" } {\n",\
"	    set options.parthread 0\n",\
"	    NGS_SolvePDE\n",\
"	    exit;\n",\
"	} {\n",\
"	    if { $solve != \"undefined\" } {\n",\
"		set options.parthread 0\n",\
"		for { set l 1 } { $l <= $solve } { incr l } { NGS_SolvePDE }\n",\
"		exit;\n",\
"	    }\n",\
"	}\n",\
"    }\n",\
"}\n",\
"\n",\
"\n",\
"\n",\
"\n",\
0};
