/**************************************************************************/
/* File:   localheap.cpp                                                  */
/* Author: Joachim Schoeberl                                              */
/* Date:   19. Apr. 2002                                                  */
/**************************************************************************/


#include <ngstd.hpp>

namespace ngstd
{
  using namespace ngstd;

  LocalHeap :: LocalHeap (unsigned int asize)
  {
    totsize = asize;
    data = new char[asize];
    p = data;
    owner = 1;
  }


  void LocalHeap :: ThrowException() throw (LocalHeapOverflow)
  {
    throw LocalHeapOverflow();
  }


  LocalHeapOverflow :: LocalHeapOverflow () 
    : Exception("Local Heap overflow, please use 'define constant heapsize = xxx' with larger value") 
  {
    ;
  }
  
  LocalHeapOverflow :: ~LocalHeapOverflow ()
  {
    ; 
  }

}

