#ifndef FILE_SPECIALELEMENT
#define FILE_SPECIALELEMENT

/*********************************************************************/
/* File:   specialelement.hpp                                        */
/* Author: Joachim Schoeberl                                         */
/* Date:   28. Mar. 2002                                             */
/*********************************************************************/

/*
  Something special ...

  Finite-Element + Integrator

  E.g., a Contact-Element  
*/



class SpecialElement
{
public:
  SpecialElement () { ; }
  virtual ~SpecialElement() { ; }

  virtual void GetDofNrs (ARRAY<int> & dnums) const = 0;
  virtual double Energy (const FlatVector<double> & elx, 
			 LocalHeap & lh) const
  {
    return 0;
  }
  virtual double Energy (const FlatVector<Complex> & elx, 
			 LocalHeap & lh) const 
  {
    cerr << "SpecialElemnt::Energy (complex) called" << endl;
    return 0;
  }

  virtual void Apply (const FlatVector<double> & elx, FlatVector<double> & ely, 
		      LocalHeap & lh) const;

  virtual void Apply (const FlatVector<Complex> & elx, 
		      FlatVector<Complex> & ely, 
		      LocalHeap & lh) const
  {
    cerr << "SpecialElemnt::Apply (complex) called" << endl;
  }

  virtual void Assemble (FlatMatrix<double> & elmat,
			 LocalHeap & lh) const;

  virtual void Assemble (FlatMatrix<Complex> & elmat,
			 LocalHeap & lh) const
  {
    cerr << "SpecialElemnt::Assemble (complex) called" << endl;
    FlatMatrix<double> relmat;
    Assemble (relmat, lh);
    elmat.AssignMemory (relmat.Height(), relmat.Width(), lh);
    elmat = relmat;
  }
};

#endif
