#ifndef _INCLUDES_H
#define _INCLUDES_H

/* includes.h -- Data structures and include files used by all the source.

   Copyright (C) 2007-2014 Eloy Paris <peloy@netexpect.org>

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/wait.h>

#if defined(BSD) || defined(__OpenBSD__)
#include <sys/ioctl.h> /* Needed for the BIOCIMMEDIATE ioctl() in FreeBSD
			  and OS X */
#ifdef __OpenBSD__
#include <net/bpf.h> /* Needed for the BIOCIMMEDIATE ioctl() call */
#endif
#endif

#include <pcap.h>
#include <dnet.h>
#include <epan/epan.h>

#ifdef HAVE_SYS_BUFMOD_H
#include <sys/bufmod.h> /* Needed for SBIOCSCHUNK and SBIOCSTIME on Solaris */
#endif

#include <errno.h>
#include <tcl.h>

#ifdef HAVE_TCLX8_4_TCLEXTEND_H
#include <tclx8.4/tclExtend.h>
#endif

#ifdef HAVE_TCL8_4_EXPECT_TCL_H
#include <tcl8.4/expect_tcl.h>
#endif

#include "missing.h"
#include "nexp.h"
#include "nexp_tclvars.h"
#include "payload.h"
#include "numbers.h"
#include "packets.h"
#include "usr.h"
#include "pbuild.h"
#include "xmalloc.h"
#include "xstrdup.h"
#include "util.h"
#include "netexpect_comm.h"
#include "nexp_commands.h"
#include "nexp_log.h"
#include "nexp_pcap.h"
#include "nexp_pbuild.h"
#include "nexp_ghost.h"
#include "nexp_tgn.h"
#include "send_network.h"
#include "spawn_network.h"
#include "expect_network.h"
#include "send_expect.h"
#include "send_receive.h"
#include "tcl_pbuild.h"
#include "tcl_barray.h"
#include "tcl_packet.h"
#include "tcl_timeval.h"
#include "tcl_numspec.h"
#include "tcl_usr.h"
#include "nexp_iface.h"
#include "byteorder.h" /* Stolen from Samba/rsync */
#include "wire.h"

#endif /* _INCLUDES_H */
