/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.svg.Metadata;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LNode;

class LogicalStructure {
    LNode[] nodes;
    LEdge[] edges;

    public static LogicalStructure build(Vector glyphs) {
        Hashtable<String, Vector> title2node = new Hashtable<String, Vector>();
        Hashtable title2edgeGroup = new Hashtable();
        int edgeCount = 0;
        for (int i = 0; i < glyphs.size(); ++i) {
            Vector v;
            String title;
            Glyph g = (Glyph)glyphs.elementAt(i);
            Metadata md = (Metadata)g.getOwner();
            if (md == null || (title = md.getTitle()) == null) continue;
            if (title.indexOf("->") != -1 || title.indexOf("--") != -1) {
                Hashtable<String, Vector> t;
                String cagid = md.getClosestAncestorGroupID();
                if (title2edgeGroup.containsKey(title)) {
                    t = (Hashtable<String, Vector>)title2edgeGroup.get(title);
                    if (t.containsKey(cagid)) {
                        v = (Vector)t.get(cagid);
                        v.add(g);
                        continue;
                    }
                    v = new Vector();
                    v.add(g);
                    t.put(cagid, v);
                    ++edgeCount;
                    continue;
                }
                v = new Vector();
                v.add(g);
                t = new Hashtable<String, Vector>(3);
                t.put(cagid, v);
                title2edgeGroup.put(title, t);
                ++edgeCount;
                continue;
            }
            if (title2node.containsKey(title)) {
                v = (Vector)title2node.get(title);
                v.add(g);
                continue;
            }
            v = new Vector();
            v.add(g);
            title2node.put(title, v);
        }
        LogicalStructure res = new LogicalStructure(title2node, title2edgeGroup, edgeCount);
        title2edgeGroup.clear();
        title2node.clear();
        return res.isEmpty() ? null : res;
    }

    LogicalStructure(Hashtable title2node, Hashtable title2edgeGroup, int edgeCount) {
        String title;
        this.nodes = new LNode[title2node.size()];
        int i = 0;
        Enumeration e = title2node.keys();
        while (e.hasMoreElements()) {
            title = (String)e.nextElement();
            this.nodes[i] = new LNode(title, (Vector)title2node.get(title));
            ++i;
        }
        i = 0;
        this.edges = new LEdge[edgeCount];
        Enumeration e2 = title2edgeGroup.keys();
        while (e2.hasMoreElements()) {
            title = (String)e2.nextElement();
            Hashtable group2edge = (Hashtable)title2edgeGroup.get(title);
            Enumeration e22 = group2edge.elements();
            while (e22.hasMoreElements()) {
                this.edges[i] = new LEdge(title, (Vector)e22.nextElement());
                ++i;
            }
        }
        for (int j = 0; j < this.edges.length; ++j) {
            int id = this.edges[j].title.indexOf("->");
            if (id != -1) {
                this.edges[j].setDirected(true);
                this.edges[j].setTail(this.getNode(this.edges[j].title.substring(0, id)));
                this.edges[j].setHead(this.getNode(this.edges[j].title.substring(id + 2)));
                continue;
            }
            id = this.edges[j].title.indexOf("--");
            if (id == -1) continue;
            this.edges[j].setDirected(false);
            this.edges[j].setTail(this.getNode(this.edges[j].title.substring(0, id)));
            this.edges[j].setHead(this.getNode(this.edges[j].title.substring(id + 2)));
        }
    }

    LNode getNode(String title) {
        Object res = null;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].title.equals(title)) continue;
            return this.nodes[i];
        }
        return null;
    }

    boolean isEmpty() {
        return this.nodes.length == 0 || this.edges.length == 0;
    }

    public String toString() {
        int i;
        String res = "";
        for (i = 0; i < this.nodes.length; ++i) {
            res = res + this.nodes[i].toString() + "\n";
        }
        for (i = 0; i < this.edges.length; ++i) {
            res = res + this.edges[i].toString() + "\n";
        }
        return res;
    }

    static LNode getNode(Glyph g) {
        Object o;
        Object object = o = g != null ? g.getOwner() : null;
        if (o != null) {
            return o instanceof LNode ? (LNode)o : null;
        }
        return null;
    }

    static LEdge getEdge(Glyph g) {
        Object o;
        Object object = o = g != null ? g.getOwner() : null;
        if (o != null) {
            return o instanceof LEdge ? (LEdge)o : null;
        }
        return null;
    }
}

