/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.glyphs.ClosedShape;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.svg.Metadata;
import java.util.Vector;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LElem;

class LNode
extends LElem {
    LEdge[] edges;
    short[] edgeDirections;

    LNode(String title, Vector glyphs) {
        int i;
        this.title = title;
        this.glyphs = new Glyph[glyphs.size()];
        this.URLs = new String[glyphs.size()];
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i] = (Glyph)glyphs.elementAt(i);
            if (this.glyphs[i].getOwner() == null) continue;
            this.URLs[i] = ((Metadata)this.glyphs[i].getOwner()).getURL();
        }
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i].setOwner(this);
        }
        this.edges = new LEdge[0];
        this.edgeDirections = new short[0];
    }

    String getURL(Glyph g) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (g != this.glyphs[i]) continue;
            return this.URLs[i];
        }
        return null;
    }

    void addArc(LEdge e, short direction) {
        LEdge[] nedges = new LEdge[this.edges.length + 1];
        short[] nedgeDirections = new short[nedges.length];
        System.arraycopy(this.edges, 0, nedges, 0, this.edges.length);
        System.arraycopy(this.edgeDirections, 0, nedgeDirections, 0, this.edgeDirections.length);
        nedges[this.edges.length] = e;
        nedgeDirections[this.edgeDirections.length] = direction;
        this.edges = nedges;
        this.edgeDirections = nedgeDirections;
    }

    LEdge[] getAllArcs() {
        LEdge[] res = new LEdge[this.edges.length];
        System.arraycopy(this.edges, 0, res, 0, this.edges.length);
        return res;
    }

    LEdge[] getOtherArcs(LEdge arc) {
        int count = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (arc == this.edges[i]) continue;
            ++count;
        }
        LEdge[] res = new LEdge[count];
        int j = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (arc == this.edges[i]) continue;
            res[j++] = this.edges[i];
        }
        return res;
    }

    LEdge[] getOutgoingArcs() {
        int oaCount = 0;
        for (int i = 0; i < this.edgeDirections.length; ++i) {
            if (this.edgeDirections[i] != 2) continue;
            ++oaCount;
        }
        LEdge[] res = new LEdge[oaCount];
        int j = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edgeDirections[i] != 2) continue;
            res[j++] = this.edges[i];
        }
        return res;
    }

    LEdge[] getIncomingArcs() {
        int oaCount = 0;
        for (int i = 0; i < this.edgeDirections.length; ++i) {
            if (this.edgeDirections[i] != 1) continue;
            ++oaCount;
        }
        LEdge[] res = new LEdge[oaCount];
        int j = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edgeDirections[i] != 1) continue;
            res[j++] = this.edges[i];
        }
        return res;
    }

    LEdge[] getUndirectedArcs() {
        int oaCount = 0;
        for (int i = 0; i < this.edgeDirections.length; ++i) {
            if (this.edgeDirections[i] != 0) continue;
            ++oaCount;
        }
        LEdge[] res = new LEdge[oaCount];
        int j = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edgeDirections[i] != 0) continue;
            res[j++] = this.edges[i];
        }
        return res;
    }

    ClosedShape getShape() {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (!(this.glyphs[i] instanceof ClosedShape)) continue;
            return (ClosedShape)this.glyphs[i];
        }
        return null;
    }

    public String toString() {
        String res = this.title + "[";
        for (int i = 0; i < this.edges.length; ++i) {
            res = res + (this.edges[i] != null ? this.edges[i].title + "@" + this.edges[i].hashCode() : "NULL") + "(" + this.edgeDirections[i] + ") ";
        }
        res = res + "]";
        return res;
    }
}

