/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.VText;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VBText
extends VText {
    Color borderColor = Color.black;
    Color fillColor = Color.white;
    public int paddingX = 10;
    public int paddingY = 10;

    public VBText(long x, long y, int z, Color c, String t) {
        super(x, y, z, c, t);
        this.sensit = true;
    }

    public VBText(long x, long y, int z, Color textColor, Color borderColor, Color fillColor, String text) {
        super(x, y, z, textColor, text);
        this.fillColor = fillColor;
        this.borderColor = borderColor;
    }

    public VBText(long x, long y, int z, Color textColor, Color borderColor, Color fillColor, String text, short ta) {
        super(x, y, z, textColor, text, ta);
        this.fillColor = fillColor;
        this.borderColor = borderColor;
    }

    public boolean coordInside(int x, int y, int camIndex) {
        boolean res = this.text_anchor == 0 ? x >= this.pc[camIndex].cx && (float)x <= (float)this.pc[camIndex].cx + this.coef * (float)this.pc[camIndex].cw && y <= this.pc[camIndex].cy && (float)y >= (float)this.pc[camIndex].cy - this.coef * (float)this.pc[camIndex].ch : (this.text_anchor == 1 ? (float)x >= (float)this.pc[camIndex].cx - this.coef * (float)this.pc[camIndex].cw / 2.0f && (float)x <= (float)this.pc[camIndex].cx + this.coef * (float)this.pc[camIndex].cw / 2.0f && y <= this.pc[camIndex].cy && (float)y >= (float)this.pc[camIndex].cy - this.coef * (float)this.pc[camIndex].ch : (float)x >= (float)this.pc[camIndex].cx - this.coef * (float)this.pc[camIndex].cw && x <= this.pc[camIndex].cx && y <= this.pc[camIndex].cy && (float)y >= (float)this.pc[camIndex].cy - this.coef * (float)this.pc[camIndex].ch);
        return res;
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        this.trueCoef = this.scaleFactor * this.coef;
        if (this.trueCoef * fontSize > this.vsm.getTextDisplayedAsSegCoef() || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VirtualSpaceManager.getMainFont());
            if (!this.pc[i].valid) {
                this.bounds = g.getFontMetrics().getStringBounds(this.text, g);
                this.pc[i].cw = (int)Math.round((this.bounds.getWidth() + (double)(2 * this.paddingX)) * (double)this.scaleFactor);
                this.pc[i].ch = (int)Math.round((this.bounds.getHeight() + (double)(2 * this.paddingY)) * (double)this.scaleFactor);
                this.pc[i].valid = true;
            }
            this.at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((float)(dx + this.pc[i].cx) - (float)this.pc[i].cw * this.coef / 2.0f, dy + this.pc[i].cy) : AffineTransform.getTranslateInstance((float)(dx + this.pc[i].cx) - (float)this.pc[i].cw * this.coef, dy + this.pc[i].cy));
            if (this.zoomSensitive) {
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
            }
            g.setTransform(this.at);
            g.setColor(this.fillColor);
            int rectW = Math.round((float)this.pc[i].cw / this.scaleFactor);
            int rectH = Math.round((float)this.pc[i].ch / this.scaleFactor);
            g.fillRect(dx, dy - rectH, rectW, rectH);
            g.setColor(this.borderColor);
            g.drawRect(dx, dy - rectH, rectW, rectH);
            g.setColor(this.color);
            g.drawString(this.text, this.paddingX, -this.paddingY);
            g.setTransform(stdT);
        } else {
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        this.trueCoef = this.scaleFactor * this.coef;
        if (this.trueCoef * fontSize > this.vsm.getTextDisplayedAsSegCoef() || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VirtualSpaceManager.getMainFont());
            if (!this.pc[i].lvalid) {
                this.bounds = g.getFontMetrics().getStringBounds(this.text, g);
                this.pc[i].lcw = (int)Math.round((this.bounds.getWidth() + (double)(2 * this.paddingX)) * (double)this.scaleFactor);
                this.pc[i].lch = (int)Math.round((this.bounds.getHeight() + (double)(2 * this.paddingY)) * (double)this.scaleFactor);
                this.pc[i].lvalid = true;
            }
            this.at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((float)(dx + this.pc[i].lcx) - (float)this.pc[i].lcw * this.coef / 2.0f, dy + this.pc[i].lcy) : AffineTransform.getTranslateInstance((float)(dx + this.pc[i].lcx) - (float)this.pc[i].lcw * this.coef, dy + this.pc[i].lcy));
            if (this.zoomSensitive) {
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
            }
            g.setTransform(this.at);
            g.setColor(this.fillColor);
            int rectW = Math.round((float)this.pc[i].lcw / this.scaleFactor);
            int rectH = Math.round((float)this.pc[i].lch / this.scaleFactor);
            g.fillRect(dx, dy - rectH, rectW, rectH);
            g.setColor(this.borderColor);
            g.drawRect(dx, dy - rectH, rectW, rectH);
            g.setColor(this.color);
            g.drawString(this.text, this.paddingX, -this.paddingY);
            g.setTransform(stdT);
        } else {
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short mouseInOut(int x, int y, int camIndex) {
        if (this.coordInside(x, y, camIndex)) {
            if (this.pc[camIndex].prevMouseIn) return 0;
            this.pc[camIndex].prevMouseIn = true;
            return (short)1;
        }
        if (!this.pc[camIndex].prevMouseIn) return (short)0;
        this.pc[camIndex].prevMouseIn = false;
        return (short)-1;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBackgroundFillColor(Color c) {
        this.fillColor = c;
    }

    public Color getBackgroundFillColor() {
        return this.fillColor;
    }
}

