/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.RenderingHints;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Vector;
import net.claribole.zvtm.engine.ViewEventHandler;

public class AccViewPanel
extends ViewPanel
implements Runnable {
    VolatileImage backBuffer;
    int valCode;

    public AccViewPanel(Vector cameras, View v) {
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (AccViewPanel.this.isShowing()) {
                    AccViewPanel.this.start();
                } else {
                    AccViewPanel.this.stop();
                }
            }
        });
        this.parent = v;
        this.cams = new Camera[cameras.size()];
        this.evHs = new ViewEventHandler[this.cams.length];
        for (int nbcam = 0; nbcam < cameras.size(); ++nbcam) {
            this.cams[nbcam] = (Camera)cameras.get(nbcam);
        }
        this.setBackground(this.backColor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.setDoubleBuffered(false);
        this.start();
        this.setAWTCursor(-1);
        VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
        if (VirtualSpaceManager.debug) {
            System.out.println("View refresh time set to " + this.frameTime + "ms");
        }
    }

    public void start() {
        this.size = this.getSize();
        this.runView = new Thread(this);
        this.runView.setPriority(5);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread me = Thread.currentThread();
        while (this.getSize().width <= 0) {
            try {
                Thread.sleep(this.inactiveSleepTime);
            }
            catch (InterruptedException e) {
                VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
                if (VirtualSpaceManager.debug) {
                    System.err.println("viewpanel.run.runview.sleep " + e);
                }
                return;
            }
        }
        this.backBufferGraphics = null;
        Dimension oldSize = this.getSize();
        while (this.runView == me) {
            this.loopStartTime = System.currentTimeMillis();
            if (this.notBlank) {
                if (this.active) {
                    if (this.repaintNow) {
                        this.repaintNow = false;
                        this.updateMouseOnly = false;
                        this.size = this.getSize();
                        this.viewW = this.size.width;
                        this.viewH = this.size.height;
                        if (this.size.width != oldSize.width || this.size.height != oldSize.height) {
                            if (this.backBuffer != null) {
                                this.backBuffer.flush();
                                this.backBuffer = null;
                            }
                            if (this.backBufferGraphics != null) {
                                this.backBufferGraphics.dispose();
                                this.backBufferGraphics = null;
                            }
                            VirtualSpaceManager cfr_ignored_1 = this.parent.parent;
                            if (VirtualSpaceManager.debug) {
                                System.out.println("Resizing JPanel: (" + oldSize.width + "x" + oldSize.height + ") -> (" + this.size.width + "x" + this.size.height + ")");
                            }
                            oldSize = this.size;
                            this.updateAntialias = true;
                            this.updateFont = true;
                        }
                        if (this.backBuffer == null) {
                            this.gconf = this.getGraphicsConfiguration();
                            this.backBuffer = this.gconf.createCompatibleVolatileImage(this.size.width, this.size.height);
                            if (this.backBufferGraphics != null) {
                                this.backBufferGraphics.dispose();
                                this.backBufferGraphics = null;
                            }
                        }
                        if (this.backBufferGraphics == null) {
                            this.backBufferGraphics = this.backBuffer.createGraphics();
                            this.updateAntialias = true;
                            this.updateFont = true;
                        }
                        if (this.updateFont) {
                            this.backBufferGraphics.setFont(VirtualSpaceManager.mainFont);
                            this.updateFont = false;
                        }
                        if (this.updateAntialias) {
                            if (this.antialias) {
                                this.backBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            } else {
                                this.backBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                            }
                            this.updateAntialias = false;
                        }
                        this.stableRefToBackBufferGraphics = this.backBufferGraphics;
                        this.gconf = this.getGraphicsConfiguration();
                        this.valCode = this.backBuffer.validate(this.gconf);
                        if (this.valCode == 2) {
                            this.backBuffer = this.gconf.createCompatibleVolatileImage(this.size.width, this.size.height);
                        }
                        this.standardStroke = this.stableRefToBackBufferGraphics.getStroke();
                        this.standardTransform = this.stableRefToBackBufferGraphics.getTransform();
                        AccViewPanel accViewPanel = this;
                        synchronized (accViewPanel) {
                            do {
                                block97: {
                                    this.stableRefToBackBufferGraphics.setPaintMode();
                                    this.stableRefToBackBufferGraphics.setBackground(this.backColor);
                                    this.stableRefToBackBufferGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                                    if (this.parent.painters[0] != null) {
                                        this.parent.painters[0].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
                                    }
                                    for (int nbcam = 0; nbcam < this.cams.length; ++nbcam) {
                                        if (this.cams[nbcam] == null || !this.cams[nbcam].enabled || !this.cams[nbcam].eager && !this.cams[nbcam].shouldRepaint()) continue;
                                        this.camIndex = this.cams[nbcam].getIndex();
                                        Vector vector = this.drawnGlyphs = this.cams[nbcam].parentSpace.getDrawnGlyphs(this.camIndex);
                                        synchronized (vector) {
                                            int i;
                                            this.drawnGlyphs.removeAllElements();
                                            this.uncoef = (this.cams[nbcam].focal + this.cams[nbcam].altitude) / this.cams[nbcam].focal;
                                            this.viewWC = (long)((float)this.cams[nbcam].posx - (float)(this.viewW / 2L - (long)this.visibilityPadding[0]) * this.uncoef);
                                            this.viewNC = (long)((float)this.cams[nbcam].posy + (float)(this.viewH / 2L - (long)this.visibilityPadding[1]) * this.uncoef);
                                            this.viewEC = (long)((float)this.cams[nbcam].posx + (float)(this.viewW / 2L - (long)this.visibilityPadding[2]) * this.uncoef);
                                            this.viewSC = (long)((float)this.cams[nbcam].posy - (float)(this.viewH / 2L - (long)this.visibilityPadding[3]) * this.uncoef);
                                            this.gll = this.cams[nbcam].parentSpace.getDrawingList();
                                            if (this.parent.detectMultipleFullFills) {
                                                int j;
                                                for (i = 0; i < this.gll.length; ++i) {
                                                    if (!this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) continue;
                                                    this.cams[nbcam].parentSpace.drewGlyph(this.gll[i], this.camIndex);
                                                    this.gll[i].project(this.cams[nbcam], this.size);
                                                }
                                                this.beginAt = 0;
                                                for (j = this.drawnGlyphs.size() - 1; j >= 0; --j) {
                                                    if (!((Glyph)this.drawnGlyphs.elementAt(j)).fillsView(this.viewW, this.viewH, this.cams[nbcam].getIndex())) continue;
                                                    this.beginAt = j;
                                                    break;
                                                }
                                                for (j = this.beginAt; j < this.drawnGlyphs.size(); ++j) {
                                                    this.gl = (Glyph)this.drawnGlyphs.elementAt(j);
                                                    if (this.gl.isVisible()) {
                                                        this.gl.draw(this.stableRefToBackBufferGraphics, this.size.width, this.size.height, this.cams[nbcam].getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                                                    }
                                                    this.cams[nbcam].parentSpace.drewGlyph(this.gl, this.camIndex);
                                                }
                                            } else {
                                                for (i = 0; i < this.gll.length; ++i) {
                                                    if (!this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) continue;
                                                    Glyph glyph = this.gll[i];
                                                    synchronized (glyph) {
                                                        this.gll[i].project(this.cams[nbcam], this.size);
                                                        if (this.gll[i].isVisible()) {
                                                            this.gll[i].draw(this.stableRefToBackBufferGraphics, this.size.width, this.size.height, this.cams[nbcam].getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                                                        }
                                                        this.cams[nbcam].parentSpace.drewGlyph(this.gll[i], this.camIndex);
                                                        continue;
                                                    }
                                                }
                                            }
                                            continue;
                                        }
                                    }
                                    if (this.parent.painters[1] != null) {
                                        this.parent.painters[1].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
                                    }
                                    if (this.parent.painters[2] != null) {
                                        this.parent.painters[2].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
                                    }
                                    for (int i = 0; i < this.parent.portals.length; ++i) {
                                        this.parent.portals[i].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
                                    }
                                    if (this.parent.painters[3] != null) {
                                        this.parent.painters[3].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
                                    }
                                    if (!this.inside) continue;
                                    try {
                                        this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                        if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                            this.parent.mouse.computeMouseOverList(this.evHs[this.activeLayer], this.cams[this.activeLayer]);
                                        }
                                    }
                                    catch (NullPointerException ex) {
                                        VirtualSpaceManager cfr_ignored_2 = this.parent.parent;
                                        if (!VirtualSpaceManager.debug) break block97;
                                        System.err.println("viewpanel.run.drawdrag " + ex);
                                    }
                                }
                                this.stableRefToBackBufferGraphics.setColor(this.parent.mouse.hcolor);
                                if (this.drawDrag) {
                                    this.stableRefToBackBufferGraphics.drawLine(this.origDragx, this.origDragy, this.parent.mouse.mx, this.parent.mouse.my);
                                }
                                if (this.drawRect) {
                                    this.stableRefToBackBufferGraphics.drawRect(Math.min(this.origDragx, this.parent.mouse.mx), Math.min(this.origDragy, this.parent.mouse.my), Math.max(this.origDragx, this.parent.mouse.mx) - Math.min(this.origDragx, this.parent.mouse.mx), Math.max(this.origDragy, this.parent.mouse.my) - Math.min(this.origDragy, this.parent.mouse.my));
                                }
                                if (this.drawOval) {
                                    if (this.circleOnly) {
                                        this.stableRefToBackBufferGraphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.mx), this.origDragy - Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragx - this.parent.mouse.mx));
                                    } else {
                                        this.stableRefToBackBufferGraphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.mx), this.origDragy - Math.abs(this.origDragy - this.parent.mouse.my), 2 * Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragy - this.parent.mouse.my));
                                    }
                                }
                                if (!this.drawVTMcursor) continue;
                                AccViewPanel ex = this;
                                synchronized (ex) {
                                    this.stableRefToBackBufferGraphics.setXORMode(this.backColor);
                                    this.parent.mouse.draw(this.stableRefToBackBufferGraphics);
                                    this.oldX = this.parent.mouse.mx;
                                    this.oldY = this.parent.mouse.my;
                                }
                            } while (this.backBuffer.contentsLost());
                            if (this.stableRefToBackBufferGraphics == this.backBufferGraphics) {
                                this.repaint();
                            }
                            this.loopTotalTime = System.currentTimeMillis() - this.loopStartTime;
                            this.timeToSleep = (long)this.frameTime - this.loopTotalTime;
                        }
                        try {
                            Thread.sleep(this.timeToSleep > (long)this.minimumSleepTime ? this.timeToSleep : (long)this.minimumSleepTime);
                            continue;
                        }
                        catch (InterruptedException e) {
                            VirtualSpaceManager cfr_ignored_3 = this.parent.parent;
                            if (VirtualSpaceManager.debug) {
                                System.err.println("viewpanel.run.runview.sleep2 " + e);
                            }
                            return;
                        }
                    }
                    if (this.updateMouseOnly) {
                        block98: {
                            this.updateMouseOnly = false;
                            try {
                                this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                    this.parent.mouse.computeMouseOverList(this.evHs[this.activeLayer], this.cams[this.activeLayer]);
                                }
                            }
                            catch (NullPointerException ex) {
                                VirtualSpaceManager cfr_ignored_4 = this.parent.parent;
                                if (!VirtualSpaceManager.debug) break block98;
                                System.err.println("viewpanel.run.drawdrag " + ex);
                            }
                        }
                        if (this.drawVTMcursor) {
                            AccViewPanel ex = this;
                            synchronized (ex) {
                                block99: {
                                    try {
                                        this.stableRefToBackBufferGraphics.setXORMode(this.backColor);
                                        this.stableRefToBackBufferGraphics.setColor(this.parent.mouse.color);
                                        this.stableRefToBackBufferGraphics.drawLine(this.oldX - this.parent.mouse.size, this.oldY, this.oldX + this.parent.mouse.size, this.oldY);
                                        this.stableRefToBackBufferGraphics.drawLine(this.oldX, this.oldY - this.parent.mouse.size, this.oldX, this.oldY + this.parent.mouse.size);
                                        this.stableRefToBackBufferGraphics.drawLine(this.parent.mouse.mx - this.parent.mouse.size, this.parent.mouse.my, this.parent.mouse.mx + this.parent.mouse.size, this.parent.mouse.my);
                                        this.stableRefToBackBufferGraphics.drawLine(this.parent.mouse.mx, this.parent.mouse.my - this.parent.mouse.size, this.parent.mouse.mx, this.parent.mouse.my + this.parent.mouse.size);
                                        this.oldX = this.parent.mouse.mx;
                                        this.oldY = this.parent.mouse.my;
                                    }
                                    catch (NullPointerException ex47) {
                                        VirtualSpaceManager cfr_ignored_5 = this.parent.parent;
                                        if (!VirtualSpaceManager.debug) break block99;
                                        System.err.println("viewpanel.run.runview.drawVTMcursor " + ex47);
                                    }
                                }
                            }
                        }
                        this.repaint();
                        this.loopTotalTime = System.currentTimeMillis() - this.loopStartTime;
                        this.timeToSleep = (long)this.frameTime - this.loopTotalTime;
                        try {
                            Thread.sleep(this.timeToSleep > (long)this.minimumSleepTime ? this.timeToSleep : (long)this.minimumSleepTime);
                            continue;
                        }
                        catch (InterruptedException e) {
                            VirtualSpaceManager cfr_ignored_6 = this.parent.parent;
                            if (VirtualSpaceManager.debug) {
                                System.err.println("viewpanel.run.runview.sleep3 " + e);
                            }
                            return;
                        }
                    }
                    try {
                        Thread.sleep(this.frameTime + this.noRepaintAdditionalTime);
                        continue;
                    }
                    catch (InterruptedException e) {
                        VirtualSpaceManager cfr_ignored_7 = this.parent.parent;
                        if (VirtualSpaceManager.debug) {
                            System.err.println("viewpanel.run.runview.sleep3 " + e);
                        }
                        return;
                    }
                }
                try {
                    Thread.sleep(this.inactiveSleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    VirtualSpaceManager cfr_ignored_8 = this.parent.parent;
                    if (VirtualSpaceManager.debug) {
                        System.err.println("viewpanel.run.runview.sleep4 " + e);
                    }
                    return;
                }
            }
            this.size = this.getSize();
            this.viewW = this.size.width;
            this.viewH = this.size.height;
            if (this.size.width != oldSize.width || this.size.height != oldSize.height) {
                if (this.backBuffer != null) {
                    this.backBuffer.flush();
                    this.backBuffer = null;
                }
                if (this.backBufferGraphics != null) {
                    this.backBufferGraphics.dispose();
                    this.backBufferGraphics = null;
                }
                VirtualSpaceManager cfr_ignored_9 = this.parent.parent;
                if (VirtualSpaceManager.debug) {
                    System.out.println("Resizing JPanel: (" + oldSize.width + "x" + oldSize.height + ") -> (" + this.size.width + "x" + this.size.height + ")");
                }
                oldSize = this.size;
                this.updateAntialias = true;
                this.updateFont = true;
            }
            if (this.backBuffer == null) {
                this.gconf = this.getGraphicsConfiguration();
                this.backBuffer = this.gconf.createCompatibleVolatileImage(this.size.width, this.size.height);
                if (this.backBufferGraphics != null) {
                    this.backBufferGraphics.dispose();
                    this.backBufferGraphics = null;
                }
            }
            if (this.backBufferGraphics == null) {
                this.backBufferGraphics = this.backBuffer.createGraphics();
                this.updateAntialias = true;
                this.updateFont = true;
            }
            if (this.updateFont) {
                this.backBufferGraphics.setFont(VirtualSpaceManager.mainFont);
                this.updateFont = false;
            }
            if (this.updateAntialias) {
                if (this.antialias) {
                    this.backBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    this.backBufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                this.updateAntialias = false;
            }
            this.stableRefToBackBufferGraphics = this.backBufferGraphics;
            this.gconf = this.getGraphicsConfiguration();
            this.valCode = this.backBuffer.validate(this.gconf);
            if (this.valCode == 2) {
                this.backBuffer = this.gconf.createCompatibleVolatileImage(this.size.width, this.size.height);
            }
            this.standardStroke = this.stableRefToBackBufferGraphics.getStroke();
            this.standardTransform = this.stableRefToBackBufferGraphics.getTransform();
            do {
                this.stableRefToBackBufferGraphics.setPaintMode();
                this.stableRefToBackBufferGraphics.setColor(this.blankColor);
                this.stableRefToBackBufferGraphics.fillRect(0, 0, this.size.width, this.size.height);
                if (this.parent.painters[3] == null) continue;
                try {
                    this.parent.painters[3].paint(this.stableRefToBackBufferGraphics, this.size.width, this.size.height);
                }
                catch (ClassCastException ex) {
                    if (!VirtualSpaceManager.debugModeON()) continue;
                    System.err.println("Failed to draw AFTER_PORTALS in blank mode");
                }
            } while (this.backBuffer.contentsLost());
            this.repaint();
            try {
                Thread.sleep(this.blankSleepTime);
            }
            catch (InterruptedException e) {
                VirtualSpaceManager cfr_ignored_10 = this.parent.parent;
                if (VirtualSpaceManager.debug) {
                    System.err.println("viewpanel.run.runview.sleep5 " + e);
                }
                return;
            }
        }
        if (this.stableRefToBackBufferGraphics != null) {
            this.stableRefToBackBufferGraphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        AccViewPanel accViewPanel = this;
        synchronized (accViewPanel) {
            if (this.backBuffer != null) {
                g.drawImage(this.backBuffer, 0, 0, this);
                if (this.repaintListener != null) {
                    this.repaintListener.viewRepainted(this.parent);
                }
            }
        }
    }

    public BufferedImage getImage() {
        return this.backBuffer.getSnapshot();
    }
}

