/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Customizer;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.form.RADVisualContainer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

/**
 * Window holding the grid designer.
 *
 * @author Jan Stola
 */
public class GridDesignerWindow extends JDialog implements Customizer {
    /** Grid-designer in this window. */
    private GridDesigner designer;

    /**
     * Creates new {@code GridDesignerWindow}.
     */
    public GridDesignerWindow() {
        super(WindowManager.getDefault().getMainWindow());
        this.designer = new GridDesigner();
        HelpCtx.setHelpIDString(designer, "gui.layouts.griddesigner"); // NOI18N
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        helpButton = new JButton();
        closeButton = new JButton();
        designerPanel = designer;

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(NbBundle.getMessage(GridDesignerWindow.class, "GridDesignerWindow.title")); // NOI18N
        addWindowListener(new WindowAdapter() {
            public void windowClosed(WindowEvent evt) {
                formWindowClosed(evt);
            }
        });
        Mnemonics.setLocalizedText(helpButton, NbBundle.getMessage(GridDesignerWindow.class, "GridDesignerWindow.helpButton.text"));
        helpButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                helpButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(closeButton, NbBundle.getMessage(GridDesignerWindow.class, "GridDesignerWindow.closeButton.text"));
        closeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        GroupLayout layout = new GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(closeButton)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(helpButton)
                .addContainerGap())
            .addComponent(designerPanel, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {closeButton, helpButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(designerPanel, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                    .addComponent(helpButton)
                    .addComponent(closeButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosed(WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        // Unregister listeners
        designer.setSelectedNodes(Collections.EMPTY_LIST);
    }//GEN-LAST:event_formWindowClosed

    private void closeButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        dispose();
    }//GEN-LAST:event_closeButtonActionPerformed

    private void helpButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_helpButtonActionPerformed
        Help help = Lookup.getDefault().lookup(Help.class);
        if (help != null) {
            help.showHelp(HelpCtx.findHelp(designer));
        }
    }//GEN-LAST:event_helpButtonActionPerformed

    /**
     * Implementation of {@code Customizer} interface (sets the object
     * to customize).
     * 
     * @param bean bean to customize.
     */
    @Override
    public void setObject(Object bean) {
        designer.setDesignedContainer((RADVisualContainer)bean);
    }

    @Override
    public void pack() {
        super.pack();
        Dimension size = getSize();
        Rectangle screenBounds = Utilities.getUsableScreenBounds();
        if (size.width > screenBounds.width) {
            size.width = screenBounds.width;
        }
        if (size.height > screenBounds.height) {
            size.height = screenBounds.height;
        }
        setBounds(Utilities.findCenterBounds(size));
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JButton closeButton;
    private JPanel designerPanel;
    private JButton helpButton;
    // End of variables declaration//GEN-END:variables

}
