/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.i18n.java;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import org.netbeans.modules.i18n.PropertyPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 * Property panel for {@code JavaI18nString}'s.
 *
 * @author  Peter Zavadsky
 */
public class JavaPropertyPanel extends PropertyPanel {

    private final ResourceBundle bundle;
    
    /** Creates new form JavaPropertyPanel */
    public JavaPropertyPanel() {
        bundle = NbBundle.getBundle(JavaPropertyPanel.class);
        initComponents();
    }    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        argumentsButton.setVisible(true);
        argumentsButton.getAccessibleContext().setAccessibleDescription(
                bundle.getString("ACS_CTL_Arguments"));                 //NOI18N
        argumentsButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                argumentsButtonActionPerformed(evt);
            }
        }
        );
    }

    /** Action handler for arguments button. */
    private void argumentsButtonActionPerformed(ActionEvent evt) {
        final JavaI18nString javaI18nString = (JavaI18nString)i18nString;
        
        final Dialog[] dialogs = new Dialog[1];
        final ParamsPanel paramsPanel = new ParamsPanel();

        paramsPanel.setArguments(javaI18nString.getArguments());

        DialogDescriptor dd = new DialogDescriptor(
            paramsPanel,
            bundle.getString("CTL_ParamsPanelTitle"), // NOI18N
            true,
            DialogDescriptor.OK_CANCEL_OPTION,
            DialogDescriptor.OK_OPTION,
            new ActionListener() {
                public void actionPerformed(ActionEvent ev) {
                    if (ev.getSource() == DialogDescriptor.OK_OPTION) {
                        javaI18nString.setArguments(paramsPanel.getArguments());
                        updateReplaceText();
                        
                        dialogs[0].setVisible(false);
                        dialogs[0].dispose();
                    } else {
                        dialogs[0].setVisible(false);
                        dialogs[0].dispose();
                    }
                }
           });
        dialogs[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialogs[0].setVisible(true);
    }

    /** Overrides superclass method. */
    @Override
    protected void updateReplaceText() {
        super.updateReplaceText();
        
        argumentsButton.setEnabled(
                i18nString.getReplaceFormat().indexOf("{arguments}") >= 0 ); // NOI18N
    }

}
