/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.qa.form;

import org.netbeans.jemmy.operators.*;

/**
 * Class implementing all necessary methods for handling "Palette Manager" NbDialog.
 * Most parts of code are generated by jelly tools.* 
 *
 * @author Jiri Vagner
 */
public class PaletteManagerOperator extends JDialogOperator {

    /** Creates new PaletteManager that can handle it.
     */
    public PaletteManagerOperator() {
        super("Palette Manager"); // NOI18N
    }

    private JLabelOperator _lblPaletteContent;
    private JTreeOperator _treePaletteContentsTree;
    private JLabelOperator _lblJLabel;
    private JButtonOperator _btMoveUp;
    private JButtonOperator _btMoveDown;
    private JButtonOperator _btRemove;
    private JButtonOperator _btNewCategory;
    private JButtonOperator _btAddFromJAR;
    private JButtonOperator _btAddFromLibrary;
    private JButtonOperator _btAddFromProject;
    private JButtonOperator _btResetPalette;
    private JButtonOperator _btClose;


    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find "Palette Content:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblPaletteContent() {
        if (_lblPaletteContent==null) {
            _lblPaletteContent = new JLabelOperator(this, "Palette Content:"); // NOI18N
        }
        return _lblPaletteContent;
    }

    /** Tries to find null TreeView$ExplorerTree in this dialog.
     * @return JTreeOperator
     */
    public JTreeOperator treePaletteContentsTree() {
        if (_treePaletteContentsTree==null) {
            _treePaletteContentsTree = new JTreeOperator(this);
        }
        return _treePaletteContentsTree;
    }

    /** Tries to find " " JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblJLabel() {
        if (_lblJLabel==null) {
            _lblJLabel = new JLabelOperator(this, " ", 1); // NOI18N
        }
        return _lblJLabel;
    }

    /** Tries to find "Move Up" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btMoveUp() {
        if (_btMoveUp==null) {
            _btMoveUp = new JButtonOperator(this, "Move Up"); // NOI18N
        }
        return _btMoveUp;
    }

    /** Tries to find "Move Down" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btMoveDown() {
        if (_btMoveDown==null) {
            _btMoveDown = new JButtonOperator(this, "Move Down"); // NOI18N
        }
        return _btMoveDown;
    }

    /** Tries to find "Remove..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btRemove() {
        if (_btRemove==null) {
            _btRemove = new JButtonOperator(this, "Remove..."); // NOI18N
        }
        return _btRemove;
    }

    /** Tries to find "New Category..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btNewCategory() {
        if (_btNewCategory==null) {
            _btNewCategory = new JButtonOperator(this, "New Category..."); // NOI18N
        }
        return _btNewCategory;
    }

    /** Tries to find "Add from JAR..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btAddFromJAR() {
        if (_btAddFromJAR==null) {
            _btAddFromJAR = new JButtonOperator(this, "Add from JAR..."); // NOI18N
        }
        return _btAddFromJAR;
    }

    /** Tries to find "Add from Library..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btAddFromLibrary() {
        if (_btAddFromLibrary==null) {
            _btAddFromLibrary = new JButtonOperator(this, "Add from Library..."); // NOI18N
        }
        return _btAddFromLibrary;
    }

    /** Tries to find "Add from Project..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btAddFromProject() {
        if (_btAddFromProject==null) {
            _btAddFromProject = new JButtonOperator(this, "Add from Project..."); // NOI18N
        }
        return _btAddFromProject;
    }

    /** Tries to find "Reset Palette" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btResetPalette() {
        if (_btResetPalette==null) {
            _btResetPalette = new JButtonOperator(this, "Reset Palette"); // NOI18N
        }
        return _btResetPalette;
    }

    /** Tries to find "Close" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btClose() {
        if (_btClose==null) {
            _btClose = new JButtonOperator(this, "Close"); // NOI18N
        }
        return _btClose;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** clicks on "Move Up" JButton
     */
    public void moveUp() {
        btMoveUp().push();
    }

    /** clicks on "Move Down" JButton
     */
    public void moveDown() {
        btMoveDown().push();
    }

    /** clicks on "Remove..." JButton
     */
    public void remove() {
        btRemove().push();
    }

    /** clicks on "New Category..." JButton
     */
    public void newCategory() {
        btNewCategory().push();
    }

    /** clicks on "Add from JAR..." JButton
     */
    public void addFromJAR() {
        btAddFromJAR().push();
    }

    /** clicks on "Add from Library..." JButton
     */
    public void addFromLibrary() {
        btAddFromLibrary().push();
    }

    /** clicks on "Add from Project..." JButton
     */
    public void addFromProject() {
        btAddFromProject().push();
    }

    /** clicks on "Reset Palette" JButton
     */
    public void resetPalette() {
        btResetPalette().push();
    }

    /** clicks on "Close" JButton
     */
    public void close() {
        btClose().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of PaletteManager by accessing all its components.
     */
    public void verify() {
        lblPaletteContent();
        treePaletteContentsTree();
        lblJLabel();
        btMoveUp();
        btMoveDown();
        btRemove();
        btNewCategory();
        btAddFromJAR();
        btAddFromLibrary();
        btAddFromProject();
        btResetPalette();
        btClose();
    }
}

