/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.profiler.j2ee.jboss;

import java.awt.Font;
import javax.swing.UIManager;
import org.netbeans.modules.profiler.attach.panels.components.DirectorySelector;
import org.netbeans.modules.profiler.attach.panels.components.JavaPlatformPanelComponent;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;

/**
 *
 * @author  Jaroslav Bachorik
 */
public class JBossIntegrationPanelUI extends javax.swing.JPanel {
  private JBossIntegrationPanel.Model model;

  /** Creates new form JBossIntegrationPanelUI */
  public JBossIntegrationPanelUI(JBossIntegrationPanel.Model model) {
    this.model = model;
    initComponents();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        platformSelector = new org.netbeans.modules.profiler.attach.panels.components.JavaPlatformPanelComponent();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        directoryJboss = new org.netbeans.modules.profiler.attach.panels.components.DirectorySelector();
        jPanel1 = new javax.swing.JPanel();

        setMaximumSize(new java.awt.Dimension(800, 600));
        setMinimumSize(new java.awt.Dimension(400, 300));
        setPreferredSize(new java.awt.Dimension(500, 300));

        platformSelector.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(JBossIntegrationPanelUI.class, "JBossIntegrationPanelUI.border.platformSelector.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, UIManager.getFont("TitledBorder.font").deriveFont(Font.BOLD))); // NOI18N
        platformSelector.setPlatformFilter(this.model.getPlatformFilter());
        platformSelector.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                platformSelectorPropertyChange(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(JBossIntegrationPanelUI.class, "InformationIntegrationLabel"))); // NOI18N

        jLabel1.setLabelFor(directoryJboss);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/profiler/j2ee/jboss/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, bundle.getString("JBossIntegrationProvider_JbossInstallLabelText")); // NOI18N

        directoryJboss.setHint(org.openide.util.NbBundle.getMessage(JBossIntegrationPanelUI.class, "JBossIntegrationPanelUI.directoryJboss.hint")); // NOI18N
        directoryJboss.setHintForeground(new java.awt.Color(89, 79, 191));
        directoryJboss.setPath(org.openide.util.NbBundle.getMessage(JBossIntegrationPanelUI.class, "JBossIntegrationPanelUI.directoryJboss.path")); // NOI18N
        directoryJboss.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                directoryJbossPropertyChange(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(directoryJboss, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 464, Short.MAX_VALUE)
                    .add(jLabel1))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(directoryJboss, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 500, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 33, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, platformSelector, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 500, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(platformSelector, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 186, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
  
    private void platformSelectorPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_platformSelectorPropertyChange
      if (evt.getPropertyName().equals(JavaPlatformPanelComponent.JAVA_PLATFORM_PROPERTY)) {
        this.model.setSelectedPlatform((TargetPlatform)evt.getNewValue());
      }
    }//GEN-LAST:event_platformSelectorPropertyChange
    
    private void directoryJbossPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_directoryJbossPropertyChange
      if (evt.getPropertyName().equals(DirectorySelector.PATH_PROPERTY)) {
        this.model.setJbossInstall(directoryJboss.getPath());
        directoryJboss.setHint(this.model.getJbossInstallHint());
      } else if (evt.getPropertyName().equals(DirectorySelector.LAYOUT_CHANGED_PROPERTY)) {
          validate();
      }
    }//GEN-LAST:event_directoryJbossPropertyChange
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.netbeans.modules.profiler.attach.panels.components.DirectorySelector directoryJboss;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private org.netbeans.modules.profiler.attach.panels.components.JavaPlatformPanelComponent platformSelector;
    // End of variables declaration//GEN-END:variables
 
  
  public void loadModel() {
    directoryJboss.setPath(model.getJbossInstall());
    platformSelector.setSelectedPlatform(model.getSelectedPlatform());
    directoryJboss.setHint(model.getJbossInstallHint());
  }
  
  public void refreshJvmList(final TargetPlatform preselectedPlatform) {
    platformSelector.refresh(preselectedPlatform);
  }
}
