/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model;

import org.netbeans.modules.xml.schema.model.SchemaModel;


/**
 * <pre>
 * &lt;xs:element name="import-schema" substitutionGroup="xsl:declaration">
 *      &lt;xs:complexType>
 *          &lt;xs:complexContent>
 *              &lt;xs:extension base="xsl:element-only-versioned-element-type">
 *                  &lt;xs:sequence>
 *                      &lt;xs:element ref="xs:schema" minOccurs="0" maxOccurs="1"/>
 *                  &lt;/xs:sequence>
 *                  &lt;xs:attribute name="namespace" type="xs:anyURI"/>
 *                  &lt;xs:attribute name="schema-location" type="xs:anyURI"/>                  
 *              &lt;/xs:extension>
 *          &lt;/xs:complexContent>
 *      &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 * @author ads
 *
 */
public interface ImportSchema extends Declaration  {
    
    String NAMESPACE = NamespaceSpec.NAMESPACE;
    
    String SCHEMA_LOCATION = "schema-location";     // NOI18N
    
    /**
     * @return embedded schema model
     */
    SchemaModel getSchemaModel();
    
    /**
     * @return "namespace" attribute value
     */
    String getNamespace();
    
    /**
     * Set new "namespace" attribute value for imported schema.
     * @param namespaceUri new value
     */
    void setNamespace( String namespaceUri );
    
    /**
     * @return "schema-location" attribute value
     */
    String getSchemaLocation();
    
    /**
     * Set "schema-location" attribute value.
     * @param location new value
     */
    void setSchemaLocation( String location );

}
