/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.php.project.wizards;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author  ads
 */
class CommandLinePanelVisual extends JPanel {

    private static final long serialVersionUID = -8903937338232152727L;
    
    private static final String BROWSE              = "BROWSE";                 // NOI18N

    private static final String SELECT_PHP_LOCATION = "LBL_SelectPhpLocation";  // NOI18N

    private static final String MSG_ILLEGAL_PHP_PATH = "MSG_IllegalPhpPath";    // NOI18N

    private static final String MSG_ABSENT_FILE      = "MSG_AbsentFile";        // NOI18N
    
    
    CommandLinePanelVisual( ProviderSpecificPanel panel ) {
        myPanel = panel;
        initComponents();
        
        myInterpreterPath.getDocument().addDocumentListener( new PathListener() );
    }
    
    void read( WizardDescriptor descriptor ) {
        myDescriptor = descriptor;
        Object obj = descriptor.getProperty( 
                NewPhpProjectWizardIterator.COMMAND_LINE );
        if ( obj instanceof String ) {
            myInterpreterPath.setText( (String ) obj );
        }
    }
    
    void store( WizardDescriptor descriptor ) {
        descriptor.putProperty( 
                NewPhpProjectWizardIterator.COMMAND_LINE , 
                myInterpreterPath.getText());
    }
    
    boolean dataIsValid() {
        File destFolder = new File( myInterpreterPath.getText())
                .getAbsoluteFile();
        File file = PhpProjectConfigurePanel.getCanonicalFile(destFolder);
        if ( file == null) {
            String message = NbBundle
                    .getMessage(NewPhpProjectWizardIterator.class,
                            MSG_ABSENT_FILE );
            myDescriptor.putProperty(
                    PanelProjectLocationVisual.WIZARD_PANEL_ERROR_MESSAGE, message);
            return false;
        }
        if ( file.isFile() ) {
            return true;
        }
        else {
            String message = NbBundle
            .getMessage(NewPhpProjectWizardIterator.class,
                    MSG_ILLEGAL_PHP_PATH );
            myDescriptor.putProperty(
                    PanelProjectLocationVisual.WIZARD_PANEL_ERROR_MESSAGE, message);
            return false;
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        myInterpreterLbl = new javax.swing.JLabel();
        myInterpreterPath = new javax.swing.JTextField();
        myPhpProgramBrowse = new javax.swing.JButton();

        org.openide.awt.Mnemonics.setLocalizedText(myInterpreterLbl, org.openide.util.NbBundle.getMessage(CommandLinePanelVisual.class, "LBL_CommandPath")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myPhpProgramBrowse, org.openide.util.NbBundle.getMessage(CommandLinePanelVisual.class, "LBL_BrowseLocation_Button")); // NOI18N
        myPhpProgramBrowse.setActionCommand(BROWSE);
        myPhpProgramBrowse.setLabel(org.openide.util.NbBundle.getMessage(CommandLinePanelVisual.class, "LBL_BrowseLocation_Button")); // NOI18N
        myPhpProgramBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browsePressed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(myInterpreterLbl)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(myInterpreterPath, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 190, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(myPhpProgramBrowse)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myInterpreterLbl)
                    .add(myPhpProgramBrowse)
                    .add(myInterpreterPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        myInterpreterPath.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CommandLinePanelVisual.class, "A11_CommandLine")); // NOI18N
        myPhpProgramBrowse.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CommandLinePanelVisual.class, "A11_BrowsePhpLocation")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void browsePressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browsePressed
        if ( BROWSE.equals( evt.getActionCommand() )){
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle( NbBundle.getMessage( 
                    CommandLinePanelVisual.class,SELECT_PHP_LOCATION));
            chooser.setFileSelectionMode(JFileChooser.FILES_ONLY );
            if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                myInterpreterPath.setText(projectDir.getAbsolutePath());
            }
            getPanel().fireChangeEvent();
        }
    }//GEN-LAST:event_browsePressed
    
    private ProviderSpecificPanel getPanel() {
        return myPanel;
    }
    
    private class PathListener implements DocumentListener {

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
         */
        public void changedUpdate( DocumentEvent e ) {
            fireChange();
        }

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
         */
        public void insertUpdate( DocumentEvent e ) {
            fireChange();
        }

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
         */
        public void removeUpdate( DocumentEvent e ) {
            fireChange();
        }
        
        private void fireChange() {
            myPanel.fireChangeEvent();
        }
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel myInterpreterLbl;
    private javax.swing.JTextField myInterpreterPath;
    private javax.swing.JButton myPhpProgramBrowse;
    // End of variables declaration//GEN-END:variables
    
    
    private ProviderSpecificPanel myPanel;
    
    private WizardDescriptor myDescriptor;

}
