<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@ page import="java.util.TreeMap" import="java.util.Iterator"%>
<%@ page import="org.netbeans.server.uihandler.LogsManager" %>
<%@ page import="org.netbeans.server.uihandler.statistics.ExceptionReports" %>
<%@ taglib uri="/WEB-INF/chart-tag.tld" prefix="chart" %>
<%@ taglib uri="/WEB-INF/statistics.tld" prefix="ui" %>

<head>
<jsp:include page="../template/header.jsp"/>
<ui:useStatistic name="ExceptionReports"/>

<a href="http://www.netbeans.org/index.html">HOME</a> 
/ 
<a href="http://www.netbeans.org/community/index.html">Community</a>
/
<a href="index.jsp">Analytics</a>
/
Graphs
/
Exception Reports

</div><td class="valign-top b-right full-width">

<div class="f-page-cell bg-sky" >
    <h2>Exception Reports Count</h2>
    
    <p>
        Exception reporting module is a piece of the <b>UI Gestures Collector</b>.
        <b>UI Gestures Collector</b> helps developpers to find steps how to reproduce 
        an exception in NetBeans IDE and how to find the root of problem.
        All the gestures are send with exception report, but you can send them
        as well using UI Gestures button in IDE. This statistics shows
        how many reports are send just as statistics data and how many of them
        are reporting exceptions.            
    </p>
</div>

<table width="100%">
    <% 
    ExceptionReports.Data exceptionReports =
            (ExceptionReports.Data)pageContext.getAttribute("globalExceptionReports");
    if (exceptionReports != null) {
        int wholeNumber = LogsManager.getDefault().getNumberOfLogs();
        int gesturesReports = wholeNumber - exceptionReports.getGlobalReportsNumber();
        TreeMap results = new TreeMap<String, Integer>();
        results.put("Exception reports", exceptionReports.getGlobalReportsNumber());
        results.put("Gestures reports", gesturesReports);
        pageContext.setAttribute("results", results);
    %>
    <tr>
        <td align="center" width="480">
            <chart:pie
                collection="results"
                category="key"
                value="value"
                title="Comparison of exceptions and gesture reports"
            />
            <p>
                This is the overall statistics of all the submitted data.
            </p>
        </td>
    </tr>
    <% } %>
    <%
    exceptionReports =
            (ExceptionReports.Data)pageContext.getAttribute("globalExceptionReports");
    if (exceptionReports != null) {
        pageContext.setAttribute("components", exceptionReports.getComponents());
        if (exceptionReports.getComponents() != null){ %>
    <tr>
        <td align="center" width="480">
            <chart:pie
                collection="components"
                category="key"
                value="value"
                title="Components issues numbers"
            />
            <p>
                This is the overall statistics of issue numbers assigned to 
                different components.
            </p>
        </td>
    </tr>
    <tr>
        <td>
          <table style="border: 1px solid">
                <thead><td>Component</td><td>Number of reports</td></thead>
                <tbody>
                <% Iterator<String> iterator = exceptionReports.getSortedKeys().iterator();
                while (iterator.hasNext()){
                    String key = iterator.next();
                    Integer value = exceptionReports.getComponents().get(key);
                    out.println("<tr> <td> " + key + "</td><td> "+ value + "</td> </tr>");
               }
               %>
               </tbody>
          </table>   
                        
        </td>
    </tr>
    <%  } %>
    <% } %>
    
</table>

</center>
<jsp:include page="../template/footer.jsp"/>