/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */
package org.netbeans.modules.languages.features;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;

import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;


/**
 *
 * @author Jan Jancura
 */
class TokenHighlightsLayer extends AbstractHighlightsContainer {

    private Highlighting            highlighting;
    private TokenHierarchy          hierarchy;
    private Document                document;
    private final PropertyChangeListener listener = new PropertyChangeListener () {
        public void propertyChange (final PropertyChangeEvent evt) {
            fireHighlightsChange ((Integer) evt.getOldValue (), (Integer) evt.getNewValue ());
        }
    };
    
    TokenHighlightsLayer (final Document document) {
        highlighting = Highlighting.getHighlighting (document);
        hierarchy = TokenHierarchy.get (document);
        this.document = document;
        highlighting.addPropertyChangeListener (WeakListeners.propertyChange(listener, highlighting));
    }
    
    public HighlightsSequence getHighlights (int startOffset, int endOffset) {
        return new Highlights (document, highlighting, hierarchy, startOffset, endOffset);
    }
    
    
    private static class Highlights implements HighlightsSequence {

        private int                 endOffset;
        private int                 startOffset1;
        private int                 endOffset1;
        private SimpleAttributeSet  attributeSet;
        private Highlighting        highlighting;
        private TokenHierarchy      hierarchy;
        private Document            document;
        
        private Highlights (
            Document                document,
            Highlighting            highlighting, 
            TokenHierarchy          hierarchy, 
            int                     startOffset, 
            int                     endOffset
        ) {
            this.document =         document;
            this.endOffset =        endOffset;
            this.highlighting =     highlighting;
            this.hierarchy =        hierarchy;
            endOffset1 =            startOffset;
        }
        
        public boolean moveNext () {
            attributeSet = new SimpleAttributeSet ();
            startOffset1 = endOffset1;
            TokenSequence ts = hierarchy.tokenSequence ();
            
            AttributeSet as = null;
            do {
                do {
                    ts.move (startOffset1);
                    if (!ts.moveNext ())
                        return endOffset1 > startOffset1;
                    Token t = ts.token ();
                    if (ts.language () == null)
                        throw new NullPointerException ("ts.language()==null: TS " + ts + " : " + document.getProperty("mimeType"));
//                    ASTToken stoken = ASTToken.create (
//                        ts.language ().mimeType (),
//                        t.id ().ordinal (),
//                        t.text ().toString (),
//                        ts.offset ()
//                    );
                    as = highlighting.get (ts.offset (), ts.offset () + t.length ());
                    if (as != null) {
                        attributeSet.addAttributes (as);
                        endOffset1 = ts.offset () + t.length ();
                    }
                    TokenSequence ts1 = ts.embedded ();
                    if (ts1 == null) break;
                    ts = ts1;
                } while (true);
                if (endOffset1 > startOffset1)
                    return true;
                startOffset1 = ts.offset () + ts.token ().length ();
                endOffset1 = startOffset1;
            } while (startOffset1 < endOffset);
            return false;
        }

        public int getStartOffset () {
            return startOffset1;
        }

        public int getEndOffset () {
            return endOffset1;
        }

        public AttributeSet getAttributes () {
            return attributeSet;
        }
    }
}
