/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */
package org.netbeans.modules.changelog.wizard;

/**
 *
 * @author  ralph
 */

import org.openide.util.*;
import javax.swing.event.*;
import javax.swing.*;
import org.netbeans.modules.changelog.*;


public class FilterPanel extends javax.swing.JPanel {

    /** Creates new form FilterPanel */
    public FilterPanel() {
        initComponents();
        putClientProperty ("WizardPanel_contentSelectedIndex", new Integer (0)); // NOI18N
        String[] comboValues = new String[4];
        comboValues[0] = NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.Substring");
        comboValues[2] = NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.AllWords");
        comboValues[3] = NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.SomeWords");
        comboValues[1] = NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.RegExp");
        DefaultComboBoxModel model = new DefaultComboBoxModel(comboValues);
        comMessage.setModel(model);
        String[] comboValues2 = new String[2];
        comboValues2[0] = NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.Substring");
        comboValues2[1] = NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.RegExp");
        comFilePattern.setModel(new DefaultComboBoxModel(comboValues2));
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        lblDate = new javax.swing.JLabel();
        txDate = new javax.swing.JTextField();
        lblUser = new javax.swing.JLabel();
        txUser = new javax.swing.JTextField();
        lblRevision = new javax.swing.JLabel();
        txRevision = new javax.swing.JTextField();
        lblMessage = new javax.swing.JLabel();
        txMessage = new javax.swing.JTextField();
        comMessage = new javax.swing.JComboBox();
        lblDateFormat = new javax.swing.JLabel();
        lRevisionRange = new javax.swing.JLabel();
        lblFilePattern = new javax.swing.JLabel();
        txFilePattern = new javax.swing.JTextField();
        comFilePattern = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        setMinimumSize(new java.awt.Dimension(400, 200));
        setPreferredSize(new java.awt.Dimension(600, 300));
        getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSN_FilterPanel"));
        getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_FilterPanel"));
        lblDate.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblDate_mnc").charAt(0));
        lblDate.setLabelFor(txDate);
        lblDate.setText(org.openide.util.NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.lblStatDate.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(lblDate, gridBagConstraints);

        txDate.setColumns(40);
        txDate.setMinimumSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(12, 6, 0, 0);
        add(txDate, gridBagConstraints);
        txDate.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_txDate"));

        lblUser.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblUser_mnc").charAt(0));
        lblUser.setLabelFor(txUser);
        lblUser.setText(org.openide.util.NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.lblUser.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        add(lblUser, gridBagConstraints);

        txUser.setColumns(10);
        txUser.setMinimumSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(txUser, gridBagConstraints);
        txUser.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_txUser"));

        lblRevision.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblRevision_mnc").charAt(0));
        lblRevision.setLabelFor(txRevision);
        lblRevision.setText(org.openide.util.NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.lblBranch.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        add(lblRevision, gridBagConstraints);

        txRevision.setColumns(10);
        txRevision.setMinimumSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(txRevision, gridBagConstraints);
        txRevision.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_txRevision"));

        lblMessage.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblMessage_mnc").charAt(0));
        lblMessage.setLabelFor(txMessage);
        lblMessage.setText(org.openide.util.NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.lblMessage.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 6, 0);
        add(lblMessage, gridBagConstraints);

        txMessage.setColumns(10);
        txMessage.setMinimumSize(new java.awt.Dimension(100, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 0);
        add(txMessage, gridBagConstraints);
        txMessage.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_txMessage"));

        comMessage.setPreferredSize(new java.awt.Dimension(250, 27));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 11);
        add(comMessage, gridBagConstraints);
        comMessage.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_comMessage"));

        lblDateFormat.setText(org.openide.util.NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.lblDateFormat.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 6, 0);
        add(lblDateFormat, gridBagConstraints);

        lRevisionRange.setText(org.openide.util.NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.lblRevisionRange.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 6, 0);
        add(lRevisionRange, gridBagConstraints);

        lblFilePattern.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACS_lblFilePattern_mnc").charAt(0));
        lblFilePattern.setLabelFor(txFilePattern);
        lblFilePattern.setText(org.openide.util.NbBundle.getBundle(FilterPanel.class).getString("FilterPanel.lblFilePattern.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 12, 0);
        add(lblFilePattern, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 12, 0);
        add(txFilePattern, gridBagConstraints);
        txFilePattern.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_txFilePattern"));

        comFilePattern.setPreferredSize(new java.awt.Dimension(250, 27));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 11, 11);
        add(comFilePattern, gridBagConstraints);
        comFilePattern.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/changelog/wizard/Bundle").getString("ACSD_comFilePattern"));

    }//GEN-END:initComponents

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblMessage;
    private javax.swing.JLabel lblDateFormat;
    private javax.swing.JTextField txUser;
    private javax.swing.JTextField txDate;
    private javax.swing.JTextField txMessage;
    private javax.swing.JTextField txFilePattern;
    private javax.swing.JLabel lblFilePattern;
    private javax.swing.JComboBox comMessage;
    private javax.swing.JLabel lblRevision;
    private javax.swing.JLabel lblDate;
    private javax.swing.JLabel lblUser;
    private javax.swing.JTextField txRevision;
    private javax.swing.JComboBox comFilePattern;
    private javax.swing.JLabel lRevisionRange;
    // End of variables declaration//GEN-END:variables


    public static class Panel implements org.openide.WizardDescriptor.Panel {


        private FilterPanel panel;
        private String name;


        public Panel (String name) {
            this.name = name;
        }

        /** Get the component displayed in this panel.
         * @return the component
         */
        public synchronized java.awt.Component getComponent() {
            if (this.panel == null) {
                this.panel = new FilterPanel();
                this.panel.setName (name);
            }
            return this.panel;
        }

        /** Help for this panel.
         * When the panel is active, this is used as the help for the wizard dialog.
         * @return the help or <code>null</code> if no help is supplied
         */
        public HelpCtx getHelp() {
            return new HelpCtx(this.getClass());
        }

        /** Add a listener to changes of the panel's validity.
         * @param l the listener to add
         * @see #isValid
         */
        public void addChangeListener(ChangeListener l) {
        }

        /** Remove a listener to changes of the panel's validity.
         * @param l the listener to remove
         */
        public void removeChangeListener(ChangeListener l) {
        }


        public boolean isValid() {
            return true;
        }

        /** Provides the wizard panel with the opportunity to update the
         * settings with its current customized state.
         * Rather than updating its settings with every change in the GUI, it should collect them,
         * and then only save them when requested to by this method.
         * Also, the original settings passed to {@link #readSettings} should not be modified (mutated);
         * rather, the (copy) passed in here should be mutated according to the collected changes.
         * This method can be called multiple times on one instance of <code>WizardDescriptor.Panel</code>.
         * @param settings the object representing a settings of the wizard
         */
        public void storeSettings(Object settings) {
            if (settings instanceof ChangeLogProcessor) {
                ChangeLogProcessor proces = (ChangeLogProcessor)settings;
                FilterPanel p = (FilterPanel) this.getComponent();
                if (p.txMessage.getText() != null && p.txMessage.getText().length() > 0) {
                    proces.setMessageFilter(p.comMessage.getSelectedIndex(), p.txMessage.getText());
                }
                else  {
                    proces.setMessageFilter(ChangeLogProcessor.MESSAGE_FILTER_SUBSTRING, null);
                }
                if (p.txFilePattern.getText() != null && p.txFilePattern.getText().length() > 0) {
                    proces.setFileFilter(p.comFilePattern.getSelectedIndex(), p.txFilePattern.getText());
                }
                else  {
                    proces.setFileFilter(ChangeLogProcessor.FILE_FILTER_SUBSTRING, null);
                }

                if (p.txUser.getText() != null & p.txUser.getText().length() > 0)
                    proces.setUser(p.txUser.getText());
                else  proces.setUser(null);

                if (p.txRevision.getText() != null & p.txRevision.getText().length() > 0)
                    proces.setRevisionRange(p.txRevision.getText());
                else  proces.setRevisionRange(null);
                if (p.txDate.getText() != null & p.txDate.getText().length() > 0)
                    proces.setDateRange(p.txDate.getText());
                else  proces.setDateRange(null);
            }
        }

        /** Provides the wizard panel with the current data--either
         * the default data or already-modified settings, if the user used the previous and/or next buttons.
         * This method can be called multiple times on one instance of <code>WizardDescriptor.Panel</code>.
         * @param settings the object representing wizard panel state, as originally supplied to {@link org.openide.WizardDescriptor#WizardDescriptor(org.openide.WizardDescriptor.Iterator,Object)}
         * @exception IllegalStateException if the the data provided
         * by the wizard are not valid.
         */
        public void readSettings(Object settings) {
            if (settings instanceof ChangeLogProcessor) {
                ChangeLogProcessor proces = (ChangeLogProcessor)settings;
                FilterPanel p = (FilterPanel) this.getComponent();
                if (proces.getRevisionRange() != null)
                    p.txRevision.setText(proces.getRevisionRange());
                if (proces.getDateRange() != null)
                    p.txDate.setText(proces.getDateRange());
                if (proces.getUser() != null) {
                    p.txUser.setText(proces.getUser());
                }
                if (proces.getMessageFilter() != null) {
                    p.txMessage.setText(proces.getMessageFilter());
                    p.comMessage.setSelectedIndex(proces.getMessageFilterType());
                }
                if (proces.getFileFilter() != null) {
                    p.txFilePattern.setText(proces.getFileFilter());
                    p.comFilePattern.setSelectedIndex(proces.getFileFilterType());
                }
            }
        }
    }

}
