/* * 
 *  $Id: uierror.c 84 2004-03-10 17:24:11Z shawill $
 *  
 *  This file is part of NeMeSI
 *
 *  NeMeSI -- NEtwork MEdia Streamer I
 *
 *  Copyright (C) 2001 by
 *  	
 *  	Giampaolo "mancho" Mancini - manchoz@inwind.it
 *	Francesco "shawill" Varano - shawill@infinto.it
 *
 *  NeMeSI is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NeMeSI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NeMeSI; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  
 * */

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>

#include <nemesi/comm.h>

#ifdef USE_UIPRINTF

/*!
  return 1, error
 */
int uierror(const char *fmt, ...)
{
	va_list ap;
	int fd;
	FILE *uistderr;
	
	if( (fd=dup(UIERROR_FILENO)) < 0 ){
		fprintf(stderr, "\nfailed duplicating UIERROR_FILENO\n");
		return -1;
	}
	if( !(uistderr=fdopen(fd, "a")) ){
		fprintf(stderr, "\nfailed opening uistderr stream.\n");
		return -1;
	}

	va_start(ap, fmt);

	fprintf(uistderr, "error: ");
	vfprintf(uistderr, fmt, ap);
	fprintf(uistderr, "\n");

	va_end(ap);
	fclose(uistderr);
	close(fd);

	return 1;
}
#endif // USE_UIPRINTF
