/* * 
 *  $Id: bpkill.c 51 2004-01-12 18:55:14Z shawill $
 *  
 *  This file is part of NeMeSI
 *
 *  NeMeSI -- NEtwork MEdia Streamer I
 *
 *  Copyright (C) 2001 by
 *  	
 *  	Giampaolo "mancho" Mancini - manchoz@inwind.it
 *	Francesco "shawill" Varano - shawill@infinto.it
 *
 *  NeMeSI is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NeMeSI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NeMeSI; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  
 * */

#include <nemesi/bufferpool.h>

/*!
* \brief Funzione per la chiusura della libreria Bufferpool.
*
* Libera la memoria precedentemente allocata per il Buffer Pool. Da questo
* momento in poi il Bufferpool non  pi accessibile.
*
* \param bp Il puntatore al Buffer Pool corrente.
* \return 0
* \see bpinit
* \see bufferpool.h
* */
int bpkill(buffer_pool *bp)
{
	free(bp->bufferpool);
	bp->bufferpool=NULL;
	return 0;
}
