[Record]
class X {
  val : int;
  
  [Nemerle.OverrideObjectEquals]
  public Equals (x : X) : bool
  {
    val == x.val
  }
}

[Record]
class Y {
  val : int;

  Plus3 : Y
  {
    get { Y (val + 3) }
  }

  [Nemerle.ForwardThis (Plus3)]
  public SomeMeth (a : int, b : string) : string
  {
    $ "$val $a $b"
  }
}


public class TypeOfTest
{
    public static Main () : void
    {
        def x = typeof (System.String);
        def y = typeof (int);

        System.Console.WriteLine (x.FullName + ", " + y.FullName);

        def x1 = X(5);
        def x2 = X(5);
        def x3 = X(7);
        assert (x1.Equals (x1));
        assert (x1.Equals (x2));
        assert (!x1.Equals (x3));
        assert ((x1 : object).Equals (x1));
        assert ((x1 : object).Equals (x2));
        assert (!(x1 : object).Equals (x3));
        
        Nemerle.IO.print (Y (39).SomeMeth (42, "42") + "\n");
    }
}

/*
BEGIN-OUTPUT
System.String, System.Int32
42 42 42
END-OUTPUT
*/
