// Compiler options: 
//
// Test for contravariance support in delegates
//

using System;

 public class A {
	 protected  mutable  name : string;
	 
	 public this ( name : string)
	 {
		 this.name = "A::" + name;
	 }

	 public this ()
	 {
	 }

	 public Name : string {
		 get {
			  name;
		 }
	 }
 }

 public class B : A {
	 public this ( name : string)
	 {
		 this.name = "B::" + name;
	 }

	 public this ()
	 {
	 }
 }

 public class C : B {
	  mutable  value : string;

	 public this ( name : string, value :  string)
	 {
		 this.name = "C::" + name;
		 this.value = value;
	 }

	 public Value : string {
		 get {
			  value;
		 }
	 }
 }

 public class Tester {

	 delegate MethodHandler ( c1 : C, c2 :  C, c3 :  C) :  void;

	 static MethodSample ( b : B, a :  A, c :  C) :  void
	 {
		 Console.WriteLine ("b = {0}", b.Name);
		 Console.WriteLine ("a = {0}", a.Name);
		 Console.WriteLine ("c = {0}, {1}", c.Name, c.Value);
	 }

	 static Main () :  void
	 {
		 mutable  mh = MethodSample;

		 mutable  a =  C ("Hello", "hello");
		 mutable  b =  C ("World", "world");
		 mutable  c =  C ("!", "!!!");

		 mh (b, a, c);
	 }
	
 }
/*
BEGIN-OUTPUT
b = C::World
a = C::Hello
c = C::!, !!!
END-OUTPUT
*/
