using System;

class Stress {

	static  mutable  mode : string = "unchecked";
	
	static  mutable  types :  array [string] =  array[
		"int",   "uint",
		"short", "ushort",
		"long",  "ulong",
		"sbyte", "byte", "char"
		];
	

	static w (mutable  s : string) :  void
	{
		Console.Write (s);
	}

	static wl (mutable  s : string) :  void
	{
		Console.WriteLine (s);
	}
	
	static generate_receptors () :  void
	{
		foreach ( t : string in types){
			w ("\tstatic void receive_" + t + " (" + t + " a)\n\t{\n");
			w ("\t\tConsole.Write (\"        \");\n");
			w ("\t\tConsole.WriteLine (a);\n");
			w ("\t}\n\n");
		}
		
	}

	static var (mutable  type_ : string,mutable  name :  string,mutable  init :  string) :  void
	{
		w ("\t\t" + type_ + " " + name + " = (" + type_ + ") " + init + ";\n");
	}

	static call (mutable  type_ : string,mutable  name :  string) :  void
	{
		w ("\t\treceive_" + type_ + " (" + mode + "((" + type_ + ") " + name + "));\n");
	}
	
	static generate_emision () :  void
	{
		foreach ( type_ : string in types){
			w ("\tstatic void probe_" + type_ + "()\n\t{\n");
			var (type_, "zero", "0");
			var (type_, "min", type_ + ".MinValue");
			var (type_, "max", type_ + ".MaxValue");
			wl ("");

			wl ("\t\tConsole.WriteLine (\"Testing: " + type_ + "\");\n");
			foreach ( t : string in types){
				wl ("\t\tConsole.WriteLine (\"   arg: " + t + " (" + type_ + ")\");\n");
				call (t, "zero");
				call (t, "min");
				call (t, "max");
			}
			
			w ("\t}\n\n");
		}
	}

	static generate_main () :  void
	{
		wl ("\tstatic void Main ()\n\t{");

		foreach ( t : string in types){
			w ("\t\tprobe_" + t + " ();\n");
		}
		wl ("\t}");
	}
	
	static Main (mutable  args :  array [string]) :  void
	{
		{
		mutable temp_2_return_ = Nemerle.Extensions.DefaultValue(void);
		mutable temp_1_break_loop_ = false;
		foreach ( arg : string in args)
		when (!temp_1_break_loop_ ){{
			when (arg == "-h" || arg == "--help"){
				Console.WriteLine ("-h, --help     Shows help");
				Console.WriteLine ("-c, --checked  Generate checked contexts");
				{
				temp_1_break_loop_ = true;
				temp_2_return_ = ();
				}
			}
			when( !temp_1_break_loop_ )
			{
			if (arg == "--checked" || arg == "-c")
			{{
				mode = "checked";
				/*continue*/();
			}
			}
			else{{
		}
		}
			}
		}when( !temp_1_break_loop_ ){}
		}
		if( temp_1_break_loop_ )
		{
		 temp_2_return_;
		}
		else
		{
		{
		wl ("using System;\nclass Test {\n");

		generate_receptors ();
		generate_emision ();

		generate_main ();
			       
		wl ("}\n");
		}
		}
		}
	}
}
