using Nemerle.Collections;
using Nemerle.Collections.List;
using Nemerle.IO;
using SCG = System.Collections.Generic;

#if NUNIT
using NUnit.Framework;

[TestFixture]
public class SetTest : Assertion
{
  mutable set : Set [int];
  
  [Test]
  public EnumerableInit () : void
  {
    def li = SCG.List ();
    li.Add (12);
    li.Add (435);
    li.Add (33);
    set = Set (li);
    Assert (set.Contains (435));
    AssertEquals (3, set.Count);
  }
  
  [Test]
  public ForEachSizes () : void
  {   
    forEachTester (array [33]);
    forEachTester (array [62, 0]);
    forEachTester (array [677, 3, -1]);
    forEachTester (array [343, 2, 44, 132, 1, 4]);
    forEachTester (array [3, 45, 222, 1, 2343, 55, 111]);
    forEachTester (array [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18]);
    forEachTester (array [-1, 23, 3454, 22, 3344, 2, 4543, 567, 876, 52, 12312, 454, -2123, 445443]);
  }
  
  private forEachTester (init : array [int]) : void
  {
    def convert = SCG.List ();
    set = Set (init);
    foreach (x in set)
      convert.Add (x);
    AssertEquals (set.Count, convert.Count);
    AssertEquals (init.Length, convert.Count);
    for (mutable i = 1; i < convert.Count; i++)
      Assert (convert [i - 1] < convert [i]);
    foreach (y in init)
      Assert (convert.Contains (y));
  }
  
  [Test]
  public ForEachEmpty () : void
  {
    def convert = SCG.List ();
    set = Set ();
    foreach (x in set)
      convert.Add (x);
    AssertEquals (0, convert.Count);
    AssertEquals (0, set.Count);
  }
    
  [Test]
  public CopyTo() : void
  {
    set = Set ([43, 4, 657]);
    def arr = array (3);
    set.CopyTo (arr, 0);
    AssertEquals (4, arr [0]);
    AssertEquals (43, arr [1]);
    AssertEquals (657, arr [2]);
  }
  
}
#else
()
#endif