/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Nemerle.Extensions;
 
// note that the fact that Tuple`2 and `3 are structs
// is also needed in MType.IsValueType

namespace Nemerle.Builtins {

public abstract class Function ['r] : Function [System.Object, 'r]
{
  public abstract apply () : 'r;
  public override apply (_ : System.Object) : 'r { apply () }
}

public abstract class FunctionVoid : Function [System.Object]
{
  public abstract apply_void () : void;
  public override apply () : System.Object { apply_void (); null }
}

public abstract class Function ['p1, 'r]
{
  public abstract apply (_ : 'p1) : 'r;
}

public abstract class FunctionVoid ['p1] : Function ['p1, System.Object]
{
  public abstract apply_void (_ : 'p1) : void;
  public override apply (p1 : 'p1) : System.Object { apply_void (p1); null }
}

public abstract class Function ['p1, 'p2, 'r] : Function [Tuple ['p1, 'p2], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2) : 'r;
  public override apply (o : Tuple ['p1, 'p2]) : 'r { apply (o.field0, o.field1) }
}

public abstract class FunctionVoid ['p1, 'p2] : FunctionVoid [Tuple ['p1, 'p2]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2) : void;
  public override apply_void (o : Tuple ['p1, 'p2]) : void { apply_void (o.field0, o.field1); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode]
  public struct Tuple ['p0, 'p1]
  {
    public field0 : 'p0;
    public field1 : 'p1;
  }

public abstract class Function ['p1, 'p2, 'p3, 'r] : Function [Tuple ['p1, 'p2, 'p3], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3]) : 'r { apply (o.field0, o.field1, o.field2) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3] : FunctionVoid [Tuple ['p1, 'p2, 'p3]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3]) : void { apply_void (o.field0, o.field1, o.field2); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode]
  public struct Tuple ['p0, 'p1, 'p2]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4]) : 'r { apply (o.field0, o.field1, o.field2, o.field3) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4]) : void { apply_void (o.field0, o.field1, o.field2, o.field3); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
    public field12 : 'p12;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
    public field12 : 'p12;
    public field13 : 'p13;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
    public field12 : 'p12;
    public field13 : 'p13;
    public field14 : 'p14;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
    public field12 : 'p12;
    public field13 : 'p13;
    public field14 : 'p14;
    public field15 : 'p15;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16, _ : 'p17) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15, o.field16) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16, _ : 'p17) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15, o.field16); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
    public field12 : 'p12;
    public field13 : 'p13;
    public field14 : 'p14;
    public field15 : 'p15;
    public field16 : 'p16;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16, _ : 'p17, _ : 'p18) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15, o.field16, o.field17) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16, _ : 'p17, _ : 'p18) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15, o.field16, o.field17); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
    public field12 : 'p12;
    public field13 : 'p13;
    public field14 : 'p14;
    public field15 : 'p15;
    public field16 : 'p16;
    public field17 : 'p17;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16, _ : 'p17, _ : 'p18, _ : 'p19) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15, o.field16, o.field17, o.field18) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16, _ : 'p17, _ : 'p18, _ : 'p19) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15, o.field16, o.field17, o.field18); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
    public field12 : 'p12;
    public field13 : 'p13;
    public field14 : 'p14;
    public field15 : 'p15;
    public field16 : 'p16;
    public field17 : 'p17;
    public field18 : 'p18;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19, 'p20, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19, 'p20], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16, _ : 'p17, _ : 'p18, _ : 'p19, _ : 'p20) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19, 'p20]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15, o.field16, o.field17, o.field18, o.field19) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19, 'p20] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19, 'p20]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9, _ : 'p10, _ : 'p11, _ : 'p12, _ : 'p13, _ : 'p14, _ : 'p15, _ : 'p16, _ : 'p17, _ : 'p18, _ : 'p19, _ : 'p20) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19, 'p20]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8, o.field9, o.field10, o.field11, o.field12, o.field13, o.field14, o.field15, o.field16, o.field17, o.field18, o.field19); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'p10, 'p11, 'p12, 'p13, 'p14, 'p15, 'p16, 'p17, 'p18, 'p19]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
    public field9 : 'p9;
    public field10 : 'p10;
    public field11 : 'p11;
    public field12 : 'p12;
    public field13 : 'p13;
    public field14 : 'p14;
    public field15 : 'p15;
    public field16 : 'p16;
    public field17 : 'p17;
    public field18 : 'p18;
    public field19 : 'p19;
  }

}
