using Nemerle.Collections;

namespace NSokoban
{
    public module LocalSearch
    {
	public SimulatedAnnealing (map : SMap, p : double) : bool * option [SMap]
	{
	    mutable queue = Queue();
	    
	    mutable ppb = p;
	    
	    mutable depth = 0;
	    
	    def r = System.Random ();

	    queue.Enqueue (map);

	    mutable next = map;

	    def start = System.DateTime.Now;

	    while(!next.GoalTest () && !(queue.Count == 0))
	    {				
		def m = queue.Dequeue();		    

		when(depth < m.moves_so_far.Length)
		{
		    ++depth;
		    System.Console.WriteLine(depth);
		}

		if( m.F < next.F)
		{
		    next = m;
		    List.Iter(m.NextStates(),fun(x){queue.Enqueue(x);});
		}
		else
		    when(r.NextDouble () < ppb)
		    {
			next = m;
			List.Iter(m.NextStates(true),fun(x){queue.Enqueue(x);});
			ppb -= 0.0001;
		    }
	    }

	    if(next.GoalTest ())
	    {
		System.Console.WriteLine("Found after "+(start - System.DateTime.Now).ToString ());	
		(true,Some (next));
	    }
	    else
		(false,None ())
	}
    }
}
